/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop.pdd.core.state;

import java.sql.Connection;
import java.util.Enumeration;
import org.apache.log4j.Logger;
import org.openspcoop.dao.commons.IDSoggetto;
import org.openspcoop.dao.state.IState;
import org.openspcoop.dao.state.StateMessage;
import org.openspcoop.dao.state.StatelessMessage;
import org.openspcoop.pdd.config.DBManager;
import org.openspcoop.pdd.config.Resource;
import org.openspcoop.pdd.core.state.IOpenSPCoopState;
import org.openspcoop.pdd.core.state.OpenSPCoopStateException;
import org.openspcoop.pdd.core.state.OpenSPCoopStateful;
import org.openspcoop.pdd.core.state.OpenSPCoopStateless;
import org.openspcoop.pdd.logger.OpenSPCoopLogger;
import org.openspcoop.pdd.mdb.GenericMessage;
import org.openspcoop.utils.UtilsException;

public abstract class OpenSPCoopState
implements IOpenSPCoopState {
    protected Logger logger = null;
    protected DBManager dbManager = null;
    protected Resource resourceDB = null;
    protected Connection connectionDB = null;
    protected boolean connessioneInizializzata = false;
    protected IDSoggetto identitaPdD = null;
    protected String idModulo = null;
    protected GenericMessage messageLib;
    protected String IDEgovSessione;
    protected StateMessage richiestaStato = null;
    protected StateMessage rispostaStato = null;
    protected boolean useConnection;

    public static OpenSPCoopStateless toStateless(OpenSPCoopStateful stateful, boolean useConnection) {
        OpenSPCoopStateless stateless = new OpenSPCoopStateless();
        stateless.connectionDB = stateful.connectionDB;
        stateless.dbManager = stateful.dbManager;
        stateless.IDEgovSessione = stateful.IDEgovSessione;
        stateless.identitaPdD = stateful.identitaPdD;
        stateless.idModulo = stateful.idModulo;
        stateless.logger = stateful.logger;
        stateless.messageLib = stateful.messageLib;
        stateless.resourceDB = stateful.resourceDB;
        stateless.richiestaStato = stateful.richiestaStato;
        stateless.rispostaStato = stateful.rispostaStato;
        stateless.useConnection = useConnection;
        stateless.connessioneInizializzata = stateful.connessioneInizializzata;
        StatelessMessage tempRichiesta = new StatelessMessage(stateful.getConnectionDB(), stateful.logger);
        tempRichiesta.setPreparedStatement(((StateMessage)stateful.getStatoRichiesta()).getPreparedStatement());
        stateless.setStatoRichiesta((IState)new StatelessMessage((StateMessage)tempRichiesta));
        StatelessMessage tempRisposta = new StatelessMessage(stateful.getConnectionDB(), stateful.logger);
        tempRisposta.setPreparedStatement(((StateMessage)stateful.getStatoRisposta()).getPreparedStatement());
        stateless.setStatoRisposta((IState)new StatelessMessage((StateMessage)tempRisposta));
        return stateless;
    }

    public abstract void updateStatoRichiesta() throws UtilsException;

    public abstract void updateStatoRisposta() throws UtilsException;

    public void initResource(IDSoggetto identitaPdD, String idModulo) throws OpenSPCoopStateException {
        if (this.useConnection) {
            if (identitaPdD == null) {
                throw new OpenSPCoopStateException("IdentitaPdD non presente");
            }
            this.identitaPdD = identitaPdD;
            if (idModulo == null) {
                throw new OpenSPCoopStateException("IDModulo non presente");
            }
            this.idModulo = idModulo;
            this.logger = OpenSPCoopLogger.getLoggerOpenSPCoopCore();
            this.dbManager = DBManager.getInstance();
            try {
                this.resourceDB = this.dbManager.getResource(identitaPdD.getCodicePorta(), this.idModulo);
            }
            catch (Exception e) {
                throw new OpenSPCoopStateException("Riscontrato errore durante la richiesta di una connessione al DB", e);
            }
            if (this.resourceDB == null) {
                throw new OpenSPCoopStateException("Riscontrato errore durante la richiesta di una connessione al DB (Risorsa is null).");
            }
            if (this.resourceDB.getResource() == null) {
                throw new OpenSPCoopStateException("Riscontrato errore durante la richiesta di una connessione al DB (Connessione is null).");
            }
            this.connectionDB = (Connection)this.resourceDB.getResource();
            try {
                this.updateStatoRichiesta();
                this.updateStatoRisposta();
            }
            catch (Exception e) {
                this.logger.error((Object)"Update stato richiesta/risposta non riuscito", (Throwable)e);
                this.dbManager.releaseResource(this.identitaPdD.getCodicePorta(), this.idModulo, this.resourceDB);
                throw new OpenSPCoopStateException("Update stato richiesta/risposta non riuscito", e);
            }
            this.connessioneInizializzata = true;
        }
    }

    public void updateResource() throws OpenSPCoopStateException {
        if (this.useConnection) {
            try {
                this.resourceDB = this.dbManager.getResource(this.identitaPdD.getCodicePorta(), this.idModulo);
            }
            catch (Exception e) {
                throw new OpenSPCoopStateException("Riscontrato errore durante la richiesta di una connessione al DB", e);
            }
            if (this.resourceDB == null) {
                throw new OpenSPCoopStateException("Riscontrato errore durante la richiesta di una connessione al DB (Risorsa is null).");
            }
            if (this.resourceDB.getResource() == null) {
                throw new OpenSPCoopStateException("Riscontrato errore durante la richiesta di una connessione al DB (Connessione is null).");
            }
            this.connectionDB = (Connection)this.resourceDB.getResource();
            this.richiestaStato.updateConnection(this.connectionDB);
            this.rispostaStato.updateConnection(this.connectionDB);
            this.connessioneInizializzata = true;
        }
    }

    public void releaseResource() {
        if (this.useConnection && this.connessioneInizializzata) {
            String key;
            Enumeration en;
            try {
                if (this.richiestaStato != null && this.richiestaStato.getPreparedStatement() != null && this.richiestaStato.getPreparedStatement().size() > 0) {
                    en = this.richiestaStato.getPreparedStatement().keys();
                    while (en.hasMoreElements()) {
                        key = (String)en.nextElement();
                        this.logger.error((Object)("PREPARED STATEMENT NON CHIUSA (RICHIESTA): " + key));
                    }
                    this.richiestaStato.closePreparedStatement();
                }
            }
            catch (Exception e) {
                this.logger.error((Object)"Chiusure prepared statement della richiesta non riuscita", (Throwable)e);
            }
            try {
                if (this.rispostaStato != null && this.rispostaStato.getPreparedStatement() != null && this.rispostaStato.getPreparedStatement().size() > 0) {
                    en = this.rispostaStato.getPreparedStatement().keys();
                    while (en.hasMoreElements()) {
                        key = (String)en.nextElement();
                        this.logger.error((Object)("PREPARED STATEMENT NON CHIUSA (RISPOSTA): " + key));
                    }
                    this.rispostaStato.closePreparedStatement();
                }
            }
            catch (Exception e) {
                this.logger.error((Object)"Chiusure prepared statement della risposta non riuscita", (Throwable)e);
            }
            try {
                if (this.resourceDB != null) {
                    this.dbManager.releaseResource(this.identitaPdD.getCodicePorta(), this.idModulo, this.resourceDB);
                }
                this.richiestaStato.updateConnection(null);
                this.rispostaStato.updateConnection(null);
            }
            catch (Exception e) {
                this.logger.error((Object)("Rilasciate risorse con errore: " + e.getMessage()), (Throwable)e);
                OpenSPCoopLogger.getLoggerOpenSPCoopConsole().error((Object)("Rilasciate risorse con errore: " + e.getMessage()));
            }
            this.connessioneInizializzata = false;
        }
    }

    public boolean resourceReleased() {
        return !this.connessioneInizializzata;
    }

    public void commit() throws OpenSPCoopStateException {
        if (this.useConnection && (this.richiestaStato != null && this.richiestaStato.getPreparedStatement() != null && this.richiestaStato.getPreparedStatement().size() > 0 || this.rispostaStato != null && this.rispostaStato.getPreparedStatement() != null && this.rispostaStato.getPreparedStatement().size() > 0)) {
            try {
                this.connectionDB.setAutoCommit(false);
                this.richiestaStato.executePreparedStatement();
                this.rispostaStato.executePreparedStatement();
                this.connectionDB.commit();
                this.connectionDB.setAutoCommit(true);
            }
            catch (Exception e) {
                try {
                    this.richiestaStato.closePreparedStatement();
                    this.rispostaStato.closePreparedStatement();
                }
                catch (Exception eClose) {
                    // empty catch block
                }
                try {
                    this.connectionDB.rollback();
                }
                catch (Exception er) {
                    // empty catch block
                }
                try {
                    this.connectionDB.setAutoCommit(true);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                throw new OpenSPCoopStateException(e.getMessage(), e);
            }
        }
    }

    public GenericMessage getMessageLib() {
        return this.messageLib;
    }

    public void setMessageLib(GenericMessage messageLib) {
        this.messageLib = messageLib;
    }

    public String getIDEgovSessione() {
        return this.IDEgovSessione;
    }

    public void setIDEgovSessione(String egovSessione) {
        this.IDEgovSessione = egovSessione;
    }

    public IState getStatoRichiesta() {
        return this.richiestaStato;
    }

    public void setStatoRichiesta(IState statoRichiesta) {
        this.richiestaStato = (StateMessage)statoRichiesta;
    }

    public IState getStatoRisposta() {
        return this.rispostaStato;
    }

    public void setStatoRisposta(IState statoRisposta) {
        this.rispostaStato = (StateMessage)statoRisposta;
    }

    public Connection getConnectionDB() {
        return this.connectionDB;
    }

    public void setConnectionDB(Connection connectionDB) {
        this.connectionDB = connectionDB;
    }
}

