/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop.pdd.core.node;

import javax.jms.JMSException;
import org.apache.log4j.Logger;
import org.openspcoop.egov.Busta;
import org.openspcoop.pdd.config.OpenSPCoopProperties;
import org.openspcoop.pdd.core.JMSReceiver;
import org.openspcoop.pdd.core.node.INodeReceiver;
import org.openspcoop.pdd.core.node.NodeException;
import org.openspcoop.pdd.core.node.NodeTimeoutException;
import org.openspcoop.pdd.core.node.TransactionManager;
import org.openspcoop.pdd.logger.MsgDiagnostico;
import org.openspcoop.pdd.logger.OpenSPCoopLogger;
import org.openspcoop.pdd.services.RicezioneBusteEGovMessage;
import org.openspcoop.pdd.services.RicezioneContenutiApplicativiMessage;

public class NodeReceiverJMS
implements INodeReceiver {
    private static OpenSPCoopProperties openspcoopProperties = OpenSPCoopProperties.getInstance();

    public Object receive(MsgDiagnostico msgDiag, String codicePorta, String idModulo, String idMessaggio, long timeout, long checkInterval) throws NodeException, NodeTimeoutException {
        Object objReturn = null;
        Logger log = OpenSPCoopLogger.getLoggerOpenSPCoopCore();
        try {
            JMSReceiver receiverJMS = new JMSReceiver(codicePorta, idModulo, openspcoopProperties.singleConnection_NodeReceiver(), log);
            while (true) {
                String strMessageSelector = "ID = '" + idMessaggio + "'";
                msgDiag.highDebug("Ricezione messaggio selector[" + strMessageSelector + "]....");
                if (!receiverJMS.receive(idModulo, strMessageSelector, timeout, checkInterval)) {
                    throw new JMSException(receiverJMS.getErrore());
                }
                msgDiag.highDebug("Ricezione effettuata");
                objReturn = receiverJMS.getObjectReceived();
                if (objReturn == null) {
                    throw new JMSException("Oggetto ricevuto dalla coda jms is null");
                }
                String idRisposta = null;
                String tipoMessaggio = null;
                if (idModulo.startsWith("RicezioneContenutiApplicativi")) {
                    msgDiag.highDebug("Lettura risposta per RicezioneContenutiApplicativi...");
                    idRisposta = ((RicezioneContenutiApplicativiMessage)objReturn).getIdEGovRisposta();
                    tipoMessaggio = "INBOX";
                    msgDiag.highDebug("Lettura risposta per RicezioneContenutiApplicativi effettuata");
                } else if (idModulo.startsWith("RicezioneBusteEGov")) {
                    msgDiag.highDebug("Lettura risposta per RicezioneBusteEGov...");
                    Busta bustaRisposta = ((RicezioneBusteEGovMessage)objReturn).getBustaRisposta();
                    idRisposta = bustaRisposta != null ? bustaRisposta.getID() : ((RicezioneBusteEGovMessage)objReturn).getIdMessaggioSblocco();
                    tipoMessaggio = "OUTBOX";
                    msgDiag.highDebug("Lettura risposta per RicezioneBusteEGov effettuata");
                }
                if (!TransactionManager.validityCheck(msgDiag, idModulo, idRisposta, tipoMessaggio, receiverJMS.getIdHeaderJMS())) {
                    msgDiag.highDebug("Messaggio con id[" + idMessaggio + "] non ha superato il validity check");
                    log.error((Object)("Messaggio con id[" + idMessaggio + "] non ha superato il validity check"));
                    continue;
                }
                break;
            }
        }
        catch (Exception e) {
            if (e.getMessage() != null) {
                if (e.getMessage().indexOf("Messaggio non ricevuto") >= 0) {
                    throw new NodeTimeoutException("Risposta per la gestione della richiesta, " + e.getMessage(), e);
                }
                throw new NodeException("Riscontrato errore nella ricezione del messaggio di risposta per la gestione della richiesta:" + e.getMessage(), e);
            }
            throw new NodeException("Riscontrato errore nella ricezione del messaggio di risposta per la gestione della richiesta", e);
        }
        return objReturn;
    }
}

