/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop.pdd.core.jmx;

import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import javax.management.Attribute;
import javax.management.AttributeList;
import javax.management.AttributeNotFoundException;
import javax.management.DynamicMBean;
import javax.management.InvalidAttributeValueException;
import javax.management.JMException;
import javax.management.MBeanAttributeInfo;
import javax.management.MBeanConstructorInfo;
import javax.management.MBeanException;
import javax.management.MBeanInfo;
import javax.management.MBeanOperationInfo;
import javax.management.NotificationBroadcasterSupport;
import javax.management.ReflectionException;
import org.apache.log4j.Logger;
import org.openspcoop.pdd.config.DBManager;
import org.openspcoop.pdd.config.OpenSPCoopProperties;
import org.openspcoop.pdd.config.QueueManager;
import org.openspcoop.pdd.core.connettori.IConnettore;
import org.openspcoop.pdd.core.connettori.RepositoryConnettori;
import org.openspcoop.pdd.logger.Dump;
import org.openspcoop.pdd.logger.MsgDiagnostico;
import org.openspcoop.pdd.logger.OpenSPCoopLogger;
import org.openspcoop.pdd.logger.Tracciamento;
import org.openspcoop.pdd.monitor.DriverMonitoraggio;
import org.openspcoop.pdd.monitor.dto.FilterSearch;
import org.openspcoop.pdd.monitor.dto.StatoPdD;
import org.openspcoop.pdd.timers.TimerMonitoraggioRisorse;
import org.openspcoop.pdd.timers.TimerThreshold;
import org.openspcoop.utils.Utilities;
import org.openspcoop.utils.date.DateManager;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MonitoraggioRisorse
extends NotificationBroadcasterSupport
implements DynamicMBean {
    static final String NUMERO_MSG_IN_CONSEGNA = "numMsgInConsegna";
    static final String TEMPO_MEDIO_ATTESA_IN_CONSEGNA = "tempoMedioAttesaInConsegna";
    static final String TEMPO_MAX_ATTESA_IN_CONSEGNA = "tempoMaxAttesaInConsegna";
    static final String NUMERO_MSG_IN_SPEDIZIONE = "numMsgInSpedizione";
    static final String TEMPO_MEDIO_ATTESA_IN_SPEDIZIONE = "tempoMedioAttesaInSpedizione";
    static final String TEMPO_MAX_ATTESA_IN_SPEDIZIONE = "tempoMaxAttesaInSpedizione";
    static final String NUMERO_MSG_IN_PROCESSAMENTO = "numMsgInProcessamento";
    static final String TEMPO_MEDIO_ATTESA_IN_PROCESSAMENTO = "tempoMedioAttesaInProcessamento";
    static final String TEMPO_MAX_ATTESA_IN_PROCESSAMENTO = "tempoMaxAttesaInProcessamento";
    static final String NUMERO_MSG_TOTALI = "totMessaggi";
    static final String TEMPO_MEDIO_ATTESA_MSG_TOTALI = "tempoMedioAttesa";
    static final String TEMPO_MAX_ATTESA_MSG_TOTALI = "tempoMaxAttesa";
    static final String TOT_MSG_DUPLICATI = "totMessaggiDuplicati";
    static final String STATO_DATI_MONITORAGGIO = "statoDatiMonitoraggioPdD";
    static final String RISORSE_DI_SISTEMA = "risorseDiSistema";
    static final String CONNESSIONI_ALLOCATE_DB_MANAGER = "getUsedDBConnections";
    static final String CONNESSIONI_ALLOCATE_QUEUE_MANAGER = "getUsedQueueConnections";
    static final String CONNESSIONI_ALLOCATE_CONNETTORI_PD = "getActivePDConnections";
    static final String CONNESSIONI_ALLOCATE_CONNETTORI_PA = "getActivePAConnections";
    private long numMsgInConsegna = 0L;
    private String tempoMedioAttesaInConsegna = "";
    private String tempoMaxAttesaInConsegna = "";
    private long numMsgInSpedizione = 0L;
    private String tempoMedioAttesaInSpedizione = "";
    private String tempoMaxAttesaInSpedizione = "";
    private long numMsgInProcessamento = 0L;
    private String tempoMedioAttesaInProcessamento = "";
    private String tempoMaxAttesaInProcessamento = "";
    private long totMessaggi = 0L;
    private String tempoMedioAttesa = "";
    private String tempoMaxAttesa = "";
    private long totMessaggiDuplicati = 0L;
    private String risorseDiSistema = "Lettura dati non effettuata         ";
    private String datiMonitoraggioPdD = "Non disponibili";
    private Logger log = OpenSPCoopLogger.getLoggerOpenSPCoopCore();

    @Override
    public Object getAttribute(String attributeName) throws AttributeNotFoundException, MBeanException, ReflectionException {
        if (attributeName == null || attributeName.equals("")) {
            throw new IllegalArgumentException("Il nome dell'attributo e' nullo o vuoto");
        }
        if (attributeName.equals(NUMERO_MSG_IN_CONSEGNA)) {
            return this.numMsgInConsegna;
        }
        if (attributeName.equals(TEMPO_MEDIO_ATTESA_IN_CONSEGNA)) {
            return this.tempoMedioAttesaInConsegna;
        }
        if (attributeName.equals(TEMPO_MAX_ATTESA_IN_CONSEGNA)) {
            return this.tempoMaxAttesaInConsegna;
        }
        if (attributeName.equals(NUMERO_MSG_IN_SPEDIZIONE)) {
            return this.numMsgInSpedizione;
        }
        if (attributeName.equals(TEMPO_MEDIO_ATTESA_IN_SPEDIZIONE)) {
            return this.tempoMedioAttesaInSpedizione;
        }
        if (attributeName.equals(TEMPO_MAX_ATTESA_IN_SPEDIZIONE)) {
            return this.tempoMaxAttesaInSpedizione;
        }
        if (attributeName.equals(NUMERO_MSG_IN_PROCESSAMENTO)) {
            return this.numMsgInProcessamento;
        }
        if (attributeName.equals(TEMPO_MEDIO_ATTESA_IN_PROCESSAMENTO)) {
            return this.tempoMedioAttesaInProcessamento;
        }
        if (attributeName.equals(TEMPO_MAX_ATTESA_IN_PROCESSAMENTO)) {
            return this.tempoMaxAttesaInProcessamento;
        }
        if (attributeName.equals(NUMERO_MSG_TOTALI)) {
            return this.totMessaggi;
        }
        if (attributeName.equals(TEMPO_MEDIO_ATTESA_MSG_TOTALI)) {
            return this.tempoMedioAttesa;
        }
        if (attributeName.equals(TEMPO_MAX_ATTESA_MSG_TOTALI)) {
            return this.tempoMaxAttesa;
        }
        if (attributeName.equals(TOT_MSG_DUPLICATI)) {
            return this.totMessaggiDuplicati;
        }
        if (attributeName.equals(RISORSE_DI_SISTEMA)) {
            return this.risorseDiSistema;
        }
        if (attributeName.equals(STATO_DATI_MONITORAGGIO)) {
            return this.datiMonitoraggioPdD;
        }
        throw new AttributeNotFoundException("Attributo " + attributeName + " non trovato");
    }

    @Override
    public AttributeList getAttributes(String[] attributesNames) {
        if (attributesNames == null) {
            throw new IllegalArgumentException("Array nullo");
        }
        AttributeList list = new AttributeList();
        for (int i = 0; i < attributesNames.length; ++i) {
            try {
                list.add(new Attribute(attributesNames[i], this.getAttribute(attributesNames[i])));
                continue;
            }
            catch (JMException ex) {
                // empty catch block
            }
        }
        return list;
    }

    @Override
    public void setAttribute(Attribute attribute) throws AttributeNotFoundException, InvalidAttributeValueException, MBeanException, ReflectionException {
        block19: {
            if (attribute == null) {
                throw new IllegalArgumentException("Il nome dell'attributo e' nullo");
            }
            try {
                if (attribute.getName().equals(NUMERO_MSG_IN_CONSEGNA)) {
                    this.numMsgInConsegna = (Long)attribute.getValue();
                    break block19;
                }
                if (attribute.getName().equals(TEMPO_MEDIO_ATTESA_IN_CONSEGNA)) {
                    this.tempoMedioAttesaInConsegna = (String)attribute.getValue();
                    break block19;
                }
                if (attribute.getName().equals(TEMPO_MAX_ATTESA_IN_CONSEGNA)) {
                    this.tempoMaxAttesaInConsegna = (String)attribute.getValue();
                    break block19;
                }
                if (attribute.getName().equals(NUMERO_MSG_IN_SPEDIZIONE)) {
                    this.numMsgInSpedizione = (Long)attribute.getValue();
                    break block19;
                }
                if (attribute.getName().equals(TEMPO_MEDIO_ATTESA_IN_SPEDIZIONE)) {
                    this.tempoMedioAttesaInSpedizione = (String)attribute.getValue();
                    break block19;
                }
                if (attribute.getName().equals(TEMPO_MAX_ATTESA_IN_SPEDIZIONE)) {
                    this.tempoMaxAttesaInSpedizione = (String)attribute.getValue();
                    break block19;
                }
                if (attribute.getName().equals(NUMERO_MSG_IN_PROCESSAMENTO)) {
                    this.numMsgInProcessamento = (Long)attribute.getValue();
                    break block19;
                }
                if (attribute.getName().equals(TEMPO_MEDIO_ATTESA_IN_PROCESSAMENTO)) {
                    this.tempoMedioAttesaInProcessamento = (String)attribute.getValue();
                    break block19;
                }
                if (attribute.getName().equals(TEMPO_MAX_ATTESA_IN_PROCESSAMENTO)) {
                    this.tempoMaxAttesaInProcessamento = (String)attribute.getValue();
                    break block19;
                }
                if (attribute.getName().equals(NUMERO_MSG_TOTALI)) {
                    this.totMessaggi = (Long)attribute.getValue();
                    break block19;
                }
                if (attribute.getName().equals(TEMPO_MEDIO_ATTESA_MSG_TOTALI)) {
                    this.tempoMedioAttesa = (String)attribute.getValue();
                    break block19;
                }
                if (attribute.getName().equals(TEMPO_MAX_ATTESA_MSG_TOTALI)) {
                    this.tempoMaxAttesa = (String)attribute.getValue();
                    break block19;
                }
                if (attribute.getName().equals(TOT_MSG_DUPLICATI)) {
                    this.totMessaggiDuplicati = (Long)attribute.getValue();
                    break block19;
                }
                if (attribute.getName().equals(RISORSE_DI_SISTEMA)) {
                    this.risorseDiSistema = (String)attribute.getValue();
                    break block19;
                }
                if (attribute.getName().equals(STATO_DATI_MONITORAGGIO)) {
                    this.refreshDatiMonitoraggioPdD();
                    break block19;
                }
                throw new AttributeNotFoundException("Attributo " + attribute.getName() + " non trovato");
            }
            catch (ClassCastException ce) {
                throw new InvalidAttributeValueException("il tipo " + attribute.getValue().getClass() + " dell'attributo " + attribute.getName() + " non e' valido");
            }
            catch (JMException j) {
                throw new MBeanException(j);
            }
        }
    }

    @Override
    public AttributeList setAttributes(AttributeList list) {
        if (list == null) {
            throw new IllegalArgumentException("Lista degli attributi e' nulla");
        }
        AttributeList ret = new AttributeList();
        Iterator it = ret.iterator();
        while (it.hasNext()) {
            try {
                Attribute attribute = (Attribute)it.next();
                this.setAttribute(attribute);
                ret.add(attribute);
            }
            catch (JMException ex) {}
        }
        return ret;
    }

    @Override
    public Object invoke(String actionName, Object[] params, String[] signature) throws MBeanException, ReflectionException {
        if (actionName == null || actionName.equals("")) {
            throw new IllegalArgumentException("Nessuna operazione definita");
        }
        if (actionName.equals(CONNESSIONI_ALLOCATE_DB_MANAGER)) {
            return this.getUsedDBConnections();
        }
        if (actionName.equals(CONNESSIONI_ALLOCATE_QUEUE_MANAGER)) {
            return this.getUsedQueueConnections();
        }
        if (actionName.equals(CONNESSIONI_ALLOCATE_CONNETTORI_PD)) {
            return this.getActivePDConnections();
        }
        if (actionName.equals(CONNESSIONI_ALLOCATE_CONNETTORI_PA)) {
            return this.getActivePAConnections();
        }
        throw new UnsupportedOperationException("Operazione " + actionName + " sconosciuta");
    }

    @Override
    public MBeanInfo getMBeanInfo() {
        boolean READABLE = true;
        boolean WRITABLE = true;
        boolean IS_GETTER = true;
        String className = this.getClass().getName();
        String description = "Monitoraggio delle risorse utilizzate dalla Porta di Dominio " + OpenSPCoopProperties.getInstance().getVersione() + ", premi pulsante (apply changes) per aggiornare i dati";
        MBeanAttributeInfo numMsgInConsegnaVAR = new MBeanAttributeInfo(NUMERO_MSG_IN_CONSEGNA, Long.TYPE.getName(), "Numero di Messaggi in gestione nel modulo 'ConsegnaContenutiApplicativi'", true, false, false);
        MBeanAttributeInfo tempoMedioAttesaInConsegnaVAR = new MBeanAttributeInfo(TEMPO_MEDIO_ATTESA_IN_CONSEGNA, String.class.getName(), "Tempo medio di attesa dei Messaggi prima di essere stati consegnati ai servizi applicativi dal modulo 'ConsegnaContenutiApplicativi'", true, false, false);
        MBeanAttributeInfo tempoMaxAttesaInConsegnaVAR = new MBeanAttributeInfo(TEMPO_MAX_ATTESA_IN_CONSEGNA, String.class.getName(), "Tempo massimo di attesa dei Messaggi prima di essere stati consegnati ai servizi applicativi dal modulo 'ConsegnaContenutiApplicativi'", true, false, false);
        MBeanAttributeInfo numMsgInSpedizioneVAR = new MBeanAttributeInfo(NUMERO_MSG_IN_SPEDIZIONE, Long.TYPE.getName(), "Numero di Messaggi in gestione nei moduli 'InoltroBusteEGov'", true, false, false);
        MBeanAttributeInfo tempoMedioAttesaInSpedizioneVAR = new MBeanAttributeInfo(TEMPO_MEDIO_ATTESA_IN_SPEDIZIONE, String.class.getName(), "Tempo medio di attesa dei Messaggi prima di essere stati inoltrate alle porte di dominio destinatarie dai moduli 'InoltroBusteEGov'", true, false, false);
        MBeanAttributeInfo tempoMaxAttesaInSpedizioneVAR = new MBeanAttributeInfo(TEMPO_MAX_ATTESA_IN_SPEDIZIONE, String.class.getName(), "Tempo massimo di attesa dei Messaggi prima di essere stati inoltrate alle porte di dominio destinatarie dai moduli 'InoltroBusteEGov'", true, false, false);
        MBeanAttributeInfo numMsgInProcessamentoVAR = new MBeanAttributeInfo(NUMERO_MSG_IN_PROCESSAMENTO, Long.TYPE.getName(), "Numero di Messaggi in gestione nei moduli interni all'infrastruttura della porta di dominio", true, false, false);
        MBeanAttributeInfo tempoMedioAttesaInProcessamentoVAR = new MBeanAttributeInfo(TEMPO_MEDIO_ATTESA_IN_PROCESSAMENTO, String.class.getName(), "Tempo medio di attesa in gestione nei moduli interni all'infrastruttura della porta di dominio", true, false, false);
        MBeanAttributeInfo tempoMaxAttesaInProcessamentoVAR = new MBeanAttributeInfo(TEMPO_MAX_ATTESA_IN_PROCESSAMENTO, String.class.getName(), "Tempo massimo di attesa in gestione nei moduli interni all'infrastruttura della porta di dominio", true, false, false);
        MBeanAttributeInfo totMessaggiVAR = new MBeanAttributeInfo(NUMERO_MSG_TOTALI, Long.TYPE.getName(), "Numero di Messaggi totali in gestione nella porta di dominio", true, false, false);
        MBeanAttributeInfo tempoMedioAttesaVAR = new MBeanAttributeInfo(TEMPO_MEDIO_ATTESA_MSG_TOTALI, String.class.getName(), "Tempo medio di attesa dei Messaggi gestiti nella porta di dominio", true, false, false);
        MBeanAttributeInfo tempoMaxAttesaVAR = new MBeanAttributeInfo(TEMPO_MAX_ATTESA_MSG_TOTALI, String.class.getName(), "Tempo massimo di attesa dei Messaggi gestiti nella porta di dominio", true, false, false);
        MBeanAttributeInfo totMessaggiDuplicatiVAR = new MBeanAttributeInfo(TOT_MSG_DUPLICATI, Long.TYPE.getName(), "Numero di Messaggi duplicati gestiti nella porta di dominio", true, false, false);
        MBeanAttributeInfo risorseDisponibiliVAR = new MBeanAttributeInfo(RISORSE_DI_SISTEMA, String.class.getName(), "Indicazione sullo stato delle risorse disponibili per la porta di dominio", true, false, false);
        MBeanAttributeInfo monitoraggioPdDVAR = new MBeanAttributeInfo(STATO_DATI_MONITORAGGIO, String.class.getName(), "Monitoraggio della porta di dominio, premi pulsante (apply changes) per aggiornare i dati", true, true, false);
        MBeanOperationInfo getConnessioneAllocateDBManagerOP = new MBeanOperationInfo(CONNESSIONI_ALLOCATE_DB_MANAGER, "Moduli funzionali che dispongono di una connessione verso il database dei messaggi", null, String.class.getName(), 1);
        MBeanOperationInfo getConnessioneAllocateQueueManagerOP = new MBeanOperationInfo(CONNESSIONI_ALLOCATE_QUEUE_MANAGER, "Moduli funzionali che dispongono di una connessione verso il Broker JMS", null, String.class.getName(), 1);
        MBeanOperationInfo getActiveConnectionsPD_OP = new MBeanOperationInfo(CONNESSIONI_ALLOCATE_CONNETTORI_PD, "Connessioni attive su cui e' in corso un inoltro di busta e-Gov (PortaDelegata)", null, String.class.getName(), 1);
        MBeanOperationInfo getActiveConnectionsPA_OP = new MBeanOperationInfo(CONNESSIONI_ALLOCATE_CONNETTORI_PA, "Connessioni attive su cui e' in corso una consegna di contenuti applicativi (PortaApplicativa)", null, String.class.getName(), 1);
        MBeanConstructorInfo defaultConstructor = new MBeanConstructorInfo("Default Constructor", "Crea e inizializza una nuova istanza del MBean", null);
        MBeanAttributeInfo[] attributes = new MBeanAttributeInfo[]{monitoraggioPdDVAR, risorseDisponibiliVAR, numMsgInConsegnaVAR, tempoMedioAttesaInConsegnaVAR, tempoMaxAttesaInConsegnaVAR, numMsgInSpedizioneVAR, tempoMedioAttesaInSpedizioneVAR, tempoMaxAttesaInSpedizioneVAR, numMsgInProcessamentoVAR, tempoMedioAttesaInProcessamentoVAR, tempoMaxAttesaInProcessamentoVAR, totMessaggiVAR, tempoMedioAttesaVAR, tempoMaxAttesaVAR, totMessaggiDuplicatiVAR};
        MBeanConstructorInfo[] constructors = new MBeanConstructorInfo[]{defaultConstructor};
        MBeanOperationInfo[] operations = new MBeanOperationInfo[]{getConnessioneAllocateDBManagerOP, getConnessioneAllocateQueueManagerOP, getActiveConnectionsPD_OP, getActiveConnectionsPA_OP};
        return new MBeanInfo(className, description, attributes, constructors, operations, null);
    }

    public void refreshDatiMonitoraggioPdD() {
        StringBuffer bf = new StringBuffer();
        if (!TimerMonitoraggioRisorse.risorseDisponibili) {
            bf.append("Risorse di sistema non disponibili: " + TimerMonitoraggioRisorse.risorsaNonDisponibile.getMessage());
        }
        if (!TimerThreshold.freeSpace) {
            if (bf.length() > 0) {
                bf.append("\n");
            }
            bf.append("[ThresholdCheck] Non sono disponibili abbastanza risorse per la gestione delle richieste");
        }
        if (!Tracciamento.tracciamentoDisponibile) {
            if (bf.length() > 0) {
                bf.append("\n");
            }
            bf.append("Tracciamento e-Gov non disponibile: " + Tracciamento.motivoMalfunzionamentoTracciamento.getMessage());
        }
        if (!MsgDiagnostico.gestoreDiagnosticaDisponibile) {
            if (bf.length() > 0) {
                bf.append("\n");
            }
            bf.append("Sistema di diagnostica non disponibile: " + MsgDiagnostico.motivoMalfunzionamentoDiagnostici.getMessage());
        }
        if (!Dump.sistemaDumpDisponibile) {
            if (bf.length() > 0) {
                bf.append("\n");
            }
            bf.append("Sistema di dump dei contenuti applicativi non disponibile: " + Dump.motivoMalfunzionamentoDump.getMessage());
        }
        if (bf.length() == 0) {
            bf.append("La Porta di Dominio possiede le adeguate risorse di sistema");
        }
        this.risorseDiSistema = bf.toString();
        try {
            OpenSPCoopProperties properties = OpenSPCoopProperties.getInstance();
            if (properties.getDatabaseType() != null) {
                DriverMonitoraggio driver = new DriverMonitoraggio(properties.getJNDIName_DataSource(), properties.getDatabaseType(), properties.getJNDIContext_DataSource(), this.log);
                StatoPdD stato = driver.getStatoRichiestePendenti(new FilterSearch());
                this.numMsgInConsegna = stato.getNumMsgInConsegna();
                this.numMsgInSpedizione = stato.getNumMsgInSpedizione();
                this.numMsgInProcessamento = stato.getNumMsgInProcessamento();
                this.totMessaggi = stato.getTotMessaggi();
                this.totMessaggiDuplicati = stato.getTotMessaggiDuplicati();
                if (stato.getTempoMaxAttesa() > 0L) {
                    this.tempoMaxAttesa = Utilities.convertSystemTimeIntoString_millisecondi((long)(stato.getTempoMaxAttesa() * 1000L), (boolean)false);
                }
                if (stato.getTempoMaxAttesaInConsegna() > 0L) {
                    this.tempoMaxAttesaInConsegna = Utilities.convertSystemTimeIntoString_millisecondi((long)(stato.getTempoMaxAttesaInConsegna() * 1000L), (boolean)false);
                }
                if (stato.getTempoMaxAttesaInSpedizione() > 0L) {
                    this.tempoMaxAttesaInSpedizione = Utilities.convertSystemTimeIntoString_millisecondi((long)(stato.getTempoMaxAttesaInSpedizione() * 1000L), (boolean)false);
                }
                if (stato.getTempoMaxAttesaInProcessamento() > 0L) {
                    this.tempoMaxAttesaInProcessamento = Utilities.convertSystemTimeIntoString_millisecondi((long)(stato.getTempoMaxAttesaInProcessamento() * 1000L), (boolean)false);
                }
                if (stato.getTempoMedioAttesa() > 0L) {
                    this.tempoMedioAttesa = Utilities.convertSystemTimeIntoString_millisecondi((long)(stato.getTempoMedioAttesa() * 1000L), (boolean)false);
                }
                if (stato.getTempoMedioAttesaInConsegna() > 0L) {
                    this.tempoMedioAttesaInConsegna = Utilities.convertSystemTimeIntoString_millisecondi((long)(stato.getTempoMedioAttesaInConsegna() * 1000L), (boolean)false);
                }
                if (stato.getTempoMedioAttesaInSpedizione() > 0L) {
                    this.tempoMedioAttesaInSpedizione = Utilities.convertSystemTimeIntoString_millisecondi((long)(stato.getTempoMedioAttesaInSpedizione() * 1000L), (boolean)false);
                }
                if (stato.getTempoMedioAttesaInProcessamento() > 0L) {
                    this.tempoMedioAttesaInProcessamento = Utilities.convertSystemTimeIntoString_millisecondi((long)(stato.getTempoMedioAttesaInProcessamento() * 1000L), (boolean)false);
                }
            } else {
                this.datiMonitoraggioPdD = "Non disponibili: e' necessario indicare il tipo di database in openspcoop.properties";
                throw new Exception("Per il monitoraggio della porta di dominio e' necessario indicare il tipo di database in openspcoop.properties");
            }
            this.datiMonitoraggioPdD = "Aggiornati al " + DateManager.getDate().toString();
        }
        catch (Exception e) {
            this.log.error((Object)"DriverMonitoraggio non inizializzato", (Throwable)e);
            this.datiMonitoraggioPdD = "Non disponibili: " + e.getMessage();
        }
    }

    public String getUsedDBConnections() {
        String[] risorse = null;
        try {
            risorse = DBManager.getStatoRisorse();
        }
        catch (Exception e) {
            return e.getMessage();
        }
        if (risorse == null) {
            return "Nessuna connessione allocata";
        }
        StringBuffer bf = new StringBuffer();
        bf.append(risorse.length + " risorse allocate: \n");
        for (int i = 0; i < risorse.length; ++i) {
            bf.append(risorse[i] + "\n");
        }
        return bf.toString();
    }

    public String getUsedQueueConnections() {
        String[] risorse = null;
        try {
            risorse = QueueManager.getStatoRisorse();
        }
        catch (Exception e) {
            return e.getMessage();
        }
        if (risorse == null) {
            return "Nessuna connessione allocata";
        }
        StringBuffer bf = new StringBuffer();
        bf.append(risorse.length + " risorse allocate: \n");
        for (int i = 0; i < risorse.length; ++i) {
            bf.append(risorse[i] + "\n");
        }
        return bf.toString();
    }

    public String getActivePDConnections() {
        Hashtable<String, IConnettore> connettori_pd = RepositoryConnettori.getConnettori_pd();
        return this.getActiveConnections(connettori_pd);
    }

    public String getActivePAConnections() {
        Hashtable<String, IConnettore> connettori_pa = RepositoryConnettori.getConnettori_pa();
        return this.getActiveConnections(connettori_pa);
    }

    private String getActiveConnections(Hashtable<String, IConnettore> connettori) {
        if (connettori == null || connettori.size() == 0) {
            return "Nessuna connessione allocata";
        }
        StringBuffer bf = new StringBuffer();
        bf.append(connettori.size() + " connessioni allocate: \n");
        Enumeration<String> cs = connettori.keys();
        while (cs.hasMoreElements()) {
            String id = cs.nextElement();
            IConnettore c = connettori.get(id);
            bf.append(id + " -> [" + c.getLocation() + "]\n");
        }
        return bf.toString();
    }
}

