/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop.pdd.core.jmx;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.Properties;
import java.util.Vector;
import javax.management.MBeanServer;
import javax.management.MBeanServerFactory;
import javax.management.ObjectName;
import org.apache.log4j.Logger;
import org.openspcoop.pdd.core.jmx.AccessoRegistroServizi;
import org.openspcoop.pdd.core.jmx.ConfigurazionePdD;
import org.openspcoop.pdd.core.jmx.EngineAutorizzazioneSPCoop;
import org.openspcoop.pdd.core.jmx.MonitoraggioRisorse;
import org.openspcoop.pdd.core.jmx.RepositoryMessaggi;
import org.openspcoop.pdd.core.jmx.RisorseJMXException;
import org.openspcoop.pdd.logger.OpenSPCoopLogger;
import org.openspcoop.utils.GestoreJNDI;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GestoreRisorseJMX {
    private MBeanServer mbeanServer;
    private Logger log;
    private Vector<ObjectName> jmxNames;

    public GestoreRisorseJMX() throws RisorseJMXException {
        this(null, null, null);
    }

    public GestoreRisorseJMX(Logger logger) throws RisorseJMXException {
        this(null, null, logger);
    }

    public GestoreRisorseJMX(String jndiNameMBeanServer, Properties jndiContext) throws RisorseJMXException {
        this(jndiNameMBeanServer, jndiContext, null);
    }

    public GestoreRisorseJMX(String jndiNameMBeanServer, Properties jndiContext, Logger logger) throws RisorseJMXException {
        block13: {
            this.mbeanServer = null;
            this.log = null;
            this.jmxNames = new Vector();
            if (logger == null) {
                this.log = OpenSPCoopLogger.getLoggerOpenSPCoopCore();
                if (this.log == null) {
                    this.log = Logger.getLogger((String)"GestoreRisorseJMX");
                }
            } else {
                this.log = logger;
            }
            try {
                if (jndiNameMBeanServer != null) {
                    GestoreJNDI jndi = new GestoreJNDI(jndiContext);
                    this.mbeanServer = (MBeanServer)jndi.lookup(jndiNameMBeanServer);
                    if (this.mbeanServer == null) {
                        throw new Exception("MBeanServer [" + jndiNameMBeanServer + "] non trovato");
                    }
                    if (logger == null) {
                        OpenSPCoopLogger.getLoggerOpenSPCoopConsole().info((Object)("Attivata gestione jmx attraverso MBeanServer [" + jndiNameMBeanServer + "]: " + this.mbeanServer.toString()));
                    }
                    this.log.info((Object)("Attivata gestione jmx attraverso MBeanServer [" + jndiNameMBeanServer + "]: " + this.mbeanServer.toString()));
                    break block13;
                }
                ArrayList<MBeanServer> lServer = MBeanServerFactory.findMBeanServer(null);
                if (lServer == null) {
                    throw new RisorseJMXException("Lista di MBean Server di default non trovata (MBeanServerFactory.findMBeanServer)");
                }
                if (lServer.isEmpty()) {
                    throw new RisorseJMXException("Lista di MBean Server di default vuota");
                }
                Iterator<MBeanServer> it = lServer.iterator();
                if (it.hasNext()) {
                    this.mbeanServer = it.next();
                    if (this.mbeanServer == null) {
                        throw new Exception("MBeanServer di default non trovato");
                    }
                    if (logger == null) {
                        OpenSPCoopLogger.getLoggerOpenSPCoopConsole().info((Object)("Attivata gestione jmx attraverso MBeanServer: " + this.mbeanServer.toString()));
                    }
                    this.log.info((Object)("Attivata gestione jmx attraverso MBeanServer: " + this.mbeanServer.toString()));
                    break block13;
                }
                throw new RisorseJMXException("Lista di MBean Server di default vuota ?");
            }
            catch (Exception e) {
                this.log.error((Object)("Riscontrato errore durante l'inizializzazione del gestore delle RisorseJMX: " + e.getMessage()), (Throwable)e);
                throw new RisorseJMXException("Riscontrato errore durante l'inizializzazione del gestore delle RisorseJMX: " + e.getMessage(), e);
            }
        }
    }

    public void registerMBeanConfigurazionePdD() throws RisorseJMXException {
        try {
            ObjectName jmxNameConfigurazione = new ObjectName("org.openspcoop.pdd", "type", "ConfigurazionePdD");
            this.mbeanServer.registerMBean(new ConfigurazionePdD(), jmxNameConfigurazione);
            this.jmxNames.add(jmxNameConfigurazione);
        }
        catch (Exception e) {
            this.log.error((Object)("Riscontrato errore durante l'inizializzazione della risorsa JMX ConfigurazionePdD: " + e.getMessage()), (Throwable)e);
            throw new RisorseJMXException("Riscontrato errore durante l'inizializzazione della risorsa JMX ConfigurazionePdD: " + e.getMessage(), e);
        }
    }

    public void registerMBeanAccessoRegistroServizi() throws RisorseJMXException {
        try {
            ObjectName jmxNameRegistro = new ObjectName("org.openspcoop.pdd", "type", "AccessoRegistroServizi");
            this.mbeanServer.registerMBean(new AccessoRegistroServizi(), jmxNameRegistro);
            this.jmxNames.add(jmxNameRegistro);
        }
        catch (Exception e) {
            this.log.error((Object)("Riscontrato errore durante l'inizializzazione della risorsa JMX AccessoRegistroServizi: " + e.getMessage()), (Throwable)e);
            throw new RisorseJMXException("Riscontrato errore durante l'inizializzazione della risorsa JMX AccessoRegistroServizi: " + e.getMessage(), e);
        }
    }

    public void registerMBeanMonitoraggioRisorse() throws RisorseJMXException {
        try {
            ObjectName jmxNameMonitoraggio = new ObjectName("org.openspcoop.pdd", "type", "MonitoraggioRisorse");
            this.mbeanServer.registerMBean(new MonitoraggioRisorse(), jmxNameMonitoraggio);
            this.jmxNames.add(jmxNameMonitoraggio);
        }
        catch (Exception e) {
            this.log.error((Object)("Riscontrato errore durante l'inizializzazione della risorsa JMX MonitoraggioRisorse: " + e.getMessage()), (Throwable)e);
            throw new RisorseJMXException("Riscontrato errore durante l'inizializzazione della risorsa JMX MonitoraggioRisorse: " + e.getMessage(), e);
        }
    }

    public void registerMBeanAutorizzazioneSPCoop() throws RisorseJMXException {
        try {
            ObjectName jmxNameAutorizzazioneSPCoop = new ObjectName("org.openspcoop.pdd", "type", "AutorizzazioneSPCoop");
            this.mbeanServer.registerMBean(new EngineAutorizzazioneSPCoop(), jmxNameAutorizzazioneSPCoop);
            this.jmxNames.add(jmxNameAutorizzazioneSPCoop);
        }
        catch (Exception e) {
            this.log.error((Object)("Riscontrato errore durante l'inizializzazione della risorsa JMX AutorizzazioneSPCoop: " + e.getMessage()), (Throwable)e);
            throw new RisorseJMXException("Riscontrato errore durante l'inizializzazione della risorsa JMX AutorizzazioneSPCoop: " + e.getMessage(), e);
        }
    }

    public void registerMBeanRepositoryMessaggi() throws RisorseJMXException {
        try {
            ObjectName jmxNameRepositoryMessaggi = new ObjectName("org.openspcoop.pdd", "type", "RepositoryMessaggi");
            this.mbeanServer.registerMBean(new RepositoryMessaggi(), jmxNameRepositoryMessaggi);
            this.jmxNames.add(jmxNameRepositoryMessaggi);
        }
        catch (Exception e) {
            this.log.error((Object)("Riscontrato errore durante l'inizializzazione della risorsa JMX RepositoryMessaggi: " + e.getMessage()), (Throwable)e);
            throw new RisorseJMXException("Riscontrato errore durante l'inizializzazione della risorsa JMX RepositoryMessaggi: " + e.getMessage(), e);
        }
    }

    public void registerMBean(Class<?> c, String nome) throws RisorseJMXException {
        try {
            ObjectName jmxName = new ObjectName("org.openspcoop.pdd", "type", nome);
            this.mbeanServer.registerMBean(c.newInstance(), jmxName);
            this.jmxNames.add(jmxName);
        }
        catch (Exception e) {
            this.log.error((Object)("Riscontrato errore durante l'inizializzazione della risorsa JMX AutorizzazioneSPCoop: " + e.getMessage()), (Throwable)e);
            throw new RisorseJMXException("Riscontrato errore durante l'inizializzazione della risorsa JMX AutorizzazioneSPCoop: " + e.getMessage(), e);
        }
    }

    public void unregisterMBeans() {
        for (int i = 0; i < this.jmxNames.size(); ++i) {
            ObjectName jmxName = this.jmxNames.get(i);
            try {
                this.mbeanServer.unregisterMBean(jmxName);
                this.log.info((Object)("Unbound della risorsa JMX [" + jmxName.toString() + "]"));
                continue;
            }
            catch (Exception e) {
                this.log.error((Object)("Riscontrato errore durante l'unbound della risorsa JMX [" + jmxName.toString() + "]: " + e.getMessage()), (Throwable)e);
            }
        }
    }

    public Object getAttributeMBeanConfigurazionePdD(String nomeAttributo) throws RisorseJMXException {
        return this.getAttribute("ConfigurazionePdD", nomeAttributo);
    }

    public Object getAttributeMBeanAccessoRegistroServizi(String nomeAttributo) throws RisorseJMXException {
        return this.getAttribute("AccessoRegistroServizi", nomeAttributo);
    }

    public Object getAttributeMBeanAutorizzazioneSPCoop(String nomeAttributo) throws RisorseJMXException {
        return this.getAttribute("AutorizzazioneSPCoop", nomeAttributo);
    }

    public Object getAttributeMBeanMonitoraggioRisorse(String nomeAttributo) throws RisorseJMXException {
        return this.getAttribute("MonitoraggioRisorse", nomeAttributo);
    }

    public Object getAttributeMBeanRepositoryMessaggi(String nomeAttributo) throws RisorseJMXException {
        return this.getAttribute("RepositoryMessaggi", nomeAttributo);
    }

    public Object getAttribute(String nomeRisorsa, String nomeAttributo) throws RisorseJMXException {
        try {
            ObjectName name = new ObjectName("org.openspcoop.pdd", "type", nomeRisorsa);
            return this.mbeanServer.getAttribute(name, nomeAttributo);
        }
        catch (Exception e) {
            this.log.error((Object)("Riscontrato errore durante la lettura dell'attributo [" + nomeAttributo + "] della risorsa [" + nomeRisorsa + "]: " + e.getMessage()), (Throwable)e);
            throw new RisorseJMXException("Riscontrato errore durante la lettura dell'attributo [" + nomeAttributo + "] della risorsa [" + nomeRisorsa + "]: " + e.getMessage(), e);
        }
    }

    public Object invokeMethodMBeanConfigurazionePdD(String nomeMetodo, Object[] params, String[] signature) throws RisorseJMXException {
        return this.invoke("ConfigurazionePdD", nomeMetodo, params, signature);
    }

    public Object invokeMethodMBeanConfigurazionePdD(String nomeMetodo) throws RisorseJMXException {
        return this.invoke("ConfigurazionePdD", nomeMetodo, null, null);
    }

    public Object invokeMethodMBeanAccessoRegistroServizi(String nomeMetodo, Object[] params, String[] signature) throws RisorseJMXException {
        return this.invoke("AccessoRegistroServizi", nomeMetodo, params, signature);
    }

    public Object invokeMethodMBeanAccessoRegistroServizi(String nomeMetodo) throws RisorseJMXException {
        return this.invoke("AccessoRegistroServizi", nomeMetodo, null, null);
    }

    public Object invokeMethodMBeanAutorizzazioneSPCoop(String nomeMetodo, Object[] params, String[] signature) throws RisorseJMXException {
        return this.invoke("AutorizzazioneSPCoop", nomeMetodo, params, signature);
    }

    public Object invokeMethodMBeanAutorizzazioneSPCoop(String nomeMetodo) throws RisorseJMXException {
        return this.invoke("AutorizzazioneSPCoop", nomeMetodo, null, null);
    }

    public Object invokeMethodMBeanMonitoraggioRisorse(String nomeMetodo, Object[] params, String[] signature) throws RisorseJMXException {
        return this.invoke("MonitoraggioRisorse", nomeMetodo, params, signature);
    }

    public Object invokeMethodMBeanMonitoraggioRisorse(String nomeMetodo) throws RisorseJMXException {
        return this.invoke("MonitoraggioRisorse", nomeMetodo, null, null);
    }

    public Object invokeMethodMBeanRepositoryMessaggi(String nomeMetodo, Object[] params, String[] signature) throws RisorseJMXException {
        return this.invoke("RepositoryMessaggi", nomeMetodo, params, signature);
    }

    public Object invokeMethodMBeanRepositoryMessaggi(String nomeMetodo) throws RisorseJMXException {
        return this.invoke("RepositoryMessaggi", nomeMetodo, null, null);
    }

    public Object invoke(String nomeRisorsa, String nomeMetodo, Object[] params, String[] signature) throws RisorseJMXException {
        try {
            ObjectName name = new ObjectName("org.openspcoop.pdd", "type", nomeRisorsa);
            return this.mbeanServer.invoke(name, nomeMetodo, params, signature);
        }
        catch (Exception e) {
            this.log.error((Object)("Riscontrato errore durante l'invocazione del metodo [" + nomeMetodo + "] della risorsa [" + nomeRisorsa + "]: " + e.getMessage()), (Throwable)e);
            throw new RisorseJMXException("Riscontrato errore durante l'invocazione del metodo [" + nomeMetodo + "] della risorsa [" + nomeRisorsa + "]: " + e.getMessage(), e);
        }
    }
}

