/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop.pdd.core.jmx;

import java.util.Iterator;
import javax.management.Attribute;
import javax.management.AttributeList;
import javax.management.AttributeNotFoundException;
import javax.management.DynamicMBean;
import javax.management.InvalidAttributeValueException;
import javax.management.JMException;
import javax.management.MBeanAttributeInfo;
import javax.management.MBeanConstructorInfo;
import javax.management.MBeanException;
import javax.management.MBeanInfo;
import javax.management.MBeanOperationInfo;
import javax.management.MBeanParameterInfo;
import javax.management.NotificationBroadcasterSupport;
import javax.management.ReflectionException;
import org.apache.log4j.Logger;
import org.openspcoop.pdd.config.OpenSPCoopProperties;
import org.openspcoop.pdd.core.autorizzazione.GestoreAutorizzazioneSPCoop;
import org.openspcoop.pdd.logger.OpenSPCoopLogger;

public class EngineAutorizzazioneSPCoop
extends NotificationBroadcasterSupport
implements DynamicMBean {
    static final String TIPO_AUTORIZZAZIONE_SPCOOP = "tipoAutorizzazioneSPCoop";
    static final String CACHE_ABILITATA = "cacheAbilitata";
    static final String RESET_CACHE = "resetCache";
    static final String ABILITA_CACHE = "abilitaCache";
    public boolean cacheAbilitata = false;
    private Logger log = OpenSPCoopLogger.getLoggerOpenSPCoopCore();

    public Object getAttribute(String attributeName) throws AttributeNotFoundException, MBeanException, ReflectionException {
        if (attributeName == null || attributeName.equals("")) {
            throw new IllegalArgumentException("Il nome dell'attributo e' nullo o vuoto");
        }
        if (attributeName.equals(TIPO_AUTORIZZAZIONE_SPCOOP)) {
            return GestoreAutorizzazioneSPCoop.getTipoAutorizzazioneSPCoop();
        }
        if (attributeName.equals(CACHE_ABILITATA)) {
            return this.cacheAbilitata;
        }
        throw new AttributeNotFoundException("Attributo " + attributeName + " non trovato");
    }

    public AttributeList getAttributes(String[] attributesNames) {
        if (attributesNames == null) {
            throw new IllegalArgumentException("Array nullo");
        }
        AttributeList list = new AttributeList();
        for (int i = 0; i < attributesNames.length; ++i) {
            try {
                list.add(new Attribute(attributesNames[i], this.getAttribute(attributesNames[i])));
                continue;
            }
            catch (JMException ex) {
                // empty catch block
            }
        }
        return list;
    }

    public void setAttribute(Attribute attribute) throws AttributeNotFoundException, InvalidAttributeValueException, MBeanException, ReflectionException {
        block7: {
            if (attribute == null) {
                throw new IllegalArgumentException("Il nome dell'attributo e' nullo");
            }
            try {
                if (attribute.getName().equals(CACHE_ABILITATA)) {
                    boolean v = (Boolean)attribute.getValue();
                    if (v) {
                        this.abilitaCache();
                    } else {
                        this.disabilitaCache();
                    }
                    break block7;
                }
                throw new AttributeNotFoundException("Attributo " + attribute.getName() + " non trovato");
            }
            catch (ClassCastException ce) {
                throw new InvalidAttributeValueException("il tipo " + attribute.getValue().getClass() + " dell'attributo " + attribute.getName() + " non e' valido");
            }
            catch (JMException j) {
                throw new MBeanException(j);
            }
        }
    }

    public AttributeList setAttributes(AttributeList list) {
        if (list == null) {
            throw new IllegalArgumentException("Lista degli attributi e' nulla");
        }
        AttributeList ret = new AttributeList();
        Iterator it = ret.iterator();
        while (it.hasNext()) {
            try {
                Attribute attribute = (Attribute)it.next();
                this.setAttribute(attribute);
                ret.add(attribute);
            }
            catch (JMException ex) {}
        }
        return ret;
    }

    public Object invoke(String actionName, Object[] params, String[] signature) throws MBeanException, ReflectionException {
        if (actionName == null || actionName.equals("")) {
            throw new IllegalArgumentException("Nessuna operazione definita");
        }
        if (actionName.equals(RESET_CACHE)) {
            return this.resetCache();
        }
        if (actionName.equals(ABILITA_CACHE)) {
            if (params.length != 4) {
                throw new MBeanException(new Exception("[AbilitaCache] Lunghezza parametri non corretta: " + params.length));
            }
            return this.abilitaCache((Long)params[0], (Boolean)params[1], (Long)params[2], (Long)params[3]);
        }
        throw new UnsupportedOperationException("Operazione " + actionName + " sconosciuta");
    }

    public MBeanInfo getMBeanInfo() {
        boolean READABLE = true;
        boolean WRITABLE = true;
        boolean IS_GETTER = true;
        String className = this.getClass().getName();
        String description = "Risorsa per la configurazione dell'autorizzazione intrapresa della Porta di Dominio " + OpenSPCoopProperties.getInstance().getVersione();
        MBeanAttributeInfo tipoAutorizzazioneSPCoopVAR = new MBeanAttributeInfo(TIPO_AUTORIZZAZIONE_SPCOOP, String.class.getName(), "Tipo di autorizzazione SPCoop intrapresa dalla Porta di Dominio", true, false, false);
        MBeanAttributeInfo cacheAbilitataVAR = new MBeanAttributeInfo(CACHE_ABILITATA, Boolean.TYPE.getName(), "Indicazione se e' abilita una cache anteposta al processo di autorizzazione SPCoop", true, true, false);
        MBeanOperationInfo resetCacheOP = new MBeanOperationInfo(RESET_CACHE, "Svuota la cache delle autorizzazioni SPCoop", null, String.class.getName(), 1);
        MBeanOperationInfo abilitaCacheParametriOP = new MBeanOperationInfo(ABILITA_CACHE, "Abilita la cache anteposta al processo di autorizzazione SPCoop", new MBeanParameterInfo[]{new MBeanParameterInfo("dimensioneCache", Long.TYPE.getName(), "Dimensione della cache"), new MBeanParameterInfo("algoritmoCacheLRU", Boolean.TYPE.getName(), "Algoritmo utilizzato (lru/mru)"), new MBeanParameterInfo("itemIdleTime", Long.TYPE.getName(), "Indica il massimo intervallo di tempo che un item pu\u00f2 esistere senza essere acceduto (con -1 verra' assegnato un tempo infinito)"), new MBeanParameterInfo("itemLifeSecond", Long.TYPE.getName(), "Vita di un elemento inserito in cache")}, String.class.getName(), 1);
        MBeanConstructorInfo defaultConstructor = new MBeanConstructorInfo("Default Constructor", "Crea e inizializza una nuova istanza del MBean", null);
        MBeanAttributeInfo[] attributes = new MBeanAttributeInfo[]{tipoAutorizzazioneSPCoopVAR, cacheAbilitataVAR};
        MBeanConstructorInfo[] constructors = new MBeanConstructorInfo[]{defaultConstructor};
        MBeanOperationInfo[] operations = new MBeanOperationInfo[]{resetCacheOP, abilitaCacheParametriOP};
        return new MBeanInfo(className, description, attributes, constructors, operations, null);
    }

    public EngineAutorizzazioneSPCoop() {
        this.cacheAbilitata = GestoreAutorizzazioneSPCoop.isCacheAbilitata();
    }

    public String resetCache() {
        try {
            if (!this.cacheAbilitata) {
                throw new Exception("Cache non abilitata");
            }
            GestoreAutorizzazioneSPCoop.resetCache();
            return "Operazione di reset effettuata con successo";
        }
        catch (Exception e) {
            this.log.error((Object)"Operazione di reset non riuscita", (Throwable)e);
            return "Operazione non riuscita: " + e.getMessage();
        }
    }

    public String abilitaCache() {
        try {
            GestoreAutorizzazioneSPCoop.abilitaCache();
            this.cacheAbilitata = true;
            return "Abilitazione cache effettuata con successo, la cache e' stata inizializzata con i valori di default presenti in cache.ccf";
        }
        catch (Exception e) {
            this.log.error((Object)e.getMessage(), (Throwable)e);
            return "Operazione non riuscita: " + e.getMessage();
        }
    }

    public String abilitaCache(long dimensioneCache, boolean algoritmoCacheLRU, long itemIdleTime, long itemLifeSecond) {
        try {
            GestoreAutorizzazioneSPCoop.abilitaCache(dimensioneCache, algoritmoCacheLRU, itemIdleTime, itemLifeSecond);
            this.cacheAbilitata = true;
            return "Abilitazione cache effettuata con successo";
        }
        catch (Exception e) {
            this.log.error((Object)e.getMessage(), (Throwable)e);
            return "Operazione non riuscita: " + e.getMessage();
        }
    }

    public String disabilitaCache() {
        try {
            GestoreAutorizzazioneSPCoop.disabilitaCache();
            this.cacheAbilitata = false;
            return "Disabilitazione cache effettuata con successo";
        }
        catch (Exception e) {
            this.log.error((Object)e.getMessage(), (Throwable)e);
            return "Operazione non riuscita: " + e.getMessage();
        }
    }
}

