/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop.pdd.core.jmx;

import java.util.Iterator;
import javax.management.Attribute;
import javax.management.AttributeList;
import javax.management.AttributeNotFoundException;
import javax.management.DynamicMBean;
import javax.management.InvalidAttributeValueException;
import javax.management.JMException;
import javax.management.MBeanAttributeInfo;
import javax.management.MBeanConstructorInfo;
import javax.management.MBeanException;
import javax.management.MBeanInfo;
import javax.management.MBeanOperationInfo;
import javax.management.MBeanParameterInfo;
import javax.management.NotificationBroadcasterSupport;
import javax.management.ReflectionException;
import org.apache.log4j.Logger;
import org.openspcoop.dao.config.AccessoRegistroRegistro;
import org.openspcoop.pdd.config.ConfigurazionePdDReader;
import org.openspcoop.pdd.config.OpenSPCoopProperties;
import org.openspcoop.pdd.logger.OpenSPCoopLogger;
import org.openspcoop.registry.RegistroServiziReader;

public class AccessoRegistroServizi
extends NotificationBroadcasterSupport
implements DynamicMBean {
    static final String CACHE_ABILITATA = "cacheAbilitata";
    static final String REGISTRI_SERVIZI = "registriServizi";
    static final String RESET_CACHE = "resetCache";
    static final String ABILITA_CACHE = "abilitaCache";
    public boolean cacheAbilitata = false;
    public String[] registriServizi = null;
    private Logger log = OpenSPCoopLogger.getLoggerOpenSPCoopCore();
    ConfigurazionePdDReader configReader = ConfigurazionePdDReader.getInstance();

    public Object getAttribute(String attributeName) throws AttributeNotFoundException, MBeanException, ReflectionException {
        if (attributeName == null || attributeName.equals("")) {
            throw new IllegalArgumentException("Il nome dell'attributo e' nullo o vuoto");
        }
        if (attributeName.equals(CACHE_ABILITATA)) {
            return this.cacheAbilitata;
        }
        if (attributeName.equals(REGISTRI_SERVIZI)) {
            return this.registriServizi;
        }
        throw new AttributeNotFoundException("Attributo " + attributeName + " non trovato");
    }

    public AttributeList getAttributes(String[] attributesNames) {
        if (attributesNames == null) {
            throw new IllegalArgumentException("Array nullo");
        }
        AttributeList list = new AttributeList();
        for (int i = 0; i < attributesNames.length; ++i) {
            try {
                list.add(new Attribute(attributesNames[i], this.getAttribute(attributesNames[i])));
                continue;
            }
            catch (JMException ex) {
                // empty catch block
            }
        }
        return list;
    }

    public void setAttribute(Attribute attribute) throws AttributeNotFoundException, InvalidAttributeValueException, MBeanException, ReflectionException {
        block8: {
            if (attribute == null) {
                throw new IllegalArgumentException("Il nome dell'attributo e' nullo");
            }
            try {
                if (attribute.getName().equals(CACHE_ABILITATA)) {
                    boolean v = (Boolean)attribute.getValue();
                    if (v && !this.cacheAbilitata) {
                        this.abilitaCache();
                    } else {
                        this.disabilitaCache();
                    }
                    break block8;
                }
                if (attribute.getName().equals(REGISTRI_SERVIZI)) {
                    this.registriServizi = (String[])attribute.getValue();
                    break block8;
                }
                throw new AttributeNotFoundException("Attributo " + attribute.getName() + " non trovato");
            }
            catch (ClassCastException ce) {
                throw new InvalidAttributeValueException("il tipo " + attribute.getValue().getClass() + " dell'attributo " + attribute.getName() + " non e' valido");
            }
            catch (JMException j) {
                throw new MBeanException(j);
            }
        }
    }

    public AttributeList setAttributes(AttributeList list) {
        if (list == null) {
            throw new IllegalArgumentException("Lista degli attributi e' nulla");
        }
        AttributeList ret = new AttributeList();
        Iterator it = ret.iterator();
        while (it.hasNext()) {
            try {
                Attribute attribute = (Attribute)it.next();
                this.setAttribute(attribute);
                ret.add(attribute);
            }
            catch (JMException ex) {}
        }
        return ret;
    }

    public Object invoke(String actionName, Object[] params, String[] signature) throws MBeanException, ReflectionException {
        if (actionName == null || actionName.equals("")) {
            throw new IllegalArgumentException("Nessuna operazione definita");
        }
        if (actionName.equals(RESET_CACHE)) {
            return this.resetCache();
        }
        if (actionName.equals(ABILITA_CACHE)) {
            if (params.length != 4) {
                throw new MBeanException(new Exception("[AbilitaCache] Lunghezza parametri non corretta: " + params.length));
            }
            return this.abilitaCache((Long)params[0], (Boolean)params[1], (Long)params[2], (Long)params[3]);
        }
        throw new UnsupportedOperationException("Operazione " + actionName + " sconosciuta");
    }

    public MBeanInfo getMBeanInfo() {
        boolean READABLE = true;
        boolean WRITABLE = true;
        boolean IS_GETTER = true;
        String className = this.getClass().getName();
        String description = "Risorsa per la configurazione dell'accesso ai registri dei servizi utilizzati a RunTime dalla Porta di Dominio " + OpenSPCoopProperties.getInstance().getVersione();
        MBeanAttributeInfo cacheAbilitataVAR = new MBeanAttributeInfo(CACHE_ABILITATA, Boolean.TYPE.getName(), "Indicazione se e' abilita una cache anteposta ai registri dei servizi acceduti dalla Porta di Dominio", true, true, false);
        MBeanAttributeInfo registriServiziVAR = new MBeanAttributeInfo(REGISTRI_SERVIZI, String[].class.getName(), "Elenco dei registri dei servizi utilizzati a RunTime dalla Porta di Dominio", true, false, false);
        MBeanOperationInfo resetCacheOP = new MBeanOperationInfo(RESET_CACHE, "Svuota la cache dei dati letti dai Registri dei Servizi", null, String.class.getName(), 1);
        MBeanOperationInfo abilitaCacheParametriOP = new MBeanOperationInfo(ABILITA_CACHE, "Abilita la cache dei dati letti dai Registri dei Servizi", new MBeanParameterInfo[]{new MBeanParameterInfo("dimensioneCache", Long.TYPE.getName(), "Dimensione della cache"), new MBeanParameterInfo("algoritmoCacheLRU", Boolean.TYPE.getName(), "Algoritmo utilizzato (lru/mru)"), new MBeanParameterInfo("itemIdleTime", Long.TYPE.getName(), "Indica il massimo intervallo di tempo che un item pu\u00f2 esistere senza essere acceduto (con -1 verra' assegnato un tempo infinito)"), new MBeanParameterInfo("itemLifeSecond", Long.TYPE.getName(), "Vita di un elemento inserito in cache")}, String.class.getName(), 1);
        MBeanConstructorInfo defaultConstructor = new MBeanConstructorInfo("Default Constructor", "Crea e inizializza una nuova istanza del MBean", null);
        MBeanAttributeInfo[] attributes = new MBeanAttributeInfo[]{cacheAbilitataVAR, registriServiziVAR};
        MBeanConstructorInfo[] constructors = new MBeanConstructorInfo[]{defaultConstructor};
        MBeanOperationInfo[] operations = new MBeanOperationInfo[]{resetCacheOP, abilitaCacheParametriOP};
        return new MBeanInfo(className, description, attributes, constructors, operations, null);
    }

    public AccessoRegistroServizi() {
        boolean bl = this.cacheAbilitata = this.configReader.getAccessoRegistroServizi().getCache() != null;
        if (this.configReader.getAccessoRegistroServizi().sizeRegistroList() > 0) {
            this.registriServizi = new String[this.configReader.getAccessoRegistroServizi().sizeRegistroList()];
            for (int i = 0; i < this.configReader.getAccessoRegistroServizi().sizeRegistroList(); ++i) {
                AccessoRegistroRegistro registro = this.configReader.getAccessoRegistroServizi().getRegistro(i);
                String autenticazione = "";
                if (registro.getUser() != null || registro.getPassword() != null) {
                    autenticazione = " (user:" + registro.getUser() + " password:" + registro.getPassword() + ")";
                }
                this.registriServizi[i] = "Registro " + registro.getNome() + " di tipo " + registro.getTipo() + "," + autenticazione + " location:" + registro.getLocation();
            }
        }
    }

    public String resetCache() {
        try {
            if (!this.cacheAbilitata) {
                throw new Exception("Cache non abilitata");
            }
            RegistroServiziReader.resetCache();
            return "Operazione di reset effettuata con successo";
        }
        catch (Exception e) {
            this.log.error((Object)"Operazione di reset non riuscita", (Throwable)e);
            return "Operazione non riuscita: " + e.getMessage();
        }
    }

    public void abilitaCache() throws JMException {
        try {
            RegistroServiziReader.abilitaCache();
            this.cacheAbilitata = true;
        }
        catch (Exception e) {
            this.log.error((Object)e.getMessage(), (Throwable)e);
        }
    }

    public String abilitaCache(long dimensioneCache, boolean algoritmoCacheLRU, long itemIdleTime, long itemLifeSecond) {
        try {
            RegistroServiziReader.abilitaCache((long)dimensioneCache, (boolean)algoritmoCacheLRU, (long)itemIdleTime, (long)itemLifeSecond);
            this.cacheAbilitata = true;
            return "Abilitazione cache effettuata con successo";
        }
        catch (Exception e) {
            this.log.error((Object)e.getMessage(), (Throwable)e);
            return "Operazione non riuscita: " + e.getMessage();
        }
    }

    public void disabilitaCache() throws JMException {
        try {
            RegistroServiziReader.disabilitaCache();
            this.cacheAbilitata = false;
        }
        catch (Exception e) {
            this.log.error((Object)e.getMessage(), (Throwable)e);
            throw new JMException("Operazione non riuscita: " + e.getMessage());
        }
    }
}

