/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop.pdd.core.integrazione;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.Iterator;
import javax.xml.soap.Name;
import javax.xml.soap.SOAPElement;
import org.apache.axis.Message;
import org.apache.axis.message.MessageElement;
import org.apache.axis.message.PrefixedQName;
import org.apache.axis.message.SOAPHeader;
import org.apache.axis.message.SOAPHeaderElement;
import org.apache.log4j.Logger;
import org.openspcoop.dao.commons.IDSoggetto;
import org.openspcoop.dao.registry.driver.IDServizio;
import org.openspcoop.pdd.core.integrazione.HeaderIntegrazione;
import org.openspcoop.pdd.core.integrazione.HeaderIntegrazioneEGov;
import org.openspcoop.pdd.core.integrazione.HeaderIntegrazioneException;
import org.openspcoop.pdd.logger.OpenSPCoopLogger;
import org.openspcoop.utils.SoapUtils;
import org.openspcoop.utils.xml.ValidatoreXSD;
import org.openspcoop.utils.xml.XMLUtils;
import org.w3c.dom.Document;

public class UtilitiesIntegrazioneWSAddressing {
    public static final String WSA_NAMESPACE = "http://www.w3.org/2005/08/addressing";
    public static final String WSA_PREFIX = "wsa";
    public static final String WSA_RELATIONSHIP_TYPE_REPLY = "http://www.w3.org/2005/08/addressing/reply";
    public static final String WSA_SOAP_HEADER_TO = "To";
    public static final String WSA_SOAP_HEADER_FROM = "From";
    public static final String WSA_SOAP_HEADER_ACTION = "Action";
    public static final String WSA_SOAP_HEADER_ID = "MessageID";
    public static final String WSA_SOAP_HEADER_RELATES_TO = "RelatesTo";
    public static final String WSA_SOAP_HEADER_RELATES_TO_ATTRIBUTE = "RelationshipType";
    private static UtilitiesIntegrazioneWSAddressing utilitiesIntegrazione = null;

    public static void readDatiWSATo(String wsaTO, HeaderIntegrazione integrazione) throws HeaderIntegrazioneException {
        if (wsaTO == null) {
            throw new HeaderIntegrazioneException("WSATO value is null");
        }
        if (!(wsaTO = wsaTO.trim()).startsWith("http://")) {
            throw new HeaderIntegrazioneException("WSATO Value is not valid: http://<nomeSoggettoErogatore>.spcoop.it/servizi/<nomeServizio>");
        }
        if (!wsaTO.contains(".spcoop.it/servizi/")) {
            throw new HeaderIntegrazioneException("WSATO Value is not valid: http://<nomeSoggettoErogatore>.spcoop.it/servizi/<nomeServizio>");
        }
        wsaTO = wsaTO.substring(7, wsaTO.length());
        int indexSoggetto = wsaTO.indexOf(".spcoop.it/servizi/");
        String nomeSoggetto = wsaTO.substring(0, indexSoggetto);
        String nomeServizio = wsaTO.substring(indexSoggetto + ".spcoop.it/servizi/".length(), wsaTO.length());
        if (nomeSoggetto == null) {
            throw new HeaderIntegrazioneException("WSATO Value is not valid (Soggetto non identificabile): http://<nomeSoggettoErogatore>.spcoop.it/servizi/<nomeServizio>");
        }
        if (nomeServizio == null) {
            throw new HeaderIntegrazioneException("WSATO Value is not valid (Servizio non identificabile): http://<nomeSoggettoErogatore>.spcoop.it/servizi/<nomeServizio>");
        }
        integrazione.getEgov().setDestinatario(nomeSoggetto);
        integrazione.getEgov().setServizio(nomeServizio);
    }

    public static String buildDatiWSATo(String soggettoErogatore, String servizio) {
        return "http://" + soggettoErogatore + ".spcoop.it/servizi/" + servizio;
    }

    public static SOAPHeaderElement buildWSATo(String actor, String soggettoErogatore, String servizio) throws Exception {
        PrefixedQName name = new PrefixedQName(WSA_NAMESPACE, WSA_SOAP_HEADER_TO, WSA_PREFIX);
        SOAPHeaderElement header = UtilitiesIntegrazioneWSAddressing.buildHeaderElement((Name)name, UtilitiesIntegrazioneWSAddressing.buildDatiWSATo(soggettoErogatore, servizio), actor);
        return header;
    }

    public static void readDatiWSAFrom(String wsaFrom, HeaderIntegrazione integrazione) throws HeaderIntegrazioneException {
        int indexSoggetto;
        if (wsaFrom == null) {
            throw new HeaderIntegrazioneException("WSAFrom value is null");
        }
        if (!(wsaFrom = wsaFrom.trim()).startsWith("http://")) {
            throw new HeaderIntegrazioneException("WSAFrom Value is not valid: http://[<nomeServizioApplicativoFruitore>.]<nomeSoggettoFruitore.spcoop.it");
        }
        if (!wsaFrom.contains(".spcoop.it")) {
            throw new HeaderIntegrazioneException("WSAFrom Value is not valid: http://[<nomeServizioApplicativoFruitore>.]<nomeSoggettoFruitore>.spcoop.it");
        }
        String nomeSoggetto = (wsaFrom = wsaFrom.substring(7, wsaFrom.length())).substring(0, indexSoggetto = wsaFrom.indexOf(".spcoop.it"));
        if (nomeSoggetto == null) {
            throw new HeaderIntegrazioneException("WSAFrom Value is not valid (Soggetto non identificabile): http://[<nomeServizioApplicativoFruitore>.]<nomeSoggettoFruitore>.spcoop.it");
        }
        if (nomeSoggetto.contains(".")) {
            String[] split = nomeSoggetto.split(".");
            nomeSoggetto = split[1];
            String sa = split[0];
            if (nomeSoggetto == null) {
                throw new HeaderIntegrazioneException("WSAFrom Value is not valid (Soggetto non identificabile): http://[<nomeServizioApplicativoFruitore>.]<nomeSoggettoFruitore>.spcoop.it");
            }
            if (sa == null) {
                throw new HeaderIntegrazioneException("WSAFrom Value is not valid (ServizioApplicativo non identificabile): http://[<nomeServizioApplicativoFruitore>.]<nomeSoggettoFruitore>.spcoop.it");
            }
            nomeSoggetto = nomeSoggetto.trim();
            sa = sa.trim();
            integrazione.setServizioApplicativo(sa);
        }
        integrazione.getEgov().setMittente(nomeSoggetto);
    }

    public static String buildDatiWSAFrom(String servizioApplicativoFruitore, String soggetto) {
        if (servizioApplicativoFruitore == null) {
            return "http://" + soggetto + ".spcoop.it";
        }
        return "http://" + servizioApplicativoFruitore + "." + soggetto + ".spcoop.it";
    }

    public static SOAPHeaderElement buildWSAFrom(String actor, String servizioApplicativoFruitore, String soggetto) throws Exception {
        PrefixedQName name = new PrefixedQName(WSA_NAMESPACE, WSA_SOAP_HEADER_FROM, WSA_PREFIX);
        SOAPHeaderElement header = UtilitiesIntegrazioneWSAddressing.buildHeaderElement((Name)name, UtilitiesIntegrazioneWSAddressing.buildDatiWSAFrom(servizioApplicativoFruitore, soggetto), actor);
        return header;
    }

    public static void readDatiWSAAction(String wsaAction, HeaderIntegrazione integrazione) throws HeaderIntegrazioneException {
        if (wsaAction == null) {
            throw new HeaderIntegrazioneException("WSAAction value is null");
        }
        if (!(wsaAction = wsaAction.trim()).startsWith("http://")) {
            throw new HeaderIntegrazioneException("WSAAction Value is not valid: http://<nomeSoggettoErogatore>.spcoop.it/servizi/<nomeServizio>/<nomeAzione>");
        }
        if (!wsaAction.contains(".spcoop.it/servizi/")) {
            throw new HeaderIntegrazioneException("WSAAction Value is not valid: http://<nomeSoggettoErogatore>.spcoop.it/servizi/<nomeServizio>/<nomeAzione>");
        }
        int indexServizi = wsaAction.indexOf(".spcoop.it/servizi/");
        String servizioAzione = wsaAction.substring(indexServizi + ".spcoop.it/servizi/".length(), wsaAction.length());
        int indexAzione = servizioAzione.indexOf("/");
        if (indexAzione <= 0) {
            throw new HeaderIntegrazioneException("WSAAction Value is not valid (Azione non identificabile): http://<nomeSoggettoErogatore>.spcoop.it/servizi/<nomeServizio>/<nomeAzione>");
        }
        String azione = servizioAzione.substring(indexAzione + 1, servizioAzione.length());
        if (azione == null) {
            throw new HeaderIntegrazioneException("WSAAction Value is not valid (Azione non identificabile): http://<nomeSoggettoErogatore>.spcoop.it/servizi/<nomeServizio>/<nomeAzione>");
        }
        integrazione.getEgov().setAzione(azione);
    }

    public static String buildDatiWSAAction(String soggettoErogatore, String servizio, String azione) {
        return "http://" + soggettoErogatore + ".spcoop.it/servizi/" + servizio + "/" + azione;
    }

    public static SOAPHeaderElement buildWSAAction(String actor, String soggettoErogatore, String servizio, String azione) throws Exception {
        PrefixedQName name = new PrefixedQName(WSA_NAMESPACE, WSA_SOAP_HEADER_ACTION, WSA_PREFIX);
        SOAPHeaderElement header = UtilitiesIntegrazioneWSAddressing.buildHeaderElement((Name)name, UtilitiesIntegrazioneWSAddressing.buildDatiWSAAction(soggettoErogatore, servizio, azione), actor);
        return header;
    }

    public static void readDatiWSAID(String wsaID, HeaderIntegrazione integrazione, boolean interpretaComeIDEgov) throws HeaderIntegrazioneException {
        if (wsaID == null) {
            throw new HeaderIntegrazioneException("WSAID value is null");
        }
        if (!(wsaID = wsaID.trim()).startsWith("uuid:")) {
            throw new HeaderIntegrazioneException("WSAID Value is not valid: uuid:<id>");
        }
        wsaID = wsaID.substring(5, wsaID.length());
        if (interpretaComeIDEgov) {
            integrazione.getEgov().setID(wsaID);
        } else {
            integrazione.setIdApplicativo(wsaID);
        }
    }

    public static String buildDatiWSAID(String id) {
        return "uuid:" + id;
    }

    public static SOAPHeaderElement buildWSAID(String actor, String wsaID) throws Exception {
        PrefixedQName name = new PrefixedQName(WSA_NAMESPACE, WSA_SOAP_HEADER_ID, WSA_PREFIX);
        SOAPHeaderElement header = UtilitiesIntegrazioneWSAddressing.buildHeaderElement((Name)name, UtilitiesIntegrazioneWSAddressing.buildDatiWSAID(wsaID), actor);
        return header;
    }

    public static void readDatiWSARelatesTo(String wsaRelatesTo, HeaderIntegrazione integrazione) throws HeaderIntegrazioneException {
        if (wsaRelatesTo == null) {
            throw new HeaderIntegrazioneException("WSARelatesTo value is null");
        }
        if (!(wsaRelatesTo = wsaRelatesTo.trim()).startsWith("uuid:")) {
            throw new HeaderIntegrazioneException("WSARelatesTo Value is not valid: uuid:<id>");
        }
        wsaRelatesTo = wsaRelatesTo.substring(5, wsaRelatesTo.length());
        integrazione.getEgov().setRiferimentoMessaggio(wsaRelatesTo);
    }

    public static String buildDatiWSARelatesTo(String id) {
        return "uuid:" + id;
    }

    public static SOAPHeaderElement buildWSARelatesTo(String actor, String id) throws Exception {
        PrefixedQName name = new PrefixedQName(WSA_NAMESPACE, WSA_SOAP_HEADER_RELATES_TO, WSA_PREFIX);
        SOAPHeaderElement header = UtilitiesIntegrazioneWSAddressing.buildHeaderElement((Name)name, UtilitiesIntegrazioneWSAddressing.buildDatiWSARelatesTo(id), actor);
        return header;
    }

    private static SOAPHeaderElement buildHeaderElement(Name name, String value, String actor) throws Exception {
        SOAPHeaderElement element = new SOAPHeaderElement(name);
        element.setActor(actor);
        element.setMustUnderstand(false);
        element.addNamespaceDeclaration("SOAP_ENV", "http://schemas.xmlsoap.org/soap/envelope/");
        element.setValue(value);
        byte[] header = SoapUtils.msgElementoToByte((MessageElement)element);
        Document document = XMLUtils.newDocument((byte[])header);
        SOAPHeaderElement elementSenzaXSITypes = new SOAPHeaderElement(document.getDocumentElement());
        return elementSenzaXSITypes;
    }

    static UtilitiesIntegrazioneWSAddressing getInstance() {
        if (utilitiesIntegrazione == null) {
            UtilitiesIntegrazioneWSAddressing.initialize();
        }
        return utilitiesIntegrazione;
    }

    private static synchronized void initialize() {
        if (utilitiesIntegrazione == null) {
            utilitiesIntegrazione = new UtilitiesIntegrazioneWSAddressing();
        }
    }

    public void readHeader(Message message, HeaderIntegrazione integrazione, ValidatoreXSD validatoreXSD, boolean interpretaIDComeIDEGov, String actorIntegrazione) throws HeaderIntegrazioneException {
        try {
            if (actorIntegrazione == null) {
                throw new Exception("Actor non definito");
            }
            Logger log = OpenSPCoopLogger.getLoggerOpenSPCoopCore();
            SOAPHeader header = (SOAPHeader)message.getSOAPHeader();
            if (header == null) {
                OpenSPCoopLogger.getLoggerOpenSPCoopCore().debug((Object)"SOAPHeader non presente");
                return;
            }
            SOAPHeaderElement wsaTO = null;
            SOAPHeaderElement wsaFROM = null;
            SOAPHeaderElement wsaAction = null;
            SOAPHeaderElement wsaID = null;
            SOAPHeaderElement wsaRelatesTo = null;
            Iterator it = header.examineAllHeaderElements();
            while (it.hasNext()) {
                SOAPHeaderElement headerElement = (SOAPHeaderElement)it.next();
                String namespace = headerElement.getNamespaceURI();
                String actor = headerElement.getActor();
                if (!actorIntegrazione.equals(actor) || !WSA_NAMESPACE.equals(namespace)) continue;
                log.debug((Object)("Trovato header WSAddressing [" + headerElement.getName() + "]"));
                if (WSA_SOAP_HEADER_TO.equals(headerElement.getName())) {
                    wsaTO = headerElement;
                    continue;
                }
                if (WSA_SOAP_HEADER_FROM.equals(headerElement.getName())) {
                    wsaFROM = headerElement;
                    continue;
                }
                if (WSA_SOAP_HEADER_ACTION.equals(headerElement.getName())) {
                    wsaAction = headerElement;
                    continue;
                }
                if (WSA_SOAP_HEADER_ID.equals(headerElement.getName())) {
                    wsaID = headerElement;
                    continue;
                }
                if (WSA_SOAP_HEADER_RELATES_TO.equals(headerElement.getName())) {
                    wsaRelatesTo = headerElement;
                    continue;
                }
                log.debug((Object)"Header non conosciuto");
            }
            if (wsaTO == null && wsaFROM == null && wsaAction == null && wsaID == null && wsaRelatesTo == null) {
                log.debug((Object)"Header di integrazione non presente");
                return;
            }
            log.debug((Object)"Validazione XSD...");
            this.validaElementoWSA(validatoreXSD, wsaTO, log);
            this.validaElementoWSA(validatoreXSD, wsaFROM, log);
            this.validaElementoWSA(validatoreXSD, wsaAction, log);
            this.validaElementoWSA(validatoreXSD, wsaID, log);
            this.validaElementoWSA(validatoreXSD, wsaRelatesTo, log);
            log.debug((Object)"Validazione XSD effettuate");
            if (wsaTO != null) {
                log.debug((Object)"Read dati da WSATo...");
                UtilitiesIntegrazioneWSAddressing.readDatiWSATo(wsaTO.getValue(), integrazione);
            }
            if (wsaFROM != null) {
                log.debug((Object)"Read dati da WSAFrom...");
                UtilitiesIntegrazioneWSAddressing.readDatiWSAFrom(wsaFROM.getValue(), integrazione);
            }
            if (wsaAction != null) {
                log.debug((Object)"Read dati da WSAAction...");
                UtilitiesIntegrazioneWSAddressing.readDatiWSAAction(wsaAction.getValue(), integrazione);
            }
            if (wsaID != null) {
                log.debug((Object)"Read dati da WSAId...");
                UtilitiesIntegrazioneWSAddressing.readDatiWSAID(wsaID.getValue(), integrazione, interpretaIDComeIDEGov);
            }
            if (wsaRelatesTo != null) {
                log.debug((Object)"Read dati da WSARelatesTo...");
                UtilitiesIntegrazioneWSAddressing.readDatiWSARelatesTo(wsaRelatesTo.getValue(), integrazione);
            }
        }
        catch (Exception e) {
            throw new HeaderIntegrazioneException("UtilitiesIntegrazione, lettura dell'header soap non riuscita: " + e.getMessage(), e);
        }
    }

    private void validaElementoWSA(ValidatoreXSD validatoreXSD, SOAPHeaderElement headerElement, Logger log) throws Exception {
        if (headerElement != null) {
            log.debug((Object)("Validazione XSD [" + headerElement.getLocalName() + "]..."));
            if (validatoreXSD == null) {
                throw new Exception("Validatore XSD non istanziato");
            }
            validatoreXSD.valida((InputStream)new ByteArrayInputStream(headerElement.getAsString().getBytes()));
        }
    }

    public void updateHeader(Message message, IDSoggetto soggettoFruitore, IDServizio idServizio, String idEGov, String servizioApplicativo, String correlazioneApplicativa, String actorIntegrazione) throws Exception {
        HeaderIntegrazione integrazione = new HeaderIntegrazione();
        integrazione.setIdApplicativo(correlazioneApplicativa);
        integrazione.setServizioApplicativo(servizioApplicativo);
        HeaderIntegrazioneEGov egov = new HeaderIntegrazioneEGov();
        egov.setTipoMittente(soggettoFruitore.getTipo());
        egov.setMittente(soggettoFruitore.getNome());
        egov.setTipoDestinatario(idServizio.getSoggettoErogatore().getTipo());
        egov.setDestinatario(idServizio.getSoggettoErogatore().getNome());
        egov.setTipoServizio(idServizio.getTipoServizio());
        egov.setServizio(idServizio.getServizio());
        egov.setAzione(idServizio.getAzione());
        egov.setID(idEGov);
        integrazione.setEgov(egov);
        this.updateHeader(message, integrazione, actorIntegrazione);
    }

    public void updateHeader(Message message, HeaderIntegrazione integrazione, String actorIntegrazione) throws Exception {
        SOAPHeader header = (SOAPHeader)message.getSOAPHeader();
        SOAPHeaderElement wsaTO = null;
        SOAPHeaderElement wsaFROM = null;
        SOAPHeaderElement wsaAction = null;
        SOAPHeaderElement wsaID = null;
        SOAPHeaderElement wsaRelatesTo = null;
        Logger log = OpenSPCoopLogger.getLoggerOpenSPCoopCore();
        if (header == null) {
            OpenSPCoopLogger.getLoggerOpenSPCoopCore().debug((Object)"SOAPHeader non presente: add soapHeader");
            header = (SOAPHeader)message.getSOAPEnvelope().addHeader();
        } else {
            Iterator it = header.examineAllHeaderElements();
            while (it.hasNext()) {
                SOAPHeaderElement headerElement = (SOAPHeaderElement)it.next();
                String namespace = headerElement.getNamespaceURI();
                if (!WSA_NAMESPACE.equals(namespace)) continue;
                log.debug((Object)("Trovato header WSAddressing [" + headerElement.getName() + "]"));
                if (WSA_SOAP_HEADER_TO.equals(headerElement.getName())) {
                    wsaTO = headerElement;
                    continue;
                }
                if (WSA_SOAP_HEADER_FROM.equals(headerElement.getName())) {
                    wsaFROM = headerElement;
                    continue;
                }
                if (WSA_SOAP_HEADER_ACTION.equals(headerElement.getName())) {
                    wsaAction = headerElement;
                    continue;
                }
                if (WSA_SOAP_HEADER_ID.equals(headerElement.getName())) {
                    wsaID = headerElement;
                    continue;
                }
                if (WSA_SOAP_HEADER_RELATES_TO.equals(headerElement.getName())) {
                    wsaRelatesTo = headerElement;
                    continue;
                }
                log.debug((Object)"Header non conosciuto");
            }
        }
        if (integrazione.getEgov() != null) {
            HeaderIntegrazioneEGov hEGOV = integrazione.getEgov();
            if (hEGOV.getDestinatario() != null && hEGOV.getServizio() != null) {
                if (wsaTO != null) {
                    wsaTO.setValue(UtilitiesIntegrazioneWSAddressing.buildDatiWSATo(hEGOV.getDestinatario(), hEGOV.getServizio()));
                } else {
                    wsaTO = UtilitiesIntegrazioneWSAddressing.buildWSATo(actorIntegrazione, hEGOV.getDestinatario(), hEGOV.getServizio());
                    header.addChildElement((SOAPElement)wsaTO);
                }
                if (hEGOV.getAzione() != null) {
                    if (wsaAction != null) {
                        wsaAction.setValue(UtilitiesIntegrazioneWSAddressing.buildDatiWSAAction(hEGOV.getDestinatario(), hEGOV.getServizio(), hEGOV.getAzione()));
                    } else {
                        wsaAction = UtilitiesIntegrazioneWSAddressing.buildWSAAction(actorIntegrazione, hEGOV.getDestinatario(), hEGOV.getServizio(), hEGOV.getAzione());
                        header.addChildElement((SOAPElement)wsaTO);
                    }
                }
            }
            if (hEGOV.getMittente() != null) {
                if (wsaFROM != null) {
                    wsaFROM.setValue(UtilitiesIntegrazioneWSAddressing.buildDatiWSAFrom(integrazione.getServizioApplicativo(), hEGOV.getMittente()));
                } else {
                    wsaFROM = UtilitiesIntegrazioneWSAddressing.buildWSAFrom(actorIntegrazione, integrazione.getServizioApplicativo(), hEGOV.getMittente());
                    header.addChildElement((SOAPElement)wsaFROM);
                }
            }
            if (hEGOV.getID() != null) {
                if (wsaID != null) {
                    wsaID.setValue(UtilitiesIntegrazioneWSAddressing.buildDatiWSAID(hEGOV.getID()));
                } else {
                    wsaID = UtilitiesIntegrazioneWSAddressing.buildWSAID(actorIntegrazione, hEGOV.getID());
                    header.addChildElement((SOAPElement)wsaID);
                }
            }
            if (hEGOV.getRiferimentoMessaggio() != null || hEGOV.getIdCollaborazione() != null) {
                String rif = hEGOV.getRiferimentoMessaggio();
                if (rif == null) {
                    rif = hEGOV.getIdCollaborazione();
                }
                if (wsaRelatesTo != null) {
                    wsaRelatesTo.setValue(UtilitiesIntegrazioneWSAddressing.buildDatiWSARelatesTo(rif));
                } else {
                    wsaRelatesTo = UtilitiesIntegrazioneWSAddressing.buildWSARelatesTo(actorIntegrazione, rif);
                    header.addChildElement((SOAPElement)wsaRelatesTo);
                }
            }
        }
    }

    public void deleteHeader(Message message, String actorIntegrazione) throws HeaderIntegrazioneException {
        try {
            if (actorIntegrazione == null) {
                throw new Exception("Actor non definito");
            }
            Logger log = OpenSPCoopLogger.getLoggerOpenSPCoopCore();
            SOAPHeader header = (SOAPHeader)message.getSOAPHeader();
            if (header == null) {
                OpenSPCoopLogger.getLoggerOpenSPCoopCore().debug((Object)"SOAPHeader non presente");
                return;
            }
            SOAPHeaderElement wsaTO = null;
            SOAPHeaderElement wsaFROM = null;
            SOAPHeaderElement wsaAction = null;
            SOAPHeaderElement wsaID = null;
            SOAPHeaderElement wsaRelatesTo = null;
            Iterator it = header.examineAllHeaderElements();
            while (it.hasNext()) {
                SOAPHeaderElement headerElement = (SOAPHeaderElement)it.next();
                String namespace = headerElement.getNamespaceURI();
                String actor = headerElement.getActor();
                if (!actorIntegrazione.equals(actor) || !WSA_NAMESPACE.equals(namespace)) continue;
                log.debug((Object)("Trovato header WSAddressing [" + headerElement.getName() + "]"));
                if (WSA_SOAP_HEADER_TO.equals(headerElement.getName())) {
                    wsaTO = headerElement;
                    continue;
                }
                if (WSA_SOAP_HEADER_FROM.equals(headerElement.getName())) {
                    wsaFROM = headerElement;
                    continue;
                }
                if (WSA_SOAP_HEADER_ACTION.equals(headerElement.getName())) {
                    wsaAction = headerElement;
                    continue;
                }
                if (WSA_SOAP_HEADER_ID.equals(headerElement.getName())) {
                    wsaID = headerElement;
                    continue;
                }
                if (WSA_SOAP_HEADER_RELATES_TO.equals(headerElement.getName())) {
                    wsaRelatesTo = headerElement;
                    continue;
                }
                log.debug((Object)"Header non conosciuto");
            }
            if (wsaTO == null && wsaFROM == null && wsaAction == null && wsaID == null && wsaRelatesTo == null) {
                log.debug((Object)"Header di integrazione non presente");
                return;
            }
            if (wsaTO != null) {
                header.removeChild(wsaTO);
            }
            if (wsaFROM != null) {
                header.removeChild(wsaFROM);
            }
            if (wsaAction != null) {
                header.removeChild(wsaAction);
            }
            if (wsaID != null) {
                header.removeChild(wsaID);
            }
            if (wsaRelatesTo != null) {
                header.removeChild(wsaRelatesTo);
            }
        }
        catch (Exception e) {
            throw new HeaderIntegrazioneException("UtilitiesIntegrazione, lettura dell'header soap non riuscita: " + e.getMessage(), e);
        }
    }
}

