/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop.pdd.core.integrazione;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.net.URLEncoder;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.Properties;
import java.util.Vector;
import javax.xml.soap.Name;
import javax.xml.soap.SOAPElement;
import org.apache.axis.Message;
import org.apache.axis.message.MessageElement;
import org.apache.axis.message.PrefixedQName;
import org.apache.axis.message.SOAPHeader;
import org.apache.axis.message.SOAPHeaderElement;
import org.openspcoop.dao.commons.IDSoggetto;
import org.openspcoop.dao.registry.driver.IDServizio;
import org.openspcoop.pdd.config.OpenSPCoopProperties;
import org.openspcoop.pdd.core.integrazione.HeaderIntegrazione;
import org.openspcoop.pdd.core.integrazione.HeaderIntegrazioneEGov;
import org.openspcoop.pdd.core.integrazione.HeaderIntegrazioneException;
import org.openspcoop.pdd.logger.OpenSPCoopLogger;
import org.openspcoop.utils.xml.ValidatoreXSD;
import org.w3c.dom.Node;

public class UtilitiesIntegrazione {
    private Properties keyValueIntegrazioneTrasporto = null;
    private Properties keyValueIntegrazioneUrlBased = null;
    private Properties keyValueIntegrazioneSoap = null;
    private OpenSPCoopProperties openspcoopProperties = OpenSPCoopProperties.getInstance();
    private static UtilitiesIntegrazione utilitiesIntegrazione = null;

    public UtilitiesIntegrazione() {
        this.keyValueIntegrazioneTrasporto = this.openspcoopProperties.getKeyValue_HeaderIntegrazioneTrasporto();
        this.keyValueIntegrazioneUrlBased = this.openspcoopProperties.getKeyValue_HeaderIntegrazioneUrlBased();
        this.keyValueIntegrazioneSoap = this.openspcoopProperties.getKeyValue_HeaderIntegrazioneSoap();
    }

    static UtilitiesIntegrazione getInstance() {
        if (utilitiesIntegrazione == null) {
            UtilitiesIntegrazione.initialize();
        }
        return utilitiesIntegrazione;
    }

    private static synchronized void initialize() {
        if (utilitiesIntegrazione == null) {
            utilitiesIntegrazione = new UtilitiesIntegrazione();
        }
    }

    public void readTransportProperties(Properties prop, HeaderIntegrazione integrazione) throws HeaderIntegrazioneException {
        try {
            if (prop != null && integrazione != null) {
                String key;
                Enumeration<?> keys;
                if (this.openspcoopProperties.isBackwardCompatibilityHeaderIntegrazione()) {
                    keys = prop.propertyNames();
                    while (keys.hasMoreElements()) {
                        key = (String)keys.nextElement();
                        if (key == null) continue;
                        if (key.equalsIgnoreCase("SPCoopTipoMittente")) {
                            integrazione.getEgov().setTipoMittente(prop.getProperty(key));
                            continue;
                        }
                        if (key.equalsIgnoreCase("SPCoopMittente")) {
                            integrazione.getEgov().setMittente(prop.getProperty(key));
                            continue;
                        }
                        if (key.equalsIgnoreCase("SPCoopTipoDestinatario")) {
                            integrazione.getEgov().setTipoDestinatario(prop.getProperty(key));
                            continue;
                        }
                        if (key.equalsIgnoreCase("SPCoopDestinatario")) {
                            integrazione.getEgov().setDestinatario(prop.getProperty(key));
                            continue;
                        }
                        if (key.equalsIgnoreCase("SPCoopTipoServizio")) {
                            integrazione.getEgov().setTipoServizio(prop.getProperty(key));
                            continue;
                        }
                        if (key.equalsIgnoreCase("SPCoopServizio")) {
                            integrazione.getEgov().setServizio(prop.getProperty(key));
                            continue;
                        }
                        if (key.equalsIgnoreCase("SPCoopAzione")) {
                            integrazione.getEgov().setAzione(prop.getProperty(key));
                            continue;
                        }
                        if (key.equalsIgnoreCase("SPCoopID")) {
                            integrazione.getEgov().setID(prop.getProperty(key));
                            continue;
                        }
                        if (key.equalsIgnoreCase("SPCoopRiferimentoMessaggio")) {
                            integrazione.getEgov().setRiferimentoMessaggio(prop.getProperty(key));
                            continue;
                        }
                        if (key.equalsIgnoreCase("SPCoopCollaborazione")) {
                            integrazione.getEgov().setIdCollaborazione(prop.getProperty(key));
                            continue;
                        }
                        if (key.equalsIgnoreCase("SPCoopIDApplicativo")) {
                            integrazione.setIdApplicativo(prop.getProperty(key));
                            continue;
                        }
                        if (!key.equalsIgnoreCase("SPCoopServizioApplicativo")) continue;
                        integrazione.setServizioApplicativo(prop.getProperty(key));
                    }
                }
                keys = prop.propertyNames();
                while (keys.hasMoreElements()) {
                    key = (String)keys.nextElement();
                    if (key == null) continue;
                    if (key.equalsIgnoreCase((String)this.keyValueIntegrazioneTrasporto.get("tipoMittente"))) {
                        integrazione.getEgov().setTipoMittente(prop.getProperty(key));
                        continue;
                    }
                    if (key.equalsIgnoreCase((String)this.keyValueIntegrazioneTrasporto.get("mittente"))) {
                        integrazione.getEgov().setMittente(prop.getProperty(key));
                        continue;
                    }
                    if (key.equalsIgnoreCase((String)this.keyValueIntegrazioneTrasporto.get("tipoDestinatario"))) {
                        integrazione.getEgov().setTipoDestinatario(prop.getProperty(key));
                        continue;
                    }
                    if (key.equalsIgnoreCase((String)this.keyValueIntegrazioneTrasporto.get("destinatario"))) {
                        integrazione.getEgov().setDestinatario(prop.getProperty(key));
                        continue;
                    }
                    if (key.equalsIgnoreCase((String)this.keyValueIntegrazioneTrasporto.get("tipoServizio"))) {
                        integrazione.getEgov().setTipoServizio(prop.getProperty(key));
                        continue;
                    }
                    if (key.equalsIgnoreCase((String)this.keyValueIntegrazioneTrasporto.get("servizio"))) {
                        integrazione.getEgov().setServizio(prop.getProperty(key));
                        continue;
                    }
                    if (key.equalsIgnoreCase((String)this.keyValueIntegrazioneTrasporto.get("azione"))) {
                        integrazione.getEgov().setAzione(prop.getProperty(key));
                        continue;
                    }
                    if (key.equalsIgnoreCase((String)this.keyValueIntegrazioneTrasporto.get("idegov"))) {
                        integrazione.getEgov().setID(prop.getProperty(key));
                        continue;
                    }
                    if (key.equalsIgnoreCase((String)this.keyValueIntegrazioneTrasporto.get("riferimentoMessaggio"))) {
                        integrazione.getEgov().setRiferimentoMessaggio(prop.getProperty(key));
                        continue;
                    }
                    if (key.equalsIgnoreCase((String)this.keyValueIntegrazioneTrasporto.get("idCollaborazione"))) {
                        integrazione.getEgov().setIdCollaborazione(prop.getProperty(key));
                        continue;
                    }
                    if (key.equalsIgnoreCase((String)this.keyValueIntegrazioneTrasporto.get("idApplicativo"))) {
                        integrazione.setIdApplicativo(prop.getProperty(key));
                        continue;
                    }
                    if (!key.equalsIgnoreCase((String)this.keyValueIntegrazioneTrasporto.get("servizioApplicativo"))) continue;
                    integrazione.setServizioApplicativo(prop.getProperty(key));
                }
            }
        }
        catch (Exception e) {
            throw new HeaderIntegrazioneException("UtilitiesIntegrazione, lettura dell'header non riuscita: " + e.getMessage(), e);
        }
    }

    public void readUrlProperties(Properties prop, HeaderIntegrazione integrazione) throws HeaderIntegrazioneException {
        try {
            if (prop != null && integrazione != null) {
                Enumeration<?> keys = prop.propertyNames();
                while (keys.hasMoreElements()) {
                    String key = (String)keys.nextElement();
                    if (key == null) continue;
                    if (key.equalsIgnoreCase((String)this.keyValueIntegrazioneUrlBased.get("tipoMittente"))) {
                        integrazione.getEgov().setTipoMittente(prop.getProperty(key));
                        continue;
                    }
                    if (key.equalsIgnoreCase((String)this.keyValueIntegrazioneUrlBased.get("mittente"))) {
                        integrazione.getEgov().setMittente(prop.getProperty(key));
                        continue;
                    }
                    if (key.equalsIgnoreCase((String)this.keyValueIntegrazioneUrlBased.get("tipoDestinatario"))) {
                        integrazione.getEgov().setTipoDestinatario(prop.getProperty(key));
                        continue;
                    }
                    if (key.equalsIgnoreCase((String)this.keyValueIntegrazioneUrlBased.get("destinatario"))) {
                        integrazione.getEgov().setDestinatario(prop.getProperty(key));
                        continue;
                    }
                    if (key.equalsIgnoreCase((String)this.keyValueIntegrazioneUrlBased.get("tipoServizio"))) {
                        integrazione.getEgov().setTipoServizio(prop.getProperty(key));
                        continue;
                    }
                    if (key.equalsIgnoreCase((String)this.keyValueIntegrazioneUrlBased.get("servizio"))) {
                        integrazione.getEgov().setServizio(prop.getProperty(key));
                        continue;
                    }
                    if (key.equalsIgnoreCase((String)this.keyValueIntegrazioneUrlBased.get("azione"))) {
                        integrazione.getEgov().setAzione(prop.getProperty(key));
                        continue;
                    }
                    if (key.equalsIgnoreCase((String)this.keyValueIntegrazioneUrlBased.get("idegov"))) {
                        integrazione.getEgov().setID(prop.getProperty(key));
                        continue;
                    }
                    if (key.equalsIgnoreCase((String)this.keyValueIntegrazioneUrlBased.get("riferimentoMessaggio"))) {
                        integrazione.getEgov().setRiferimentoMessaggio(prop.getProperty(key));
                        continue;
                    }
                    if (key.equalsIgnoreCase((String)this.keyValueIntegrazioneUrlBased.get("idCollaborazione"))) {
                        integrazione.getEgov().setIdCollaborazione(prop.getProperty(key));
                        continue;
                    }
                    if (key.equalsIgnoreCase((String)this.keyValueIntegrazioneUrlBased.get("idApplicativo"))) {
                        integrazione.setIdApplicativo(prop.getProperty(key));
                        continue;
                    }
                    if (!key.equalsIgnoreCase((String)this.keyValueIntegrazioneUrlBased.get("servizioApplicativo"))) continue;
                    integrazione.setServizioApplicativo(prop.getProperty(key));
                }
            }
        }
        catch (Exception e) {
            throw new HeaderIntegrazioneException("UtilitiesIntegrazione, lettura dell'header non riuscita: " + e.getMessage(), e);
        }
    }

    public void setRequestUrlProperties(HeaderIntegrazione integrazione, Properties properties) throws HeaderIntegrazioneException {
        this.setUrlProperties(integrazione, properties, true, false);
    }

    public void setResponseUrlProperties(HeaderIntegrazione integrazione, Properties properties) throws HeaderIntegrazioneException {
        this.setUrlProperties(integrazione, properties, false, true);
    }

    private void setUrlProperties(HeaderIntegrazione integrazione, Properties properties, boolean request, boolean response) throws HeaderIntegrazioneException {
        try {
            if (properties != null && integrazione != null) {
                if (integrazione.getEgov() != null) {
                    if (integrazione.getEgov().getTipoMittente() != null) {
                        properties.put(this.keyValueIntegrazioneUrlBased.get("tipoMittente"), integrazione.getEgov().getTipoMittente());
                    }
                    if (integrazione.getEgov().getMittente() != null) {
                        properties.put(this.keyValueIntegrazioneUrlBased.get("mittente"), integrazione.getEgov().getMittente());
                    }
                    if (integrazione.getEgov().getTipoDestinatario() != null) {
                        properties.put(this.keyValueIntegrazioneUrlBased.get("tipoDestinatario"), integrazione.getEgov().getTipoDestinatario());
                    }
                    if (integrazione.getEgov().getDestinatario() != null) {
                        properties.put(this.keyValueIntegrazioneUrlBased.get("destinatario"), integrazione.getEgov().getDestinatario());
                    }
                    if (integrazione.getEgov().getTipoServizio() != null) {
                        properties.put(this.keyValueIntegrazioneUrlBased.get("tipoServizio"), integrazione.getEgov().getTipoServizio());
                    }
                    if (integrazione.getEgov().getServizio() != null) {
                        properties.put(this.keyValueIntegrazioneUrlBased.get("servizio"), integrazione.getEgov().getServizio());
                    }
                    if (integrazione.getEgov().getAzione() != null) {
                        properties.put(this.keyValueIntegrazioneUrlBased.get("azione"), integrazione.getEgov().getAzione());
                    }
                    if (integrazione.getEgov().getID() != null) {
                        properties.put(this.keyValueIntegrazioneUrlBased.get("idegov"), integrazione.getEgov().getID());
                    }
                    if (integrazione.getEgov().getRiferimentoMessaggio() != null) {
                        properties.put(this.keyValueIntegrazioneUrlBased.get("riferimentoMessaggio"), integrazione.getEgov().getRiferimentoMessaggio());
                    }
                    if (integrazione.getEgov().getIdCollaborazione() != null) {
                        properties.put(this.keyValueIntegrazioneUrlBased.get("idCollaborazione"), integrazione.getEgov().getIdCollaborazione());
                    }
                }
                if (integrazione.getIdApplicativo() != null) {
                    properties.put(this.keyValueIntegrazioneUrlBased.get("idApplicativo"), integrazione.getIdApplicativo());
                }
                if (integrazione.getServizioApplicativo() != null) {
                    properties.put(this.keyValueIntegrazioneUrlBased.get("servizioApplicativo"), integrazione.getServizioApplicativo());
                }
            }
            if (properties != null) {
                properties.put("SPCoopPdd", URLEncoder.encode(this.openspcoopProperties.getHttpServer(), "UTF-8"));
                if (this.openspcoopProperties.getHttpXPdDDetails() != null && !"".equals(this.openspcoopProperties.getHttpXPdDDetails())) {
                    properties.put("SPCoopDettagliPdd", URLEncoder.encode(this.openspcoopProperties.getHttpXPdDDetails(), "UTF-8"));
                }
            }
        }
        catch (Exception e) {
            throw new HeaderIntegrazioneException("UtilitiesIntegrazione, creazione delle proprieta' dell'header non riuscita: " + e.getMessage(), e);
        }
    }

    public void setRequestTransportProperties(HeaderIntegrazione integrazione, Properties properties) throws HeaderIntegrazioneException {
        this.setTransportProperties(integrazione, properties, true, false);
    }

    public void setResponseTransportProperties(HeaderIntegrazione integrazione, Properties properties) throws HeaderIntegrazioneException {
        this.setTransportProperties(integrazione, properties, false, true);
    }

    private void setTransportProperties(HeaderIntegrazione integrazione, Properties properties, boolean request, boolean response) throws HeaderIntegrazioneException {
        try {
            if (properties != null && integrazione != null) {
                if (integrazione.getEgov() != null) {
                    if (integrazione.getEgov().getTipoMittente() != null) {
                        properties.put(this.keyValueIntegrazioneTrasporto.get("tipoMittente"), integrazione.getEgov().getTipoMittente());
                    }
                    if (integrazione.getEgov().getMittente() != null) {
                        properties.put(this.keyValueIntegrazioneTrasporto.get("mittente"), integrazione.getEgov().getMittente());
                    }
                    if (integrazione.getEgov().getTipoDestinatario() != null) {
                        properties.put(this.keyValueIntegrazioneTrasporto.get("tipoDestinatario"), integrazione.getEgov().getTipoDestinatario());
                    }
                    if (integrazione.getEgov().getDestinatario() != null) {
                        properties.put(this.keyValueIntegrazioneTrasporto.get("destinatario"), integrazione.getEgov().getDestinatario());
                    }
                    if (integrazione.getEgov().getTipoServizio() != null) {
                        properties.put(this.keyValueIntegrazioneTrasporto.get("tipoServizio"), integrazione.getEgov().getTipoServizio());
                    }
                    if (integrazione.getEgov().getServizio() != null) {
                        properties.put(this.keyValueIntegrazioneTrasporto.get("servizio"), integrazione.getEgov().getServizio());
                    }
                    if (integrazione.getEgov().getAzione() != null) {
                        properties.put(this.keyValueIntegrazioneTrasporto.get("azione"), integrazione.getEgov().getAzione());
                    }
                    if (integrazione.getEgov().getID() != null) {
                        properties.put(this.keyValueIntegrazioneTrasporto.get("idegov"), integrazione.getEgov().getID());
                    }
                    if (integrazione.getEgov().getRiferimentoMessaggio() != null) {
                        properties.put(this.keyValueIntegrazioneTrasporto.get("riferimentoMessaggio"), integrazione.getEgov().getRiferimentoMessaggio());
                    }
                    if (integrazione.getEgov().getIdCollaborazione() != null) {
                        properties.put(this.keyValueIntegrazioneTrasporto.get("idCollaborazione"), integrazione.getEgov().getIdCollaborazione());
                    }
                }
                if (integrazione.getIdApplicativo() != null) {
                    properties.put(this.keyValueIntegrazioneTrasporto.get("idApplicativo"), integrazione.getIdApplicativo());
                }
                if (integrazione.getServizioApplicativo() != null) {
                    properties.put(this.keyValueIntegrazioneTrasporto.get("servizioApplicativo"), integrazione.getServizioApplicativo());
                }
            }
            if (properties != null) {
                if (request) {
                    properties.put("User-Agent", this.openspcoopProperties.getHttpUserAgent());
                }
                properties.put("X-SPCoop-Pdd", this.openspcoopProperties.getHttpServer());
                if (this.openspcoopProperties.getHttpXPdDDetails() != null && !"".equals(this.openspcoopProperties.getHttpXPdDDetails())) {
                    properties.put("X-SPCoop-PddDetails", this.openspcoopProperties.getHttpXPdDDetails());
                }
            }
        }
        catch (Exception e) {
            throw new HeaderIntegrazioneException("UtilitiesIntegrazione, creazione delle proprieta' dell'header non riuscita: " + e.getMessage(), e);
        }
    }

    public void readHeader(Message message, HeaderIntegrazione integrazione, ValidatoreXSD validatoreXSD, String actorIntegrazione) throws HeaderIntegrazioneException {
        try {
            if (actorIntegrazione == null) {
                throw new Exception("Actor non definito");
            }
            SOAPHeader header = (SOAPHeader)message.getSOAPHeader();
            if (header == null) {
                OpenSPCoopLogger.getLoggerOpenSPCoopCore().debug((Object)"SOAPHeader non presente");
                return;
            }
            SOAPHeaderElement headerElement = null;
            Iterator it = header.examineAllHeaderElements();
            while (it.hasNext() && !actorIntegrazione.equals((headerElement = (SOAPHeaderElement)it.next()).getActor())) {
                headerElement = null;
            }
            if (headerElement == null) {
                OpenSPCoopLogger.getLoggerOpenSPCoopCore().debug((Object)"Header di integrazione non presente");
                return;
            }
            if (validatoreXSD == null) {
                throw new Exception("Validatore XSD non istanziato");
            }
            validatoreXSD.valida((InputStream)new ByteArrayInputStream(headerElement.getAsString().getBytes()));
            String tipoMittente = null;
            try {
                tipoMittente = headerElement.getAttribute((String)this.keyValueIntegrazioneSoap.get("tipoMittente"));
            }
            catch (Exception e) {
                // empty catch block
            }
            if (tipoMittente != null) {
                integrazione.getEgov().setTipoMittente(tipoMittente);
            }
            String mittente = null;
            try {
                mittente = headerElement.getAttribute((String)this.keyValueIntegrazioneSoap.get("mittente"));
            }
            catch (Exception e) {
                // empty catch block
            }
            if (mittente != null) {
                integrazione.getEgov().setMittente(mittente);
            }
            String tipoDestinatario = null;
            try {
                tipoDestinatario = headerElement.getAttribute((String)this.keyValueIntegrazioneSoap.get("tipoDestinatario"));
            }
            catch (Exception e) {
                // empty catch block
            }
            if (tipoDestinatario != null) {
                integrazione.getEgov().setTipoDestinatario(tipoDestinatario);
            }
            String destinatario = null;
            try {
                destinatario = headerElement.getAttribute((String)this.keyValueIntegrazioneSoap.get("destinatario"));
            }
            catch (Exception e) {
                // empty catch block
            }
            if (destinatario != null) {
                integrazione.getEgov().setDestinatario(destinatario);
            }
            String tipoServizio = null;
            try {
                tipoServizio = headerElement.getAttribute((String)this.keyValueIntegrazioneSoap.get("tipoServizio"));
            }
            catch (Exception e) {
                // empty catch block
            }
            if (tipoServizio != null) {
                integrazione.getEgov().setTipoServizio(tipoServizio);
            }
            String servizio = null;
            try {
                servizio = headerElement.getAttribute((String)this.keyValueIntegrazioneSoap.get("servizio"));
            }
            catch (Exception e) {
                // empty catch block
            }
            if (servizio != null) {
                integrazione.getEgov().setServizio(servizio);
            }
            String azione = null;
            try {
                azione = headerElement.getAttribute((String)this.keyValueIntegrazioneSoap.get("azione"));
            }
            catch (Exception e) {
                // empty catch block
            }
            if (azione != null) {
                integrazione.getEgov().setAzione(azione);
            }
            String idEGov = null;
            try {
                idEGov = headerElement.getAttribute((String)this.keyValueIntegrazioneSoap.get("idegov"));
            }
            catch (Exception e) {
                // empty catch block
            }
            if (idEGov != null) {
                integrazione.getEgov().setID(idEGov);
            }
            String riferimentoMessaggio = null;
            try {
                riferimentoMessaggio = headerElement.getAttribute((String)this.keyValueIntegrazioneSoap.get("riferimentoMessaggio"));
            }
            catch (Exception e) {
                // empty catch block
            }
            if (riferimentoMessaggio != null) {
                integrazione.getEgov().setRiferimentoMessaggio(riferimentoMessaggio);
            }
            String collaborazione = null;
            try {
                collaborazione = headerElement.getAttribute((String)this.keyValueIntegrazioneSoap.get("idCollaborazione"));
            }
            catch (Exception e) {
                // empty catch block
            }
            if (collaborazione != null) {
                integrazione.getEgov().setIdCollaborazione(collaborazione);
            }
            String idApplicativo = null;
            try {
                idApplicativo = headerElement.getAttribute((String)this.keyValueIntegrazioneSoap.get("idApplicativo"));
            }
            catch (Exception e) {
                // empty catch block
            }
            if (idApplicativo != null) {
                integrazione.setIdApplicativo(idApplicativo);
            }
            String sa = null;
            try {
                sa = headerElement.getAttribute((String)this.keyValueIntegrazioneSoap.get("servizioApplicativo"));
            }
            catch (Exception e) {
                // empty catch block
            }
            if (sa != null) {
                integrazione.setServizioApplicativo(sa);
            }
        }
        catch (Exception e) {
            throw new HeaderIntegrazioneException("UtilitiesIntegrazione, lettura dell'header soap non riuscita: " + e.getMessage(), e);
        }
    }

    public void updateHeader(Message message, IDSoggetto soggettoFruitore, IDServizio idServizio, String idEGov, String servizioApplicativo, String correlazioneApplicativa, String actorIntegrazione, String nomeElemento, String prefix, String namespace) throws Exception {
        HeaderIntegrazione integrazione = new HeaderIntegrazione();
        integrazione.setIdApplicativo(correlazioneApplicativa);
        integrazione.setServizioApplicativo(servizioApplicativo);
        HeaderIntegrazioneEGov egov = new HeaderIntegrazioneEGov();
        egov.setTipoMittente(soggettoFruitore.getTipo());
        egov.setMittente(soggettoFruitore.getNome());
        egov.setTipoDestinatario(idServizio.getSoggettoErogatore().getTipo());
        egov.setDestinatario(idServizio.getSoggettoErogatore().getNome());
        egov.setTipoServizio(idServizio.getTipoServizio());
        egov.setServizio(idServizio.getServizio());
        egov.setAzione(idServizio.getAzione());
        egov.setID(idEGov);
        integrazione.setEgov(egov);
        this.updateHeader(message, integrazione, actorIntegrazione, nomeElemento, prefix, namespace);
    }

    public void updateHeader(Message message, HeaderIntegrazione integrazione, String actorIntegrazione, String nomeElemento, String prefix, String namespace) throws Exception {
        MessageElement tmp;
        if (actorIntegrazione == null) {
            throw new Exception("Actor non definito");
        }
        SOAPHeader header = (SOAPHeader)message.getSOAPHeader();
        SOAPHeaderElement headerIntegrazione = null;
        if (header == null) {
            OpenSPCoopLogger.getLoggerOpenSPCoopCore().debug((Object)"SOAPHeader non presente: add soapHeader");
            header = (SOAPHeader)message.getSOAPEnvelope().addHeader();
        } else {
            Iterator it = header.examineAllHeaderElements();
            while (it.hasNext() && !actorIntegrazione.equals((headerIntegrazione = (SOAPHeaderElement)it.next()).getActor())) {
                headerIntegrazione = null;
            }
            if (headerIntegrazione == null) {
                OpenSPCoopLogger.getLoggerOpenSPCoopCore().debug((Object)"Header di integrazione non presente, lo creo");
            }
        }
        Vector<MessageElement> v = new Vector<MessageElement>();
        if (headerIntegrazione != null) {
            Iterator it = headerIntegrazione.getChildElements();
            if (it.hasNext()) {
                tmp = (MessageElement)it.next();
                v.add(tmp);
            }
            header.removeChild((Node)headerIntegrazione);
        }
        SOAPHeaderElement headerIntegrazioneNEW = this.buildHeader(integrazione, nomeElemento, prefix, namespace, actorIntegrazione);
        while (v.size() > 0) {
            tmp = (MessageElement)v.remove(0);
            headerIntegrazioneNEW.addChildElement((SOAPElement)tmp);
        }
        header.addChildElement((SOAPElement)headerIntegrazioneNEW);
    }

    public SOAPHeaderElement buildHeader(HeaderIntegrazione integrazione, String nomeElemento, String prefix, String namespace, String actor) throws HeaderIntegrazioneException {
        try {
            PrefixedQName name = new PrefixedQName(namespace, nomeElemento, prefix);
            SOAPHeaderElement header = new SOAPHeaderElement((Name)name);
            header.setActor(actor);
            header.setMustUnderstand(false);
            header.addNamespaceDeclaration("SOAP_ENV", "http://schemas.xmlsoap.org/soap/envelope/");
            this.setAttributes(integrazione, header);
            return header;
        }
        catch (Exception e) {
            throw new HeaderIntegrazioneException("UtilitiesIntegrazione, creazione dell'header soap non riuscita: " + e.getMessage(), e);
        }
    }

    public void setAttributes(HeaderIntegrazione integrazione, SOAPHeaderElement header) {
        if (integrazione.getEgov() != null) {
            if (integrazione.getEgov().getTipoMittente() != null) {
                header.setAttribute((String)this.keyValueIntegrazioneSoap.get("tipoMittente"), integrazione.getEgov().getTipoMittente());
            }
            if (integrazione.getEgov().getMittente() != null) {
                header.setAttribute((String)this.keyValueIntegrazioneSoap.get("mittente"), integrazione.getEgov().getMittente());
            }
            if (integrazione.getEgov().getTipoDestinatario() != null) {
                header.setAttribute((String)this.keyValueIntegrazioneSoap.get("tipoDestinatario"), integrazione.getEgov().getTipoDestinatario());
            }
            if (integrazione.getEgov().getDestinatario() != null) {
                header.setAttribute((String)this.keyValueIntegrazioneSoap.get("destinatario"), integrazione.getEgov().getDestinatario());
            }
            if (integrazione.getEgov().getTipoServizio() != null) {
                header.setAttribute((String)this.keyValueIntegrazioneSoap.get("tipoServizio"), integrazione.getEgov().getTipoServizio());
            }
            if (integrazione.getEgov().getServizio() != null) {
                header.setAttribute((String)this.keyValueIntegrazioneSoap.get("servizio"), integrazione.getEgov().getServizio());
            }
            if (integrazione.getEgov().getAzione() != null) {
                header.setAttribute((String)this.keyValueIntegrazioneSoap.get("azione"), integrazione.getEgov().getAzione());
            }
            if (integrazione.getEgov().getID() != null) {
                header.setAttribute((String)this.keyValueIntegrazioneSoap.get("idegov"), integrazione.getEgov().getID());
            }
            if (integrazione.getEgov().getRiferimentoMessaggio() != null) {
                header.setAttribute((String)this.keyValueIntegrazioneSoap.get("riferimentoMessaggio"), integrazione.getEgov().getRiferimentoMessaggio());
            }
            if (integrazione.getEgov().getIdCollaborazione() != null) {
                header.setAttribute((String)this.keyValueIntegrazioneSoap.get("idCollaborazione"), integrazione.getEgov().getIdCollaborazione());
            }
        }
        if (integrazione.getIdApplicativo() != null) {
            header.setAttribute((String)this.keyValueIntegrazioneSoap.get("idApplicativo"), integrazione.getIdApplicativo());
        }
        if (integrazione.getServizioApplicativo() != null) {
            header.setAttribute((String)this.keyValueIntegrazioneSoap.get("servizioApplicativo"), integrazione.getServizioApplicativo());
        }
        header.setAttribute("SPCoopPdd", this.openspcoopProperties.getHeaderIntegrazioneSOAPPdDVersione());
        if (this.openspcoopProperties.getHeaderIntegrazioneSOAPPdDDetails() != null && !"".equals(this.openspcoopProperties.getHeaderIntegrazioneSOAPPdDDetails())) {
            header.setAttribute("SPCoopPddDetails", this.openspcoopProperties.getHeaderIntegrazioneSOAPPdDDetails());
        }
    }

    public void deleteHeader(Message message, String actorIntegrazione) throws HeaderIntegrazioneException {
        try {
            if (actorIntegrazione == null) {
                throw new Exception("Actor non definito");
            }
            SOAPHeader header = (SOAPHeader)message.getSOAPHeader();
            if (header == null) {
                OpenSPCoopLogger.getLoggerOpenSPCoopCore().debug((Object)"SOAPHeader non presente");
                return;
            }
            SOAPHeaderElement headerElement = null;
            Iterator it = header.examineAllHeaderElements();
            while (it.hasNext() && !actorIntegrazione.equals((headerElement = (SOAPHeaderElement)it.next()).getActor())) {
                headerElement = null;
            }
            if (headerElement == null) {
                OpenSPCoopLogger.getLoggerOpenSPCoopCore().debug((Object)"Header di integrazione non presente");
                return;
            }
            header.removeChild((Node)headerElement);
        }
        catch (Exception e) {
            throw new HeaderIntegrazioneException("UtilitiesIntegrazione, eliminazione dell'header soap non riuscita: " + e.getMessage(), e);
        }
    }
}

