/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop.pdd.core.integrazione;

import java.util.Properties;
import javax.xml.soap.SOAPElement;
import org.apache.axis.Message;
import org.apache.axis.message.SOAPHeaderElement;
import org.apache.log4j.Logger;
import org.openspcoop.dao.commons.IDSoggetto;
import org.openspcoop.dao.registry.driver.IDServizio;
import org.openspcoop.pdd.config.OpenSPCoopProperties;
import org.openspcoop.pdd.core.ParametriPortaDelegata;
import org.openspcoop.pdd.core.integrazione.HeaderIntegrazione;
import org.openspcoop.pdd.core.integrazione.HeaderIntegrazioneException;
import org.openspcoop.pdd.core.integrazione.IGestoreIntegrazionePDSoap;
import org.openspcoop.pdd.core.integrazione.UtilitiesIntegrazione;
import org.openspcoop.pdd.logger.OpenSPCoopLogger;
import org.openspcoop.utils.xml.ValidatoreXSD;
import org.openspcoop.utils.xml.XSDResourceResolver;
import org.w3c.dom.ls.LSResourceResolver;

public class GestoreIntegrazionePDSoap
implements IGestoreIntegrazionePDSoap {
    UtilitiesIntegrazione utilities = UtilitiesIntegrazione.getInstance();
    private ValidatoreXSD validatoreXSD = null;
    OpenSPCoopProperties openspcoopProperties = OpenSPCoopProperties.getInstance();
    private static Logger log = OpenSPCoopLogger.getLoggerOpenSPCoopCore();

    public GestoreIntegrazionePDSoap() {
        try {
            XSDResourceResolver xsdResourceResolver = new XSDResourceResolver();
            xsdResourceResolver.addResource("soapEnvelope.xsd", UtilitiesIntegrazione.class.getResourceAsStream("/soapEnvelope.xsd"));
            this.validatoreXSD = new ValidatoreXSD((LSResourceResolver)xsdResourceResolver, UtilitiesIntegrazione.class.getResourceAsStream("/integrazione.xsd"));
        }
        catch (Exception e) {
            log.error((Object)("Integrazione.xsd, errore durante la costruzione del validatore xsd: " + e.getMessage()));
        }
    }

    public void readHeader(HeaderIntegrazione integrazione, Message message, ParametriPortaDelegata parPD) throws HeaderIntegrazioneException {
        try {
            this.utilities.readHeader(message, integrazione, this.validatoreXSD, this.openspcoopProperties.getHeaderSoapActorIntegrazione());
        }
        catch (Exception e) {
            throw new HeaderIntegrazioneException("GestoreIntegrazionePDSoap, " + e.getMessage(), e);
        }
    }

    public void deleteHeader(Message message) throws HeaderIntegrazioneException {
        try {
            this.utilities.deleteHeader(message, this.openspcoopProperties.getHeaderSoapActorIntegrazione());
        }
        catch (Exception e) {
            throw new HeaderIntegrazioneException("GestoreIntegrazionePDSoap, " + e.getMessage(), e);
        }
    }

    public void updateHeader(Message message, IDSoggetto soggettoFruitore, IDServizio idServizio, String idEGov, String servizioApplicativo, String correlazioneApplicativa) throws HeaderIntegrazioneException {
        try {
            this.utilities.updateHeader(message, soggettoFruitore, idServizio, idEGov, servizioApplicativo, correlazioneApplicativa, this.openspcoopProperties.getHeaderSoapActorIntegrazione(), this.openspcoopProperties.getHeaderSoapNameIntegrazione(), this.openspcoopProperties.getHeaderSoapPrefixIntegrazione(), this.openspcoopProperties.getHeaderSoapActorIntegrazione());
        }
        catch (Exception e) {
            throw new HeaderIntegrazioneException("GestoreIntegrazionePDSoap, " + e.getMessage(), e);
        }
    }

    public void setResponseHeader(HeaderIntegrazione integrazione, Message message, Properties properties) throws HeaderIntegrazioneException {
        try {
            SOAPHeaderElement header = this.utilities.buildHeader(integrazione, this.openspcoopProperties.getHeaderSoapNameIntegrazione(), this.openspcoopProperties.getHeaderSoapPrefixIntegrazione(), this.openspcoopProperties.getHeaderSoapActorIntegrazione(), this.openspcoopProperties.getHeaderSoapActorIntegrazione());
            message.getSOAPHeader().addChildElement((SOAPElement)header);
        }
        catch (Exception e) {
            throw new HeaderIntegrazioneException("GestoreIntegrazionePDSoap, " + e.getMessage(), e);
        }
    }
}

