/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop.pdd.core.integrazione;

import java.util.Properties;
import javax.xml.soap.SOAPElement;
import org.apache.axis.Message;
import org.apache.axis.message.SOAPHeaderElement;
import org.apache.log4j.Logger;
import org.openspcoop.pdd.config.OpenSPCoopProperties;
import org.openspcoop.pdd.core.integrazione.HeaderIntegrazione;
import org.openspcoop.pdd.core.integrazione.HeaderIntegrazioneEGov;
import org.openspcoop.pdd.core.integrazione.HeaderIntegrazioneException;
import org.openspcoop.pdd.core.integrazione.IGestoreIntegrazionePASoap;
import org.openspcoop.pdd.core.integrazione.UtilitiesIntegrazione;
import org.openspcoop.pdd.core.integrazione.UtilitiesIntegrazioneWSAddressing;
import org.openspcoop.pdd.logger.OpenSPCoopLogger;
import org.openspcoop.utils.xml.ValidatoreXSD;

public class GestoreIntegrazionePAWSAddressing
implements IGestoreIntegrazionePASoap {
    UtilitiesIntegrazioneWSAddressing utilities = UtilitiesIntegrazioneWSAddressing.getInstance();
    OpenSPCoopProperties openspcoopProperties = OpenSPCoopProperties.getInstance();
    private ValidatoreXSD validatoreXSD = null;
    private static Logger log = OpenSPCoopLogger.getLoggerOpenSPCoopCore();

    public GestoreIntegrazionePAWSAddressing() {
        try {
            this.validatoreXSD = new ValidatoreXSD(UtilitiesIntegrazione.class.getResourceAsStream("/ws-addr.xsd"));
        }
        catch (Exception e) {
            log.error((Object)("ws-addr.xsd, errore durante la costruzione del validatore xsd: " + e.getMessage()));
        }
    }

    public void readHeader(HeaderIntegrazione integrazione, Message message) throws HeaderIntegrazioneException {
        try {
            this.utilities.readHeader(message, integrazione, this.validatoreXSD, false, this.openspcoopProperties.getHeaderSoapActorIntegrazione());
        }
        catch (Exception e) {
            throw new HeaderIntegrazioneException("GestoreIntegrazionePDSoap, " + e.getMessage(), e);
        }
    }

    public void deleteHeader(Message message) throws HeaderIntegrazioneException {
        try {
            this.utilities.deleteHeader(message, this.openspcoopProperties.getHeaderSoapActorIntegrazione());
        }
        catch (Exception e) {
            throw new HeaderIntegrazioneException("GestoreIntegrazionePDSoap, " + e.getMessage(), e);
        }
    }

    public void setHeader(HeaderIntegrazione integrazione, Message message, Properties properties) throws HeaderIntegrazioneException {
        try {
            if (integrazione.getEgov() != null) {
                HeaderIntegrazioneEGov hEGOV = integrazione.getEgov();
                if (hEGOV.getDestinatario() != null && hEGOV.getServizio() != null) {
                    SOAPHeaderElement wsaTO = UtilitiesIntegrazioneWSAddressing.buildWSATo(this.openspcoopProperties.getHeaderSoapActorIntegrazione(), hEGOV.getDestinatario(), hEGOV.getServizio());
                    message.getSOAPHeader().addChildElement((SOAPElement)wsaTO);
                    if (hEGOV.getAzione() != null) {
                        SOAPHeaderElement wsaAction = UtilitiesIntegrazioneWSAddressing.buildWSAAction(this.openspcoopProperties.getHeaderSoapActorIntegrazione(), hEGOV.getDestinatario(), hEGOV.getServizio(), hEGOV.getAzione());
                        message.getSOAPHeader().addChildElement((SOAPElement)wsaAction);
                    }
                }
                if (hEGOV.getMittente() != null) {
                    SOAPHeaderElement wsaFROM = UtilitiesIntegrazioneWSAddressing.buildWSAFrom(this.openspcoopProperties.getHeaderSoapActorIntegrazione(), integrazione.getServizioApplicativo(), hEGOV.getMittente());
                    message.getSOAPHeader().addChildElement((SOAPElement)wsaFROM);
                }
                if (hEGOV.getID() != null) {
                    SOAPHeaderElement wsaID = UtilitiesIntegrazioneWSAddressing.buildWSAID(this.openspcoopProperties.getHeaderSoapActorIntegrazione(), hEGOV.getID());
                    message.getSOAPHeader().addChildElement((SOAPElement)wsaID);
                }
                if (hEGOV.getRiferimentoMessaggio() != null || hEGOV.getIdCollaborazione() != null) {
                    String rif = hEGOV.getRiferimentoMessaggio();
                    if (rif == null) {
                        rif = hEGOV.getIdCollaborazione();
                    }
                    SOAPHeaderElement wsaRelatesTo = UtilitiesIntegrazioneWSAddressing.buildWSARelatesTo(this.openspcoopProperties.getHeaderSoapActorIntegrazione(), rif);
                    message.getSOAPHeader().addChildElement((SOAPElement)wsaRelatesTo);
                }
            }
        }
        catch (Exception e) {
            throw new HeaderIntegrazioneException("GestoreIntegrazionePASoap, " + e.getMessage(), e);
        }
    }

    public void updateHeader(HeaderIntegrazione integrazione, Message message) throws HeaderIntegrazioneException {
        try {
            this.utilities.updateHeader(message, integrazione, this.openspcoopProperties.getHeaderSoapActorIntegrazione());
        }
        catch (Exception e) {
            throw new HeaderIntegrazioneException("GestoreIntegrazionePDSoap, " + e.getMessage(), e);
        }
    }
}

