/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop.pdd.core.handlers;

import org.apache.log4j.Logger;
import org.openspcoop.pdd.config.ClassNameProperties;
import org.openspcoop.pdd.config.OpenSPCoopProperties;
import org.openspcoop.pdd.core.handlers.ExitContext;
import org.openspcoop.pdd.core.handlers.ExitHandler;
import org.openspcoop.pdd.core.handlers.GeneratoreCasualeDate;
import org.openspcoop.pdd.core.handlers.HandlerException;
import org.openspcoop.pdd.core.handlers.InRequestContext;
import org.openspcoop.pdd.core.handlers.InRequestEGovContext;
import org.openspcoop.pdd.core.handlers.InRequestEGovHandler;
import org.openspcoop.pdd.core.handlers.InRequestHandler;
import org.openspcoop.pdd.core.handlers.InResponseContext;
import org.openspcoop.pdd.core.handlers.InResponseHandler;
import org.openspcoop.pdd.core.handlers.InitContext;
import org.openspcoop.pdd.core.handlers.InitHandler;
import org.openspcoop.pdd.core.handlers.IntegrationManagerRequestContext;
import org.openspcoop.pdd.core.handlers.IntegrationManagerRequestHandler;
import org.openspcoop.pdd.core.handlers.IntegrationManagerResponseContext;
import org.openspcoop.pdd.core.handlers.IntegrationManagerResponseHandler;
import org.openspcoop.pdd.core.handlers.OutRequestContext;
import org.openspcoop.pdd.core.handlers.OutRequestHandler;
import org.openspcoop.pdd.core.handlers.OutResponseContext;
import org.openspcoop.pdd.core.handlers.OutResponseHandler;
import org.openspcoop.pdd.core.handlers.PostOutResponseContext;
import org.openspcoop.pdd.core.handlers.PostOutResponseHandler;
import org.openspcoop.pdd.core.handlers.PreInRequestContext;
import org.openspcoop.pdd.core.handlers.PreInRequestHandler;
import org.openspcoop.pdd.logger.MsgDiagnostico;
import org.openspcoop.utils.Loader;
import org.openspcoop.utils.date.DateManager;
import org.openspcoop.utils.id.UniqueIdentifierManager;

public class GestoreHandlers {
    private static boolean initialize = false;
    private static OpenSPCoopProperties properties = null;
    private static GeneratoreCasualeDate generatoreCasualeDati = null;
    private static InitHandler[] initHandlers = null;
    private static String[] tipiInitHandlers = null;
    private static ExitHandler[] exitHandlers = null;
    private static String[] tipiExitHandlers = null;
    private static PreInRequestHandler[] preInRequestHandlers = null;
    private static String[] tipiPreInRequestHandlers = null;
    private static InRequestHandler[] inRequestHandlers = null;
    private static String[] tipiInRequestHandlers = null;
    private static InRequestEGovHandler[] inRequestEGovHandlers = null;
    private static String[] tipiInRequestEGovHandlers = null;
    private static OutRequestHandler[] outRequestHandlers = null;
    private static String[] tipiOutRequestHandlers = null;
    private static InResponseHandler[] inResponseHandlers = null;
    private static String[] tipiInResponseHandlers = null;
    private static OutResponseHandler[] outResponseHandlers = null;
    private static String[] tipiOutResponseHandlers = null;
    private static PostOutResponseHandler[] postOutResponseHandlers = null;
    private static String[] tipiPostOutResponseHandlers = null;
    private static IntegrationManagerRequestHandler[] integrationManagerRequestHandlers = null;
    private static String[] tipiIntegrationManagerRequestHandlers = null;
    private static IntegrationManagerResponseHandler[] integrationManagerResponseHandlers = null;
    private static String[] tipiIntegrationManagerResponseHandlers = null;

    private static synchronized void initialize(MsgDiagnostico msgDiag) {
        if (!initialize) {
            String classe;
            String tipo;
            int i;
            properties = OpenSPCoopProperties.getInstance();
            ClassNameProperties classNameProperties = ClassNameProperties.getInstance();
            Loader loader = Loader.getInstance();
            if (properties.generazioneDateCasualiLogAbilitato() && !UniqueIdentifierManager.isGenerazioneUIDDisabilitata()) {
                generatoreCasualeDati = GeneratoreCasualeDate.getGeneratoreCasualeDate();
            }
            if ((tipiInitHandlers = properties.getInitHandler()) != null) {
                initHandlers = new InitHandler[tipiInitHandlers.length];
                for (i = 0; i < tipiInitHandlers.length; ++i) {
                    try {
                        tipo = tipiInitHandlers[i];
                        classe = classNameProperties.getInitHandler(tipo);
                        GestoreHandlers.initHandlers[i] = (InitHandler)loader.newInstance(classe);
                        continue;
                    }
                    catch (Exception e) {
                        msgDiag.logErroreGenerico(e, "Inizializzazione InitHandler [" + tipiInitHandlers[i] + "]");
                    }
                }
            }
            if ((tipiExitHandlers = properties.getExitHandler()) != null) {
                exitHandlers = new ExitHandler[tipiExitHandlers.length];
                for (i = 0; i < tipiExitHandlers.length; ++i) {
                    try {
                        tipo = tipiExitHandlers[i];
                        classe = classNameProperties.getExitHandler(tipo);
                        GestoreHandlers.exitHandlers[i] = (ExitHandler)loader.newInstance(classe);
                        continue;
                    }
                    catch (Exception e) {
                        msgDiag.logErroreGenerico(e, "Inizializzazione ExitHandler [" + tipiExitHandlers[i] + "]");
                    }
                }
            }
            if ((tipiPreInRequestHandlers = properties.getPreInRequestHandler()) != null) {
                preInRequestHandlers = new PreInRequestHandler[tipiPreInRequestHandlers.length];
                for (i = 0; i < tipiPreInRequestHandlers.length; ++i) {
                    try {
                        tipo = tipiPreInRequestHandlers[i];
                        classe = classNameProperties.getPreInRequestHandler(tipo);
                        GestoreHandlers.preInRequestHandlers[i] = (PreInRequestHandler)loader.newInstance(classe);
                        continue;
                    }
                    catch (Exception e) {
                        msgDiag.logErroreGenerico(e, "Inizializzazione PreInRequestHandler [" + tipiPreInRequestHandlers[i] + "]");
                    }
                }
            }
            if ((tipiInRequestHandlers = properties.getInRequestHandler()) != null) {
                inRequestHandlers = new InRequestHandler[tipiInRequestHandlers.length];
                for (i = 0; i < tipiInRequestHandlers.length; ++i) {
                    try {
                        tipo = tipiInRequestHandlers[i];
                        classe = classNameProperties.getInRequestHandler(tipo);
                        GestoreHandlers.inRequestHandlers[i] = (InRequestHandler)loader.newInstance(classe);
                        continue;
                    }
                    catch (Exception e) {
                        msgDiag.logErroreGenerico(e, "Inizializzazione InRequestHandler [" + tipiInRequestHandlers[i] + "]");
                    }
                }
            }
            if ((tipiInRequestEGovHandlers = properties.getInRequestEGovHandler()) != null) {
                inRequestEGovHandlers = new InRequestEGovHandler[tipiInRequestEGovHandlers.length];
                for (i = 0; i < tipiInRequestEGovHandlers.length; ++i) {
                    try {
                        tipo = tipiInRequestEGovHandlers[i];
                        classe = classNameProperties.getInRequestEGovHandler(tipo);
                        GestoreHandlers.inRequestEGovHandlers[i] = (InRequestEGovHandler)loader.newInstance(classe);
                        continue;
                    }
                    catch (Exception e) {
                        msgDiag.logErroreGenerico(e, "Inizializzazione InRequestEGovHandler [" + tipiInRequestEGovHandlers[i] + "]");
                    }
                }
            }
            if ((tipiOutRequestHandlers = properties.getOutRequestHandler()) != null) {
                outRequestHandlers = new OutRequestHandler[tipiOutRequestHandlers.length];
                for (i = 0; i < tipiOutRequestHandlers.length; ++i) {
                    try {
                        tipo = tipiOutRequestHandlers[i];
                        classe = classNameProperties.getOutRequestHandler(tipo);
                        GestoreHandlers.outRequestHandlers[i] = (OutRequestHandler)loader.newInstance(classe);
                        continue;
                    }
                    catch (Exception e) {
                        msgDiag.logErroreGenerico(e, "Inizializzazione OutRequestHandler [" + tipiOutRequestHandlers[i] + "]");
                    }
                }
            }
            if ((tipiInResponseHandlers = properties.getInResponseHandler()) != null) {
                inResponseHandlers = new InResponseHandler[tipiInResponseHandlers.length];
                for (i = 0; i < tipiInResponseHandlers.length; ++i) {
                    try {
                        tipo = tipiInResponseHandlers[i];
                        classe = classNameProperties.getInResponseHandler(tipo);
                        GestoreHandlers.inResponseHandlers[i] = (InResponseHandler)loader.newInstance(classe);
                        continue;
                    }
                    catch (Exception e) {
                        msgDiag.logErroreGenerico(e, "Inizializzazione InResponseHandler [" + tipiInResponseHandlers[i] + "]");
                    }
                }
            }
            if ((tipiOutResponseHandlers = properties.getOutResponseHandler()) != null) {
                outResponseHandlers = new OutResponseHandler[tipiOutResponseHandlers.length];
                for (i = 0; i < tipiOutResponseHandlers.length; ++i) {
                    try {
                        tipo = tipiOutResponseHandlers[i];
                        classe = classNameProperties.getOutResponseHandler(tipo);
                        GestoreHandlers.outResponseHandlers[i] = (OutResponseHandler)loader.newInstance(classe);
                        continue;
                    }
                    catch (Exception e) {
                        msgDiag.logErroreGenerico(e, "Inizializzazione OutResponseHandler [" + tipiOutResponseHandlers[i] + "]");
                    }
                }
            }
            if ((tipiPostOutResponseHandlers = properties.getPostOutResponseHandler()) != null) {
                postOutResponseHandlers = new PostOutResponseHandler[tipiPostOutResponseHandlers.length];
                for (i = 0; i < tipiPostOutResponseHandlers.length; ++i) {
                    try {
                        tipo = tipiPostOutResponseHandlers[i];
                        classe = classNameProperties.getPostOutResponseHandler(tipo);
                        GestoreHandlers.postOutResponseHandlers[i] = (PostOutResponseHandler)loader.newInstance(classe);
                        continue;
                    }
                    catch (Exception e) {
                        msgDiag.logErroreGenerico(e, "Inizializzazione PostOutResponseHandler [" + tipiPostOutResponseHandlers[i] + "]");
                    }
                }
            }
            if ((tipiIntegrationManagerRequestHandlers = properties.getIntegrationManagerRequestHandler()) != null) {
                integrationManagerRequestHandlers = new IntegrationManagerRequestHandler[tipiIntegrationManagerRequestHandlers.length];
                for (i = 0; i < tipiIntegrationManagerRequestHandlers.length; ++i) {
                    try {
                        tipo = tipiIntegrationManagerRequestHandlers[i];
                        classe = classNameProperties.getIntegrationManagerRequestHandler(tipo);
                        GestoreHandlers.integrationManagerRequestHandlers[i] = (IntegrationManagerRequestHandler)loader.newInstance(classe);
                        continue;
                    }
                    catch (Exception e) {
                        msgDiag.logErroreGenerico(e, "Inizializzazione IntegrationManagerRequestHandler [" + tipiIntegrationManagerRequestHandlers[i] + "]");
                    }
                }
            }
            if ((tipiIntegrationManagerResponseHandlers = properties.getIntegrationManagerResponseHandler()) != null) {
                integrationManagerResponseHandlers = new IntegrationManagerResponseHandler[tipiIntegrationManagerResponseHandlers.length];
                for (i = 0; i < tipiIntegrationManagerResponseHandlers.length; ++i) {
                    try {
                        tipo = tipiIntegrationManagerResponseHandlers[i];
                        classe = classNameProperties.getIntegrationManagerResponseHandler(tipo);
                        GestoreHandlers.integrationManagerResponseHandlers[i] = (IntegrationManagerResponseHandler)loader.newInstance(classe);
                        continue;
                    }
                    catch (Exception e) {
                        msgDiag.logErroreGenerico(e, "Inizializzazione IntegrationManagerResponseHandler [" + tipiIntegrationManagerResponseHandlers[i] + "]");
                    }
                }
            }
        }
        initialize = true;
    }

    public static void init(InitContext context, MsgDiagnostico msgDiag) throws HandlerException {
        if (!initialize) {
            GestoreHandlers.initialize(msgDiag);
        }
        if (initHandlers != null) {
            for (int i = 0; i < initHandlers.length; ++i) {
                try {
                    initHandlers[i].invoke(context);
                    continue;
                }
                catch (Exception e) {
                    HandlerException ex = new HandlerException(e.getMessage(), e);
                    ex.setIdentitaHandler("InitHandler[" + initHandlers[i] + "]");
                    throw ex;
                }
            }
        }
    }

    public static void exit(ExitContext context) {
        Logger log = null;
        if (context != null) {
            log = context.getLogCore() != null ? context.getLogCore() : context.getLogConsole();
        }
        if (initialize && exitHandlers != null) {
            for (int i = 0; i < exitHandlers.length; ++i) {
                try {
                    exitHandlers[i].invoke(context);
                    continue;
                }
                catch (Exception e) {
                    if (log == null) continue;
                    log.error((Object)("ExitHandler[" + tipiExitHandlers[i] + "]"), (Throwable)e);
                }
            }
        }
    }

    public static void preInRequest(PreInRequestContext context, MsgDiagnostico msgDiag) {
        if (!initialize) {
            GestoreHandlers.initialize(msgDiag);
        }
        if (preInRequestHandlers != null) {
            for (int i = 0; i < preInRequestHandlers.length; ++i) {
                try {
                    preInRequestHandlers[i].invoke(context);
                    continue;
                }
                catch (Exception e) {
                    msgDiag.logErroreGenerico(e, "PreInRequestHandler[" + tipiPreInRequestHandlers[i] + "]");
                }
            }
        }
    }

    public static void inRequest(InRequestContext context, MsgDiagnostico msgDiag) throws HandlerException {
        if (!initialize) {
            GestoreHandlers.initialize(msgDiag);
        }
        if (context.getDataElaborazioneMessaggio() == null) {
            context.setDataElaborazioneMessaggio(DateManager.getDate());
        }
        if (properties.generazioneDateCasualiLogAbilitato() && context.getPddContext().getObject("ID") != null) {
            context.setDataElaborazioneMessaggio(generatoreCasualeDati.getProssimaData((String)context.getPddContext().getObject("ID")));
        }
        if (inRequestHandlers != null) {
            for (int i = 0; i < inRequestHandlers.length; ++i) {
                try {
                    inRequestHandlers[i].invoke(context);
                    continue;
                }
                catch (Exception e) {
                    HandlerException ex = new HandlerException(e.getMessage(), e);
                    ex.setIdentitaHandler("InRequestHandler[" + tipiInRequestHandlers[i] + "]");
                    throw ex;
                }
            }
        }
    }

    public static void inRequestEGov(InRequestEGovContext context, MsgDiagnostico msgDiag) throws HandlerException {
        if (!initialize) {
            GestoreHandlers.initialize(msgDiag);
        }
        if (context.getDataElaborazioneMessaggio() == null) {
            context.setDataElaborazioneMessaggio(DateManager.getDate());
        }
        if (properties.generazioneDateCasualiLogAbilitato() && context.getPddContext().getObject("ID") != null) {
            context.setDataElaborazioneMessaggio(generatoreCasualeDati.getProssimaData((String)context.getPddContext().getObject("ID")));
        }
        if (inRequestEGovHandlers != null) {
            for (int i = 0; i < inRequestEGovHandlers.length; ++i) {
                try {
                    inRequestEGovHandlers[i].invoke(context);
                    continue;
                }
                catch (Exception e) {
                    HandlerException ex = new HandlerException(e.getMessage(), e);
                    ex.setIdentitaHandler("inRequestEGovHandlers[" + tipiInRequestHandlers[i] + "]");
                    throw ex;
                }
            }
        }
    }

    public static void outRequest(OutRequestContext context, MsgDiagnostico msgDiag) throws HandlerException {
        if (!initialize) {
            GestoreHandlers.initialize(msgDiag);
        }
        if (context.getDataElaborazioneMessaggio() == null) {
            context.setDataElaborazioneMessaggio(DateManager.getDate());
        }
        if (properties.generazioneDateCasualiLogAbilitato() && context.getPddContext().getObject("ID") != null) {
            context.setDataElaborazioneMessaggio(generatoreCasualeDati.getProssimaData((String)context.getPddContext().getObject("ID")));
        }
        if (outRequestHandlers != null) {
            for (int i = 0; i < outRequestHandlers.length; ++i) {
                try {
                    outRequestHandlers[i].invoke(context);
                    continue;
                }
                catch (Exception e) {
                    HandlerException ex = new HandlerException(e.getMessage(), e);
                    ex.setIdentitaHandler("OutRequestHandler[" + tipiOutRequestHandlers[i] + "]");
                    throw ex;
                }
            }
        }
    }

    public static void inResponse(InResponseContext context, MsgDiagnostico msgDiag) throws HandlerException {
        if (!initialize) {
            GestoreHandlers.initialize(msgDiag);
        }
        if (context.getDataElaborazioneMessaggio() == null) {
            context.setDataElaborazioneMessaggio(DateManager.getDate());
        }
        if (properties.generazioneDateCasualiLogAbilitato() && context.getPddContext().getObject("ID") != null) {
            context.setDataElaborazioneMessaggio(generatoreCasualeDati.getProssimaData((String)context.getPddContext().getObject("ID")));
        }
        if (inResponseHandlers != null) {
            for (int i = 0; i < inResponseHandlers.length; ++i) {
                try {
                    inResponseHandlers[i].invoke(context);
                    continue;
                }
                catch (Exception e) {
                    HandlerException ex = new HandlerException(e.getMessage(), e);
                    ex.setIdentitaHandler("InResponseHandler[" + tipiInResponseHandlers[i] + "]");
                    throw ex;
                }
            }
        }
    }

    public static void outResponse(OutResponseContext context, MsgDiagnostico msgDiag) throws HandlerException {
        if (!initialize) {
            GestoreHandlers.initialize(msgDiag);
        }
        if (context.getDataElaborazioneMessaggio() == null) {
            context.setDataElaborazioneMessaggio(DateManager.getDate());
        }
        if (properties.generazioneDateCasualiLogAbilitato() && context.getPddContext().getObject("ID") != null) {
            context.setDataElaborazioneMessaggio(generatoreCasualeDati.getProssimaData((String)context.getPddContext().getObject("ID")));
        }
        if (outResponseHandlers != null) {
            for (int i = 0; i < outResponseHandlers.length; ++i) {
                try {
                    outResponseHandlers[i].invoke(context);
                    continue;
                }
                catch (Exception e) {
                    HandlerException ex = new HandlerException(e.getMessage(), e);
                    ex.setIdentitaHandler("OutResponseHandler[" + tipiOutResponseHandlers[i] + "]");
                    throw ex;
                }
            }
        }
    }

    public static void postOutResponse(PostOutResponseContext context, MsgDiagnostico msgDiag) {
        if (!initialize) {
            GestoreHandlers.initialize(msgDiag);
        }
        if (context.getDataElaborazioneMessaggio() == null) {
            context.setDataElaborazioneMessaggio(DateManager.getDate());
        }
        if (properties.generazioneDateCasualiLogAbilitato() && context.getPddContext().getObject("ID") != null) {
            context.setDataElaborazioneMessaggio(generatoreCasualeDati.getProssimaData((String)context.getPddContext().getObject("ID")));
        }
        if (postOutResponseHandlers != null) {
            for (int i = 0; i < postOutResponseHandlers.length; ++i) {
                try {
                    postOutResponseHandlers[i].invoke(context);
                    continue;
                }
                catch (Exception e) {
                    msgDiag.logErroreGenerico(e, "PostOutResponseHandler[" + tipiPostOutResponseHandlers[i] + "]");
                }
            }
        }
        GestoreHandlers.rilasciaRisorseDemoMode((String)context.getPddContext().getObject("ID"));
    }

    public static void integrationManagerRequest(IntegrationManagerRequestContext context, MsgDiagnostico msgDiag) throws HandlerException {
        if (!initialize) {
            GestoreHandlers.initialize(msgDiag);
        }
        if (properties.generazioneDateCasualiLogAbilitato() && context.getPddContext().getObject("ID") != null && context.getDataRichiestaOperazione() != null) {
            context.setDataRichiestaOperazione(generatoreCasualeDati.getProssimaData((String)context.getPddContext().getObject("ID")));
        }
        if (integrationManagerRequestHandlers != null) {
            for (int i = 0; i < integrationManagerRequestHandlers.length; ++i) {
                try {
                    integrationManagerRequestHandlers[i].invoke(context);
                    continue;
                }
                catch (Exception e) {
                    HandlerException ex = new HandlerException(e.getMessage(), e);
                    ex.setIdentitaHandler("IntegrationManagerRequestHandler[" + tipiIntegrationManagerRequestHandlers[i] + "]");
                    throw ex;
                }
            }
        }
    }

    public static void integrationManagerResponse(IntegrationManagerResponseContext context, MsgDiagnostico msgDiag) throws HandlerException {
        if (!initialize) {
            GestoreHandlers.initialize(msgDiag);
        }
        if (properties.generazioneDateCasualiLogAbilitato() && context.getPddContext().getObject("ID") != null) {
            if (context.getDataRichiestaOperazione() != null) {
                context.setDataRichiestaOperazione(generatoreCasualeDati.getProssimaData((String)context.getPddContext().getObject("ID")));
            }
            if (context.getDataCompletamentoOperazione() != null) {
                context.setDataCompletamentoOperazione(generatoreCasualeDati.getProssimaData((String)context.getPddContext().getObject("ID")));
            }
        }
        if (integrationManagerResponseHandlers != null) {
            for (int i = 0; i < integrationManagerResponseHandlers.length; ++i) {
                try {
                    integrationManagerResponseHandlers[i].invoke(context);
                    continue;
                }
                catch (Exception e) {
                    HandlerException ex = new HandlerException(e.getMessage(), e);
                    ex.setIdentitaHandler("IntegrationManagerResponseHandler[" + tipiIntegrationManagerResponseHandlers[i] + "]");
                    throw ex;
                }
            }
        }
        GestoreHandlers.rilasciaRisorseDemoMode((String)context.getPddContext().getObject("ID"));
    }

    private static void rilasciaRisorseDemoMode(String idCluster) {
        if (properties.generazioneDateCasualiLogAbilitato() && idCluster != null) {
            GeneratoreCasualeDate.getGeneratoreCasualeDate().releaseResource(idCluster);
        }
    }
}

