/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop.pdd.core.handlers;

import java.util.Date;
import java.util.Hashtable;
import org.apache.log4j.Logger;

public class GeneratoreCasualeDate {
    private static GeneratoreCasualeDate generatore = null;
    private static long SOGLIA_MS_MIN = 1L;
    private static long SOGLIA_MS_MAX = 20L;
    private Date intervalloInizio = null;
    private Date intervalloFine = null;
    private Hashtable<String, Date> dateGenerate = new Hashtable();

    public static synchronized void init(Date intervalloInizio, Date intervalloFine, Logger log) {
        if (generatore == null) {
            generatore = new GeneratoreCasualeDate(intervalloInizio, intervalloFine, log);
        }
    }

    public static GeneratoreCasualeDate getGeneratoreCasualeDate() {
        return generatore;
    }

    private static long getRandom(long inizio, long fine) {
        long value = inizio + Math.round(Math.random() * (double)(fine - inizio));
        return value;
    }

    public GeneratoreCasualeDate(Date intervalloInizio, Date intervalloFine, Logger log) {
        this.intervalloInizio = intervalloInizio;
        this.intervalloFine = intervalloFine;
        log.info((Object)("Generatore di date causauli dei log attivato con intervallo [" + this.intervalloInizio + "] - [" + this.intervalloFine + "]"));
    }

    private Date getNextDate(String idCluster) {
        Date nextDate = null;
        if (this.dateGenerate.containsKey(idCluster)) {
            Date data = this.dateGenerate.remove(idCluster);
            nextDate = new Date(data.getTime() + GeneratoreCasualeDate.getRandom(SOGLIA_MS_MIN, SOGLIA_MS_MAX));
        } else {
            nextDate = new Date(GeneratoreCasualeDate.getRandom(this.intervalloInizio.getTime(), this.intervalloFine.getTime()));
        }
        this.dateGenerate.put(idCluster, nextDate);
        return nextDate;
    }

    public Date getProssimaData(String idCluster) {
        return this.getNextDate(idCluster);
    }

    public void releaseResource(String idCluster) {
        this.dateGenerate.remove(idCluster);
    }
}

