/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop.pdd.core.connettori;

import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLConnection;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Properties;
import javax.xml.messaging.URLEndpoint;
import javax.xml.soap.MimeHeader;
import javax.xml.soap.SOAPException;
import javax.xml.soap.SOAPMessage;
import org.apache.axis.AxisProperties;
import org.apache.axis.Message;
import org.apache.axis.encoding.Base64;
import org.apache.axis.soap.SOAPConnectionImpl;
import org.apache.log4j.Logger;
import org.openspcoop.egov.Busta;
import org.openspcoop.pdd.core.autenticazione.Credenziali;
import org.openspcoop.pdd.core.connettori.ConnettoreBase;
import org.openspcoop.pdd.core.connettori.ConnettoreException;
import org.openspcoop.pdd.core.connettori.ConnettoreMsg;
import org.openspcoop.pdd.logger.OpenSPCoopLogger;
import org.openspcoop.utils.SoapUtils;

public class ConnettoreSAAJ
extends ConnettoreBase {
    private Logger log = null;
    private Message requestMsg;
    private Hashtable<String, String> properties;
    private Busta bustaSPCoop;
    private Properties propertiesTrasporto;
    private Properties propertiesUrlBased;
    private Credenziali credenziali;
    private String idEGovMessaggio;
    private boolean debug = false;
    private SOAPConnectionImpl connection = null;

    public boolean send(ConnettoreMsg request) {
        this.log = OpenSPCoopLogger.getLoggerOpenSPCoopCore();
        if (request == null) {
            this.errore = "Messaggio da consegnare is Null (ConnettoreMsg)";
            return false;
        }
        this.requestMsg = request.getRequestMessage();
        this.properties = request.getConnectorProperties();
        this.bustaSPCoop = request.getBusta();
        if (this.bustaSPCoop != null) {
            this.idEGovMessaggio = this.bustaSPCoop.getID();
        }
        this.propertiesTrasporto = request.getPropertiesTrasporto();
        this.propertiesUrlBased = request.getPropertiesUrlBased();
        this.credenziali = request.getCredenziali();
        if (this.requestMsg == null) {
            this.errore = "Messaggio da consegnare is Null (AxisMsg)";
            return false;
        }
        if (this.properties == null) {
            this.errore = "Proprieta' del connettore non definite";
        }
        if (this.properties.size() == 0) {
            this.errore = "Proprieta' del connettore non definite";
        }
        if (this.properties.get("location") == null) {
            this.errore = "Proprieta' 'location' non fornita e richiesta da questo tipo di connettore [" + request.getTipoConnettore() + "]";
            return false;
        }
        if (this.properties.get("debug") != null && "true".equalsIgnoreCase(this.properties.get("debug").trim())) {
            this.debug = true;
        }
        return this.sendSAAJ();
    }

    private boolean sendSAAJ() {
        try {
            if (this.debug) {
                this.log.debug((Object)("[" + this.idEGovMessaggio + "] impostazione timeout..."));
            }
            int connectionTimeout = -1;
            int readConnectionTimeout = -1;
            if (this.properties.get("connection-timeout") != null) {
                try {
                    connectionTimeout = Integer.parseInt(this.properties.get("connection-timeout"));
                }
                catch (Exception e) {
                    this.log.error((Object)"Parametro connection-timeout errato", (Throwable)e);
                }
            }
            if (connectionTimeout == -1) {
                connectionTimeout = 10000;
            }
            if (this.properties.get("read-connection-timeout") != null) {
                try {
                    readConnectionTimeout = Integer.parseInt(this.properties.get("read-connection-timeout"));
                }
                catch (Exception e) {
                    this.log.error((Object)"Parametro read-connection-timeout errato", (Throwable)e);
                }
            }
            if (readConnectionTimeout == -1) {
                readConnectionTimeout = 120000;
            }
            if (this.debug) {
                this.log.debug((Object)("[" + this.idEGovMessaggio + "] impostazione http timeout CT[" + connectionTimeout + "] RT[" + readConnectionTimeout + "]..."));
            }
            if (this.debug) {
                this.log.debug((Object)("[" + this.idEGovMessaggio + "] check validita URL..."));
            }
            this.location = this.properties.get("location");
            URL urlTest = new URL(this.location);
            URLConnection connectionTest = urlTest.openConnection();
            HttpURLConnection httpConnTest = (HttpURLConnection)connectionTest;
            httpConnTest.setRequestMethod("POST");
            httpConnTest.setConnectTimeout(connectionTimeout);
            httpConnTest.setReadTimeout(readConnectionTimeout);
            httpConnTest.setDoOutput(true);
            OutputStream outTest = httpConnTest.getOutputStream();
            outTest.close();
            httpConnTest.disconnect();
            if (this.debug) {
                this.log.debug((Object)("[" + this.idEGovMessaggio + "] prefixOptimization..."));
            }
            String prefixOptimization = "true";
            if (this.properties.get("prefix-optimization") != null) {
                if ("false".equalsIgnoreCase(this.properties.get("prefix-optimization"))) {
                    prefixOptimization = "false";
                }
                this.log.info((Object)("Prefix Optimization = '" + prefixOptimization + "'"));
                AxisProperties.setProperty((String)"enableNamespacePrefixOptimization", (String)prefixOptimization);
            }
            if (this.debug) {
                this.log.debug((Object)("[" + this.idEGovMessaggio + "] creazione connessione..."));
            }
            SOAPConnectionImpl connection = new SOAPConnectionImpl();
            if (this.debug) {
                this.log.debug((Object)("[" + this.idEGovMessaggio + "] creazione URL..."));
            }
            StringBuffer urlBuilder = new StringBuffer();
            urlBuilder.append(this.location);
            if (this.propertiesUrlBased != null && this.propertiesUrlBased.size() > 0) {
                Enumeration<Object> enumSPC = this.propertiesUrlBased.keys();
                while (enumSPC.hasMoreElements()) {
                    if (!urlBuilder.toString().contains("?")) {
                        urlBuilder.append("?");
                    } else {
                        urlBuilder.append("&");
                    }
                    String key = (String)enumSPC.nextElement();
                    String value = (String)this.propertiesUrlBased.get(key);
                    urlBuilder.append(key);
                    urlBuilder.append("=");
                    urlBuilder.append(value);
                }
            }
            URLEndpoint urlConnection = new URLEndpoint(urlBuilder.toString());
            try {
                if (this.requestMsg.getMimeHeaders() != null) {
                    if (this.debug) {
                        this.log.debug((Object)("[" + this.idEGovMessaggio + "] impostazione header di trasporto..."));
                    }
                    if (this.propertiesTrasporto != null) {
                        Enumeration<Object> enumSPC = this.propertiesTrasporto.keys();
                        while (enumSPC.hasMoreElements()) {
                            String key = (String)enumSPC.nextElement();
                            if ("User-Agent".equalsIgnoreCase(key)) continue;
                            String value = (String)this.propertiesTrasporto.get(key);
                            if (this.debug) {
                                this.log.debug((Object)("[" + this.idEGovMessaggio + "] set proprieta' [" + key + "]=[" + value + "]..."));
                            }
                            this.requestMsg.getMimeHeaders().addHeader(key, value);
                        }
                    }
                    if (this.debug) {
                        this.log.debug((Object)("[" + this.idEGovMessaggio + "] impostazione autenticazione..."));
                    }
                    String user = null;
                    String password = null;
                    if (this.credenziali != null) {
                        user = this.credenziali.getUsername();
                        password = this.credenziali.getPassword();
                    } else {
                        user = this.properties.get("user");
                        password = this.properties.get("password");
                    }
                    if (user != null && password != null) {
                        String authentication = user + ":" + password;
                        authentication = "Basic " + Base64.encode((byte[])authentication.getBytes());
                        this.requestMsg.getMimeHeaders().addHeader("Authorization", authentication);
                        if (this.debug) {
                            this.log.debug((Object)("[" + this.idEGovMessaggio + "] impostazione autenticazione (username:" + user + " password:" + password + ") [" + authentication + "]..."));
                        }
                    }
                }
                if (this.debug) {
                    this.log.debug((Object)("[" + this.idEGovMessaggio + "] set timeout..."));
                }
                connection.setTimeout(Integer.valueOf(readConnectionTimeout));
                if (this.debug) {
                    this.log.debug((Object)("[" + this.idEGovMessaggio + "] send..."));
                }
                this.responseMsg = (Message)connection.call((SOAPMessage)this.requestMsg, (Object)urlConnection);
            }
            catch (SOAPException sendError) {
                this.eccezioneProcessamento = sendError;
                String errorMsg = sendError.getMessage();
                connection.close();
                this.errore = "Errore avvenuto durante la consegna SOAP (lettura risposta): " + errorMsg;
                return false;
            }
            if (this.debug) {
                this.log.debug((Object)("[" + this.idEGovMessaggio + "] check consistenza..."));
            }
            if (this.responseMsg != null && this.responseMsg.getSOAPBody() != null && this.responseMsg.getSOAPBody().hasFault() && this.responseMsg.getSOAPBody().getFault().getFaultString().indexOf("Premature end of file") != -1) {
                this.responseMsg = null;
            }
            if (this.responseMsg != null && this.responseMsg.getMimeHeaders() != null) {
                if (this.propertiesTrasportoRisposta == null) {
                    this.propertiesTrasportoRisposta = new Properties();
                }
                Iterator it = this.responseMsg.getMimeHeaders().getAllHeaders();
                while (it.hasNext()) {
                    MimeHeader mh = (MimeHeader)it.next();
                    this.propertiesTrasportoRisposta.put(mh.getName(), mh.getValue());
                    if (!"content-length".equalsIgnoreCase(mh.getName())) continue;
                    try {
                        this.contentLength = Integer.parseInt(mh.getValue());
                    }
                    catch (Exception e) {}
                }
            }
            this.codice = 200;
            if (this.responseMsg != null && this.contentLength < 0L) {
                this.contentLength = SoapUtils.getLength((Message)this.responseMsg, (boolean)true);
            }
            if (this.debug) {
                this.log.debug((Object)("[" + this.idEGovMessaggio + "] gestione invio/risposta http effettuata con successo"));
            }
            return true;
        }
        catch (Exception e) {
            this.eccezioneProcessamento = e;
            this.errore = "Errore avvenuto durante la consegna SOAP: " + e.getMessage();
            return false;
        }
    }

    public void disconnect() throws ConnettoreException {
        try {
            if (this.connection != null) {
                if (this.debug && this.log != null) {
                    this.log.debug((Object)("[" + this.idEGovMessaggio + "] connection.close ..."));
                }
                this.connection.close();
            }
        }
        catch (Exception e) {
            throw new ConnettoreException("Chiusura connessione non riuscita: " + e.getMessage(), e);
        }
    }
}

