/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop.pdd.core.connettori;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLConnection;
import java.security.KeyStore;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.KeyManager;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import javax.xml.soap.SOAPBody;
import org.apache.axis.Message;
import org.apache.axis.encoding.Base64;
import org.apache.axis.soap.SOAP11Constants;
import org.apache.axis.soap.SOAPConstants;
import org.apache.log4j.Logger;
import org.openspcoop.dao.commons.TransferLengthModes;
import org.openspcoop.egov.Busta;
import org.openspcoop.pdd.config.MailcapActivationReader;
import org.openspcoop.pdd.config.OpenSPCoopProperties;
import org.openspcoop.pdd.core.autenticazione.Credenziali;
import org.openspcoop.pdd.core.connettori.ConnettoreBase;
import org.openspcoop.pdd.core.connettori.ConnettoreException;
import org.openspcoop.pdd.core.connettori.ConnettoreHTTPSHostNameVerifierDisabled;
import org.openspcoop.pdd.core.connettori.ConnettoreHTTPSProperties;
import org.openspcoop.pdd.core.connettori.ConnettoreMsg;
import org.openspcoop.pdd.logger.OpenSPCoopLogger;
import org.openspcoop.utils.Loader;
import org.openspcoop.utils.SoapUtils;
import org.openspcoop.utils.UtilsException;

public class ConnettoreHTTP
extends ConnettoreBase {
    public static final int HTTP_CONNECTION_TIMEOUT = 10000;
    public static final int HTTP_READ_CONNECTION_TIMEOUT = 120000;
    public ByteArrayOutputStream outByte = new ByteArrayOutputStream();
    private Message requestMsg;
    private Hashtable<String, String> properties;
    private boolean sbustamentoSoap;
    private Properties propertiesTrasporto;
    private Properties propertiesUrlBased;
    private Credenziali credenziali;
    private Busta bustaSPCoop;
    private boolean debug = false;
    private OpenSPCoopProperties openspcoopProperties = null;
    private String idEGovMessaggio;
    private Logger log = null;
    private Loader loader = null;
    private String idModulo = null;
    private boolean https = false;
    private ConnettoreHTTPSProperties sslContextProperties;
    private InputStream is = null;
    private HttpURLConnection httpConn = null;

    public ConnettoreHTTP() {
        this.https = false;
    }

    public ConnettoreHTTP(boolean https) {
        this.https = https;
    }

    public boolean send(ConnettoreMsg request) {
        this.log = OpenSPCoopLogger.getLoggerOpenSPCoopCore();
        this.openspcoopProperties = OpenSPCoopProperties.getInstance();
        this.loader = Loader.getInstance();
        if (request == null) {
            this.errore = "Messaggio da consegnare is Null (ConnettoreMsg)";
            return false;
        }
        this.requestMsg = request.getRequestMessage();
        this.properties = request.getConnectorProperties();
        this.sbustamentoSoap = request.getSbustamentoSOAP();
        this.propertiesTrasporto = request.getPropertiesTrasporto();
        this.propertiesUrlBased = request.getPropertiesUrlBased();
        this.bustaSPCoop = request.getBusta();
        if (this.bustaSPCoop != null) {
            this.idEGovMessaggio = this.bustaSPCoop.getID();
        }
        this.credenziali = request.getCredenziali();
        if (this.requestMsg == null) {
            this.errore = "Messaggio da consegnare is Null (AxisMsg)";
            return false;
        }
        if (this.properties == null) {
            this.errore = "Proprieta' del connettore non definite";
        }
        if (this.properties.size() == 0) {
            this.errore = "Proprieta' del connettore non definite";
        }
        if (this.properties.get("location") == null) {
            this.errore = "Proprieta' 'location' non fornita e richiesta da questo tipo di connettore [" + request.getTipoConnettore() + "]";
            return false;
        }
        if (this.properties.get("debug") != null && "true".equalsIgnoreCase(this.properties.get("debug").trim())) {
            this.debug = true;
        }
        if (this.https) {
            try {
                this.sslContextProperties = ConnettoreHTTPSProperties.readProperties(this.properties);
            }
            catch (Exception e) {
                this.errore = "[HTTPS error]" + e.getMessage();
                return false;
            }
        }
        this.idModulo = request.getIdModulo();
        return this.sendHTTP();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean sendHTTP() {
        FileInputStream finKeyStore = null;
        FileInputStream finTrustStore = null;
        try {
            int resultHTTPOperation;
            block142: {
                String mimeTypeAttachment;
                String locationRisposta;
                String tipoRisposta;
                Map<String, List<String>> mapHeaderHttpResponse;
                SSLContext sslContext = null;
                if (this.https) {
                    if (this.debug) {
                        this.log.debug((Object)"Creo contesto ssl...");
                    }
                    KeyManager[] km = null;
                    TrustManager[] tm = null;
                    if (this.sslContextProperties.getKeyStoreLocation() != null) {
                        if (this.debug) {
                            this.log.debug((Object)"Gestione keystore...");
                        }
                        KeyStore keystore = KeyStore.getInstance(this.sslContextProperties.getKeyStoreType());
                        finKeyStore = new FileInputStream(this.sslContextProperties.getKeyStoreLocation());
                        keystore.load(finKeyStore, this.sslContextProperties.getKeyStorePassword().toCharArray());
                        KeyManagerFactory keyManagerFactory = KeyManagerFactory.getInstance(this.sslContextProperties.getKeyManagementAlgorithm());
                        keyManagerFactory.init(keystore, this.sslContextProperties.getKeyPassword().toCharArray());
                        km = keyManagerFactory.getKeyManagers();
                        if (this.debug) {
                            this.log.debug((Object)"Gestione keystore effettuata");
                        }
                    }
                    if (this.sslContextProperties.getTrustStoreLocation() != null) {
                        if (this.debug) {
                            this.log.debug((Object)"Gestione truststore...");
                        }
                        KeyStore truststore = KeyStore.getInstance(this.sslContextProperties.getTrustStoreType());
                        finTrustStore = new FileInputStream(this.sslContextProperties.getTrustStoreLocation());
                        truststore.load(finTrustStore, this.sslContextProperties.getTrustStorePassword().toCharArray());
                        TrustManagerFactory trustManagerFactory = TrustManagerFactory.getInstance(this.sslContextProperties.getTrustManagementAlgorithm());
                        trustManagerFactory.init(truststore);
                        tm = trustManagerFactory.getTrustManagers();
                        if (this.debug) {
                            this.log.debug((Object)"Gestione truststore effettuata");
                        }
                    }
                    sslContext = SSLContext.getInstance(this.sslContextProperties.getSslType());
                    sslContext.init(km, tm, null);
                }
                if (this.debug) {
                    this.log.debug((Object)("[" + this.idEGovMessaggio + "] creazione URL..."));
                }
                StringBuffer urlBuilder = new StringBuffer();
                this.location = this.properties.get("location");
                urlBuilder.append(this.location);
                if (this.propertiesUrlBased != null && this.propertiesUrlBased.size() > 0) {
                    Enumeration<Object> enumSPC = this.propertiesUrlBased.keys();
                    while (enumSPC.hasMoreElements()) {
                        if (!urlBuilder.toString().contains("?")) {
                            urlBuilder.append("?");
                        } else {
                            urlBuilder.append("&");
                        }
                        String key = (String)enumSPC.nextElement();
                        String value = (String)this.propertiesUrlBased.get(key);
                        urlBuilder.append(key);
                        urlBuilder.append("=");
                        urlBuilder.append(value);
                    }
                }
                if (this.debug) {
                    this.log.debug((Object)("[" + this.idEGovMessaggio + "] creazione URL [" + urlBuilder.toString() + "]..."));
                }
                URL url = new URL(urlBuilder.toString());
                if (this.debug) {
                    this.log.debug((Object)("[" + this.idEGovMessaggio + "] creazione connessione alla URL [" + urlBuilder.toString() + "]..."));
                }
                URLConnection connection = url.openConnection();
                this.httpConn = (HttpURLConnection)connection;
                if (this.https) {
                    HttpsURLConnection httpsConn = (HttpsURLConnection)this.httpConn;
                    httpsConn.setSSLSocketFactory(sslContext.getSocketFactory());
                    if (this.sslContextProperties.isHostnameVerifier()) {
                        if (this.sslContextProperties.getClassNameHostnameVerifier() != null) {
                            this.log.debug((Object)("[" + this.idEGovMessaggio + "] HostNamve verifier enabled [" + this.sslContextProperties.getClassNameHostnameVerifier() + "]"));
                            HostnameVerifier verifica = (HostnameVerifier)this.loader.newInstance(this.sslContextProperties.getClassNameHostnameVerifier());
                            httpsConn.setHostnameVerifier(verifica);
                        } else {
                            this.log.debug((Object)("[" + this.idEGovMessaggio + "] HostNamve verifier enabled"));
                        }
                    } else {
                        this.log.debug((Object)("[" + this.idEGovMessaggio + "] HostNamve verifier disabled"));
                        ConnettoreHTTPSHostNameVerifierDisabled disabilitato = new ConnettoreHTTPSHostNameVerifierDisabled(this.log);
                        httpsConn.setHostnameVerifier(disabilitato);
                    }
                }
                if (this.debug) {
                    this.log.debug((Object)("[" + this.idEGovMessaggio + "] impostazione content type..."));
                }
                String contentTypeRichiesta = null;
                contentTypeRichiesta = this.sbustamentoSoap && this.requestMsg.countAttachments() > 0 && SoapUtils.isTunnelOpenSPCoopSoap((SOAPBody)this.requestMsg.getSOAPBody()) ? SoapUtils.getContentTypeTunnelOpenSPCoopSoap((SOAPBody)this.requestMsg.getSOAPBody()) : this.requestMsg.getContentType((SOAPConstants)new SOAP11Constants());
                if (this.debug) {
                    this.log.debug((Object)("[" + this.idEGovMessaggio + "] impostazione http content type [" + contentTypeRichiesta + "]..."));
                }
                this.httpConn.setRequestProperty("Content-Type", contentTypeRichiesta);
                if (this.debug) {
                    this.log.debug((Object)("[" + this.idEGovMessaggio + "] impostazione transfer-length..."));
                }
                boolean transferEncodingChunked = false;
                TransferLengthModes tlm = null;
                int chunkLength = -1;
                if ("ConsegnaContenutiApplicativi".equals(this.idModulo)) {
                    tlm = this.openspcoopProperties.getTransferLengthModes_consegnaContenutiApplicativi();
                    chunkLength = this.openspcoopProperties.getChunkLength_consegnaContenutiApplicativi();
                } else {
                    tlm = this.openspcoopProperties.getTransferLengthModes_inoltroBusteEGov();
                    chunkLength = this.openspcoopProperties.getChunkLength_inoltroBusteEGov();
                }
                transferEncodingChunked = TransferLengthModes.TRANSFER_ENCODING_CHUNKED.equals(tlm);
                if (transferEncodingChunked) {
                    this.httpConn.setChunkedStreamingMode(chunkLength);
                }
                if (this.debug) {
                    this.log.debug((Object)("[" + this.idEGovMessaggio + "] impostazione transfer-length effettuata (chunkLength:" + chunkLength + "): " + tlm));
                }
                if (this.debug) {
                    this.log.debug((Object)("[" + this.idEGovMessaggio + "] impostazione timeout..."));
                }
                int connectionTimeout = -1;
                int readConnectionTimeout = -1;
                if (this.properties.get("connection-timeout") != null) {
                    try {
                        connectionTimeout = Integer.parseInt(this.properties.get("connection-timeout"));
                    }
                    catch (Exception e) {
                        this.log.error((Object)"Parametro connection-timeout errato", (Throwable)e);
                    }
                }
                if (connectionTimeout == -1) {
                    connectionTimeout = 10000;
                }
                if (this.properties.get("read-connection-timeout") != null) {
                    try {
                        readConnectionTimeout = Integer.parseInt(this.properties.get("read-connection-timeout"));
                    }
                    catch (Exception e) {
                        this.log.error((Object)"Parametro read-connection-timeout errato", (Throwable)e);
                    }
                }
                if (readConnectionTimeout == -1) {
                    readConnectionTimeout = 120000;
                }
                if (this.debug) {
                    this.log.debug((Object)("[" + this.idEGovMessaggio + "] impostazione http timeout CT[" + connectionTimeout + "] RT[" + readConnectionTimeout + "]..."));
                }
                this.httpConn.setConnectTimeout(connectionTimeout);
                this.httpConn.setReadTimeout(readConnectionTimeout);
                this.httpConn.setInstanceFollowRedirects(true);
                if (this.debug) {
                    this.log.debug((Object)("[" + this.idEGovMessaggio + "] impostazione soap action..."));
                }
                String soapAction = null;
                if (!this.sbustamentoSoap) {
                    soapAction = (String)this.requestMsg.getProperty("SOAPAction");
                    if (soapAction == null) {
                        soapAction = "\"OpenSPCoop\"";
                    }
                    this.httpConn.setRequestProperty("SOAPAction", soapAction);
                    if (this.debug) {
                        this.log.debug((Object)("[" + this.idEGovMessaggio + "] SOAP Action inviata [" + soapAction + "]"));
                    }
                }
                if (this.debug) {
                    this.log.debug((Object)("[" + this.idEGovMessaggio + "] impostazione autenticazione..."));
                }
                String user = null;
                String password = null;
                if (this.credenziali != null) {
                    user = this.credenziali.getUsername();
                    password = this.credenziali.getPassword();
                } else {
                    user = this.properties.get("user");
                    password = this.properties.get("password");
                }
                if (user != null && password != null) {
                    String authentication = user + ":" + password;
                    authentication = "Basic " + Base64.encode((byte[])authentication.getBytes());
                    this.httpConn.setRequestProperty("Authorization", authentication);
                    if (this.debug) {
                        this.log.debug((Object)("[" + this.idEGovMessaggio + "] impostazione autenticazione (username:" + user + " password:" + password + ") [" + authentication + "]..."));
                    }
                }
                if (this.debug) {
                    this.log.debug((Object)("[" + this.idEGovMessaggio + "] impostazione header di trasporto..."));
                }
                if (this.propertiesTrasporto != null) {
                    Enumeration<Object> enumSPC = this.propertiesTrasporto.keys();
                    while (enumSPC.hasMoreElements()) {
                        String key = (String)enumSPC.nextElement();
                        String value = (String)this.propertiesTrasporto.get(key);
                        if (this.debug) {
                            this.log.debug((Object)("[" + this.idEGovMessaggio + "] set proprieta' [" + key + "]=[" + value + "]..."));
                        }
                        this.httpConn.setRequestProperty(key, value);
                    }
                }
                if (this.debug) {
                    this.log.debug((Object)("[" + this.idEGovMessaggio + "] impostazione POST..."));
                }
                this.httpConn.setRequestMethod("POST");
                this.httpConn.setDoOutput(true);
                this.httpConn.setDoInput(true);
                if (this.debug) {
                    this.log.debug((Object)("[" + this.idEGovMessaggio + "] spedizione byte..."));
                }
                OutputStream out = this.httpConn.getOutputStream();
                if (this.debug) {
                    ByteArrayOutputStream bout = new ByteArrayOutputStream();
                    if (this.sbustamentoSoap) {
                        this.log.debug((Object)("[" + this.idEGovMessaggio + "] Sbustamento..."));
                        SoapUtils.sbustamentoMessaggio((Message)this.requestMsg, (OutputStream)bout);
                    } else {
                        this.requestMsg.writeTo((OutputStream)bout);
                    }
                    bout.flush();
                    bout.close();
                    out.write(bout.toByteArray());
                    this.log.debug((Object)("[" + this.idEGovMessaggio + "] Messaggio inviato (ContentType:" + contentTypeRichiesta + ") :\n" + bout.toString()));
                    bout.close();
                } else if (this.sbustamentoSoap) {
                    if (this.debug) {
                        this.log.debug((Object)("[" + this.idEGovMessaggio + "] Sbustamento..."));
                    }
                    SoapUtils.sbustamentoMessaggio((Message)this.requestMsg, (OutputStream)out);
                } else {
                    this.requestMsg.writeTo(out);
                }
                out.close();
                if (this.debug) {
                    this.log.debug((Object)("[" + this.idEGovMessaggio + "] Analisi risposta..."));
                }
                if ((mapHeaderHttpResponse = this.httpConn.getHeaderFields()) != null && mapHeaderHttpResponse.size() > 0) {
                    if (this.propertiesTrasportoRisposta == null) {
                        this.propertiesTrasportoRisposta = new Properties();
                    }
                    for (String keyHttpResponse : mapHeaderHttpResponse.keySet()) {
                        List<String> valueHttpResponse = mapHeaderHttpResponse.get(keyHttpResponse);
                        StringBuffer bfHttpResponse = new StringBuffer();
                        for (int i = 0; i < valueHttpResponse.size(); ++i) {
                            if (i > 0) {
                                bfHttpResponse.append(",");
                            }
                            bfHttpResponse.append(valueHttpResponse.get(i));
                        }
                        if (keyHttpResponse == null) {
                            keyHttpResponse = "ReturnCode";
                        }
                        this.propertiesTrasportoRisposta.put(keyHttpResponse, bfHttpResponse.toString());
                    }
                }
                if ((tipoRisposta = this.httpConn.getHeaderField("Content-Type")) == null) {
                    tipoRisposta = this.httpConn.getHeaderField("Content-Type".toLowerCase());
                }
                if (tipoRisposta == null) {
                    tipoRisposta = this.httpConn.getHeaderField("Content-Type".toUpperCase());
                }
                if ((locationRisposta = this.httpConn.getHeaderField("Content-Location")) == null) {
                    locationRisposta = this.httpConn.getHeaderField("Content-Location".toLowerCase());
                }
                if (locationRisposta == null) {
                    locationRisposta = this.httpConn.getHeaderField("Content-Location".toUpperCase());
                }
                if (this.httpConn.getContentLength() > 0) {
                    this.contentLength = this.httpConn.getContentLength();
                }
                boolean imbustamentoConAttachment = false;
                if ("true".equals(this.httpConn.getHeaderField(this.openspcoopProperties.getTunnelSOAPKeyWord_headerTrasporto()))) {
                    imbustamentoConAttachment = true;
                }
                if ((mimeTypeAttachment = this.httpConn.getHeaderField(this.openspcoopProperties.getTunnelSOAPKeyWordMimeType_headerTrasporto())) == null) {
                    mimeTypeAttachment = "application/openspcoop";
                }
                if (this.debug) {
                    this.log.debug((Object)("[" + this.idEGovMessaggio + "] Analisi risposta input stream e risultato http..."));
                }
                this.is = (resultHTTPOperation = this.httpConn.getResponseCode()) < 300 ? this.httpConn.getInputStream() : this.httpConn.getErrorStream();
                if (this.is != null && resultHTTPOperation != 202) {
                    block141: {
                        String tipoLetturaRisposta = null;
                        try {
                            int readByte;
                            byte[] readB;
                            if (this.debug) {
                                ByteArrayOutputStream bout = new ByteArrayOutputStream();
                                readB = new byte[65536];
                                readByte = 0;
                                while ((readByte = this.is.read(readB)) != -1) {
                                    bout.write(readB, 0, readByte);
                                }
                                this.is.close();
                                bout.flush();
                                bout.close();
                                this.log.debug((Object)("[" + this.idEGovMessaggio + "] Messaggio ricevuto (ContentType:" + tipoRisposta + ") :\n" + bout.toString()));
                                this.is = new ByteArrayInputStream(bout.toByteArray());
                            }
                            if (!this.sbustamentoSoap) {
                                if (this.debug) {
                                    this.log.debug((Object)("[" + this.idEGovMessaggio + "] Ricostruzione normale..."));
                                }
                                tipoLetturaRisposta = "Costruzione messaggio SOAP";
                                this.responseMsg = new Message((Object)this.is, false, tipoRisposta, locationRisposta);
                                break block141;
                            }
                            if (imbustamentoConAttachment) {
                                if (this.debug) {
                                    this.log.debug((Object)("[" + this.idEGovMessaggio + "] Imbustamento con attachments..."));
                                }
                                tipoLetturaRisposta = "Costruzione messaggio SOAP per Tunnel con mimeType " + mimeTypeAttachment;
                                try {
                                    this.responseMsg = SoapUtils.imbustamentoMessaggioConAttachment((InputStream)this.is, (String)mimeTypeAttachment, (boolean)MailcapActivationReader.existsDataContentHandler(mimeTypeAttachment), (String)tipoRisposta);
                                    break block141;
                                }
                                catch (UtilsException e) {
                                    if (e.getMessage() == null || !e.getMessage().equals("Contenuto da imbustare non presente")) {
                                        throw e;
                                    }
                                    break block141;
                                }
                            }
                            if (tipoRisposta != null && tipoRisposta.contains("multipart/related")) {
                                if (this.debug) {
                                    this.log.debug((Object)("[" + this.idEGovMessaggio + "] Imbustamento messaggio multipart/related..."));
                                }
                                tipoLetturaRisposta = "Imbustamento messaggio multipart/related in un SOAP WithAttachments";
                                ByteArrayOutputStream byteBuffer = new ByteArrayOutputStream();
                                readB = new byte[65536];
                                readByte = 0;
                                while ((readByte = this.is.read(readB)) != -1) {
                                    byteBuffer.write(readB, 0, readByte);
                                }
                                if (byteBuffer.size() > 0) {
                                    this.responseMsg = SoapUtils.imbustamentoMessaggio((byte[])byteBuffer.toByteArray(), (boolean)this.openspcoopProperties.isDeleteInstructionTargetMachineXml());
                                }
                            } else {
                                if (this.debug) {
                                    this.log.debug((Object)("[" + this.idEGovMessaggio + "] Imbustamento messaggio..."));
                                }
                                tipoLetturaRisposta = "Imbustamento messaggio xml in un messaggio SOAP";
                                this.responseMsg = new Message((Object)this.is, true, tipoRisposta, locationRisposta);
                            }
                        }
                        catch (Exception e) {
                            this.eccezioneProcessamento = e;
                            this.errore = "Errore avvenuto durante la consegna HTTP (" + tipoLetturaRisposta + "): " + e.getMessage();
                            this.log.error((Object)("Errore avvenuto durante la consegna HTTP (" + tipoLetturaRisposta + ")"), (Throwable)e);
                            boolean readB = false;
                            try {
                                if (finKeyStore != null) {
                                    finKeyStore.close();
                                }
                            }
                            catch (Exception e2) {
                                // empty catch block
                            }
                            try {
                                if (finTrustStore != null) {
                                    finTrustStore.close();
                                }
                            }
                            catch (Exception e3) {
                                // empty catch block
                            }
                            return readB;
                        }
                    }
                    if (this.debug) {
                        this.log.debug((Object)("[" + this.idEGovMessaggio + "] save messaggio..."));
                    }
                    try {
                        if (this.responseMsg != null && this.responseMsg.countAttachments() == 0) {
                            this.responseMsg.getSOAPPartAsBytes();
                        }
                    }
                    catch (Exception e) {
                        this.eccezioneProcessamento = e;
                        this.errore = "Errore avvenuto durante la consegna HTTP (salvataggio risposta): " + e.getMessage();
                        boolean readB = false;
                        try {
                            if (finKeyStore != null) {
                                finKeyStore.close();
                            }
                        }
                        catch (Exception e4) {
                            // empty catch block
                        }
                        try {
                            if (finTrustStore != null) {
                                finTrustStore.close();
                            }
                        }
                        catch (Exception e5) {
                            // empty catch block
                        }
                        return readB;
                    }
                    if (this.debug) {
                        this.log.debug((Object)("[" + this.idEGovMessaggio + "] check consistenza messaggio..."));
                    }
                    try {
                        this.responseMsg.getSOAPEnvelope().getAsString();
                    }
                    catch (Exception e) {
                        boolean premature;
                        this.responseMsg = null;
                        boolean result2XX = resultHTTPOperation >= 200 && resultHTTPOperation <= 299;
                        boolean bl = premature = e.getMessage() != null && e.getMessage().indexOf("Premature end of file") != -1 && result2XX;
                        if (premature || !result2XX) break block142;
                        this.eccezioneProcessamento = e;
                        this.errore = "Errore avvenuto durante la consegna HTTP (lettura risposta): " + e.getMessage();
                        boolean bl2 = false;
                        try {
                            if (finKeyStore != null) {
                                finKeyStore.close();
                            }
                        }
                        catch (Exception e6) {
                            // empty catch block
                        }
                        try {
                            if (finTrustStore != null) {
                                finTrustStore.close();
                            }
                        }
                        catch (Exception e7) {
                            // empty catch block
                        }
                        return bl2;
                    }
                }
            }
            this.codice = resultHTTPOperation;
            if (this.debug) {
                this.log.debug((Object)("[" + this.idEGovMessaggio + "] gestione invio/risposta http effettuata con successo"));
            }
            boolean bl = true;
            return bl;
        }
        catch (Exception e) {
            this.eccezioneProcessamento = e;
            if (this.debug) {
                this.log.debug((Object)("[" + this.idEGovMessaggio + "] Errore avvenuto durante la consegna HTTP: " + e.getMessage()), (Throwable)e);
            }
            this.errore = "Errore avvenuto durante la consegna HTTP: " + e.getMessage();
            boolean bl = false;
            return bl;
        }
        finally {
            try {
                if (finKeyStore != null) {
                    finKeyStore.close();
                }
            }
            catch (Exception e) {}
            try {
                if (finTrustStore != null) {
                    finTrustStore.close();
                }
            }
            catch (Exception e) {}
        }
    }

    public void disconnect() throws ConnettoreException {
        try {
            if (this.is != null) {
                if (this.debug && this.log != null) {
                    this.log.debug((Object)("[" + this.idEGovMessaggio + "] chiusura socket..."));
                }
                this.is.close();
            }
            if (this.httpConn != null) {
                if (this.debug && this.log != null) {
                    this.log.debug((Object)("[" + this.idEGovMessaggio + "] chiusura connessione..."));
                }
                this.httpConn.disconnect();
            }
        }
        catch (Exception e) {
            throw new ConnettoreException("Chiusura connessione non riuscita: " + e.getMessage(), e);
        }
    }
}

