/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop.pdd.core.connettori;

import java.io.File;
import java.io.FileInputStream;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Hashtable;
import org.apache.axis.Message;
import org.openspcoop.egov.Imbustamento;
import org.openspcoop.pdd.core.connettori.ConnettoreBase;
import org.openspcoop.pdd.core.connettori.ConnettoreMsg;
import org.openspcoop.pdd.services.ServletUtils;
import org.openspcoop.utils.FileSystemUtilities;

public class ConnettoreFileEcho
extends ConnettoreBase {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean send(ConnettoreMsg request) {
        FileInputStream fin = null;
        File tmp = null;
        try {
            Hashtable<String, String> properties = request.getConnectorProperties();
            if (properties == null) {
                this.errore = "Proprieta' del connettore non definite";
            }
            if (properties.size() == 0) {
                this.errore = "Proprieta' del connettore non definite";
            }
            request.setRequestMessage(null);
            String filePath = properties.get("location");
            if (filePath == null) {
                this.errore = "Proprieta' 'location' non fornita e richiesta da questo tipo di connettore [" + request.getTipoConnettore() + "]";
                boolean bl = false;
                return bl;
            }
            File f = new File(filePath = filePath.trim());
            if (!f.exists()) {
                this.errore = "File fornito [" + f.getAbsolutePath() + "] non esiste, richiesto da questo tipo di connettore [" + request.getTipoConnettore() + "]";
                boolean e = false;
                return e;
            }
            if (!f.canRead()) {
                this.errore = "File fornito [" + f.getAbsolutePath() + "] non accessibile in lettura, richiesto da questo tipo di connettore [" + request.getTipoConnettore() + "]";
                boolean e = false;
                return e;
            }
            String isTemplace = properties.get("template-busta");
            if ("true".equals(isTemplace)) {
                String mittente = properties.get("mittente");
                if (mittente == null) {
                    this.errore = "Richiesta funzionalita' di generazione busta senza pero' fornire il mittente";
                    boolean bl = false;
                    return bl;
                }
                String destinatario = properties.get("destinatario");
                if (destinatario == null) {
                    this.errore = "Richiesta funzionalita' di generazione busta senza pero' fornire il destinatario";
                    boolean e = false;
                    return e;
                }
                String servizio = properties.get("servizio");
                if (servizio == null) {
                    this.errore = "Richiesta funzionalita' di generazione busta senza pero' fornire il servizio";
                    boolean e = false;
                    return e;
                }
                String azione = properties.get("azione");
                if (azione == null) {
                    this.errore = "Richiesta funzionalita' di generazione busta senza pero' fornire l'azione";
                    boolean e = false;
                    return e;
                }
                String profilo = properties.get("profilo");
                if (profilo == null) {
                    this.errore = "Richiesta funzionalita' di generazione busta senza pero' fornire il profilo";
                    boolean e = false;
                    return e;
                }
                tmp = File.createTempFile("ConnettoreFileSystem", ".openspcoop");
                Imbustamento imbustatore = new Imbustamento();
                String idEGOVRisposta = null;
                idEGOVRisposta = imbustatore.buildID_eGov(destinatario + "SPCoopIT", destinatario);
                SimpleDateFormat dateformat = new SimpleDateFormat("yyyy-MM-dd_HH:mm:ss.SSS");
                String gdo = dateformat.format(new Date()).replace('_', 'T');
                String[] keywords = new String[]{"@MITTENTE@", "@DESTINATARIO@", "@SERVIZIO@", "@AZIONE@", "@PROFILO@", "@IDEGOV@", "@RIF_MSG@", "@GDO@"};
                String[] values = new String[]{mittente, destinatario, servizio, azione, profilo, idEGOVRisposta, request.getBusta().getID(), gdo};
                FileSystemUtilities.copyFileAndReplaceAllKeywords((File)f, (File)tmp, (String[])keywords, (String[])values);
                f = tmp;
            }
            this.location = f.getAbsolutePath();
            fin = new FileInputStream(f);
            this.responseMsg = new Message((Object)fin, false);
            try {
                if (this.responseMsg != null && this.responseMsg.countAttachments() == 0) {
                    byte[] tmpB = this.responseMsg.getSOAPPartAsBytes();
                    tmpB = null;
                }
            }
            catch (Exception e) {
                this.eccezioneProcessamento = e;
                this.errore = "Errore avvenuto durante il salvataggio della risposta: " + e.getMessage();
                boolean bl = false;
                if (fin != null) {
                    try {
                        fin.close();
                    }
                    catch (Exception e2) {
                        // empty catch block
                    }
                }
                if (tmp != null) {
                    tmp.delete();
                }
                return bl;
            }
            try {
                ServletUtils.checkAxisMessage(this.responseMsg);
            }
            catch (Exception e) {
                this.eccezioneProcessamento = e;
                this.errore = "Errore avvenuto durante la lettura della risposta: " + e.getMessage();
                boolean bl = false;
                if (fin != null) {
                    try {
                        fin.close();
                    }
                    catch (Exception e3) {
                        // empty catch block
                    }
                }
                if (tmp != null) {
                    tmp.delete();
                }
                return bl;
            }
            this.codice = 200;
        }
        catch (Exception e) {
            this.eccezioneProcessamento = e;
            this.errore = "Errore durante la generazione della risposta: " + e.getMessage();
            boolean bl = false;
            return bl;
        }
        finally {
            if (fin != null) {
                try {
                    fin.close();
                }
                catch (Exception e) {}
            }
            if (tmp != null) {
                tmp.delete();
            }
        }
        return true;
    }
}

