/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop.pdd.core.autorizzazione;

import org.openspcoop.dao.commons.IDSoggetto;
import org.openspcoop.dao.registry.driver.IDServizio;
import org.openspcoop.pdd.core.autorizzazione.EsitoAutorizzazione;
import org.openspcoop.pdd.core.autorizzazione.IAutorizzazioneSPCoop;
import org.openspcoop.registry.EsitoAutorizzazioneSPCoop;
import org.openspcoop.registry.RegistroServiziReader;

public class AutorizzazioneSPCoopRegistro
implements IAutorizzazioneSPCoop {
    public EsitoAutorizzazione process(String pdd, String identitaServizioApplicativoFruitore, String subjectServizioApplicativoFruitoreFromWSSHeader, IDSoggetto soggetto, IDServizio servizio) {
        EsitoAutorizzazione esito = new EsitoAutorizzazione();
        try {
            RegistroServiziReader reg = RegistroServiziReader.getInstance();
            EsitoAutorizzazioneSPCoop esitoAutorizzazione = reg.isFruitoreServizioAutorizzato(pdd, identitaServizioApplicativoFruitore, soggetto, servizio);
            if (!esitoAutorizzazione.isServizioAutorizzato()) {
                String errore = "Il soggetto " + soggetto.getTipo() + "/" + soggetto.getNome() + " non e' autorizzato ad invocare il servizio " + servizio.getTipoServizio() + "/" + servizio.getServizio() + " erogato da " + servizio.getSoggettoErogatore().getTipo() + "/" + servizio.getSoggettoErogatore().getNome();
                if (esitoAutorizzazione.getDetails() != null) {
                    errore = errore + " (" + esitoAutorizzazione.getDetails() + ")";
                }
                esito.setMsgErrore(errore);
                esito.setCodiceErrore("EGOV_IT_201");
                esito.setServizioAutorizzato(false);
            } else {
                esito.setServizioAutorizzato(true);
                if (esitoAutorizzazione.getDetails() != null) {
                    esito.setDetails(esitoAutorizzazione.getDetails());
                }
            }
        }
        catch (Exception e) {
            esito.setMsgErrore("Errore durante il processo di autorizzazione SPCoop: " + e.getMessage());
            esito.setCodiceErrore("EGOV_IT_200");
            esito.setServizioAutorizzato(false);
            esito.setEccezioneProcessamento(e);
        }
        return esito;
    }
}

