/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop.pdd.core.autorizzazione;

import java.io.InputStream;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;
import javax.sql.DataSource;
import org.apache.log4j.Logger;
import org.openspcoop.dao.commons.IDSoggetto;
import org.openspcoop.dao.registry.driver.IDServizio;
import org.openspcoop.pdd.core.autorizzazione.EsitoAutorizzazione;
import org.openspcoop.pdd.core.autorizzazione.IAutorizzazioneSPCoop;
import org.openspcoop.pdd.logger.OpenSPCoopLogger;
import org.openspcoop.utils.GestoreJNDI;
import org.openspcoop.utils.Utilities;

public class AutorizzazionePdDConsole
implements IAutorizzazioneSPCoop {
    private static boolean initialized = false;
    private static DataSource dataSource = null;
    private static String checkPdd = "disabilitato";
    private static String checkFruizioneServizioApplicativo = "disabilitato";
    private static String checkFruizionePerRuolo = "disabilitato";
    private static final String ALMOST_ONE = "almostOne";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static synchronized void initRisorse() {
        if (!initialized) {
            InputStream properties = null;
            try {
                properties = AutorizzazionePdDConsole.class.getResourceAsStream("/autorizzazionePdDConsole.properties");
                if (properties == null) {
                    throw new Exception("File autorizzazionePdDConsole.properties non trovato");
                }
                Properties reader = new Properties();
                reader.load(properties);
                if (Utilities.readProperties((String)"dataSource.property.", (Properties)reader) == null) {
                    throw new Exception("Proprieta' per il contesto JNDI [dataSource.property.*] non correttamente definite");
                }
                if (reader.getProperty("dataSource") == null) {
                    throw new Exception("Nome JNDI del DataSource non fornito");
                }
                GestoreJNDI jndi = new GestoreJNDI(Utilities.readProperties((String)"dataSource.property.", (Properties)reader));
                dataSource = (DataSource)jndi.lookup(reader.getProperty("dataSource").trim());
                if (dataSource == null) {
                    throw new Exception("DataSource is null");
                }
                if (reader.getProperty("checkPdd") == null) {
                    throw new Exception("Proprieta' 'checkPdd' non fornita");
                }
                if (!"abilitato".equals(reader.getProperty("checkPdd").trim()) && !"disabilitato".equals(reader.getProperty("checkPdd").trim())) {
                    throw new Exception("Proprieta' 'checkPdd' non possiede un valore valido");
                }
                checkPdd = reader.getProperty("checkPdd").trim();
                if (reader.getProperty("checkFruizioneServizioApplicativo") == null) {
                    throw new Exception("Proprieta' 'checkFruizioneServizioApplicativo' non fornita");
                }
                if (!(ALMOST_ONE.equals(reader.getProperty("checkFruizioneServizioApplicativo").trim()) || "abilitato".equals(reader.getProperty("checkFruizioneServizioApplicativo").trim()) || "disabilitato".equals(reader.getProperty("checkFruizioneServizioApplicativo").trim()))) {
                    throw new Exception("Proprieta' 'checkFruizioneServizioApplicativo' non possiede un valore valido");
                }
                checkFruizioneServizioApplicativo = reader.getProperty("checkFruizioneServizioApplicativo").trim();
                if (reader.getProperty("checkFruizionePerRuolo") == null) {
                    throw new Exception("Proprieta' 'checkFruizionePerRuolo' non fornita");
                }
                if (!(ALMOST_ONE.equals(reader.getProperty("checkFruizionePerRuolo").trim()) || "abilitato".equals(reader.getProperty("checkFruizionePerRuolo").trim()) || "disabilitato".equals(reader.getProperty("checkFruizionePerRuolo").trim()))) {
                    throw new Exception("Proprieta' 'checkFruizionePerRuolo' non possiede un valore valido");
                }
                checkFruizionePerRuolo = reader.getProperty("checkFruizionePerRuolo").trim();
                initialized = true;
            }
            catch (Exception e) {
                Logger log = OpenSPCoopLogger.getLoggerOpenSPCoopCore();
                if (log == null) {
                    log = Logger.getLogger((String)"autorizzazionePdDConsole");
                }
                log.error((Object)("Errore durante l'istanziazione della classe autorizzazionePdDConsole: " + e.getMessage()), (Throwable)e);
            }
            finally {
                try {
                    properties.close();
                }
                catch (Exception exception) {}
            }
        }
    }

    public static DataSource getDataSource() throws Exception {
        if (!initialized) {
            AutorizzazionePdDConsole.initRisorse();
        }
        if (!initialized) {
            throw new Exception("DataSource non disponibile");
        }
        return dataSource;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public EsitoAutorizzazione process(String pdd, String identitaServizioApplicativoFruitore, String subjectServizioApplicativoFruitoreFromWSSHeader, IDSoggetto soggetto, IDServizio servizio) {
        EsitoAutorizzazione esito = new EsitoAutorizzazione();
        Connection connectionDB = null;
        PreparedStatement pstmt = null;
        ResultSet rs = null;
        String query = null;
        Logger log = OpenSPCoopLogger.getLoggerOpenSPCoopCore();
        if (log == null) {
            log = Logger.getLogger((String)"autorizzazionePdDConsole");
        }
        try {
            if (soggetto == null) throw new Exception("Dati soggetto fruitore non forniti");
            if (soggetto.getTipo() == null) throw new Exception("Dati soggetto fruitore non forniti");
            if (soggetto.getNome() == null) {
                throw new Exception("Dati soggetto fruitore non forniti");
            }
            if (servizio == null) throw new Exception("Dati servizio non forniti");
            if (servizio.getTipoServizio() == null) throw new Exception("Dati servizio non forniti");
            if (servizio.getServizio() == null) {
                throw new Exception("Dati servizio non forniti");
            }
            if (servizio.getSoggettoErogatore() == null) throw new Exception("Dati soggetto erogatore non forniti");
            if (servizio.getSoggettoErogatore().getTipo() == null) throw new Exception("Dati soggetto erogatore non forniti");
            if (servizio.getSoggettoErogatore().getNome() == null) {
                throw new Exception("Dati soggetto erogatore non forniti");
            }
            connectionDB = AutorizzazionePdDConsole.getDataSource().getConnection();
            if (connectionDB == null) {
                throw new Exception("Connessione al Database non disponibile");
            }
            query = "select pdd.tipo FROM pdd,soggetti where soggetti.server=pdd.nome AND soggetti.tipo_soggetto=? AND soggetti.nome_soggetto=?";
            pstmt = connectionDB.prepareStatement(query);
            pstmt.setString(1, soggetto.getTipo());
            pstmt.setString(2, soggetto.getNome());
            rs = pstmt.executeQuery();
            if (!rs.next()) {
                rs.close();
                pstmt.close();
                esito.setMsgErrore("Il soggetto " + soggetto.getTipo() + "/" + soggetto.getNome() + " non appartiene a nessuna Porta di Dominio??? Non e' autorizzato ad invocare il servizio " + servizio.getTipoServizio() + "/" + servizio.getServizio() + " erogato da " + servizio.getSoggettoErogatore().getTipo() + "/" + servizio.getSoggettoErogatore().getNome());
                esito.setCodiceErrore("EGOV_IT_201");
                esito.setServizioAutorizzato(false);
                EsitoAutorizzazione esitoAutorizzazione = esito;
                return esitoAutorizzazione;
            }
            String tipoPdd = rs.getString("tipo");
            boolean pddEsterna = false;
            if ("esterno".equals(tipoPdd)) {
                pddEsterna = true;
            }
            log.debug((Object)("Soggetto fruitore " + soggetto.toString() + " appartiene ad una pdd di tipo [" + tipoPdd + "]"));
            rs.close();
            pstmt.close();
            if ("abilitato".equals(checkPdd) && pdd != null) {
                Object subjectPotenziale;
                Hashtable hashSubject = Utilities.getSubjectIntoHashtable((String)pdd);
                query = "select * from pdd,soggetti where soggetti.server=pdd.nome and soggetti.tipo_soggetto=? and soggetti.nome_soggetto=?";
                Enumeration keys = hashSubject.keys();
                while (keys.hasMoreElements()) {
                    String key = (String)keys.nextElement();
                    String value = (String)hashSubject.get(key);
                    String ricerca = "/" + Utilities.formatKeySubject((String)key) + "=" + Utilities.formatValueSubject((String)value) + "/";
                    query = query + " and " + "pdd" + ".subject like '%" + ricerca + "%'";
                }
                pstmt = connectionDB.prepareStatement(query);
                pstmt.setString(1, soggetto.getTipo());
                pstmt.setString(2, soggetto.getNome());
                rs = pstmt.executeQuery();
                boolean match = false;
                while (rs.next()) {
                    subjectPotenziale = rs.getString("subject");
                    if (!Utilities.sslVerify((String)subjectPotenziale, (String)pdd)) continue;
                    match = true;
                    break;
                }
                if (!match) {
                    rs.close();
                    pstmt.close();
                    esito.setMsgErrore("Il soggetto " + soggetto.getTipo() + "/" + soggetto.getNome() + " non appartiene alla Porta di Dominio con subject [" + pdd + "], quindi non e' autorizzato ad invocare il servizio " + servizio.getTipoServizio() + "/" + servizio.getServizio() + " erogato da " + servizio.getSoggettoErogatore().getTipo() + "/" + servizio.getSoggettoErogatore().getNome());
                    esito.setCodiceErrore("EGOV_IT_201");
                    esito.setServizioAutorizzato(false);
                    subjectPotenziale = esito;
                    return subjectPotenziale;
                }
                rs.close();
                pstmt.close();
            }
            boolean autorizzato = false;
            if ("abilitato".equals(checkFruizioneServizioApplicativo) || ALMOST_ONE.equals(checkFruizioneServizioApplicativo)) {
                query = "select * from politiche_sicurezza,soggetti,servizi_applicativi where politiche_sicurezza.id_fruitore=soggetti.id AND soggetti.tipo_soggetto=? AND soggetti.nome_soggetto=? AND servizi_applicativi.id_soggetto=soggetti.id AND politiche_sicurezza.id_servizio_applicativo=servizi_applicativi.id AND politiche_sicurezza.id_servizio in ( select servizi.id from servizi,soggetti where servizi.tipo_servizio=? AND servizi.nome_servizio=? AND servizi.id_soggetto=soggetti.id AND soggetti.tipo_soggetto=? AND soggetti.nome_soggetto=? )";
                boolean checkFallitoPerMancanzaIdentitaServizioApplicativo = false;
                if (!pddEsterna && "abilitato".equals(checkFruizioneServizioApplicativo)) {
                    if (identitaServizioApplicativoFruitore != null && subjectServizioApplicativoFruitoreFromWSSHeader != null) {
                        query = query + " AND ( (" + "servizi_applicativi" + ".nome=?) OR (" + "servizi_applicativi" + ".subject=?))";
                    } else if (identitaServizioApplicativoFruitore != null) {
                        query = query + " AND " + "servizi_applicativi" + ".nome=?";
                    } else if (subjectServizioApplicativoFruitoreFromWSSHeader != null) {
                        query = query + " AND " + "servizi_applicativi" + ".subject=?";
                    } else {
                        log.debug((Object)("CheckFruizioneServizioApplicativo (sa non fornito) [" + checkFruizioneServizioApplicativo + "] QUERY[" + query + "] SA(" + identitaServizioApplicativoFruitore + ") WSSSubject(" + subjectServizioApplicativoFruitoreFromWSSHeader + "). Il soggetto " + soggetto.getTipo() + "/" + soggetto.getNome() + " non e' autorizzato ad invocare" + "il servizio " + servizio.getTipoServizio() + "/" + servizio.getServizio() + " erogato da " + servizio.getSoggettoErogatore().getTipo() + "/" + servizio.getSoggettoErogatore().getNome() + "."));
                        checkFallitoPerMancanzaIdentitaServizioApplicativo = true;
                    }
                }
                if (!checkFallitoPerMancanzaIdentitaServizioApplicativo) {
                    pstmt = connectionDB.prepareStatement(query);
                    pstmt.setString(1, soggetto.getTipo());
                    pstmt.setString(2, soggetto.getNome());
                    pstmt.setString(3, servizio.getTipoServizio());
                    pstmt.setString(4, servizio.getServizio());
                    pstmt.setString(5, servizio.getSoggettoErogatore().getTipo());
                    pstmt.setString(6, servizio.getSoggettoErogatore().getNome());
                    if (!pddEsterna && "abilitato".equals(checkFruizioneServizioApplicativo)) {
                        if (identitaServizioApplicativoFruitore != null && subjectServizioApplicativoFruitoreFromWSSHeader != null) {
                            pstmt.setString(7, identitaServizioApplicativoFruitore);
                            pstmt.setString(8, subjectServizioApplicativoFruitoreFromWSSHeader);
                        } else if (identitaServizioApplicativoFruitore != null) {
                            pstmt.setString(7, identitaServizioApplicativoFruitore);
                        } else if (subjectServizioApplicativoFruitoreFromWSSHeader != null) {
                            pstmt.setString(8, subjectServizioApplicativoFruitoreFromWSSHeader);
                        }
                    }
                    if (!(autorizzato = (rs = pstmt.executeQuery()).next())) {
                        log.debug((Object)("CheckFruizioneServizioApplicativo[" + checkFruizioneServizioApplicativo + "] QUERY[" + query + "] SA(" + identitaServizioApplicativoFruitore + ") WSSSubject(" + subjectServizioApplicativoFruitoreFromWSSHeader + "). Il soggetto " + soggetto.getTipo() + "/" + soggetto.getNome() + " non e' autorizzato ad invocare" + "il servizio " + servizio.getTipoServizio() + "/" + servizio.getServizio() + " erogato da " + servizio.getSoggettoErogatore().getTipo() + "/" + servizio.getSoggettoErogatore().getNome() + "."));
                    }
                    rs.close();
                    pstmt.close();
                }
            }
            if (!autorizzato && ("abilitato".equals(checkFruizionePerRuolo) || ALMOST_ONE.equals(checkFruizionePerRuolo))) {
                boolean isCorrelato = false;
                query = "select servizio_correlato from servizi,soggetti where servizi.tipo_servizio=? AND servizi.nome_servizio=? AND servizi.id_soggetto=soggetti.id AND soggetti.tipo_soggetto=? AND soggetti.nome_soggetto=?";
                pstmt = connectionDB.prepareStatement(query);
                pstmt.setString(1, servizio.getTipoServizio());
                pstmt.setString(2, servizio.getServizio());
                pstmt.setString(3, servizio.getSoggettoErogatore().getTipo());
                pstmt.setString(4, servizio.getSoggettoErogatore().getNome());
                rs = pstmt.executeQuery();
                if (!rs.next()) {
                    log.debug((Object)("CheckFruizionePerRuolo[" + checkFruizionePerRuolo + "] QUERY[" + query + "]. " + "Il soggetto " + soggetto.getTipo() + "/" + soggetto.getNome() + " cerca di usufruire di un servizio non esistente: " + servizio.getTipoServizio() + "/" + servizio.getServizio() + " erogato da " + servizio.getSoggettoErogatore().getTipo() + "/" + servizio.getSoggettoErogatore().getNome() + "."));
                    rs.close();
                    pstmt.close();
                    esito.setMsgErrore("Il soggetto " + soggetto.getTipo() + "/" + soggetto.getNome() + " cerca di usufruire di un servizio non esistente: " + servizio.getTipoServizio() + "/" + servizio.getServizio() + " erogato da " + servizio.getSoggettoErogatore().getTipo() + "/" + servizio.getSoggettoErogatore().getNome() + ".");
                    esito.setCodiceErrore("EGOV_IT_201");
                    esito.setServizioAutorizzato(false);
                    EsitoAutorizzazione match = esito;
                    return match;
                }
                isCorrelato = "abilitato".equals(rs.getString("servizio_correlato"));
                rs.close();
                pstmt.close();
                query = "select * from accordi,servizi,soggetti,servizi_applicativi,ruoli_sa where ruoli_sa.id_accordo=accordi.id AND accordi.id=servizi.id_accordo AND accordi.nome = servizi.nome_servizio AND servizi.tipo_servizio=? AND servizi.nome_servizio=? AND servizi.id_soggetto=soggetti.id AND soggetti.tipo_soggetto=? AND soggetti.nome_soggetto=? AND servizi.servizio_correlato=? AND ruoli_sa.servizio_correlato=? AND ruoli_sa.id_servizio_applicativo=servizi_applicativi.id";
                boolean checkFallitoPerMancanzaIdentitaServizioApplicativo = false;
                if (!pddEsterna && "abilitato".equals(checkFruizionePerRuolo)) {
                    if (identitaServizioApplicativoFruitore != null && subjectServizioApplicativoFruitoreFromWSSHeader != null) {
                        query = query + " AND " + "( (" + "servizi_applicativi" + ".nome=?) OR (" + "servizi_applicativi" + ".subject=?)) AND" + "servizi_applicativi" + ".id_soggetto in ( select id from " + "soggetti" + " where tipo_soggetto=? AND nome_soggetto=? )";
                    } else if (identitaServizioApplicativoFruitore != null) {
                        query = query + " AND " + "servizi_applicativi" + ".nome=? AND " + "servizi_applicativi" + ".id_soggetto in ( select id from " + "soggetti" + " where tipo_soggetto=? AND nome_soggetto=? )";
                    } else if (subjectServizioApplicativoFruitoreFromWSSHeader != null) {
                        query = query + " AND " + "servizi_applicativi" + ".subject=? AND " + "servizi_applicativi" + ".id_soggetto in ( select id from " + "soggetti" + " where tipo_soggetto=? AND nome_soggetto=? )";
                    } else {
                        log.debug((Object)("CheckFruizionePerRuolo (sa non fornito) [" + checkFruizionePerRuolo + "] QUERY[" + query + "] SA(" + identitaServizioApplicativoFruitore + ") WSSSubject(" + subjectServizioApplicativoFruitoreFromWSSHeader + "). Il soggetto " + soggetto.getTipo() + "/" + soggetto.getNome() + " non e' autorizzato ad invocare" + "il servizio " + servizio.getTipoServizio() + "/" + servizio.getServizio() + " erogato da " + servizio.getSoggettoErogatore().getTipo() + "/" + servizio.getSoggettoErogatore().getNome() + "."));
                        checkFallitoPerMancanzaIdentitaServizioApplicativo = true;
                    }
                }
                if (!checkFallitoPerMancanzaIdentitaServizioApplicativo) {
                    pstmt = connectionDB.prepareStatement(query);
                    pstmt.setString(1, servizio.getTipoServizio());
                    pstmt.setString(2, servizio.getServizio());
                    pstmt.setString(3, servizio.getSoggettoErogatore().getTipo());
                    pstmt.setString(4, servizio.getSoggettoErogatore().getNome());
                    if (isCorrelato) {
                        pstmt.setString(5, "abilitato");
                    } else {
                        pstmt.setString(5, "disabilitato");
                    }
                    if (isCorrelato) {
                        pstmt.setInt(6, 1);
                    } else {
                        pstmt.setInt(6, 0);
                    }
                    if (!pddEsterna && "abilitato".equals(checkFruizionePerRuolo)) {
                        if (identitaServizioApplicativoFruitore != null && subjectServizioApplicativoFruitoreFromWSSHeader != null) {
                            pstmt.setString(7, identitaServizioApplicativoFruitore);
                            pstmt.setString(8, subjectServizioApplicativoFruitoreFromWSSHeader);
                            pstmt.setString(9, soggetto.getTipo());
                            pstmt.setString(10, soggetto.getNome());
                        } else if (identitaServizioApplicativoFruitore != null) {
                            pstmt.setString(7, identitaServizioApplicativoFruitore);
                            pstmt.setString(8, soggetto.getTipo());
                            pstmt.setString(9, soggetto.getNome());
                        } else if (subjectServizioApplicativoFruitoreFromWSSHeader != null) {
                            pstmt.setString(7, subjectServizioApplicativoFruitoreFromWSSHeader);
                            pstmt.setString(8, soggetto.getTipo());
                            pstmt.setString(9, soggetto.getNome());
                        }
                    }
                    rs = pstmt.executeQuery();
                    autorizzato = rs.next();
                    log.debug((Object)("CheckFruizionePerRuolo[" + checkFruizionePerRuolo + "] QUERY[" + query + "] SA(" + identitaServizioApplicativoFruitore + ") WSSSubject(" + subjectServizioApplicativoFruitoreFromWSSHeader + "). Il soggetto " + soggetto.getTipo() + "/" + soggetto.getNome() + " non e' autorizzato ad invocare" + "il servizio " + servizio.getTipoServizio() + "/" + servizio.getServizio() + " erogato da " + servizio.getSoggettoErogatore().getTipo() + "/" + servizio.getSoggettoErogatore().getNome() + "."));
                    rs.close();
                    pstmt.close();
                }
            }
            if (!autorizzato) {
                String servizioApplicativoMsg = "";
                if (!pddEsterna && ("abilitato".equals(checkFruizioneServizioApplicativo) || "abilitato".equals(checkFruizionePerRuolo))) {
                    servizioApplicativoMsg = identitaServizioApplicativoFruitore != null && subjectServizioApplicativoFruitoreFromWSSHeader != null ? "servizio applicativo [" + identitaServizioApplicativoFruitore + "] (subject-wss [" + subjectServizioApplicativoFruitoreFromWSSHeader + "]) del " : (identitaServizioApplicativoFruitore != null ? "servizio applicativo [" + identitaServizioApplicativoFruitore + "] del " : (subjectServizioApplicativoFruitoreFromWSSHeader != null ? "servizio applicativo (subject-wss [" + identitaServizioApplicativoFruitore + "]) del " : "servizio applicativo ANONIMO (ne identita' ne subject-wss fornito) del "));
                }
                esito.setMsgErrore("Il " + servizioApplicativoMsg + "soggetto " + soggetto.getTipo() + "/" + soggetto.getNome() + " non e' autorizzato ad invocare il servizio " + servizio.getTipoServizio() + "/" + servizio.getServizio() + " erogato da " + servizio.getSoggettoErogatore().getTipo() + "/" + servizio.getSoggettoErogatore().getNome());
                esito.setCodiceErrore("EGOV_IT_201");
                esito.setServizioAutorizzato(false);
                return esito;
            }
            esito.setServizioAutorizzato(true);
            return esito;
        }
        catch (Exception e) {
            log.error((Object)("Errore durante il processo di autorizzazione PdDConsole query[" + query + "]"), (Throwable)e);
            esito.setMsgErrore("Errore durante il processo di autorizzazione PdDConsole: " + e.getMessage());
            esito.setCodiceErrore("EGOV_IT_200");
            esito.setServizioAutorizzato(false);
            esito.setEccezioneProcessamento(e);
            try {
                if (rs != null) {
                    rs.close();
                }
            }
            catch (Exception eClose) {
                // empty catch block
            }
            try {
                if (pstmt == null) return esito;
                pstmt.close();
                return esito;
            }
            catch (Exception eClose) {
                // empty catch block
                return esito;
            }
        }
        finally {
            try {
                if (connectionDB != null) {
                    connectionDB.close();
                }
            }
            catch (Exception eClose) {}
        }
    }
}

