/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop.pdd.core.autorizzazione;

import org.openspcoop.dao.commons.IDSoggetto;
import org.openspcoop.dao.config.PortaDelegata;
import org.openspcoop.dao.config.driver.DriverConfigurazioneException;
import org.openspcoop.dao.config.driver.DriverConfigurazioneNotFound;
import org.openspcoop.dao.registry.driver.IDServizio;
import org.openspcoop.pdd.config.ConfigurazionePdDReader;
import org.openspcoop.pdd.core.autorizzazione.AutorizzazioneException;
import org.openspcoop.pdd.core.autorizzazione.EsitoAutorizzazione;
import org.openspcoop.pdd.core.autorizzazione.IAutorizzazione;
import org.openspcoop.pdd.logger.OpenSPCoopLogger;

public class AutorizzazioneOpenSPCoop
implements IAutorizzazione {
    public EsitoAutorizzazione process(String servizioApplicativo, IDSoggetto soggetto, String locationPD, IDServizio servizio, PortaDelegata pd) throws AutorizzazioneException {
        EsitoAutorizzazione esito = new EsitoAutorizzazione();
        try {
            if (!ConfigurazionePdDReader.getInstance().autorizzazione(pd, servizioApplicativo)) {
                esito.setMsgErrore("Servizio non invocabile dal servizio applicativo " + servizioApplicativo);
                esito.setCodiceErrore("OPENSPCOOP_ORG_404");
                esito.setServizioAutorizzato(false);
                return esito;
            }
        }
        catch (DriverConfigurazioneNotFound e) {
            esito.setMsgErrore("La porta delegata invocata non esiste  servizioApplicativo(" + servizioApplicativo + "): " + e.getMessage());
            esito.setCodiceErrore("OPENSPCOOP_ORG_401");
            esito.setServizioAutorizzato(false);
            return esito;
        }
        catch (DriverConfigurazioneException e) {
            OpenSPCoopLogger.getLoggerOpenSPCoopCore().error((Object)"AutorizzazioneOpenSPCoop non riuscita", (Throwable)e);
            esito.setMsgErrore("Sistema non disponibile");
            esito.setCodiceErrore("OPENSPCOOP_ORG_536");
            esito.setServizioAutorizzato(false);
            esito.setEccezioneProcessamento((Exception)((Object)e));
            return esito;
        }
        esito.setServizioAutorizzato(true);
        return esito;
    }
}

