/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop.pdd.core.autenticazione;

import java.util.Properties;
import org.apache.axis.Message;
import org.openspcoop.pdd.core.autenticazione.Credenziali;
import org.openspcoop.pdd.core.autenticazione.GestoreCredenzialiConfigurationException;
import org.openspcoop.pdd.core.autenticazione.GestoreCredenzialiException;
import org.openspcoop.pdd.core.autenticazione.IGestoreCredenziali;
import org.openspcoop.pdd.core.connettori.InfoConnettoreIngresso;

public class GestoreCredenzialiTest
implements IGestoreCredenziali {
    public static final String TEST_CREDENZIALI_BASIC_USERNAME = "X-OpenSPCoop-TestCredenziali-BasicUsername";
    public static final String TEST_CREDENZIALI_BASIC_PASSWORD = "X-OpenSPCoop-TestCredenziali-BasicPassword";
    public static final String TEST_CREDENZIALI_SSL_SUBJECT = "X-OpenSPCoop-TestCredenziali-SSLSubject";
    public static final String TEST_CREDENZIALI_SIMULAZIONE_ERRORE = "X-OpenSPCoop-TestCredenziali-SimulazioneErrore";
    public static final String TEST_CREDENZIALI_SIMULAZIONE_ERRORE_CONFIGURAZIONE = "X-OpenSPCoop-TestCredenziali-SimulazioneErroreConfigurazione";
    private String identita = null;

    public Credenziali elaborazioneCredenziali(InfoConnettoreIngresso infoConnettoreIngresso, Message messaggio) throws GestoreCredenzialiException, GestoreCredenzialiConfigurationException {
        Credenziali c = new Credenziali();
        if (this.existsHeader(infoConnettoreIngresso.getParametersTrasporto(), TEST_CREDENZIALI_BASIC_USERNAME)) {
            String username = this.getProperty(infoConnettoreIngresso.getParametersTrasporto(), TEST_CREDENZIALI_BASIC_USERNAME);
            String password = this.getProperty(infoConnettoreIngresso.getParametersTrasporto(), TEST_CREDENZIALI_BASIC_PASSWORD);
            if (username == null || "".equals(username)) {
                throw new GestoreCredenzialiConfigurationException("Username value non fornito");
            }
            if (password == null || "".equals(password)) {
                throw new GestoreCredenzialiConfigurationException("Password value non fornito");
            }
            c.setUsername(username);
            c.setPassword(password);
        } else if (this.existsHeader(infoConnettoreIngresso.getParametersTrasporto(), TEST_CREDENZIALI_SSL_SUBJECT)) {
            String subject = this.getProperty(infoConnettoreIngresso.getParametersTrasporto(), TEST_CREDENZIALI_SSL_SUBJECT);
            if (subject == null || "".equals(subject)) {
                throw new GestoreCredenzialiConfigurationException("Subject value non fornito");
            }
            c.setSubject(subject);
        } else {
            if (this.existsHeader(infoConnettoreIngresso.getParametersTrasporto(), TEST_CREDENZIALI_SIMULAZIONE_ERRORE)) {
                throw new GestoreCredenzialiException("Eccezione generale richiesta dalla testsuite");
            }
            if (this.existsHeader(infoConnettoreIngresso.getParametersTrasporto(), TEST_CREDENZIALI_SIMULAZIONE_ERRORE_CONFIGURAZIONE)) {
                throw new GestoreCredenzialiConfigurationException("Eccezione, di configurazione, richiesta dalla testsuite");
            }
            return infoConnettoreIngresso.getCredenziali();
        }
        this.identita = infoConnettoreIngresso.getCredenziali().getSubject() != null || infoConnettoreIngresso.getCredenziali().getUsername() != null ? "GestoreCredenziali di test " + infoConnettoreIngresso.getCredenziali().toString() : "GestoreCredenziali di test anonimo";
        return c;
    }

    public String getIdentitaGestoreCredenziali() {
        return this.identita;
    }

    private boolean existsHeader(Properties properties, String name) {
        if (properties != null) {
            return properties.containsKey(name) || properties.containsKey(name.toLowerCase()) || properties.containsKey(name.toUpperCase());
        }
        return false;
    }

    private String getProperty(Properties properties, String name) {
        if (properties != null) {
            String tmp = properties.getProperty(name);
            if (tmp == null) {
                tmp = properties.getProperty(name.toLowerCase());
            }
            if (tmp == null) {
                tmp = properties.getProperty(name.toUpperCase());
            }
            return tmp;
        }
        return null;
    }
}

