/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop.pdd.core.autenticazione;

import org.openspcoop.dao.commons.IDSoggetto;
import org.openspcoop.pdd.config.ConfigurazionePdDReader;
import org.openspcoop.pdd.core.autenticazione.Credenziali;
import org.openspcoop.pdd.core.autenticazione.IAutenticazione;
import org.openspcoop.pdd.logger.OpenSPCoopLogger;

public class AutenticazioneBASIC
implements IAutenticazione {
    private String servizioApplicativo;
    private String msgError;
    private String codiceError;
    private Exception exception;

    public boolean process(Credenziali credenziali, IDSoggetto soggetto, String locationPD) {
        String user = credenziali.getUsername();
        String password = credenziali.getPassword();
        if (user == null || "".equals(user) || password == null || "".equals(password)) {
            this.msgError = "Credenziali non fornite";
            this.codiceError = "OPENSPCOOP_ORG_402";
            return false;
        }
        try {
            this.servizioApplicativo = ConfigurazionePdDReader.getInstance().autenticazioneHTTP(soggetto, locationPD, user, password);
        }
        catch (Exception e) {
            OpenSPCoopLogger.getLoggerOpenSPCoopCore().error((Object)"AutenticazioneBasic non riuscita", (Throwable)e);
            this.msgError = "Sistema non disponibile";
            this.codiceError = "OPENSPCOOP_ORG_536";
            this.exception = e;
            return false;
        }
        if (this.servizioApplicativo == null) {
            this.msgError = "Credenziali fornite non corrette";
            this.codiceError = "OPENSPCOOP_ORG_402";
            return false;
        }
        return true;
    }

    public boolean process(Credenziali credenziali) {
        String user = credenziali.getUsername();
        String password = credenziali.getPassword();
        if (user == null || "".equals(user) || password == null || "".equals(password)) {
            this.msgError = "Credenziali non fornite";
            this.codiceError = "OPENSPCOOP_ORG_402";
            return false;
        }
        try {
            this.servizioApplicativo = ConfigurazionePdDReader.getInstance().autenticazioneHTTP(user, password);
        }
        catch (Exception e) {
            OpenSPCoopLogger.getLoggerOpenSPCoopCore().error((Object)"AutenticazioneBasic non riuscita", (Throwable)e);
            this.msgError = "Sistema non disponibile";
            this.codiceError = "OPENSPCOOP_ORG_536";
            this.exception = e;
            return false;
        }
        if (this.servizioApplicativo == null) {
            this.msgError = "Credenziali fornite non corrette";
            this.codiceError = "OPENSPCOOP_ORG_402";
            return false;
        }
        return true;
    }

    public String getServizioApplicativo() {
        return this.servizioApplicativo;
    }

    public String getMsgError() {
        return this.msgError;
    }

    public String getCodiceErrore() {
        return this.codiceError;
    }

    public Exception getException() {
        return this.exception;
    }
}

