/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop.pdd.core;

import java.io.ByteArrayOutputStream;
import java.util.Vector;
import javax.xml.soap.SOAPBody;
import org.apache.axis.message.MessageElement;
import org.apache.log4j.Logger;
import org.openspcoop.dao.registry.Message;
import org.openspcoop.dao.registry.MessagePart;
import org.openspcoop.dao.registry.Operation;
import org.openspcoop.dao.registry.PortType;
import org.openspcoop.dao.registry.driver.DriverRegistroServiziException;
import org.openspcoop.dao.registry.driver.DriverRegistroServiziNotFound;
import org.openspcoop.dao.registry.driver.IDServizio;
import org.openspcoop.dao.registry.wsdl.AccordoServizioWrapper;
import org.openspcoop.pdd.core.ValidatoreMessaggiApplicativiException;
import org.openspcoop.pdd.logger.OpenSPCoopLogger;
import org.openspcoop.registry.RegistroServiziReader;
import org.openspcoop.utils.UtilsException;
import org.openspcoop.utils.xml.ValidatoreXSD;
import org.openspcoop.utils.xml.XMLUtils;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class ValidatoreMessaggiApplicativi {
    RegistroServiziReader registroServiziReader;
    IDServizio idServizio;
    SOAPBody body;
    AccordoServizioWrapper accordoServizioWrapper = null;
    Logger logger = null;

    public static String replaceWithDefinitorio(String codice) {
        return codice.replace("TIPO_WSDL", "Schema xsd dei messaggi");
    }

    public static String replaceWithErogatore(String codice) {
        return codice.replace("TIPO_WSDL", "Wsdl erogatore");
    }

    public static String replaceWithFruitore(String codice) {
        return codice.replace("TIPO_WSDL", "Wsdl fruitore");
    }

    public boolean isServizioCorrelato() {
        try {
            return this.accordoServizioWrapper.isCorrelato();
        }
        catch (Exception e) {
            return false;
        }
    }

    public ValidatoreMessaggiApplicativi(RegistroServiziReader registro, IDServizio idServizio, SOAPBody body, boolean readWSDLAccordoServizio) throws ValidatoreMessaggiApplicativiException {
        if (registro == null) {
            ValidatoreMessaggiApplicativiException ex = new ValidatoreMessaggiApplicativiException("Reader del Registro dei Servizi non fornito");
            ex.setCodiceErrore("OPENSPCOOP_ORG_531");
            ex.setMsgErrore("Sistema non disponibile");
            throw ex;
        }
        if (idServizio == null || idServizio.getSoggettoErogatore() == null || idServizio.getTipoServizio() == null || idServizio.getServizio() == null || idServizio.getSoggettoErogatore().getTipo() == null || idServizio.getSoggettoErogatore().getNome() == null) {
            ValidatoreMessaggiApplicativiException ex = new ValidatoreMessaggiApplicativiException("ID del servizio SPCoop da validare, non fornito");
            ex.setCodiceErrore("OPENSPCOOP_ORG_531");
            ex.setMsgErrore("Sistema non disponibile");
            throw ex;
        }
        if (body == null || !body.hasChildNodes()) {
            ValidatoreMessaggiApplicativiException ex = new ValidatoreMessaggiApplicativiException("SOAPBody non esistente");
            ex.setCodiceErrore("OPENSPCOOP_ORG_531");
            ex.setMsgErrore("Sistema non disponibile");
            throw ex;
        }
        this.registroServiziReader = registro;
        this.idServizio = idServizio;
        this.body = body;
        this.logger = OpenSPCoopLogger.getLoggerOpenSPCoopCore();
        try {
            this.accordoServizioWrapper = this.registroServiziReader.getWsdlAccordoServizio(idServizio, readWSDLAccordoServizio);
        }
        catch (DriverRegistroServiziNotFound e) {
            this.logger.error((Object)("Riscontrato errore durante la ricerca dei wsdl/xsd che definiscono l'accordo di servizio: " + e.getMessage()), (Throwable)e);
            ValidatoreMessaggiApplicativiException ex = new ValidatoreMessaggiApplicativiException("Riscontrato errore durante la ricerca del Wsdl: " + e.getMessage());
            ex.setCodiceErrore("OPENSPCOOP_ORG_405");
            ex.setMsgErrore(ValidatoreMessaggiApplicativi.replaceWithDefinitorio("Servizio SPCoop richiesto con la porta delegata non trovato nel registro dei servizi di OpenSPCoop"));
            throw ex;
        }
        catch (DriverRegistroServiziException e) {
            this.logger.error((Object)("Riscontrato errore durante l'inizializzazione: " + e.getMessage()), (Throwable)e);
            ValidatoreMessaggiApplicativiException ex = new ValidatoreMessaggiApplicativiException("Riscontrato errore durante l'inizializzazione: " + e.getMessage());
            if (e.getMessage() != null && e.getMessage().startsWith("[SchemaXSD]")) {
                ex.setCodiceErrore("OPENSPCOOP_ORG_417");
                ex.setMsgErrore(ValidatoreMessaggiApplicativi.replaceWithDefinitorio("TIPO_WSDL del servizio non definito (o definito non correttamente) nel Registro dei Servizi"));
                throw ex;
            }
            if (e.getMessage() != null && e.getMessage().startsWith("[WSDL-FRUITORE]")) {
                ex.setCodiceErrore("OPENSPCOOP_ORG_417");
                ex.setMsgErrore(ValidatoreMessaggiApplicativi.replaceWithFruitore("TIPO_WSDL del servizio non definito (o definito non correttamente) nel Registro dei Servizi"));
                throw ex;
            }
            if (e.getMessage() != null && e.getMessage().startsWith("[WSDL-EROGATORE]")) {
                ex.setCodiceErrore("OPENSPCOOP_ORG_417");
                ex.setMsgErrore(ValidatoreMessaggiApplicativi.replaceWithErogatore("TIPO_WSDL del servizio non definito (o definito non correttamente) nel Registro dei Servizi"));
                throw ex;
            }
            ex.setCodiceErrore("OPENSPCOOP_ORG_530");
            ex.setMsgErrore("Sistema non disponibile");
            throw ex;
        }
    }

    public AccordoServizioWrapper getAccordoServizioWrapper() {
        return this.accordoServizioWrapper;
    }

    public void validateWithWsdlDefinitorio(boolean isRichiesta, boolean checkStyle) throws ValidatoreMessaggiApplicativiException {
        ValidatoreXSD validatoreBodyApplicativo = null;
        try {
            if (this.accordoServizioWrapper.getSchema() == null) {
                throw new Exception("Schema non costruito?");
            }
            validatoreBodyApplicativo = new ValidatoreXSD(this.accordoServizioWrapper.getSchema());
        }
        catch (Exception e) {
            this.logger.error((Object)("Riscontrato errore durante la costruzione del validatore XSD per il contenuto applicativo: " + e.getMessage()), (Throwable)e);
            ValidatoreMessaggiApplicativiException ex = new ValidatoreMessaggiApplicativiException("Riscontrato errore durante la costruzione del validatore XSD per il contenuto applicativo: " + e.getMessage());
            ex.setCodiceErrore("OPENSPCOOP_ORG_417");
            ex.setMsgErrore(ValidatoreMessaggiApplicativi.replaceWithDefinitorio("TIPO_WSDL del servizio non definito (o definito non correttamente) nel Registro dei Servizi"));
            throw ex;
        }
        StringBuffer errorMsgValidazioneXSD = new StringBuffer();
        if (!checkStyle || this.idServizio.getAzione() == null) {
            this.logger.debug((Object)"Validazione XSD senza considerare il WSDLAccordoServizio");
            NodeList nl = this.body.getChildNodes();
            for (int i = 0; i < nl.getLength(); ++i) {
                String nomeElemento = null;
                try {
                    nomeElemento = nl.item(i).getLocalName();
                    validatoreBodyApplicativo.valida(nl.item(i), true);
                    continue;
                }
                catch (Exception e) {
                    if (errorMsgValidazioneXSD.length() == 0) {
                        if (isRichiesta) {
                            errorMsgValidazioneXSD.append("Validazione XSD del contenuto della richiesta fallita:\n");
                        } else {
                            errorMsgValidazioneXSD.append("Validazione XSD del contenuto della risposta fallita:\n");
                        }
                    } else {
                        errorMsgValidazioneXSD.append("\n");
                    }
                    errorMsgValidazioneXSD.append("(elemento " + nomeElemento + "): " + e.getMessage());
                }
            }
        } else {
            int i;
            this.logger.debug((Object)"Validazione XSD che considera il WSDLAccordoServizio");
            String style = "document";
            String use = "literal";
            String azione = this.idServizio.getAzione();
            try {
                PortType portType = this.accordoServizioWrapper.getPortType(this.accordoServizioWrapper.getNomePortType());
                if (portType == null) {
                    throw new Exception("Port-type [" + this.idServizio.getServizio() + "] non esistente nell'accordo di servizio " + this.accordoServizioWrapper.getIdAccordoServizio());
                }
                if (portType.getStyle() != null && !"".equals(portType.getStyle()) && "rpc".equals(portType.getStyle())) {
                    style = "rpc";
                }
                for (i = 0; i < portType.sizeAzioneList(); ++i) {
                    if (!azione.equals(portType.getAzione(i).getNome())) continue;
                    Operation operation = portType.getAzione(i);
                    if (operation.getStyle() != null && !"".equals(operation.getStyle())) {
                        if ("rpc".equals(operation.getStyle())) {
                            style = "rpc";
                        } else if ("document".equals(operation.getStyle())) {
                            style = "document";
                        }
                    }
                    if (isRichiesta) {
                        if (operation.getMessageInput() == null || operation.getMessageInput().getUse() == null || "".equals(operation.getMessageInput().getUse()) || !"encoded".equals(operation.getMessageInput().getUse())) continue;
                        use = "encoded";
                        continue;
                    }
                    if (operation.getMessageOutput() == null || operation.getMessageOutput().getUse() == null || "".equals(operation.getMessageOutput().getUse()) || !"encoded".equals(operation.getMessageOutput().getUse())) continue;
                    use = "encoded";
                }
            }
            catch (Exception e) {
                errorMsgValidazioneXSD.append("Validazione xsd fallita: " + e.getMessage());
            }
            if (errorMsgValidazioneXSD.length() == 0) {
                this.logger.debug((Object)("Validazione XSD con style[" + style + "] e use[" + use + "]..."));
                NodeList nl = this.body.getChildNodes();
                if ("rpc".equals(style) && nl.getLength() > 1) {
                    errorMsgValidazioneXSD.append("Operation [" + azione + "] (style RPC) con piu' di un root element nel contenuto applicativo");
                }
                if (errorMsgValidazioneXSD.length() == 0) {
                    for (i = 0; i < nl.getLength(); ++i) {
                        String nomeElemento = null;
                        try {
                            nomeElemento = nl.item(i).getLocalName();
                            Node nodo = null;
                            if ("encoded".equals(use)) {
                                this.logger.debug((Object)("Validazione XSD con style[" + style + "] e use[" + use + "], richiede la pulizia dei xsi:types prima della validazione..."));
                                nodo = this.cleanXSITypes(nl.item(i));
                            } else {
                                nodo = nl.item(i);
                            }
                            if ("rpc".equals(style)) {
                                this.logger.debug((Object)("Validazione XSD con style[" + style + "] e use[" + use + "] RPC Validation..."));
                                String nomeAtteso = azione;
                                if (!isRichiesta) {
                                    nomeAtteso = azione + "Response";
                                }
                                if (!nomeAtteso.equals(nomeElemento)) {
                                    throw new Exception("Root element [" + nomeElemento + "] non equivale all'operation name " + nomeAtteso + " (RPC Style)");
                                }
                                NodeList nlChilds = nodo.getChildNodes();
                                for (int j = 0; j < nl.getLength(); ++j) {
                                    Node nChild = nlChilds.item(j);
                                    validatoreBodyApplicativo.valida(nChild, true);
                                }
                                continue;
                            }
                            this.logger.debug((Object)("Validazione XSD con style[" + style + "] e use[" + use + "] Document Validation..."));
                            validatoreBodyApplicativo.valida(nodo, true);
                            continue;
                        }
                        catch (Exception e) {
                            if (errorMsgValidazioneXSD.length() == 0) {
                                if (isRichiesta) {
                                    errorMsgValidazioneXSD.append("Validazione XSD del contenuto della richiesta fallita:\n");
                                } else {
                                    errorMsgValidazioneXSD.append("Validazione XSD del contenuto della risposta fallita:\n");
                                }
                            } else {
                                errorMsgValidazioneXSD.append("\n");
                            }
                            errorMsgValidazioneXSD.append("(elemento " + nomeElemento + "): " + e.getMessage());
                        }
                    }
                }
            }
        }
        if (errorMsgValidazioneXSD.length() > 0) {
            ValidatoreMessaggiApplicativiException ex = new ValidatoreMessaggiApplicativiException(errorMsgValidazioneXSD.toString());
            if (isRichiesta) {
                ex.setCodiceErrore("OPENSPCOOP_ORG_418");
                ex.setMsgErrore(ValidatoreMessaggiApplicativi.replaceWithDefinitorio("Il contenuto applicativo del messaggio di richiesta non rispetta l'accordo di servizio (TIPO_WSDL) definito nel Registro dei Servizi"));
            } else {
                ex.setCodiceErrore("OPENSPCOOP_ORG_419");
                ex.setMsgErrore(ValidatoreMessaggiApplicativi.replaceWithDefinitorio("Il contenuto applicativo del messaggio di risposta non rispetta l'accordo di servizio (TIPO_WSDL) definito nel Registro dei Servizi"));
            }
            throw ex;
        }
    }

    public Element cleanXSITypes(Node node) throws Exception {
        MessageElement daClonare = (MessageElement)node;
        byte[] element = this.eraserType(daClonare.getAsString().getBytes());
        Element e = XMLUtils.newElement((byte[])element);
        return e;
    }

    public byte[] eraserType(byte[] xml) throws UtilsException {
        ByteArrayOutputStream cleanXML = null;
        String prefix = "";
        try {
            int k;
            int contatoreFineAttributo;
            cleanXML = new ByteArrayOutputStream();
            int i = 0;
            while (i < xml.length) {
                if (xml[i] == 32) {
                    String importXSITYPE = "http://www.w3.org/2001/XMLSchema-instance";
                    if (i + "xmlns:".length() < xml.length && xml[i + 1] == 120 && xml[i + 2] == 109 && xml[i + 3] == 108 && xml[i + 4] == 110 && xml[i + 5] == 115 && xml[i + 6] == 58) {
                        StringBuffer test = new StringBuffer("xmlns:");
                        StringBuffer prefixTest = new StringBuffer();
                        contatoreFineAttributo = 0;
                        k = 7;
                        while (i + k < xml.length) {
                            if ((char)xml[i + k] == '\"') {
                                ++contatoreFineAttributo;
                            }
                            if (contatoreFineAttributo == 0) {
                                prefixTest.append((char)xml[i + k]);
                            }
                            test.append((char)xml[i + k]);
                            if (contatoreFineAttributo >= 2) break;
                            ++k;
                        }
                        int indexFirst = test.toString().indexOf(34);
                        int secondFirst = test.toString().indexOf(34, indexFirst + 1);
                        String testEquals = test.toString().substring(indexFirst + 1, secondFirst);
                        if (importXSITYPE.equalsIgnoreCase(testEquals)) {
                            prefix = prefixTest.toString().substring(0, prefixTest.length() - 1);
                            i = i + test.toString().length() + 1;
                            continue;
                        }
                    }
                    cleanXML.write(xml[i]);
                    ++i;
                    continue;
                }
                cleanXML.write(xml[i]);
                ++i;
            }
            byte[] risultato = cleanXML.toByteArray();
            cleanXML = new ByteArrayOutputStream();
            cleanXML.close();
            int i2 = 0;
            while (i2 < risultato.length) {
                if (risultato[i2] == 32) {
                    String XSITYPE_PREFIX = prefix + ":type=\"";
                    if (i2 + XSITYPE_PREFIX.length() + 2 < risultato.length) {
                        StringBuffer test = new StringBuffer("");
                        contatoreFineAttributo = 0;
                        k = 1;
                        while (i2 + k < risultato.length) {
                            if ((char)risultato[i2 + k] == '\"') {
                                ++contatoreFineAttributo;
                            }
                            test.append((char)risultato[i2 + k]);
                            if (contatoreFineAttributo >= 2) break;
                            ++k;
                        }
                        if (test.toString().startsWith(XSITYPE_PREFIX)) {
                            i2 = i2 + test.toString().length() + 1;
                            continue;
                        }
                    }
                    cleanXML.write(risultato[i2]);
                    ++i2;
                    continue;
                }
                cleanXML.write(risultato[i2]);
                ++i2;
            }
            risultato = cleanXML.toByteArray();
            cleanXML.close();
            return risultato;
        }
        catch (Exception e) {
            this.logger.error((Object)"Utilities.eraserType", (Throwable)e);
            try {
                if (cleanXML != null) {
                    cleanXML.close();
                }
            }
            catch (Exception eis) {
                // empty catch block
            }
            throw new UtilsException("Eliminazione xsi:type per validazione non riuscita " + e.getMessage(), (Throwable)e);
        }
    }

    public void validateWithWsdlLogicoImplementativo(boolean isRichiesta, String soapAction) throws ValidatoreMessaggiApplicativiException {
        String errorMsgValidazioneXSD = null;
        try {
            String portType = this.accordoServizioWrapper.getNomePortType();
            String operation = this.idServizio.getAzione();
            if (operation == null) {
                throw new ValidatoreMessaggiApplicativiException("Azione SPCoop non definita");
            }
            String style = "document";
            String use = "literal";
            PortType portTypeAS = this.accordoServizioWrapper.getPortType(portType);
            if (portTypeAS == null) {
                throw new ValidatoreMessaggiApplicativiException("Port-type [" + portType + "] non esistente nell'accordo di servizio " + this.accordoServizioWrapper.getIdAccordoServizio());
            }
            if (portTypeAS.getStyle() != null && !"".equals(portTypeAS.getStyle()) && "rpc".equals(portTypeAS.getStyle())) {
                style = "rpc";
            }
            if (portTypeAS.sizeAzioneList() <= 0) {
                throw new Exception("operations per il port type [" + portType + "] non presenti");
            }
            boolean matchingNameOperation = false;
            boolean matchingArgomentsOperation = false;
            String soapActionWSDL = null;
            StringBuffer eccezioni = new StringBuffer();
            for (int i = 0; i < portTypeAS.sizeAzioneList(); ++i) {
                int wsdlIndex;
                Message argumentsOperation;
                Operation operationAS = portTypeAS.getAzione(i);
                if (!operationAS.getNome().equals(operation)) continue;
                matchingNameOperation = true;
                Message message = argumentsOperation = isRichiesta ? operationAS.getMessageInput() : operationAS.getMessageOutput();
                if (operationAS.getStyle() != null && !"".equals(operationAS.getStyle())) {
                    if ("rpc".equals(operationAS.getStyle())) {
                        style = "rpc";
                    } else if ("document".equals(operationAS.getStyle())) {
                        style = "document";
                    }
                }
                if (argumentsOperation != null && argumentsOperation.getUse() != null && !"".equals(argumentsOperation.getUse()) && "encoded".equals(argumentsOperation.getUse())) {
                    use = "encoded";
                }
                this.logger.debug((Object)("WSDL, esamino operation[" + operation + "] con style[" + style + "] e use[" + use + "] ..."));
                NodeList nodiContenutoApplicativo = null;
                if ("rpc".equals(style)) {
                    String nomeAtteso = operation;
                    if (!isRichiesta) {
                        nomeAtteso = operation + "Response";
                    }
                    if (!nomeAtteso.equals(this.body.getFirstChild().getLocalName())) {
                        this.logger.debug((Object)("WSDL, esamino operation[" + operation + "] con style[" + style + "] e use[" + use + "]: Root element [" + this.body.getFirstChild().getLocalName() + "] non equivale all'operation name " + nomeAtteso + " (RPC Style)"));
                        continue;
                    }
                    nodiContenutoApplicativo = this.body.getFirstChild().getChildNodes();
                } else {
                    nodiContenutoApplicativo = this.body.getChildNodes();
                }
                int sizeArgumentsOperation = 0;
                if (argumentsOperation != null) {
                    sizeArgumentsOperation = argumentsOperation.sizePartList();
                }
                if (sizeArgumentsOperation != nodiContenutoApplicativo.getLength()) {
                    this.logger.debug((Object)("WSDL, esamino operation[" + operation + "] con style[" + style + "] e use[" + use + "]: Argomenti attesi[" + sizeArgumentsOperation + "], trovati nel body[" + nodiContenutoApplicativo.getLength() + "]"));
                    continue;
                }
                String tipo = "output";
                if (isRichiesta) {
                    tipo = "input";
                }
                if (argumentsOperation == null || argumentsOperation.sizePartList() <= 0) continue;
                Vector<String> elementRootBody = new Vector<String>();
                StringBuffer bodyElements = new StringBuffer();
                int numeroBodyElements = 0;
                for (int indexBody = 0; indexBody < nodiContenutoApplicativo.getLength(); ++indexBody) {
                    String argomentoPresenteBody = nodiContenutoApplicativo.item(indexBody).getLocalName();
                    elementRootBody.add(argomentoPresenteBody);
                    if (indexBody > 0) {
                        bodyElements.append(",");
                    }
                    bodyElements.append(argomentoPresenteBody);
                }
                numeroBodyElements = elementRootBody.size();
                int soapBodyArguments = nodiContenutoApplicativo.getLength();
                for (wsdlIndex = 0; wsdlIndex < argumentsOperation.sizePartList(); ++wsdlIndex) {
                    if (wsdlIndex == soapBodyArguments) {
                        this.logger.debug((Object)("WSDL, esamino operation[" + operation + "] con style[" + style + "] e use[" + use + "]: Pi\u00f9 oggetti definiti nel WSDL di quanti ce ne siano nel messaggio"));
                        continue;
                    }
                    MessagePart argument = argumentsOperation.getPart(wsdlIndex);
                    String argomentoAtteso = argument.getElementName();
                    boolean find = false;
                    for (int indexBody = 0; indexBody < elementRootBody.size(); ++indexBody) {
                        if (!((String)elementRootBody.get(indexBody)).equals(argomentoAtteso)) continue;
                        find = true;
                        elementRootBody.remove(indexBody);
                    }
                    if (find) continue;
                    eccezioni.append("\nParametro di " + tipo + " '" + argomentoAtteso + "' richiesto nel wsdl ma non presente nei root-element (" + numeroBodyElements + ") presenti nel body: " + bodyElements);
                    this.logger.debug((Object)("WSDL, esamino operation[" + operation + "] con style[" + style + "] e use[" + use + "]: Atteso " + argomentoAtteso + " body " + bodyElements));
                    break;
                }
                if (wsdlIndex != soapBodyArguments) continue;
                soapActionWSDL = operationAS.getSoapAction();
                matchingArgomentsOperation = true;
            }
            if (!matchingArgomentsOperation) {
                if (matchingNameOperation) {
                    if (eccezioni.length() > 0) {
                        throw new ValidatoreMessaggiApplicativiException("Operazione [" + operation + "] del port-type [" + portType + "] (AccordoServizio:" + this.accordoServizioWrapper.getIdAccordoServizio() + "), con argomenti non conformi alla definizione wsdl: " + eccezioni.toString());
                    }
                    throw new ValidatoreMessaggiApplicativiException("Operazione [" + operation + "] del port-type [" + portType + "] (AccordoServizio:" + this.accordoServizioWrapper.getIdAccordoServizio() + "), con argomenti non conformi alla definizione wsdl");
                }
                throw new ValidatoreMessaggiApplicativiException("Operazione [" + operation + "] non presente nel port-type [" + portType + "] (AccordoServizio:" + this.accordoServizioWrapper.getIdAccordoServizio() + ").");
            }
            if (isRichiesta && soapActionWSDL != null) {
                this.logger.debug((Object)"CheckSOAPAction");
                String soapActionRipulita = null;
                if (soapAction != null) {
                    soapActionRipulita = soapAction.trim();
                    if (soapActionRipulita.startsWith("\"")) {
                        soapActionRipulita = soapActionRipulita.substring(1);
                    }
                    if (soapActionRipulita.endsWith("\"")) {
                        soapActionRipulita = soapActionRipulita.substring(0, soapActionRipulita.length() - 1);
                    }
                }
                if (!soapActionWSDL.equalsIgnoreCase(soapActionRipulita)) {
                    throw new ValidatoreMessaggiApplicativiException("Operazione [" + operation + "] del port-type [" + portType + "] con soap action [" + soapActionRipulita + "] che non rispetta quella indicata nel wsdl: " + soapActionWSDL);
                }
            }
        }
        catch (Exception e) {
            this.logger.error((Object)("Validazione WSDL (" + isRichiesta + ") fallita: " + e.getMessage()), (Throwable)e);
            if (!(e instanceof ValidatoreMessaggiApplicativiException)) {
                this.logger.debug((Object)"Validazione WSDL fallita", (Throwable)e);
            }
            errorMsgValidazioneXSD = isRichiesta ? "Validazione WSDL del contenuto della richiesta fallita: " + e.getMessage() : "Validazione WSDL del contenuto della risposta fallita: " + e.getMessage();
        }
        if (errorMsgValidazioneXSD != null) {
            ValidatoreMessaggiApplicativiException ex = new ValidatoreMessaggiApplicativiException(errorMsgValidazioneXSD);
            if (isRichiesta) {
                ex.setCodiceErrore("OPENSPCOOP_ORG_418");
                if (this.accordoServizioWrapper.isCorrelato()) {
                    ex.setMsgErrore(ValidatoreMessaggiApplicativi.replaceWithFruitore("Il contenuto applicativo del messaggio di richiesta non rispetta l'accordo di servizio (TIPO_WSDL) definito nel Registro dei Servizi"));
                } else {
                    ex.setMsgErrore(ValidatoreMessaggiApplicativi.replaceWithErogatore("Il contenuto applicativo del messaggio di richiesta non rispetta l'accordo di servizio (TIPO_WSDL) definito nel Registro dei Servizi"));
                }
            } else {
                ex.setCodiceErrore("OPENSPCOOP_ORG_419");
                if (this.accordoServizioWrapper.isCorrelato()) {
                    ex.setMsgErrore(ValidatoreMessaggiApplicativi.replaceWithFruitore("Il contenuto applicativo del messaggio di risposta non rispetta l'accordo di servizio (TIPO_WSDL) definito nel Registro dei Servizi"));
                } else {
                    ex.setMsgErrore(ValidatoreMessaggiApplicativi.replaceWithErogatore("Il contenuto applicativo del messaggio di risposta non rispetta l'accordo di servizio (TIPO_WSDL) definito nel Registro dei Servizi"));
                }
            }
            throw ex;
        }
    }
}

