/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop.pdd.core;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.Statement;
import org.apache.axis.Message;
import org.apache.axis.soap.SOAP11Constants;
import org.apache.axis.soap.SOAPConstants;
import org.apache.log4j.Logger;
import org.openspcoop.dao.state.StateMessage;
import org.openspcoop.pdd.core.state.IOpenSPCoopState;
import org.openspcoop.pdd.core.state.OpenSPCoopStateful;
import org.openspcoop.pdd.core.state.OpenSPCoopStateless;
import org.openspcoop.utils.SoapUtils;
import org.openspcoop.utils.Utilities;
import org.openspcoop.utils.UtilsException;
import org.openspcoop.utils.jdbc.IJDBCAdapter;

public class SoapMessage
implements Serializable {
    private static final long serialVersionUID = 1L;
    private Logger log = null;
    private String idMessaggio;
    private String box;
    private boolean saveOnFS;
    private String keyMsg;
    private String workDir;
    private IJDBCAdapter adapter;
    private IOpenSPCoopState openspcoopstate;

    public SoapMessage(String idMsg, IOpenSPCoopState openspcoopstate, String box, String workDir, Logger alog) throws UtilsException {
        this(idMsg, openspcoopstate, box, workDir, null, alog);
    }

    public SoapMessage(String idMsg, IOpenSPCoopState openspcoopstate, String box, IJDBCAdapter adapterJDBC, Logger alog) throws UtilsException {
        this(idMsg, openspcoopstate, box, null, adapterJDBC, alog);
    }

    public SoapMessage(String idMsg, IOpenSPCoopState openspcoopstate, String box, String workDir, IJDBCAdapter adapterJDBC, Logger alog) throws UtilsException {
        this.idMessaggio = idMsg;
        this.box = box;
        this.openspcoopstate = openspcoopstate;
        this.log = alog != null ? alog : Logger.getLogger((String)"SoapMessage");
        try {
            this.keyMsg = Utilities.hash((String)idMsg);
            if (this.keyMsg == null) {
                throw new Exception("Codifica hash non riuscita: keyMsg is null");
            }
        }
        catch (Exception e) {
            String errorMsg = "SOAP_MESSAGE, costructor error (CodificaHash): " + box + "/" + idMsg + ": " + e.getMessage();
            this.log.error((Object)errorMsg);
            throw new UtilsException(errorMsg, (Throwable)e);
        }
        if (adapterJDBC == null) {
            this.saveOnFS = true;
            this.workDir = workDir;
        } else {
            this.saveOnFS = false;
            this.adapter = adapterJDBC;
        }
    }

    public String getBaseDir() throws UtilsException {
        File dir = new File(this.workDir);
        if (!dir.exists()) {
            String errorMsg = "SOAP_MESSAGE, getBaseDir: " + this.box + "/" + this.idMessaggio + ": directory di lavoro inesistente (" + this.workDir + ").";
            this.log.error((Object)errorMsg);
            throw new UtilsException(errorMsg);
        }
        String baseDir = this.workDir;
        if (!baseDir.endsWith(File.separator)) {
            baseDir = baseDir + File.separator;
        }
        if ("INBOX".equals(this.box)) {
            baseDir = baseDir + "INBOX";
        } else if ("OUTBOX".equals(this.box)) {
            baseDir = baseDir + "OUTBOX";
        } else {
            String errorMsg = "SOAP_MESSAGE, getBaseDir: " + this.box + "/" + this.idMessaggio + ": box non valido? .";
            this.log.error((Object)errorMsg);
            throw new UtilsException(errorMsg);
        }
        File dirINOUT = new File(baseDir);
        if (!dirINOUT.exists() && !dirINOUT.mkdir()) {
            String errorMsg = "SOAP_MESSAGE, getBaseDir: " + this.box + "/" + this.idMessaggio + ": directory di lavoro (" + this.workDir + ") non permette la creazione di sottodirectory INBOX/OUTBOX.";
            this.log.error((Object)errorMsg);
            throw new UtilsException(errorMsg);
        }
        return baseDir + File.separator;
    }

    public String getIdMessaggio() {
        return this.idMessaggio;
    }

    public void updateState(IOpenSPCoopState openspcoopstate) {
        this.openspcoopstate = openspcoopstate;
    }

    public void save(Message msg, boolean isRichiesta, boolean portaDiTipoStateless) throws UtilsException {
        String soapAction = null;
        try {
            soapAction = SoapUtils.getSoapAction((Message)msg);
        }
        catch (Exception e) {
            String errorMsg = "SOAP_MESSAGE, save (soapAction): " + this.box + "/" + this.idMessaggio + ": " + e.getMessage();
            this.log.error((Object)errorMsg);
            throw new UtilsException(errorMsg, (Throwable)e);
        }
        if (!portaDiTipoStateless) {
            StateMessage stateMsg = isRichiesta ? (StateMessage)this.openspcoopstate.getStatoRichiesta() : (StateMessage)this.openspcoopstate.getStatoRisposta();
            Connection connectionDB = stateMsg.getConnectionDB();
            Statement pstmt = null;
            try {
                StringBuffer query = new StringBuffer();
                query.append("INSERT INTO  ");
                query.append("DEFINIZIONE_MESSAGGI");
                if (this.saveOnFS) {
                    query.append(" (ID_EGOV,TIPO,SOAP_ACTION,CONTENT_TYPE,CONTENT_LOCATION) VALUES ( ? , ? , ? , ? , ?)");
                } else {
                    query.append(" (ID_EGOV,TIPO,SOAP_ACTION,CONTENT_TYPE,CONTENT_LOCATION,MSG_BYTES) VALUES ( ? , ? , ? , ? , ? , ?)");
                }
                pstmt = connectionDB.prepareStatement(query.toString());
                pstmt.setString(1, this.idMessaggio);
                if ("INBOX".equals(this.box)) {
                    pstmt.setString(2, "INBOX");
                } else {
                    pstmt.setString(2, "OUTBOX");
                }
                pstmt.setString(3, soapAction);
                pstmt.setString(4, msg.getContentType((SOAPConstants)new SOAP11Constants()));
                pstmt.setString(5, msg.getSOAPPart().getContentLocation());
                if (this.saveOnFS) {
                    String saveDir = this.getBaseDir();
                    if (saveDir == null) {
                        String errorMsg = "WorkDir non correttamente inizializzata";
                        throw new UtilsException(errorMsg);
                    }
                    String path = saveDir + this.keyMsg;
                    SoapUtils.saveAxisMessage((String)path, (Message)msg);
                } else {
                    ByteArrayOutputStream msgByte = new ByteArrayOutputStream();
                    msg.writeTo((OutputStream)msgByte);
                    msgByte.flush();
                    msgByte.close();
                    this.adapter.setBinaryData((PreparedStatement)pstmt, 6, msgByte.toByteArray());
                }
                stateMsg.getPreparedStatement().put("INSERT SaveMessage[" + this.keyMsg + "," + this.box + "]", pstmt);
            }
            catch (Exception e) {
                try {
                    if (pstmt != null) {
                        pstmt.close();
                    }
                }
                catch (Exception err) {
                    // empty catch block
                }
                String errorMsg = "SOAP_MESSAGE, save : " + this.box + "/" + this.idMessaggio + ": " + e.getMessage();
                this.log.error((Object)errorMsg, (Throwable)e);
                throw new UtilsException(errorMsg, (Throwable)e);
            }
        }
        if (portaDiTipoStateless) {
            try {
                if (soapAction != null) {
                    msg.setProperty("SOAPAction", (Object)soapAction);
                }
            }
            catch (Exception e) {
                String errorMsg = "SOAP_MESSAGE, set (soapAction): " + this.box + "/" + this.idMessaggio + ": " + e.getMessage();
                this.log.error((Object)errorMsg);
                throw new UtilsException(errorMsg, (Throwable)e);
            }
            if (isRichiesta) {
                ((OpenSPCoopStateless)this.openspcoopstate).setRichiestaMsg(msg);
            } else {
                ((OpenSPCoopStateless)this.openspcoopstate).setRispostaMsg(msg);
            }
        } else {
            throw new UtilsException("Metodo invocato con OpenSPCoopState non valido");
        }
    }

    public Message read(boolean isRichiesta, boolean portaDiTipoStateless) throws UtilsException {
        if (!portaDiTipoStateless) {
            Connection connectionDB = isRichiesta ? ((StateMessage)this.openspcoopstate.getStatoRichiesta()).getConnectionDB() : ((StateMessage)this.openspcoopstate.getStatoRisposta()).getConnectionDB();
            Message msg = null;
            Statement pstmt = null;
            InputStream is = null;
            ResultSet rs = null;
            try {
                StringBuffer query = new StringBuffer();
                if (this.saveOnFS) {
                    query.append("select SOAP_ACTION,CONTENT_TYPE,CONTENT_LOCATION ");
                } else {
                    query.append("select SOAP_ACTION,CONTENT_TYPE,CONTENT_LOCATION,MSG_BYTES ");
                }
                query.append("from ");
                query.append("DEFINIZIONE_MESSAGGI");
                query.append(" WHERE ID_EGOV = ? AND TIPO = ?");
                pstmt = connectionDB.prepareStatement(query.toString());
                pstmt.setString(1, this.idMessaggio);
                if ("INBOX".equals(this.box)) {
                    pstmt.setString(2, "INBOX");
                } else {
                    pstmt.setString(2, "OUTBOX");
                }
                rs = pstmt.executeQuery();
                if (rs == null) {
                    String errorMsg = "ResultSet is null?";
                    throw new UtilsException(errorMsg);
                }
                if (!rs.next()) {
                    String errorMsg = "Messaggio non esistente";
                    throw new UtilsException(errorMsg);
                }
                String contentType = rs.getString("CONTENT_TYPE");
                String contentLocation = rs.getString("CONTENT_LOCATION");
                if (this.saveOnFS) {
                    String saveDir = this.getBaseDir();
                    if (saveDir == null) {
                        String errorMsg = "WorkDir non correttamente inizializzata";
                        throw new UtilsException(errorMsg);
                    }
                    String path = saveDir + this.keyMsg;
                    File fileCheck = new File(path);
                    if (!fileCheck.exists()) {
                        String errorMsg = "Il messaggio non risulta gia' registrato (" + path + ").";
                        throw new UtilsException(errorMsg);
                    }
                    is = new FileInputStream(path);
                } else {
                    is = new ByteArrayInputStream(this.adapter.getBinaryData(rs, 4));
                }
                msg = new Message((Object)is, false, contentType, contentLocation);
                try {
                    String soapAction = rs.getString("SOAP_ACTION");
                    if (soapAction != null) {
                        msg.setProperty("SOAPAction", (Object)soapAction);
                    }
                }
                catch (Exception e) {
                    throw new UtilsException(e.getMessage(), (Throwable)e);
                }
                rs.close();
                pstmt.close();
            }
            catch (Exception e) {
                try {
                    if (rs != null) {
                        rs.close();
                    }
                }
                catch (Exception er) {
                    // empty catch block
                }
                try {
                    if (pstmt != null) {
                        pstmt.close();
                    }
                }
                catch (Exception er) {
                    // empty catch block
                }
                try {
                    if (is != null) {
                        is.close();
                    }
                }
                catch (Exception er) {
                    // empty catch block
                }
                String errorMsg = "SOAP_MESSAGE, read: " + this.box + "/" + this.idMessaggio + ": " + e.getMessage();
                this.log.error((Object)errorMsg, (Throwable)e);
                throw new UtilsException(errorMsg, (Throwable)e);
            }
            return msg;
        }
        if (portaDiTipoStateless) {
            if (isRichiesta) {
                return ((OpenSPCoopStateless)this.openspcoopstate).getRichiestaMsg();
            }
            return ((OpenSPCoopStateless)this.openspcoopstate).getRispostaMsg();
        }
        throw new UtilsException("Metodo invocato con IState non valido");
    }

    public void delete(boolean isRichiesta, boolean onewayVersione11) throws UtilsException {
        if (this.openspcoopstate instanceof OpenSPCoopStateful || onewayVersione11) {
            StateMessage stateMSG = isRichiesta ? (StateMessage)this.openspcoopstate.getStatoRichiesta() : (StateMessage)this.openspcoopstate.getStatoRisposta();
            Connection connectionDB = stateMSG.getConnectionDB();
            Statement pstmt = null;
            try {
                if (this.saveOnFS) {
                    String saveDir = this.getBaseDir();
                    if (saveDir == null) {
                        String errorMsg = "WorkDir non correttamente inizializzata";
                        throw new UtilsException(errorMsg);
                    }
                    String path = saveDir + this.keyMsg;
                    File fileDelete = new File(path);
                    if (fileDelete.exists()) {
                        fileDelete.delete();
                    }
                }
                StringBuffer query = new StringBuffer();
                query.append("DELETE from ");
                query.append("DEFINIZIONE_MESSAGGI");
                query.append(" WHERE ID_EGOV = ? AND TIPO = ?");
                pstmt = connectionDB.prepareStatement(query.toString());
                pstmt.setString(1, this.idMessaggio);
                if ("INBOX".equals(this.box)) {
                    pstmt.setString(2, "INBOX");
                } else {
                    pstmt.setString(2, "OUTBOX");
                }
                pstmt.execute();
                pstmt.close();
            }
            catch (Exception e) {
                try {
                    if (pstmt != null) {
                        pstmt.close();
                    }
                }
                catch (Exception er) {
                    // empty catch block
                }
                String errorMsg = "SOAP_MESSAGE, delete: " + this.box + "/" + this.idMessaggio + ": " + e.getMessage();
                this.log.error((Object)errorMsg, (Throwable)e);
                throw new UtilsException(errorMsg, (Throwable)e);
            }
        }
        if (!(this.openspcoopstate instanceof OpenSPCoopStateless)) {
            throw new UtilsException("Metodo invocato con IState non valido");
        }
    }

    public void deleteMessageFromFileSystem() {
        try {
            if (this.saveOnFS) {
                String saveDir = this.getBaseDir();
                if (saveDir == null) {
                    String errorMsg = "WorkDir non correttamente inizializzata";
                    throw new UtilsException(errorMsg);
                }
                String path = saveDir + this.keyMsg;
                File fileDelete = new File(path);
                if (fileDelete.exists()) {
                    fileDelete.delete();
                }
            }
        }
        catch (Exception e) {
            String errorMsg = "SOAP_MESSAGE, deleteMessageFromFileSystem: " + this.box + "/" + this.idMessaggio + ": " + e.getMessage();
            this.log.error((Object)errorMsg, (Throwable)e);
        }
    }
}

