/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop.pdd.core;

import java.io.Serializable;
import java.util.Enumeration;
import java.util.Properties;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageProducer;
import javax.jms.ObjectMessage;
import javax.jms.Queue;
import org.apache.log4j.Logger;
import org.openspcoop.pdd.config.JMSObject;
import org.openspcoop.pdd.config.QueueManager;
import org.openspcoop.pdd.config.Resource;

public class JMSSender {
    private QueueManager qmanager;
    private String idModulo = null;
    private String codicePorta = null;
    private String errore;
    private Logger log;

    public JMSSender(String aCodicePorta, String aIDModulo, Logger log) throws Exception {
        this.codicePorta = aCodicePorta;
        this.idModulo = "JMSSender." + aIDModulo;
        this.qmanager = QueueManager.getInstance();
        this.log = log;
    }

    public boolean send(String destinatario, Serializable objectToSend, String idEGov) {
        Properties prop = new Properties();
        prop.put("ID", idEGov);
        return this.send(destinatario, objectToSend, prop);
    }

    public boolean send(String destinatario, Serializable objectToSend, Properties properties) {
        Resource resource = null;
        MessageProducer sender = null;
        try {
            if (destinatario == null) {
                return true;
            }
            JMSObject jmsObject = null;
            try {
                resource = this.qmanager.getResource(this.codicePorta, this.idModulo);
                if (resource == null) {
                    throw new JMSException("Resource is null");
                }
                if (resource.getResource() == null) {
                    throw new JMSException("JMSObject is null");
                }
                jmsObject = (JMSObject)resource.getResource();
                if (jmsObject.getConnection() == null) {
                    throw new Exception("Connessione is null");
                }
                if (jmsObject.getSession() == null) {
                    throw new Exception("Sessione is null");
                }
            }
            catch (Exception e) {
                this.log.error((Object)("JMSObject non ottenibile dal Pool: " + e.getMessage()), (Throwable)e);
                this.errore = "JMSObject non ottenibile dal Pool: " + e.getMessage();
                return false;
            }
            Queue queue = this.qmanager.getQueue(destinatario);
            if (queue == null) {
                this.qmanager.releaseResource(this.codicePorta, this.idModulo, resource);
                this.errore = "La coda [" + destinatario + "] non e' tra quelle registrate per OpenSPCoop";
                return false;
            }
            try {
                sender = jmsObject.getSession().createProducer((Destination)queue);
            }
            catch (JMSException e) {
                this.qmanager.releaseResource(this.codicePorta, this.idModulo, resource);
                this.log.error((Object)("Riscontrato errore durante la creazione del sender [" + destinatario + "] :" + e.getMessage()), (Throwable)e);
                this.errore = "Riscontrato errore durante la creazione del sender [" + destinatario + "] :" + e.getMessage();
                return false;
            }
            ObjectMessage message = jmsObject.getSession().createObjectMessage(objectToSend);
            Enumeration<?> en = properties.propertyNames();
            while (en.hasMoreElements()) {
                String key = (String)en.nextElement();
                String value = properties.getProperty(key);
                if ("true".equalsIgnoreCase(value)) {
                    message.setBooleanProperty(key, true);
                    continue;
                }
                if ("false".equalsIgnoreCase(value)) {
                    message.setBooleanProperty(key, false);
                    continue;
                }
                Long testLong = null;
                try {
                    testLong = new Long(value);
                }
                catch (Exception e) {
                    testLong = null;
                }
                if (testLong != null) {
                    message.setLongProperty(key, testLong.longValue());
                    continue;
                }
                message.setStringProperty(key, value);
            }
            sender.send((Message)message);
            sender.close();
            this.qmanager.releaseResource(this.codicePorta, this.idModulo, resource);
            return true;
        }
        catch (Exception e) {
            try {
                if (sender != null) {
                    sender.close();
                }
            }
            catch (Exception eClose) {
                // empty catch block
            }
            if (resource != null) {
                try {
                    this.qmanager.releaseResource(this.codicePorta, this.idModulo, resource);
                }
                catch (Exception eClose) {
                    // empty catch block
                }
            }
            this.log.error((Object)("Riscontrato errore durante la creazione/spedizione dell'oggetto :" + e.getMessage()), (Throwable)e);
            this.errore = "Riscontrato errore durante la creazione/spedizione dell'oggetto :" + e.getMessage();
            return false;
        }
    }

    public String getErrore() {
        return this.errore;
    }
}

