/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop.pdd.core;

import java.io.ByteArrayOutputStream;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Random;
import java.util.Vector;
import org.apache.axis.Message;
import org.apache.axis.encoding.Base64;
import org.apache.jcs.JCS;
import org.apache.jcs.access.exception.CacheException;
import org.apache.jcs.engine.behavior.ICompositeCacheAttributes;
import org.apache.jcs.engine.behavior.IElementAttributes;
import org.apache.log4j.Logger;
import org.openspcoop.dao.commons.IDSoggetto;
import org.openspcoop.dao.config.driver.DriverConfigurazioneException;
import org.openspcoop.dao.state.IState;
import org.openspcoop.dao.state.StateMessage;
import org.openspcoop.dao.state.StatefulMessage;
import org.openspcoop.egov.Busta;
import org.openspcoop.egov.Configurazione;
import org.openspcoop.egov.EGovException;
import org.openspcoop.egov.IGestoreRepositoryEGov;
import org.openspcoop.egov.ProfiloDiCollaborazione;
import org.openspcoop.egov.RepositoryEGov;
import org.openspcoop.egov.Riscontri;
import org.openspcoop.egov.RollbackRepositoryEGov;
import org.openspcoop.pdd.config.ClassNameProperties;
import org.openspcoop.pdd.config.OpenSPCoopProperties;
import org.openspcoop.pdd.core.GestoreMessaggiException;
import org.openspcoop.pdd.core.IPdDContextSerializer;
import org.openspcoop.pdd.core.JMSReceiver;
import org.openspcoop.pdd.core.PdDContext;
import org.openspcoop.pdd.core.SoapMessage;
import org.openspcoop.pdd.core.state.IOpenSPCoopState;
import org.openspcoop.pdd.core.state.OpenSPCoopStateful;
import org.openspcoop.pdd.core.state.OpenSPCoopStateless;
import org.openspcoop.pdd.logger.MsgDiagnostico;
import org.openspcoop.pdd.logger.OpenSPCoopLogger;
import org.openspcoop.utils.Loader;
import org.openspcoop.utils.UtilsException;
import org.openspcoop.utils.date.DateManager;
import org.openspcoop.utils.jdbc.IJDBCAdapter;
import org.openspcoop.utils.sql.ISQLQueryObject;
import org.openspcoop.utils.sql.SQLObjectFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GestoreMessaggi {
    private Logger log = null;
    private IOpenSPCoopState openspcoopstate = null;
    private boolean isRichiesta = false;
    private boolean readyForDrop = false;
    private boolean portaDiTipoStateless = false;
    private boolean routingStateless;
    private boolean oneWayVersione11 = false;
    public static final String MESSAGGI = "MESSAGGI";
    public static final String MSG_SERVIZI_APPLICATIVI = "MSG_SERVIZI_APPLICATIVI";
    public static final String DEFINIZIONE_MESSAGGI = "DEFINIZIONE_MESSAGGI";
    public static final String CONSEGNA_TRAMITE_CONNETTORE = "Connettore";
    public static final String CONSEGNA_TRAMITE_CONNECTION_REPLY = "ConnectionReply";
    public static final String CONSEGNA_TRAMITE_INTEGRATION_MANAGER = "IntegrationManager";
    private MsgDiagnostico msgDiag;
    private String idEGov;
    private String workDir;
    private String tipo;
    private IJDBCAdapter adapter = null;
    private OpenSPCoopProperties propertiesReader;
    private IPdDContextSerializer pddContextSerializer = null;
    private static final String GESTORE_MESSAGGI_CACHE_NAME = "gestoreMessaggi";
    private static JCS cacheMappingGestoreMessaggi = null;
    private static String cluster_id = null;
    private Hashtable<String, String> tableProprietariMessaggiGestiti;
    private Hashtable<String, Boolean> tableMessaggiGestiti;
    public static final String NUMERO_RISPEDIZIONE = "[spedizione n.";

    public static void resetCache() throws GestoreMessaggiException {
        if (cacheMappingGestoreMessaggi != null) {
            try {
                cacheMappingGestoreMessaggi.clear();
            }
            catch (Exception e) {
                throw new GestoreMessaggiException(e.getMessage(), e);
            }
        }
    }

    public static void abilitaCache() throws GestoreMessaggiException {
        if (cacheMappingGestoreMessaggi != null) {
            throw new GestoreMessaggiException("Cache gia' abilitata");
        }
        try {
            cacheMappingGestoreMessaggi = JCS.getInstance((String)GESTORE_MESSAGGI_CACHE_NAME);
        }
        catch (Exception e) {
            throw new GestoreMessaggiException(e.getMessage(), e);
        }
    }

    public static void abilitaCache(long dimensioneCache, boolean algoritmoCacheLRU, long itemIdleTime, long itemLifeSecond) throws GestoreMessaggiException {
        if (cacheMappingGestoreMessaggi != null) {
            throw new GestoreMessaggiException("Cache gia' abilitata");
        }
        try {
            String algoritmoCache = null;
            algoritmoCache = algoritmoCacheLRU ? "lru" : "mru";
            GestoreMessaggi.initCacheGestoreMessaggi((int)dimensioneCache, algoritmoCache, itemIdleTime, itemLifeSecond, null, null);
        }
        catch (Exception e) {
            throw new GestoreMessaggiException(e.getMessage(), e);
        }
    }

    public static void disabilitaCache() throws GestoreMessaggiException {
        if (cacheMappingGestoreMessaggi == null) {
            throw new GestoreMessaggiException("Cache gia' disabilitata");
        }
        try {
            cacheMappingGestoreMessaggi.clear();
            cacheMappingGestoreMessaggi = null;
        }
        catch (Exception e) {
            throw new GestoreMessaggiException(e.getMessage(), e);
        }
    }

    public static boolean isCacheAbilitata() {
        return cacheMappingGestoreMessaggi != null;
    }

    public static void initialize() throws Exception {
        OpenSPCoopProperties properties = OpenSPCoopProperties.getInstance();
        if (properties.isAbilitataCacheGestoreMessaggi()) {
            Logger log = OpenSPCoopLogger.getLoggerOpenSPCoopCore();
            Logger logConsole = OpenSPCoopLogger.getLoggerOpenSPCoopConsole();
            int dimensioneCache = properties.getDimensioneCacheGestoreMessaggi();
            String algoritmoCache = properties.getAlgoritmoCacheGestoreMessaggi();
            long itemIdleTime = properties.getItemIdleTimeCacheGestoreMessaggi();
            long itemLifeSecond = properties.getItemLifeSecondCacheGestoreMessaggi();
            GestoreMessaggi.initCacheGestoreMessaggi(dimensioneCache, algoritmoCache, itemIdleTime, itemLifeSecond, log, logConsole);
        }
    }

    public static void initCacheGestoreMessaggi(int dimensioneCache, String algoritmoCache, long itemIdleTime, long itemLifeSecond, Logger log, Logger logConsole) throws Exception {
        if (log != null) {
            log.info((Object)"Inizializzazione cache gestoreMessaggi");
        }
        if (logConsole != null) {
            logConsole.info((Object)"Inizializzazione cache gestoreMessaggi");
        }
        cacheMappingGestoreMessaggi = JCS.getInstance((String)GESTORE_MESSAGGI_CACHE_NAME);
        String msg = null;
        if (dimensioneCache > 0 || algoritmoCache != null) {
            ICompositeCacheAttributes cacheAttr = cacheMappingGestoreMessaggi.getCacheAttributes();
            if (dimensioneCache > 0) {
                try {
                    msg = "Dimensione della cache (Gestore Messaggi) impostata al valore: " + dimensioneCache;
                    if (log != null) {
                        log.info((Object)msg);
                    }
                    if (logConsole != null) {
                        logConsole.info((Object)msg);
                    }
                    cacheAttr.setMaxObjects(dimensioneCache);
                }
                catch (Exception error) {
                    throw new DriverConfigurazioneException("Parametro errato per la dimensione della cache (Gestore Messaggi): " + error.getMessage());
                }
            }
            if (algoritmoCache != null) {
                msg = "Algoritmo di cache (Gestore Messaggi) impostato al valore: " + algoritmoCache;
                if (log != null) {
                    log.info((Object)msg);
                }
                if (logConsole != null) {
                    logConsole.info((Object)msg);
                }
                if ("mru".equalsIgnoreCase(algoritmoCache)) {
                    cacheAttr.setCacheName("org.apache.jcs.engine.memory.mru.MRUMemoryCache");
                } else {
                    cacheAttr.setCacheName("org.apache.jcs.engine.memory.lru.LRUMemoryCache");
                }
            }
            cacheMappingGestoreMessaggi.setCacheAttributes(cacheAttr);
        }
        if (itemIdleTime > 0L || itemLifeSecond > 0L) {
            IElementAttributes elemAttr = cacheMappingGestoreMessaggi.getDefaultElementAttributes();
            if (itemIdleTime > 0L) {
                try {
                    msg = "Attributo 'IdleTime' (Gestore Messaggi) impostato al valore: " + itemIdleTime;
                    if (log != null) {
                        log.info((Object)msg);
                    }
                    if (logConsole != null) {
                        logConsole.info((Object)msg);
                    }
                    elemAttr.setIdleTime(itemIdleTime);
                }
                catch (Exception error) {
                    throw new DriverConfigurazioneException("Parametro errato per l'attributo 'IdleTime' (Gestore Messaggi): " + error.getMessage());
                }
            }
            if (itemLifeSecond > 0L) {
                try {
                    msg = "Attributo 'MaxLifeSecond' (Gestore Messaggi) impostato al valore: " + itemLifeSecond;
                    if (log != null) {
                        log.info((Object)msg);
                    }
                    if (logConsole != null) {
                        logConsole.info((Object)msg);
                    }
                    elemAttr.setMaxLifeSeconds(itemLifeSecond);
                }
                catch (Exception error) {
                    throw new DriverConfigurazioneException("Parametro errato per l'attributo 'MaxLifeSecond' (Gestore Messaggi): " + error.getMessage());
                }
            }
            cacheMappingGestoreMessaggi.setDefaultElementAttributes(elemAttr);
        }
    }

    public static String cacheToString() {
        if (cacheMappingGestoreMessaggi != null) {
            StringBuffer bf = new StringBuffer();
            bf.append("Cache GestoreMessaggi: " + cacheMappingGestoreMessaggi.getStats());
            return bf.toString();
        }
        return "Cache non abilitata";
    }

    public static void addIntoCache_MappingRifMsgToId(MsgDiagnostico msgDiag, String tipoMessaggio, String riferimentoMessaggio, String idEGov) throws CacheException {
        if (cacheMappingGestoreMessaggi != null) {
            String key = "mappingRifMsgToId_" + tipoMessaggio + "_" + riferimentoMessaggio;
            cacheMappingGestoreMessaggi.put((Object)key, (Object)idEGov);
        }
    }

    public static String getFromCache_idFromRifMsgMapping(String tipoMessaggio, String riferimentoMessaggio) {
        if (cacheMappingGestoreMessaggi != null) {
            Object obj = cacheMappingGestoreMessaggi.get((Object)("mappingRifMsgToId_" + tipoMessaggio + "_" + riferimentoMessaggio));
            if (obj != null) {
                return (String)obj;
            }
            return null;
        }
        return null;
    }

    public static void deleteFromCache_idFromRifMsgMapping(String tipoMessaggio, String riferimentoMessaggio) {
        if (cacheMappingGestoreMessaggi != null) {
            String key = "mappingRifMsgToId_" + tipoMessaggio + "_" + riferimentoMessaggio;
            try {
                cacheMappingGestoreMessaggi.remove((Object)key);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public static void addIntoCache_Proprietario(MsgDiagnostico msgDiag, String tipoMessaggio, String idEGov, String proprietario) throws CacheException {
        if (cacheMappingGestoreMessaggi != null) {
            String prop = proprietario;
            if (prop.startsWith("RicezioneContenutiApplicativi")) {
                prop = "RicezioneContenutiApplicativi";
            } else if (prop.startsWith("RicezioneBusteEGov")) {
                prop = "RicezioneBusteEGov";
            }
            String key = "proprietario_to" + prop + "_(" + tipoMessaggio + "_" + idEGov + ")";
            cacheMappingGestoreMessaggi.put((Object)key, (Object)proprietario);
        }
    }

    public static String getFromCache_Proprietario(String idModulo, String tipoMessaggio, String idEGov) {
        if (cacheMappingGestoreMessaggi != null) {
            String prop = idModulo;
            if (prop.startsWith("RicezioneContenutiApplicativi")) {
                prop = "RicezioneContenutiApplicativi";
            } else if (prop.startsWith("RicezioneBusteEGov")) {
                prop = "RicezioneBusteEGov";
            }
            String key = "proprietario_to" + prop + "_(" + tipoMessaggio + "_" + idEGov + ")";
            Object obj = cacheMappingGestoreMessaggi.get((Object)key);
            if (obj != null) {
                return (String)obj;
            }
            return null;
        }
        return null;
    }

    public static void deleteFromCache_Proprietario(String modulo, String tipoMessaggio, String idEGov) {
        if (cacheMappingGestoreMessaggi != null) {
            String key = "proprietario_to" + modulo + "_(" + tipoMessaggio + "_" + idEGov + ")";
            try {
                cacheMappingGestoreMessaggi.remove((Object)key);
            }
            catch (Exception e) {
                // empty catch block
            }
        }
    }

    public static void addIntoCache_existsMessage(MsgDiagnostico msgDiag, String tipoMessaggio, String idEGov) throws CacheException {
        if (cacheMappingGestoreMessaggi != null) {
            String key = "existsMessage_" + tipoMessaggio + "_" + idEGov;
            cacheMappingGestoreMessaggi.put((Object)key, (Object)true);
        }
    }

    public static boolean getFromCache_existsMessage(String tipoMessaggio, String idEGov) {
        if (cacheMappingGestoreMessaggi != null) {
            Object obj = cacheMappingGestoreMessaggi.get((Object)("existsMessage_" + tipoMessaggio + "_" + idEGov));
            if (obj != null) {
                return (Boolean)obj;
            }
            return false;
        }
        return false;
    }

    public static void deleteFromCache_existsMessage(String tipoMessaggio, String idEGov) {
        if (cacheMappingGestoreMessaggi != null) {
            String key = "existsMessage_" + tipoMessaggio + "_" + idEGov;
            try {
                cacheMappingGestoreMessaggi.remove((Object)key);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private void addProprietarioIntoTable(String tipo, String idEGov, String proprietario) {
        this.tableProprietariMessaggiGestiti.put(tipo + "@" + idEGov, proprietario);
    }

    public void addProprietariMsgGestitiFromTable(Hashtable<String, String> t) throws UtilsException {
        this.tableProprietariMessaggiGestiti.putAll(t);
    }

    public Hashtable<String, String> getTableProprietariMessaggiGestiti() {
        return this.tableProprietariMessaggiGestiti;
    }

    public void addProprietariIntoCache_readFromTable(String modulo, String descrizione, String idEGovRichiestaCorrelata, boolean router) {
        if (this.openspcoopstate instanceof OpenSPCoopStateless) {
            return;
        }
        Enumeration<String> keys = this.tableProprietariMessaggiGestiti.keys();
        while (keys.hasMoreElements()) {
            String key = keys.nextElement();
            String[] idTipo = key.split("@");
            String value = this.tableProprietariMessaggiGestiti.get(key);
            try {
                this.msgDiag.highDebug("Aggiornamento proprietario [" + descrizione + "] (Modulo:" + modulo + ") per [" + idTipo[0] + "/" + idTipo[1] + "] a [" + value + "] ...");
                GestoreMessaggi.addIntoCache_Proprietario(this.msgDiag, idTipo[0], idTipo[1], value);
                this.msgDiag.highDebug("Aggiornamento proprietario [" + descrizione + "] (Modulo:" + modulo + ") per [" + idTipo[0] + "/" + idTipo[1] + "] a [" + value + "] effettuata");
                if ("GestoreMessaggi".equals(value)) {
                    this.puliziaCache(modulo, this.idEGov, this.tipo, idEGovRichiestaCorrelata, router);
                    continue;
                }
                this.puliziaCacheAltriProprietari(modulo, this.idEGov, this.tipo);
            }
            catch (Exception e) {
                this.msgDiag.logErroreGenerico(e, "GestoreMessaggi.addIntoCache_Proprietario(Descr:" + descrizione + ",Modulo:" + modulo + ",Per:" + idTipo[0] + "/" + idTipo[1] + ",Value:" + value + "");
                this.log.error((Object)("Aggiornamento proprietario [" + descrizione + "] (Modulo:" + modulo + ") per [" + idTipo[0] + "/" + idTipo[1] + "] a [" + value + "] non riuscita"), (Throwable)e);
            }
        }
    }

    public void puliziaCacheAltriProprietari(String moduloVecchio, String idEGov, String tipo) {
        if (moduloVecchio.indexOf("RicezioneContenutiApplicativi") >= 0) {
            GestoreMessaggi.deleteFromCache_Proprietario("RicezioneContenutiApplicativi", tipo, idEGov);
        } else if (moduloVecchio.indexOf("Imbustamento") >= 0) {
            GestoreMessaggi.deleteFromCache_Proprietario("Imbustamento", tipo, idEGov);
        } else if (moduloVecchio.indexOf("InoltroBusteEGov") >= 0) {
            GestoreMessaggi.deleteFromCache_Proprietario("InoltroBusteEGov", tipo, idEGov);
        } else if (moduloVecchio.indexOf("SbustamentoRisposte") >= 0) {
            GestoreMessaggi.deleteFromCache_Proprietario("SbustamentoRisposte", tipo, idEGov);
        } else if (moduloVecchio.indexOf("RicezioneBusteEGov") >= 0) {
            GestoreMessaggi.deleteFromCache_Proprietario("RicezioneBusteEGov", tipo, idEGov);
        } else if (moduloVecchio.indexOf("Sbustamento") >= 0) {
            GestoreMessaggi.deleteFromCache_Proprietario("Sbustamento", tipo, idEGov);
        } else if (moduloVecchio.indexOf("ConsegnaContenutiApplicativi") >= 0) {
            GestoreMessaggi.deleteFromCache_Proprietario("ConsegnaContenutiApplicativi", tipo, idEGov);
        } else if (moduloVecchio.indexOf("InoltroRisposteEGov") >= 0) {
            GestoreMessaggi.deleteFromCache_Proprietario("InoltroRisposteEGov", tipo, idEGov);
        } else if (moduloVecchio.indexOf("ImbustamentoRisposte") >= 0) {
            GestoreMessaggi.deleteFromCache_Proprietario("ImbustamentoRisposte", tipo, idEGov);
        }
    }

    public void puliziaCache(String modulo, String idEGov, String tipo, String idEGovRichiesta, boolean router) {
        try {
            GestoreMessaggi.deleteFromCache_existsMessage(tipo, idEGov);
            if (idEGovRichiesta != null) {
                GestoreMessaggi.deleteFromCache_idFromRifMsgMapping(tipo, idEGovRichiesta);
            }
            if (router) {
                if (idEGovRichiesta == null) {
                    GestoreMessaggi.deleteFromCache_Proprietario("InoltroBusteEGov", tipo, idEGov);
                } else {
                    GestoreMessaggi.deleteFromCache_Proprietario("RicezioneBusteEGov", tipo, idEGov);
                }
            } else if (idEGovRichiesta == null) {
                if ("OUTBOX".equals(tipo)) {
                    GestoreMessaggi.deleteFromCache_Proprietario("Imbustamento", tipo, idEGov);
                    GestoreMessaggi.deleteFromCache_Proprietario("InoltroBusteEGov", tipo, idEGov);
                } else {
                    GestoreMessaggi.deleteFromCache_Proprietario("Sbustamento", tipo, idEGov);
                    GestoreMessaggi.deleteFromCache_Proprietario("ConsegnaContenutiApplicativi", tipo, idEGov);
                }
            } else if ("INBOX".equals(tipo)) {
                GestoreMessaggi.deleteFromCache_Proprietario("SbustamentoRisposte", tipo, idEGov);
                GestoreMessaggi.deleteFromCache_Proprietario("RicezioneContenutiApplicativi", tipo, idEGov);
            } else {
                GestoreMessaggi.deleteFromCache_Proprietario("ImbustamentoRisposte", tipo, idEGov);
                GestoreMessaggi.deleteFromCache_Proprietario("RicezioneBusteEGov", tipo, idEGov);
                GestoreMessaggi.deleteFromCache_Proprietario("InoltroRisposteEGov", tipo, idEGov);
            }
        }
        catch (Exception e) {
            this.msgDiag.logErroreGenerico(e, "GestoreMessaggi.puliziaCache(Modulo:" + modulo + ",Per:" + idEGov + "/" + tipo + ",Router:" + router + "");
            this.log.error((Object)("Pulizia della cache non riuscita (Modulo:" + modulo + ") per [" + idEGov + "/" + tipo + "] router[" + router + "]"), (Throwable)e);
        }
    }

    private void addMessaggioIntoTable(String tipo, String idEGov) {
        this.tableMessaggiGestiti.put(tipo + "@" + idEGov, true);
    }

    public void addMsgGestitiFromTable(Hashtable<String, Boolean> t) throws UtilsException {
        this.tableMessaggiGestiti.putAll(t);
    }

    public Hashtable<String, Boolean> getTableMessaggiGestiti() {
        return this.tableMessaggiGestiti;
    }

    public void addMessaggiIntoCache_readFromTable(String modulo, String descrizione) {
        if (this.openspcoopstate instanceof OpenSPCoopStateless) {
            return;
        }
        Enumeration<String> keys = this.tableMessaggiGestiti.keys();
        while (keys.hasMoreElements()) {
            String key = keys.nextElement();
            String[] idTipo = key.split("@");
            Boolean value = this.tableMessaggiGestiti.get(key);
            try {
                this.msgDiag.highDebug("Aggiornamento existsMessage [" + descrizione + "] (Modulo:" + modulo + ") per [" + idTipo[0] + "/" + idTipo[1] + "] a [" + value + "] ...");
                GestoreMessaggi.addIntoCache_existsMessage(this.msgDiag, idTipo[0], idTipo[1]);
                this.msgDiag.highDebug("Aggiornamento existsMessage [" + descrizione + "] (Modulo:" + modulo + ") per [" + idTipo[0] + "/" + idTipo[1] + "] a [" + value + "] effettuata");
            }
            catch (Exception e) {
                this.msgDiag.logErroreGenerico(e, "GestoreMessaggi.addIntoCache_existsMessage(Descr:" + descrizione + ",Modulo:" + modulo + ",Per:" + idTipo[0] + "/" + idTipo[1] + ",Value:" + value + "");
                this.log.error((Object)("Aggiornamento existsMessage [" + descrizione + "] (Modulo:" + modulo + ") per [" + idTipo[0] + "/" + idTipo[1] + "] a [" + value + "] non riuscita"), (Throwable)e);
            }
        }
    }

    public GestoreMessaggi(IOpenSPCoopState openspcoopstate, boolean isRichiesta, MsgDiagnostico msgDiag) {
        this(openspcoopstate, isRichiesta, null, null, OpenSPCoopLogger.getLoggerOpenSPCoopCore(), msgDiag);
    }

    public GestoreMessaggi(IOpenSPCoopState openspcoopstate, boolean isRichiesta, Logger alog, MsgDiagnostico msgDiag) {
        this(openspcoopstate, isRichiesta, null, null, alog, msgDiag);
    }

    public GestoreMessaggi(IOpenSPCoopState openspcoopstate, boolean isRichiesta, String idEGov, String tipo, MsgDiagnostico msgDiag) {
        this(openspcoopstate, isRichiesta, idEGov, tipo, Configurazione.getLibraryLog(), msgDiag);
    }

    public GestoreMessaggi(IOpenSPCoopState openspcoopstate, boolean isRichiesta, String idEGov, String tipo, Logger alog, MsgDiagnostico msgDiag) {
        String pddContextSerializerClass;
        this.openspcoopstate = openspcoopstate;
        this.isRichiesta = isRichiesta;
        this.tableProprietariMessaggiGestiti = new Hashtable();
        this.tableMessaggiGestiti = new Hashtable();
        this.idEGov = idEGov;
        this.tipo = tipo;
        this.propertiesReader = OpenSPCoopProperties.getInstance();
        this.msgDiag = msgDiag;
        this.log = alog != null ? alog : Logger.getLogger((String)"GestoreMessaggi");
        Loader loader = Loader.getInstance();
        if (!this.propertiesReader.isRepositoryOnFS()) {
            try {
                ClassNameProperties classNameProperties = ClassNameProperties.getInstance();
                String adapterClass = classNameProperties.getJDBCAdapter(this.propertiesReader.getRepositoryJDBCAdapter());
                if (adapterClass == null) {
                    this.log.error((Object)("Inizializzione GestoreMessaggi non riuscita: AdapterClass non registrata [" + this.propertiesReader.getRepositoryJDBCAdapter() + "]"));
                }
                this.adapter = (IJDBCAdapter)loader.newInstance(adapterClass);
            }
            catch (Exception e) {
                this.log.error((Object)("Inizializzione GestoreMessaggi non riuscita: AdapterClass non trovata [" + this.propertiesReader.getRepositoryJDBCAdapter() + "]:" + e.getMessage()), (Throwable)e);
            }
        } else {
            this.workDir = this.propertiesReader.getRepositoryDirectory();
        }
        if ((pddContextSerializerClass = this.propertiesReader.getPddContextSerializer()) != null && !"none".equals(pddContextSerializerClass)) {
            try {
                this.pddContextSerializer = (IPdDContextSerializer)loader.newInstance(pddContextSerializerClass);
            }
            catch (Exception e) {
                this.log.error((Object)("Inizializzione GestoreMessaggi non riuscita: IPdDContextSerializer non trovata [" + pddContextSerializerClass + "]:" + e.getMessage()), (Throwable)e);
            }
        }
        cluster_id = this.propertiesReader.getClusterId();
    }

    public void updateOpenSPCoopState(IOpenSPCoopState openspcoopstate) {
        this.openspcoopstate = openspcoopstate;
    }

    private String getColonnaSQL(String idNodo) throws SQLException {
        if (idNodo.startsWith("RicezioneContenutiApplicativi")) {
            return "MOD_RICEZ_CONT_APPLICATIVI";
        }
        if ("ConsegnaContenutiApplicativi".equals(idNodo)) {
            return "MOD_CONSEGNA_CONT_APPLICATIVI";
        }
        if (idNodo.startsWith("RicezioneBusteEGov")) {
            return "MOD_RICEZ_BUSTE_EGOV";
        }
        if ("InoltroBusteEGov".equals(idNodo)) {
            return "MOD_INOLTRO_BUSTE_EGOV";
        }
        if ("InoltroRisposteEGov".equals(idNodo)) {
            return "MOD_INOLTRO_RISPOSTE_EGOV";
        }
        if ("Imbustamento".equals(idNodo)) {
            return "MOD_IMBUSTAMENTO";
        }
        if ("ImbustamentoRisposte".equals(idNodo)) {
            return "MOD_IMBUSTAMENTO_RISPOSTE";
        }
        if ("Sbustamento".equals(idNodo)) {
            return "MOD_SBUSTAMENTO";
        }
        if ("SbustamentoRisposte".equals(idNodo)) {
            return "MOD_SBUSTAMENTO_RISPOSTE";
        }
        throw new SQLException("Traduzione IDModulo->ColonnaSQL per modulo [" + idNodo + "] non possibile");
    }

    public void registraMessaggio(Message axisMessage, String correlazioneApplicativa, PdDContext pddContext) throws GestoreMessaggiException {
        this.registraMessaggio(axisMessage, null, false, correlazioneApplicativa, pddContext);
    }

    public void registraMessaggio(Message axisMessage, Timestamp oraRegistrazione, String correlazioneApplicativa, PdDContext pddContext) throws GestoreMessaggiException {
        this.registraMessaggio(axisMessage, oraRegistrazione, false, correlazioneApplicativa, pddContext);
    }

    public void registraMessaggio(Message axisMessage, Timestamp oraRegistrazione, boolean salvaNelloStateless, String correlazioneApplicativa, PdDContext pddContext) throws GestoreMessaggiException {
        StateMessage stato;
        Timestamp oraRegistrazioneT = null;
        oraRegistrazioneT = oraRegistrazione == null ? DateManager.getTimestamp() : oraRegistrazione;
        boolean gestisciInfoGenericheDB = true;
        if (this.openspcoopstate instanceof OpenSPCoopStateless) {
            if (this.isRichiesta) {
                ((OpenSPCoopStateless)this.openspcoopstate).getTempiAttraversamentoPDD().setRicezioneMsgIngresso(oraRegistrazioneT);
            } else {
                ((OpenSPCoopStateless)this.openspcoopstate).getTempiAttraversamentoPDD().setRicezioneMsgRisposta(oraRegistrazioneT);
            }
            ((OpenSPCoopStateless)this.openspcoopstate).setIDCorrelazioneApplicativa(correlazioneApplicativa);
            ((OpenSPCoopStateless)this.openspcoopstate).setPddContext(pddContext);
            if (!this.isRichiesta) {
                ((OpenSPCoopStateless)this.openspcoopstate).setRispostaMsg(axisMessage);
                return;
            }
            if (!this.oneWayVersione11 || this.routingStateless) {
                gestisciInfoGenericheDB = false;
            }
        }
        StateMessage stateMessage = stato = this.isRichiesta ? (StateMessage)this.openspcoopstate.getStatoRichiesta() : (StateMessage)this.openspcoopstate.getStatoRisposta();
        if (gestisciInfoGenericheDB) {
            Connection connectionDB = stato.getConnectionDB();
            Statement pstmt = null;
            try {
                StringBuffer fieldNamesPdDContext = new StringBuffer();
                StringBuffer fieldValuesPdDContext = new StringBuffer();
                Hashtable<String, String> contextSerializerParameters = null;
                Vector<Object> objectSerializer = new Vector<Object>();
                if (this.pddContextSerializer != null && (contextSerializerParameters = this.pddContextSerializer.getGestoreMessaggiKeywords()) != null && contextSerializerParameters.size() > 0) {
                    Enumeration<String> keywordContext = contextSerializerParameters.keys();
                    while (keywordContext.hasMoreElements()) {
                        String keyword = keywordContext.nextElement();
                        Object o = pddContext.getObject(keyword);
                        if (o == null) continue;
                        fieldNamesPdDContext.append(" , ");
                        fieldValuesPdDContext.append(" , ");
                        fieldNamesPdDContext.append(contextSerializerParameters.get(keyword));
                        fieldValuesPdDContext.append("?");
                        if (!(o instanceof String || o instanceof Long || o instanceof Timestamp)) {
                            throw new Exception("Oggetto con chiave [" + keyword + "] e' di tipo [" + o.getClass().getName() + "], e' possibile serializzare solo i tipi java.lang.String/java.lang.Long/java.sql.Timestamp");
                        }
                        objectSerializer.add(o);
                    }
                }
                StringBuffer query = new StringBuffer();
                query.append("INSERT INTO ");
                query.append(MESSAGGI);
                query.append("(ID_EGOV,TIPO,ORA_REGISTRAZIONE,RISPEDIZIONE, REDELIVERY_DELAY, CLUSTER_ID, CORRELAZIONE_APPLICATIVA" + fieldNamesPdDContext.toString() + ") VALUES ( ? , ? , ? , ? , ? , ? , ?" + fieldValuesPdDContext.toString() + ")");
                pstmt = connectionDB.prepareStatement(query.toString());
                pstmt.setString(1, this.idEGov);
                pstmt.setString(2, this.tipo);
                pstmt.setTimestamp(3, oraRegistrazioneT);
                pstmt.setTimestamp(4, oraRegistrazioneT);
                pstmt.setTimestamp(5, oraRegistrazioneT);
                pstmt.setString(6, cluster_id);
                pstmt.setString(7, correlazioneApplicativa);
                int index = 8;
                for (int i = 0; i < objectSerializer.size(); ++i) {
                    Object o = objectSerializer.get(i);
                    if (o instanceof String) {
                        pstmt.setString(index++, o.toString());
                        continue;
                    }
                    if (o instanceof Long) {
                        pstmt.setLong(index++, (Long)o);
                        continue;
                    }
                    if (!(o instanceof Timestamp)) continue;
                    pstmt.setTimestamp(index++, (Timestamp)o);
                }
                stato.getPreparedStatement().put("INSERT registraMessaggioOpenSPCoop " + this.tipo + "/" + this.idEGov, pstmt);
                this.addMessaggioIntoTable(this.tipo, this.idEGov);
            }
            catch (Exception e) {
                String errorMsg = "GESTORE_MESSAGGI, Errore di registrazione " + this.tipo + "/" + this.idEGov + ": " + e.getMessage();
                this.log.error((Object)errorMsg, (Throwable)e);
                try {
                    if (pstmt != null) {
                        pstmt.close();
                    }
                }
                catch (Exception er) {
                    // empty catch block
                }
                throw new GestoreMessaggiException(errorMsg, e);
            }
        }
        if (axisMessage != null) {
            SoapMessage msgSoap = null;
            try {
                msgSoap = new SoapMessage(this.idEGov, this.openspcoopstate, this.tipo, this.workDir, this.adapter, this.log);
                msgSoap.save(axisMessage, this.isRichiesta, salvaNelloStateless);
            }
            catch (Exception e) {
                String errorMsg = "GESTORE_MESSAGGI, Errore di registrazione (SoapMessage) " + this.tipo + "/" + this.idEGov + ": " + e.getMessage();
                if (msgSoap != null) {
                    stato.closePreparedStatement();
                }
                this.log.error((Object)errorMsg, (Throwable)e);
                throw new GestoreMessaggiException(errorMsg, e);
            }
        }
    }

    public void registraInformazioniMessaggio_statelessEngine(Timestamp oraRegistrazione, String proprietarioMessaggio, String correlazioneApplicativa, PdDContext pddContext) throws GestoreMessaggiException {
        this.registraInformazioniMessaggio_statelessEngine(oraRegistrazione, proprietarioMessaggio, null, correlazioneApplicativa, pddContext);
    }

    public void registraInformazioniMessaggio_statelessEngine(Timestamp oraRegistrazione, String proprietarioMessaggio, String riferimentoMessaggio, String correlazioneApplicativa, PdDContext pddContext) throws GestoreMessaggiException {
        Timestamp oraRegistrazioneT = null;
        oraRegistrazioneT = oraRegistrazione == null ? DateManager.getTimestamp() : oraRegistrazione;
        StateMessage stato = this.isRichiesta ? (StateMessage)this.openspcoopstate.getStatoRichiesta() : (StateMessage)this.openspcoopstate.getStatoRisposta();
        Connection connectionDB = stato.getConnectionDB();
        Statement pstmt = null;
        try {
            StringBuffer fieldNamesPdDContext = new StringBuffer();
            StringBuffer fieldValuesPdDContext = new StringBuffer();
            Hashtable<String, String> contextSerializerParameters = null;
            Vector<Object> objectSerializer = new Vector<Object>();
            if (this.pddContextSerializer != null && (contextSerializerParameters = this.pddContextSerializer.getGestoreMessaggiKeywords()) != null && contextSerializerParameters.size() > 0) {
                Enumeration<String> keywordContext = contextSerializerParameters.keys();
                while (keywordContext.hasMoreElements()) {
                    String keyword = keywordContext.nextElement();
                    Object o = pddContext.getObject(keyword);
                    if (o == null) continue;
                    fieldNamesPdDContext.append(" , ");
                    fieldValuesPdDContext.append(" , ");
                    fieldNamesPdDContext.append(contextSerializerParameters.get(keyword));
                    fieldValuesPdDContext.append("?");
                    if (!(o instanceof String || o instanceof Long || o instanceof Timestamp)) {
                        throw new Exception("Oggetto con chiave [" + keyword + "] e' di tipo [" + o.getClass().getName() + "], e' possibile serializzare solo i tipi java.lang.String/java.lang.Long/java.sql.Timestamp");
                    }
                    objectSerializer.add(o);
                }
            }
            StringBuffer query = new StringBuffer();
            query.append("INSERT INTO ");
            query.append(MESSAGGI);
            query.append("(ID_EGOV,TIPO,ORA_REGISTRAZIONE,RISPEDIZIONE, REDELIVERY_DELAY, CLUSTER_ID, PROPRIETARIO, CORRELAZIONE_APPLICATIVA ");
            if (riferimentoMessaggio != null) {
                query.append(", RIFERIMENTO_MSG");
            }
            query.append(fieldNamesPdDContext.toString());
            query.append(") VALUES ( ? , ? , ? , ? , ? , ? , ? , ? ");
            if (riferimentoMessaggio != null) {
                query.append(", ?");
            }
            query.append(fieldValuesPdDContext);
            query.append(" )");
            pstmt = connectionDB.prepareStatement(query.toString());
            pstmt.setString(1, this.idEGov);
            pstmt.setString(2, this.tipo);
            pstmt.setTimestamp(3, oraRegistrazioneT);
            pstmt.setTimestamp(4, oraRegistrazioneT);
            pstmt.setTimestamp(5, oraRegistrazioneT);
            pstmt.setString(6, cluster_id);
            pstmt.setString(7, proprietarioMessaggio);
            pstmt.setString(8, correlazioneApplicativa);
            int index = 9;
            if (riferimentoMessaggio != null) {
                pstmt.setString(index++, riferimentoMessaggio);
            }
            for (int i = 0; i < objectSerializer.size(); ++i) {
                Object o = objectSerializer.get(i);
                if (o instanceof String) {
                    pstmt.setString(index++, o.toString());
                    continue;
                }
                if (o instanceof Long) {
                    pstmt.setLong(index++, (Long)o);
                    continue;
                }
                if (!(o instanceof Timestamp)) continue;
                pstmt.setTimestamp(index++, (Timestamp)o);
            }
            stato.getPreparedStatement().put("INSERT registraMessaggioOpenSPCoop(stateless engine) " + this.tipo + "/" + this.idEGov, pstmt);
            this.addMessaggioIntoTable(this.tipo, this.idEGov);
        }
        catch (Exception e) {
            String errorMsg = "GESTORE_MESSAGGI, Errore di registrazione (stateless engine) " + this.tipo + "/" + this.idEGov + ": " + e.getMessage();
            this.log.error((Object)errorMsg, (Throwable)e);
            try {
                if (pstmt != null) {
                    pstmt.close();
                }
            }
            catch (Exception er) {
                // empty catch block
            }
            throw new GestoreMessaggiException(errorMsg, e);
        }
    }

    public void registraMessaggio_statelessEngine(Message axisMessage) throws GestoreMessaggiException {
        if (axisMessage != null) {
            StateMessage stato = this.isRichiesta ? (StateMessage)this.openspcoopstate.getStatoRichiesta() : (StateMessage)this.openspcoopstate.getStatoRisposta();
            SoapMessage msgSoap = null;
            try {
                msgSoap = new SoapMessage(this.idEGov, this.openspcoopstate, this.tipo, this.workDir, this.adapter, this.log);
                msgSoap.save(axisMessage, this.isRichiesta, false);
            }
            catch (Exception e) {
                String errorMsg = "GESTORE_MESSAGGI, Errore di registrazione (SoapMessage) " + this.tipo + "/" + this.idEGov + ": " + e.getMessage();
                if (msgSoap != null) {
                    stato.closePreparedStatement();
                }
                this.log.error((Object)errorMsg, (Throwable)e);
                throw new GestoreMessaggiException(errorMsg, e);
            }
        }
    }

    public void registraDestinatarioMessaggio(String serv, boolean sbustamento, boolean integrationManager, String tipoConsegna, Timestamp oraRegistrazioneMessaggio) throws GestoreMessaggiException {
        if (this.openspcoopstate instanceof OpenSPCoopStateful || this.oneWayVersione11) {
            StateMessage stateMSG = this.isRichiesta ? (StateMessage)this.openspcoopstate.getStatoRichiesta() : (StateMessage)this.openspcoopstate.getStatoRisposta();
            Connection connectionDB = stateMSG.getConnectionDB();
            PreparedStatement pstmt = null;
            try {
                StringBuffer query = new StringBuffer();
                query.append("INSERT INTO ");
                query.append(MSG_SERVIZI_APPLICATIVI);
                query.append("(ID_EGOV,SERVIZIO_APPLICATIVO,SBUSTAMENTO_SOAP,INTEGRATION_MANAGER,TIPO_CONSEGNA,RISPEDIZIONE) VALUES ( ? , ? , ? , ? , ? , ? )");
                pstmt = connectionDB.prepareStatement(query.toString());
                pstmt.setString(1, this.idEGov);
                pstmt.setString(2, serv);
                if (sbustamento) {
                    pstmt.setInt(3, 1);
                } else {
                    pstmt.setInt(3, 0);
                }
                if (integrationManager) {
                    pstmt.setInt(4, 1);
                } else {
                    pstmt.setInt(4, 0);
                }
                pstmt.setString(5, tipoConsegna);
                pstmt.setTimestamp(6, oraRegistrazioneMessaggio);
                stateMSG.getPreparedStatement().put("INSERT registraDestinatarioMessaggioOpenSPCoop[" + serv + "][" + this.idEGov + "]", pstmt);
            }
            catch (Exception e) {
                String errorMsg = "GESTORE_MESSAGGI, Errore di registrazione destinatario Messaggio " + this.tipo + "/" + this.idEGov + ": " + e.getMessage();
                try {
                    if (pstmt != null) {
                        pstmt.close();
                    }
                }
                catch (Exception er) {
                    // empty catch block
                }
                this.log.error((Object)errorMsg, (Throwable)e);
                throw new GestoreMessaggiException(errorMsg, e);
            }
        }
        if (!(this.openspcoopstate instanceof OpenSPCoopStateless) || this.oneWayVersione11) {
            throw new GestoreMessaggiException("Metodo invocato con IState non valido");
        }
    }

    public void aggiornaProprietarioMessaggio(String nodoOpenSPCoop) throws GestoreMessaggiException {
        this.aggiornaProprietarioMessaggio_engine(nodoOpenSPCoop, false);
    }

    public void aggiornaProprietarioMessaggio(String nodoOpenSPCoop, boolean searchForRiferimentoMsg) throws GestoreMessaggiException {
        this.aggiornaProprietarioMessaggio_engine(nodoOpenSPCoop, searchForRiferimentoMsg);
    }

    private void aggiornaProprietarioMessaggio_engine(String nodoOpenSPCoop, boolean searchForRiferimentoMsg) throws GestoreMessaggiException {
        boolean stateful = this.openspcoopstate instanceof OpenSPCoopStateful;
        if (!stateful) {
            if (this.isRichiesta) {
                ((OpenSPCoopStateless)this.openspcoopstate).setDestinatarioRequestMsgLib(nodoOpenSPCoop);
            } else {
                ((OpenSPCoopStateless)this.openspcoopstate).setDestinatarioResponseMsgLib(nodoOpenSPCoop);
            }
        }
        if (stateful || this.readyForDrop || this.oneWayVersione11) {
            StateMessage stateMsg = this.isRichiesta ? (StateMessage)this.openspcoopstate.getStatoRichiesta() : (StateMessage)this.openspcoopstate.getStatoRisposta();
            Connection connectionDB = stateMsg.getConnectionDB();
            Statement pstmt = null;
            try {
                StringBuffer query = new StringBuffer();
                query.append("UPDATE ");
                query.append(MESSAGGI);
                query.append(" SET PROPRIETARIO=? WHERE ");
                String tipoMessaggio = null;
                if (searchForRiferimentoMsg) {
                    tipoMessaggio = "OUTBOX".equals(this.tipo) ? "INBOX" : "OUTBOX";
                    query.append(" RIFERIMENTO_MSG=? AND TIPO=? ");
                } else {
                    tipoMessaggio = this.tipo;
                    query.append(" ID_EGOV=? AND TIPO=? ");
                }
                pstmt = connectionDB.prepareStatement(query.toString());
                pstmt.setString(1, nodoOpenSPCoop);
                pstmt.setString(2, this.idEGov);
                pstmt.setString(3, tipoMessaggio);
                stateMsg.getPreparedStatement().put("UPDATE aggiornaProprietarioMessaggioOpenSPCoop " + this.tipo + "/" + this.idEGov, pstmt);
                this.addProprietarioIntoTable(this.tipo, this.idEGov, nodoOpenSPCoop);
            }
            catch (Exception e) {
                String errorMsg = "GESTORE_MESSAGGI, Errore di aggiornamento proprietario Messaggio " + this.tipo + "/" + this.idEGov + ": " + e.getMessage();
                try {
                    if (pstmt != null) {
                        pstmt.close();
                    }
                }
                catch (Exception er) {
                    // empty catch block
                }
                this.log.error((Object)errorMsg, (Throwable)e);
                throw new GestoreMessaggiException(errorMsg, e);
            }
        }
    }

    public void aggiornaRiferimentoMessaggio(String riferimentoMessaggio) throws GestoreMessaggiException {
        this.aggiornaRiferimentoMessaggio(riferimentoMessaggio, false);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void aggiornaRiferimentoMessaggio(String riferimentoMessaggio, boolean saveIntoDB) throws GestoreMessaggiException {
        if (this.openspcoopstate instanceof OpenSPCoopStateful || saveIntoDB) {
            StateMessage state = this.isRichiesta ? (StateMessage)this.openspcoopstate.getStatoRichiesta() : (StateMessage)this.openspcoopstate.getStatoRisposta();
            Connection connectionDB = state.getConnectionDB();
            PreparedStatement pstmt = null;
            try {
                StringBuffer query = new StringBuffer();
                query.append("UPDATE ");
                query.append(MESSAGGI);
                query.append(" SET RIFERIMENTO_MSG=? WHERE  ID_EGOV = ? AND TIPO=?");
                pstmt = connectionDB.prepareStatement(query.toString());
                pstmt.setString(1, riferimentoMessaggio);
                pstmt.setString(2, this.idEGov);
                pstmt.setString(3, this.tipo);
                state.getPreparedStatement().put("UPDATE aggiornaRiferimentoMessaggioOpenSPCoop " + this.tipo + "/" + this.idEGov, pstmt);
                if (cacheMappingGestoreMessaggi == null) return;
                try {
                    this.msgDiag.highDebug("Aggiornamento riferimentoMessaggio per [" + this.tipo + "/" + riferimentoMessaggio + "] a [" + this.idEGov + "] ...");
                    GestoreMessaggi.addIntoCache_MappingRifMsgToId(this.msgDiag, this.tipo, riferimentoMessaggio, this.idEGov);
                    this.msgDiag.highDebug("Aggiornamento riferimentoMessaggio per [" + this.tipo + "/" + riferimentoMessaggio + "] a [" + this.idEGov + "] effettuata.");
                    return;
                }
                catch (Exception e) {
                    this.msgDiag.logErroreGenerico(e, "GestoreMessaggi.addIntoCache_MappingRifMsgToId(Per:" + this.tipo + "/" + riferimentoMessaggio + ",Value:" + this.idEGov + "");
                }
                return;
            }
            catch (Exception e) {
                String errorMsg = "GESTORE_MESSAGGI, Errore di aggiornamento riferimento messaggio " + this.tipo + "/" + this.idEGov + ": " + e.getMessage();
                try {
                    if (pstmt != null) {
                        pstmt.close();
                    }
                }
                catch (Exception er) {
                    // empty catch block
                }
                this.log.error((Object)errorMsg, (Throwable)e);
                throw new GestoreMessaggiException(errorMsg, e);
            }
        }
        if (this.openspcoopstate instanceof OpenSPCoopStateless) return;
        throw new GestoreMessaggiException("Metodo invocato con OpenSPCoopState non valido");
    }

    public void aggiornaErroreProcessamentoMessaggio(String motivoErrore, String servizioApplicativo) throws GestoreMessaggiException {
        if (this.openspcoopstate instanceof OpenSPCoopStateful || this.oneWayVersione11) {
            StateMessage stateMSG = this.isRichiesta ? (StateMessage)this.openspcoopstate.getStatoRichiesta() : (StateMessage)this.openspcoopstate.getStatoRisposta();
            Connection connectionDB = stateMSG.getConnectionDB();
            String motivoErroreGiaRegistrato = this.getErroreProcessamentoMessaggio(servizioApplicativo);
            String prefix = "";
            if (motivoErroreGiaRegistrato != null && motivoErroreGiaRegistrato.startsWith(NUMERO_RISPEDIZIONE)) {
                int index = motivoErroreGiaRegistrato.indexOf("]");
                prefix = motivoErroreGiaRegistrato.substring(0, index + 2);
                motivoErroreGiaRegistrato = motivoErroreGiaRegistrato.substring(index + 2);
            }
            if (motivoErroreGiaRegistrato == null || !motivoErroreGiaRegistrato.equals(motivoErrore)) {
                PreparedStatement pstmt = null;
                try {
                    StringBuffer query = new StringBuffer();
                    query.append("UPDATE ");
                    if (servizioApplicativo == null) {
                        query.append(MESSAGGI);
                    } else {
                        query.append(MSG_SERVIZI_APPLICATIVI);
                    }
                    query.append(" SET ERRORE_PROCESSAMENTO=? WHERE ID_EGOV = ?");
                    if (servizioApplicativo != null) {
                        query.append(" AND SERVIZIO_APPLICATIVO=?");
                    } else {
                        query.append(" AND TIPO=?");
                    }
                    pstmt = connectionDB.prepareStatement(query.toString());
                    pstmt.setString(1, prefix + motivoErrore);
                    pstmt.setString(2, this.idEGov);
                    if (servizioApplicativo != null) {
                        pstmt.setString(3, servizioApplicativo);
                    } else {
                        pstmt.setString(3, this.tipo);
                    }
                    pstmt.execute();
                    pstmt.close();
                }
                catch (Exception e) {
                    String errorMsg = "GESTORE_MESSAGGI, Errore di aggiornamento errore processamento messaggio " + this.tipo + "/" + this.idEGov + " sa[" + servizioApplicativo + "]: " + e.getMessage();
                    try {
                        if (pstmt != null) {
                            pstmt.close();
                        }
                    }
                    catch (Exception er) {
                        // empty catch block
                    }
                    this.log.error((Object)errorMsg, (Throwable)e);
                    throw new GestoreMessaggiException(errorMsg, e);
                }
            }
        } else if (!(this.openspcoopstate instanceof OpenSPCoopStateless)) {
            throw new GestoreMessaggiException("Metodo invocato con OpenSPCoopState non valido");
        }
    }

    public void aggiungiMessaggioSerializzato(IJDBCAdapter adapter, byte[] msgByte) throws GestoreMessaggiException {
        StateMessage stateMsg = this.isRichiesta ? (StateMessage)this.openspcoopstate.getStatoRichiesta() : (StateMessage)this.openspcoopstate.getStatoRisposta();
        Connection connectionDB = stateMsg.getConnectionDB();
        PreparedStatement pstmt = null;
        try {
            StringBuffer query = new StringBuffer();
            query.append("UPDATE ");
            query.append(MESSAGGI);
            query.append(" SET msg_bytes=? WHERE id_egov= ? and tipo= ?");
            pstmt = connectionDB.prepareStatement(query.toString());
            adapter.setBinaryData(pstmt, 1, msgByte);
            pstmt.setString(2, this.idEGov);
            pstmt.setString(3, this.tipo);
            stateMsg.getPreparedStatement().put("UPDATE aggiungiMessaggioSerializzatoInMessaggioOpenSPCoop " + this.tipo + "/" + this.idEGov, pstmt);
        }
        catch (Exception e) {
            String errorMsg = "GESTORE_MESSAGGI, Errore di aggiornamento errore processamento messaggio " + this.tipo + "/" + this.idEGov + " " + e.getMessage();
            try {
                if (pstmt != null) {
                    pstmt.close();
                }
            }
            catch (Exception er) {
                // empty catch block
            }
            this.log.error((Object)errorMsg, (Throwable)e);
            throw new GestoreMessaggiException(errorMsg, e);
        }
    }

    public void ripristinaMessaggio() throws GestoreMessaggiException {
        StateMessage stateMsg = this.isRichiesta ? (StateMessage)this.openspcoopstate.getStatoRichiesta() : (StateMessage)this.openspcoopstate.getStatoRisposta();
        Connection connectionDB = stateMsg.getConnectionDB();
        PreparedStatement pstmt = null;
        String sql = "UPDATE MESSAGGI SET scheduling=0 where id_egov=? AND tipo=?";
        try {
            pstmt = connectionDB.prepareStatement(sql);
            pstmt.setString(1, this.idEGov);
            pstmt.setString(2, this.tipo);
            pstmt.execute();
        }
        catch (Exception e) {
            String errorMsg = "GESTORE_MESSAGGI, Errore di aggiornamento errore processamento messaggio " + this.tipo + "/" + this.idEGov + " " + e.getMessage();
            try {
                if (pstmt != null) {
                    pstmt.close();
                }
            }
            catch (Exception er) {
                // empty catch block
            }
            this.log.error((Object)errorMsg, (Throwable)e);
            throw new GestoreMessaggiException(errorMsg, e);
        }
    }

    public void aggiornaDataRispedizione(Timestamp dataRispedizione, String servizioApplicativo) throws GestoreMessaggiException {
        if (this.openspcoopstate instanceof OpenSPCoopStateful || this.oneWayVersione11) {
            StateMessage stateMSG = this.isRichiesta ? (StateMessage)this.openspcoopstate.getStatoRichiesta() : (StateMessage)this.openspcoopstate.getStatoRisposta();
            Connection connectionDB = stateMSG.getConnectionDB();
            String motivoErroreGiaRegistrato = this.getErroreProcessamentoMessaggio(servizioApplicativo);
            Statement pstmt = null;
            try {
                int numeroSpedizione = 0;
                if (motivoErroreGiaRegistrato == null) {
                    motivoErroreGiaRegistrato = "[spedizione n.1] ";
                    numeroSpedizione = 1;
                } else if (!motivoErroreGiaRegistrato.startsWith(NUMERO_RISPEDIZIONE)) {
                    motivoErroreGiaRegistrato = "[spedizione n.1] " + motivoErroreGiaRegistrato;
                    numeroSpedizione = 1;
                } else {
                    int indexNumber = motivoErroreGiaRegistrato.indexOf("]");
                    if (indexNumber == -1) {
                        throw new GestoreMessaggiException("Errore processamento corrotto (] non presente)");
                    }
                    try {
                        StringBuffer bf = new StringBuffer();
                        int j = indexNumber - 1;
                        while (motivoErroreGiaRegistrato.charAt(j) != '.') {
                            bf.append(motivoErroreGiaRegistrato.charAt(j));
                            --j;
                        }
                        bf.reverse();
                        numeroSpedizione = Integer.parseInt(bf.toString());
                        String oldMotivo = motivoErroreGiaRegistrato.substring(indexNumber + 2);
                        motivoErroreGiaRegistrato = NUMERO_RISPEDIZIONE + ++numeroSpedizione + "] " + oldMotivo;
                    }
                    catch (Exception e) {
                        throw new GestoreMessaggiException("Aggiornamento numero spedizione non riuscito: " + e.getMessage(), e);
                    }
                }
                long spedizione = dataRispedizione.getTime();
                if (this.propertiesReader.isRitardoConsegnaAbilitato() && numeroSpedizione > 1) {
                    long limite;
                    long ritardoEsponenziale = this.propertiesReader.getRitardoConsegnaEsponenziale();
                    long ritardo = 1L;
                    boolean moltiplicazione = this.propertiesReader.isRitardoConsegnaEsponenzialeConMoltiplicazione();
                    if (!moltiplicazione) {
                        ritardo = 0L;
                    }
                    if ((limite = (long)(numeroSpedizione - 1)) > this.propertiesReader.getRitardoConsegnaEsponenzialeLimite()) {
                        limite = this.propertiesReader.getRitardoConsegnaEsponenzialeLimite();
                    }
                    int i = 0;
                    while ((long)i < limite) {
                        ritardo = moltiplicazione ? (ritardo *= ritardoEsponenziale) : (ritardo += ritardoEsponenziale);
                        ++i;
                    }
                    spedizione += ritardo * 1000L;
                }
                StringBuffer query = new StringBuffer();
                query.append("UPDATE ");
                if (servizioApplicativo != null) {
                    query.append(MSG_SERVIZI_APPLICATIVI);
                } else {
                    query.append(MESSAGGI);
                }
                query.append(" SET RISPEDIZIONE=?, ERRORE_PROCESSAMENTO=? WHERE  ID_EGOV = ?");
                if (servizioApplicativo != null) {
                    query.append(" AND SERVIZIO_APPLICATIVO=?");
                } else {
                    query.append(" AND TIPO=?");
                }
                pstmt = connectionDB.prepareStatement(query.toString());
                Timestamp t = new Timestamp(spedizione);
                pstmt.setTimestamp(1, t);
                pstmt.setString(2, motivoErroreGiaRegistrato);
                pstmt.setString(3, this.idEGov);
                if (servizioApplicativo != null) {
                    pstmt.setString(4, servizioApplicativo);
                } else {
                    pstmt.setString(4, this.tipo);
                }
                pstmt.execute();
                pstmt.close();
            }
            catch (Exception e) {
                String errorMsg = "GESTORE_MESSAGGI, Errore di aggiornamento data rispedizione Messaggio " + this.tipo + "/" + this.idEGov + " sa[" + servizioApplicativo + "]: " + e.getMessage();
                try {
                    if (pstmt != null) {
                        pstmt.close();
                    }
                }
                catch (Exception er) {
                    // empty catch block
                }
                this.log.error((Object)errorMsg, (Throwable)e);
                throw new GestoreMessaggiException(errorMsg, e);
            }
        }
        if (!(this.openspcoopstate instanceof OpenSPCoopStateless)) {
            throw new GestoreMessaggiException("Metodo invocato con OpenSPCoopState non valido");
        }
    }

    public void aggiornaIDHeaderJMS(String nodoOpenSPCoop, String idHeaderJMS) throws GestoreMessaggiException {
        this.aggiornaIDHeaderJMS(nodoOpenSPCoop, idHeaderJMS, null);
    }

    public void aggiornaIDHeaderJMS(String nodoOpenSPCoop, String idHeaderJMS, String servizioApplicativo) throws GestoreMessaggiException {
        if (this.openspcoopstate instanceof OpenSPCoopStateful) {
            StatefulMessage stateful = this.isRichiesta ? (StatefulMessage)this.openspcoopstate.getStatoRichiesta() : (StatefulMessage)this.openspcoopstate.getStatoRisposta();
            Connection connectionDB = stateful.getConnectionDB();
            PreparedStatement pstmt = null;
            try {
                String query = null;
                query = "ConsegnaContenutiApplicativi".equals(nodoOpenSPCoop) ? "UPDATE MSG_SERVIZI_APPLICATIVI SET " + this.getColonnaSQL(nodoOpenSPCoop) + "=? WHERE  ID_EGOV = ? AND SERVIZIO_APPLICATIVO=?" : "UPDATE MESSAGGI SET " + this.getColonnaSQL(nodoOpenSPCoop) + "=? WHERE  ID_EGOV = ? AND TIPO=?";
                pstmt = connectionDB.prepareStatement(query);
                pstmt.setString(1, idHeaderJMS);
                pstmt.setString(2, this.idEGov);
                if ("ConsegnaContenutiApplicativi".equals(nodoOpenSPCoop)) {
                    pstmt.setString(3, servizioApplicativo);
                } else {
                    pstmt.setString(3, this.tipo);
                }
                pstmt.execute();
                pstmt.close();
            }
            catch (Exception e) {
                String errorMsg = "GESTORE_MESSAGGI, Errore di aggiornamento IDHeaderJMS " + this.tipo + "/" + this.idEGov + ": " + e.getMessage();
                try {
                    if (pstmt != null) {
                        pstmt.close();
                    }
                }
                catch (Exception er) {
                    // empty catch block
                }
                this.log.error((Object)errorMsg, (Throwable)e);
                throw new GestoreMessaggiException(errorMsg, e);
            }
        }
        if (!(this.openspcoopstate instanceof OpenSPCoopStateless)) {
            throw new GestoreMessaggiException("Metodo invocato con OpenSPCoopState non valido");
        }
    }

    public String getProprietario_SerializableRead(String idModulo, long attesaAttiva, int checkInterval) throws GestoreMessaggiException {
        return this.getProprietario(idModulo, true, attesaAttiva, checkInterval, false);
    }

    public String getProprietario_SerializableRead(String idModulo, long attesaAttiva, int checkInterval, boolean onlyCache) throws GestoreMessaggiException {
        return this.getProprietario(idModulo, true, attesaAttiva, checkInterval, onlyCache);
    }

    public String getProprietario(String idModulo) throws GestoreMessaggiException {
        return this.getProprietario(idModulo, false, -1L, -1, false);
    }

    public String getProprietario(String idModulo, boolean onlyCache) throws GestoreMessaggiException {
        return this.getProprietario(idModulo, false, -1L, -1, onlyCache);
    }

    private String getProprietario(String idModulo, boolean serializable, long attesaAttiva, int checkInterval, boolean onlyCache) throws GestoreMessaggiException {
        if (this.openspcoopstate instanceof OpenSPCoopStateless && !this.oneWayVersione11) {
            return this.isRichiesta ? ((OpenSPCoopStateless)this.openspcoopstate).getDestinatarioRequestMsgLib() : ((OpenSPCoopStateless)this.openspcoopstate).getDestinatarioResponseMsgLib();
        }
        if (this.openspcoopstate instanceof OpenSPCoopStateful || this.oneWayVersione11) {
            StateMessage stateMSG = this.isRichiesta ? (StateMessage)this.openspcoopstate.getStatoRichiesta() : (StateMessage)this.openspcoopstate.getStatoRisposta();
            Connection connectionDB = stateMSG.getConnectionDB();
            if (cacheMappingGestoreMessaggi != null) {
                try {
                    this.msgDiag.highDebug("getProprietario, read from cache...");
                    String proprietario = GestoreMessaggi.getFromCache_Proprietario(idModulo, this.tipo, this.idEGov);
                    if (proprietario != null) {
                        return proprietario;
                    }
                    if (onlyCache) {
                        return null;
                    }
                }
                catch (Exception e) {
                    String errorMsg = "GESTORE_MESSAGGI, error getProprietario (Cache) " + this.tipo + "/" + this.idEGov + ": " + e.getMessage();
                    this.log.error((Object)errorMsg, (Throwable)e);
                    throw new GestoreMessaggiException(errorMsg, e);
                }
            }
            this.msgDiag.highDebug("getProprietario, read from DB...");
            if (!serializable) {
                PreparedStatement pstmt = null;
                ResultSet rs = null;
                String value = null;
                try {
                    String query = "SELECT PROPRIETARIO FROM MESSAGGI WHERE ID_EGOV=? AND TIPO=?";
                    pstmt = connectionDB.prepareStatement(query);
                    pstmt.setString(1, this.idEGov);
                    pstmt.setString(2, this.tipo);
                    rs = pstmt.executeQuery();
                    if (rs.next()) {
                        value = rs.getString("PROPRIETARIO");
                    }
                    rs.close();
                    pstmt.close();
                }
                catch (Exception e) {
                    try {
                        if (rs != null) {
                            rs.close();
                        }
                    }
                    catch (Exception er) {
                        // empty catch block
                    }
                    try {
                        if (pstmt != null) {
                            pstmt.close();
                        }
                    }
                    catch (Exception er) {
                        // empty catch block
                    }
                }
                return value;
            }
            int oldTransactionIsolation = -1;
            try {
                oldTransactionIsolation = connectionDB.getTransactionIsolation();
                connectionDB.setAutoCommit(false);
                connectionDB.setTransactionIsolation(8);
            }
            catch (Exception er) {
                String errorMsg = "GESTORE_MESSAGGI, Errore getProprietario Messaggio(setIsolation) " + this.tipo + "/" + this.idEGov + ": " + er.getMessage();
                this.log.error((Object)errorMsg, (Throwable)er);
                throw new GestoreMessaggiException(errorMsg, er);
            }
            PreparedStatement pstmt = null;
            ResultSet rs = null;
            boolean getProprietarioOK = false;
            String value = null;
            long scadenzaWhile = DateManager.getTimeMillis() + attesaAttiva;
            while (!getProprietarioOK && DateManager.getTimeMillis() < scadenzaWhile) {
                try {
                    String query = "SELECT PROPRIETARIO FROM MESSAGGI WHERE ID_EGOV=? AND TIPO=? FOR UPDATE";
                    pstmt = connectionDB.prepareStatement(query);
                    pstmt.setString(1, this.idEGov);
                    pstmt.setString(2, this.tipo);
                    rs = pstmt.executeQuery();
                    if (rs.next()) {
                        value = rs.getString("PROPRIETARIO");
                    }
                    rs.close();
                    pstmt.close();
                    connectionDB.commit();
                    getProprietarioOK = true;
                }
                catch (Exception e) {
                    try {
                        if (rs != null) {
                            rs.close();
                        }
                    }
                    catch (Exception er) {
                        // empty catch block
                    }
                    try {
                        if (pstmt != null) {
                            pstmt.close();
                        }
                    }
                    catch (Exception er) {
                        // empty catch block
                    }
                    try {
                        connectionDB.rollback();
                    }
                    catch (Exception er) {
                        // empty catch block
                    }
                }
                if (getProprietarioOK) continue;
                try {
                    Thread.sleep(new Random().nextInt(checkInterval));
                }
                catch (Exception eRandom) {}
            }
            try {
                connectionDB.setTransactionIsolation(oldTransactionIsolation);
                connectionDB.setAutoCommit(true);
                stateMSG.updateConnection(connectionDB);
            }
            catch (Exception er) {
                String errorMsg = "GESTORE_MESSAGGI, Errore getProprietario Messaggio(ripristinoIsolation) " + this.tipo + "/" + this.idEGov + ": " + er.getMessage();
                this.log.error((Object)errorMsg, (Throwable)er);
                throw new GestoreMessaggiException(errorMsg, er);
            }
            return value;
        }
        throw new GestoreMessaggiException("Metodo invocato con OpenSPCoopState non valido");
    }

    public String getIDJMSRicevuto(String nodoOpenSPCoop) throws GestoreMessaggiException {
        return this.getIDJMSRicevuto(nodoOpenSPCoop, null);
    }

    public String getIDJMSRicevuto(String nodoOpenSPCoop, String servizioApplicativo) throws GestoreMessaggiException {
        if (this.openspcoopstate instanceof OpenSPCoopStateful) {
            StatefulMessage stateful = this.isRichiesta ? (StatefulMessage)this.openspcoopstate.getStatoRichiesta() : (StatefulMessage)this.openspcoopstate.getStatoRisposta();
            Connection connectionDB = stateful.getConnectionDB();
            PreparedStatement pstmt = null;
            ResultSet rs = null;
            try {
                String query = null;
                query = "ConsegnaContenutiApplicativi".equals(nodoOpenSPCoop) ? "SELECT " + this.getColonnaSQL(nodoOpenSPCoop) + " FROM " + MSG_SERVIZI_APPLICATIVI + " WHERE ID_EGOV=? AND SERVIZIO_APPLICATIVO=?" : "SELECT " + this.getColonnaSQL(nodoOpenSPCoop) + " FROM " + MESSAGGI + " WHERE ID_EGOV=? AND TIPO=?";
                pstmt = connectionDB.prepareStatement(query);
                pstmt.setString(1, this.idEGov);
                if ("ConsegnaContenutiApplicativi".equals(nodoOpenSPCoop)) {
                    pstmt.setString(2, servizioApplicativo);
                } else {
                    pstmt.setString(2, this.tipo);
                }
                rs = pstmt.executeQuery();
                String value = null;
                if (rs.next()) {
                    value = rs.getString(this.getColonnaSQL(nodoOpenSPCoop));
                }
                rs.close();
                pstmt.close();
                return value;
            }
            catch (Exception e) {
                String errorMsg = "GESTORE_MESSAGGI, Errore get IDHeaderJMS " + this.tipo + "/" + this.idEGov + ": " + e.getMessage();
                try {
                    if (rs != null) {
                        rs.close();
                    }
                }
                catch (Exception er) {
                    // empty catch block
                }
                try {
                    if (pstmt != null) {
                        pstmt.close();
                    }
                }
                catch (Exception er) {
                    // empty catch block
                }
                this.log.error((Object)errorMsg, (Throwable)e);
                throw new GestoreMessaggiException(errorMsg, e);
            }
        }
        throw new GestoreMessaggiException("Metodo invocato con OpenSPCoopState non valido");
    }

    public boolean existsMessage_onlyCache(boolean searchForRiferimentoMsg) throws GestoreMessaggiException {
        return this.existsMessage_engine(searchForRiferimentoMsg, true, false);
    }

    public boolean existsMessage_onlyCache() throws GestoreMessaggiException {
        return this.existsMessage_engine(false, true, false);
    }

    public boolean existsMessage_noCache(boolean searchForRiferimentoMsg) throws GestoreMessaggiException {
        return this.existsMessage_engine(searchForRiferimentoMsg, false, true);
    }

    public boolean existsMessage_noCache() throws GestoreMessaggiException {
        return this.existsMessage_engine(false, false, true);
    }

    public boolean existsMessage(boolean searchForRiferimentoMsg) throws GestoreMessaggiException {
        return this.existsMessage_engine(searchForRiferimentoMsg, false, false);
    }

    public boolean existsMessage() throws GestoreMessaggiException {
        return this.existsMessage_engine(false, false, false);
    }

    private boolean existsMessage_engine(boolean searchForRiferimentoMsg, boolean onlyCache, boolean noCache) throws GestoreMessaggiException {
        if (this.openspcoopstate instanceof OpenSPCoopStateless && (!this.oneWayVersione11 || this.routingStateless)) {
            return false;
        }
        StateMessage stateMSG = this.isRichiesta ? (StateMessage)this.openspcoopstate.getStatoRichiesta() : (StateMessage)this.openspcoopstate.getStatoRisposta();
        Connection connectionDB = stateMSG.getConnectionDB();
        String idEGovSearch = this.idEGov;
        if (searchForRiferimentoMsg) {
            try {
                idEGovSearch = this.mapRiferimentoIntoIDEgov();
            }
            catch (Exception e) {
                // empty catch block
            }
            if (idEGovSearch == null) {
                return false;
            }
        }
        if (cacheMappingGestoreMessaggi != null && !noCache) {
            try {
                this.msgDiag.highDebug("existsMessage, read from cache ID[" + idEGovSearch + "]...");
                Boolean value = GestoreMessaggi.getFromCache_existsMessage(this.tipo, idEGovSearch);
                if (value != null && value.booleanValue()) {
                    return true;
                }
                if (onlyCache) {
                    return false;
                }
            }
            catch (Exception e) {
                String errorMsg = "GESTORE_MESSAGGI, error existsMessage (Cache) " + this.tipo + "/" + idEGovSearch + ": " + e.getMessage();
                this.log.error((Object)errorMsg, (Throwable)e);
                return false;
            }
        }
        this.msgDiag.highDebug("existsMessage, read from DB ID[" + idEGovSearch + "]...");
        PreparedStatement pstmt = null;
        ResultSet rs = null;
        try {
            String query = "SELECT ID_EGOV FROM MESSAGGI WHERE ID_EGOV=? AND TIPO=?";
            pstmt = connectionDB.prepareStatement(query);
            pstmt.setString(1, idEGovSearch);
            pstmt.setString(2, this.tipo);
            rs = pstmt.executeQuery();
            if (rs.next()) {
                rs.close();
                pstmt.close();
                return true;
            }
            rs.close();
            pstmt.close();
            return false;
        }
        catch (Exception e) {
            String errorMsg = "GESTORE_MESSAGGI, Errore existsMessage " + this.tipo + "/" + idEGovSearch + ": " + e.getMessage();
            try {
                if (rs != null) {
                    rs.close();
                }
            }
            catch (Exception er) {
                // empty catch block
            }
            try {
                if (pstmt != null) {
                    pstmt.close();
                }
            }
            catch (Exception er) {
                // empty catch block
            }
            this.log.error((Object)errorMsg, (Throwable)e);
            return false;
        }
    }

    public Message getMessage() throws GestoreMessaggiException {
        return this.getMessage(false);
    }

    public Message getMessage(boolean searchForRiferimentoMsg) throws GestoreMessaggiException {
        Message msgAxis = null;
        String idEGovSearch = this.idEGov;
        if (searchForRiferimentoMsg) {
            idEGovSearch = this.mapRiferimentoIntoIDEgov();
        }
        SoapMessage soapMsg = null;
        try {
            soapMsg = new SoapMessage(idEGovSearch, this.openspcoopstate, this.tipo, this.workDir, this.adapter, this.log);
            msgAxis = soapMsg.read(this.isRichiesta, this.portaDiTipoStateless || this.routingStateless);
        }
        catch (Exception e) {
            String errorMsg = "GESTORE_MESSAGGI, getMessage " + this.tipo + "/" + this.idEGov + ": " + e.getMessage();
            this.log.error((Object)errorMsg, (Throwable)e);
            throw new GestoreMessaggiException(errorMsg, e);
        }
        return msgAxis;
    }

    public String mapRiferimentoIntoIDEgov() throws GestoreMessaggiException {
        return this.mapRiferimentoIntoIDEgov(false);
    }

    public String mapRiferimentoIntoIDEgov(boolean onlyCache) throws GestoreMessaggiException {
        if (this.openspcoopstate instanceof OpenSPCoopStateful) {
            StatefulMessage stateful = this.isRichiesta ? (StatefulMessage)this.openspcoopstate.getStatoRichiesta() : (StatefulMessage)this.openspcoopstate.getStatoRisposta();
            Connection connectionDB = stateful.getConnectionDB();
            if (cacheMappingGestoreMessaggi != null) {
                try {
                    this.msgDiag.highDebug("mapRiferimentoIntoIDEgov, read from cache ...");
                    String id = GestoreMessaggi.getFromCache_idFromRifMsgMapping(this.tipo, this.idEGov);
                    if (id != null) {
                        return id;
                    }
                    if (onlyCache) {
                        return null;
                    }
                }
                catch (Exception e) {
                    String errorMsg = "GESTORE_MESSAGGI, error mapRiferimentoIntoIDEgov (Cache) " + this.tipo + "/" + this.idEGov + ": " + e.getMessage();
                    this.log.error((Object)errorMsg, (Throwable)e);
                    throw new GestoreMessaggiException(errorMsg, e);
                }
            }
            this.msgDiag.highDebug("mapRiferimentoIntoIDEgov, read from DB ...");
            PreparedStatement pstmt = null;
            ResultSet rs = null;
            try {
                String query = "SELECT ID_EGOV FROM MESSAGGI WHERE RIFERIMENTO_MSG=? AND TIPO=? AND PROPRIETARIO IS NOT NULL AND PROPRIETARIO != ? ORDER BY ORA_REGISTRAZIONE DESC";
                pstmt = connectionDB.prepareStatement(query);
                pstmt.setString(1, this.idEGov);
                pstmt.setString(2, this.tipo);
                pstmt.setString(3, "GestoreMessaggi");
                rs = pstmt.executeQuery();
                String value = null;
                if (rs.next()) {
                    value = rs.getString("ID_EGOV");
                }
                rs.close();
                pstmt.close();
                return value;
            }
            catch (Exception e) {
                String errorMsg = "GESTORE_MESSAGGI, error mapRiferimentoIntoIDEgov " + this.tipo + "/" + this.idEGov + ": " + e.getMessage();
                try {
                    if (rs != null) {
                        rs.close();
                    }
                }
                catch (Exception er) {
                    // empty catch block
                }
                try {
                    if (pstmt != null) {
                        pstmt.close();
                    }
                }
                catch (Exception er) {
                    // empty catch block
                }
                this.log.error((Object)errorMsg, (Throwable)e);
                throw new GestoreMessaggiException(errorMsg, e);
            }
        }
        throw new GestoreMessaggiException("Metodo invocato con OpenSPCoopState non valido");
    }

    public String getErroreProcessamentoMessaggio(String servizioApplicativo) throws GestoreMessaggiException {
        if (this.openspcoopstate instanceof OpenSPCoopStateful || this.oneWayVersione11) {
            StateMessage stateMSG = this.isRichiesta ? (StateMessage)this.openspcoopstate.getStatoRichiesta() : (StateMessage)this.openspcoopstate.getStatoRisposta();
            Connection connectionDB = stateMSG.getConnectionDB();
            PreparedStatement pstmtRead = null;
            ResultSet rs = null;
            String motivoErroreGiaRegistrato = null;
            try {
                String query = null;
                query = servizioApplicativo == null ? "SELECT ERRORE_PROCESSAMENTO FROM MESSAGGI WHERE ID_EGOV = ? AND TIPO=?" : "SELECT ERRORE_PROCESSAMENTO FROM MSG_SERVIZI_APPLICATIVI WHERE ID_EGOV = ? AND SERVIZIO_APPLICATIVO=?";
                pstmtRead = connectionDB.prepareStatement(query);
                pstmtRead.setString(1, this.idEGov);
                if (servizioApplicativo != null) {
                    pstmtRead.setString(2, servizioApplicativo);
                } else {
                    pstmtRead.setString(2, this.tipo);
                }
                rs = pstmtRead.executeQuery();
                if (rs.next()) {
                    motivoErroreGiaRegistrato = rs.getString("ERRORE_PROCESSAMENTO");
                }
                rs.close();
                pstmtRead.close();
            }
            catch (Exception e) {
                String errorMsg = "GESTORE_MESSAGGI, Errore getErroreProcessamentoMessaggio " + this.tipo + "/" + this.idEGov + " sa[" + servizioApplicativo + "]: " + e.getMessage();
                try {
                    if (rs != null) {
                        rs.close();
                    }
                }
                catch (Exception er) {
                    // empty catch block
                }
                try {
                    if (pstmtRead != null) {
                        pstmtRead.close();
                    }
                }
                catch (Exception er) {
                    // empty catch block
                }
                this.log.error((Object)errorMsg, (Throwable)e);
                throw new GestoreMessaggiException(errorMsg, e);
            }
            return motivoErroreGiaRegistrato;
        }
        throw new GestoreMessaggiException("Metodo invocato con OpenSPCoopState non valido");
    }

    public Timestamp getOraRegistrazioneMessaggio() throws GestoreMessaggiException {
        Timestamp t = null;
        if (this.openspcoopstate instanceof OpenSPCoopStateful) {
            StatefulMessage stateful = this.isRichiesta ? (StatefulMessage)this.openspcoopstate.getStatoRichiesta() : (StatefulMessage)this.openspcoopstate.getStatoRisposta();
            Connection connectionDB = stateful.getConnectionDB();
            PreparedStatement pstmtRead = null;
            ResultSet rs = null;
            try {
                String query = "SELECT ORA_REGISTRAZIONE FROM MESSAGGI WHERE ID_EGOV = ? AND TIPO=?";
                pstmtRead = connectionDB.prepareStatement(query);
                pstmtRead.setString(1, this.idEGov);
                pstmtRead.setString(2, this.tipo);
                rs = pstmtRead.executeQuery();
                if (rs.next()) {
                    t = rs.getTimestamp("ORA_REGISTRAZIONE");
                }
                rs.close();
                pstmtRead.close();
                if (t == null) {
                    throw new Exception("Ora registrazione non registrata");
                }
                return t;
            }
            catch (Exception e) {
                String errorMsg = "GESTORE_MESSAGGI, Errore getOraRegistrazioneMessaggio " + this.tipo + "/" + this.idEGov + ": " + e.getMessage();
                try {
                    if (rs != null) {
                        rs.close();
                    }
                }
                catch (Exception er) {
                    // empty catch block
                }
                try {
                    if (pstmtRead != null) {
                        pstmtRead.close();
                    }
                }
                catch (Exception er) {
                    // empty catch block
                }
                this.log.error((Object)errorMsg, (Throwable)e);
                throw new GestoreMessaggiException(errorMsg, e);
            }
        }
        if (this.openspcoopstate instanceof OpenSPCoopStateless) {
            t = this.isRichiesta ? ((OpenSPCoopStateless)this.openspcoopstate).getTempiAttraversamentoPDD().getRicezioneMsgIngresso() : ((OpenSPCoopStateless)this.openspcoopstate).getTempiAttraversamentoPDD().getRicezioneMsgRisposta();
            if (t == null) {
                throw new GestoreMessaggiException("Ora registrazione non registrata");
            }
            return t;
        }
        throw new GestoreMessaggiException("Metodo invocato con OpenSPCoopState non valido");
    }

    public Timestamp getDataRispedizioneMessaggio() throws GestoreMessaggiException {
        if (this.openspcoopstate instanceof OpenSPCoopStateful) {
            StatefulMessage stateful = this.isRichiesta ? (StatefulMessage)this.openspcoopstate.getStatoRichiesta() : (StatefulMessage)this.openspcoopstate.getStatoRisposta();
            Connection connectionDB = stateful.getConnectionDB();
            PreparedStatement pstmtRead = null;
            ResultSet rs = null;
            try {
                String query = "SELECT RISPEDIZIONE FROM MESSAGGI WHERE ID_EGOV = ? AND TIPO=?";
                pstmtRead = connectionDB.prepareStatement(query);
                pstmtRead.setString(1, this.idEGov);
                pstmtRead.setString(2, this.tipo);
                rs = pstmtRead.executeQuery();
                Timestamp t = null;
                if (rs.next()) {
                    t = rs.getTimestamp("RISPEDIZIONE");
                }
                rs.close();
                pstmtRead.close();
                if (t == null) {
                    throw new Exception("Ora rispedizione non registrata");
                }
                return t;
            }
            catch (Exception e) {
                String errorMsg = "GESTORE_MESSAGGI, Errore getDataRispedizioneMessaggio " + this.tipo + "/" + this.idEGov + ": " + e.getMessage();
                try {
                    if (rs != null) {
                        rs.close();
                    }
                }
                catch (Exception er) {
                    // empty catch block
                }
                try {
                    if (pstmtRead != null) {
                        pstmtRead.close();
                    }
                }
                catch (Exception er) {
                    // empty catch block
                }
                this.log.error((Object)errorMsg, (Throwable)e);
                throw new GestoreMessaggiException(errorMsg, e);
            }
        }
        throw new GestoreMessaggiException("Metodo invocato con OpenSPCoopState non valido");
    }

    public boolean isPrimaConsegna(String servizioApplicativo) throws GestoreMessaggiException {
        if (this.openspcoopstate instanceof OpenSPCoopStateful || this.oneWayVersione11) {
            StateMessage stateMSG = this.isRichiesta ? (StateMessage)this.openspcoopstate.getStatoRichiesta() : (StateMessage)this.openspcoopstate.getStatoRisposta();
            Connection connectionDB = stateMSG.getConnectionDB();
            PreparedStatement pstmtRead = null;
            ResultSet rs = null;
            try {
                String query = null;
                query = servizioApplicativo == null ? "SELECT MESSAGGI.RISPEDIZIONE,MESSAGGI.ORA_REGISTRAZIONE FROM MESSAGGI WHERE ID_EGOV = ? AND TIPO=?" : "SELECT MSG_SERVIZI_APPLICATIVI.RISPEDIZIONE,MESSAGGI.ORA_REGISTRAZIONE FROM MSG_SERVIZI_APPLICATIVI,MESSAGGI WHERE MSG_SERVIZI_APPLICATIVI.ID_EGOV=MESSAGGI.ID_EGOV AND MESSAGGI.ID_EGOV= ? AND MSG_SERVIZI_APPLICATIVI.SERVIZIO_APPLICATIVO=? AND MESSAGGI.TIPO=?";
                pstmtRead = connectionDB.prepareStatement(query);
                pstmtRead.setString(1, this.idEGov);
                if (servizioApplicativo != null) {
                    pstmtRead.setString(2, servizioApplicativo);
                    pstmtRead.setString(3, "INBOX");
                } else {
                    pstmtRead.setString(2, this.tipo);
                }
                rs = pstmtRead.executeQuery();
                Timestamp oraRegistrazione = null;
                Timestamp rispedizione = null;
                if (rs.next()) {
                    oraRegistrazione = rs.getTimestamp("ORA_REGISTRAZIONE");
                    rispedizione = rs.getTimestamp("RISPEDIZIONE");
                }
                rs.close();
                pstmtRead.close();
                if (oraRegistrazione == null) {
                    this.log.error((Object)"OraRegistrazione is null");
                }
                if (rispedizione == null) {
                    this.log.error((Object)"Rispedizione is null");
                }
                return oraRegistrazione != null && rispedizione != null && oraRegistrazione.compareTo(rispedizione) == 0;
            }
            catch (Exception e) {
                String errorMsg = "GESTORE_MESSAGGI, Errore isPrimaConsegna " + this.tipo + "/" + this.idEGov + " sa[" + servizioApplicativo + "]: " + e.getMessage();
                try {
                    if (rs != null) {
                        rs.close();
                    }
                }
                catch (Exception er) {
                    // empty catch block
                }
                try {
                    if (pstmtRead != null) {
                        pstmtRead.close();
                    }
                }
                catch (Exception er) {
                    // empty catch block
                }
                this.log.error((Object)errorMsg, (Throwable)e);
                throw new GestoreMessaggiException(errorMsg, e);
            }
        }
        throw new GestoreMessaggiException("Metodo invocato con OpenSPCoopState non valido");
    }

    public boolean isRiconsegnaMessaggio(String servizioApplicativo) throws GestoreMessaggiException {
        if (this.openspcoopstate instanceof OpenSPCoopStateful || this.oneWayVersione11) {
            StateMessage stateMSG = this.isRichiesta ? (StateMessage)this.openspcoopstate.getStatoRichiesta() : (StateMessage)this.openspcoopstate.getStatoRisposta();
            Connection connectionDB = stateMSG.getConnectionDB();
            if (this.isPrimaConsegna(servizioApplicativo)) {
                return true;
            }
            PreparedStatement pstmt = null;
            ResultSet rs = null;
            try {
                StringBuffer bf = new StringBuffer();
                bf.append("SELECT RISPEDIZIONE FROM ");
                if (servizioApplicativo != null) {
                    bf.append(MSG_SERVIZI_APPLICATIVI);
                } else {
                    bf.append(MESSAGGI);
                }
                bf.append(" WHERE ID_EGOV=?");
                if (servizioApplicativo != null) {
                    bf.append(" AND SERVIZIO_APPLICATIVO=?");
                } else {
                    bf.append(" AND TIPO=?");
                }
                pstmt = connectionDB.prepareStatement(bf.toString());
                pstmt.setString(1, this.idEGov);
                if (servizioApplicativo != null) {
                    pstmt.setString(2, servizioApplicativo);
                } else {
                    pstmt.setString(2, this.tipo);
                }
                rs = pstmt.executeQuery();
                Timestamp riconsegna = null;
                if (rs.next()) {
                    riconsegna = rs.getTimestamp("RISPEDIZIONE");
                }
                rs.close();
                pstmt.close();
                Timestamp now = DateManager.getTimestamp();
                if (riconsegna == null) {
                    this.log.error((Object)("Calcolo riconsegna non riuscito [" + this.tipo + "/" + this.idEGov + "], riconsegna is null? query[" + bf.toString() + "] sa[" + servizioApplicativo + "]"));
                    throw new Exception("Calcolo riconsegna non riuscito [" + this.tipo + "/" + this.idEGov + "]");
                }
                if (riconsegna.before(now)) {
                    return true;
                }
                this.log.debug((Object)("Riconsegna messaggio prematura [" + this.tipo + "/" + this.idEGov + "] RICONSEGNA[" + riconsegna.toString() + "] < NOW[" + now.toString() + "] == false"));
                return false;
            }
            catch (Exception e) {
                String errorMsg = "GESTORE_MESSAGGI, Errore isRiconsegnaMessaggio " + this.tipo + "/" + this.idEGov + ": " + e.getMessage();
                try {
                    if (rs != null) {
                        rs.close();
                    }
                }
                catch (Exception er) {
                    // empty catch block
                }
                try {
                    if (pstmt != null) {
                        pstmt.close();
                    }
                }
                catch (Exception er) {
                    // empty catch block
                }
                this.log.error((Object)errorMsg, (Throwable)e);
                throw new GestoreMessaggiException(errorMsg, e);
            }
        }
        if (this.openspcoopstate instanceof OpenSPCoopStateless) {
            return true;
        }
        throw new GestoreMessaggiException("Metodo invocato con OpenSPCoopState non valido");
    }

    public String getRiferimentoMessaggio() throws GestoreMessaggiException {
        if (this.openspcoopstate instanceof OpenSPCoopStateful) {
            StatefulMessage stateful = this.isRichiesta ? (StatefulMessage)this.openspcoopstate.getStatoRichiesta() : (StatefulMessage)this.openspcoopstate.getStatoRisposta();
            Connection connectionDB = stateful.getConnectionDB();
            PreparedStatement pstmt = null;
            ResultSet rs = null;
            try {
                String query = "SELECT RIFERIMENTO_MSG FROM MESSAGGI WHERE ID_EGOV=? AND TIPO=?";
                pstmt = connectionDB.prepareStatement(query);
                pstmt.setString(1, this.idEGov);
                pstmt.setString(2, this.tipo);
                rs = pstmt.executeQuery();
                String value = null;
                if (rs.next()) {
                    value = rs.getString("RIFERIMENTO_MSG");
                }
                rs.close();
                pstmt.close();
                return value;
            }
            catch (Exception e) {
                String errorMsg = "GESTORE_MESSAGGI, Errore get RIFERIMENTO_MSG " + this.tipo + "/" + this.idEGov + ": " + e.getMessage();
                try {
                    if (rs != null) {
                        rs.close();
                    }
                }
                catch (Exception er) {
                    // empty catch block
                }
                try {
                    if (pstmt != null) {
                        pstmt.close();
                    }
                }
                catch (Exception er) {
                    // empty catch block
                }
                this.log.error((Object)errorMsg, (Throwable)e);
                throw new GestoreMessaggiException(errorMsg, e);
            }
        }
        throw new GestoreMessaggiException("Metodo invocato con OpenSPCoopState non valido");
    }

    public String getIDCorrelazioneApplicativa() throws GestoreMessaggiException {
        String id = null;
        if (this.openspcoopstate instanceof OpenSPCoopStateful) {
            StatefulMessage stateful = this.isRichiesta ? (StatefulMessage)this.openspcoopstate.getStatoRichiesta() : (StatefulMessage)this.openspcoopstate.getStatoRisposta();
            Connection connectionDB = stateful.getConnectionDB();
            PreparedStatement pstmtRead = null;
            ResultSet rs = null;
            try {
                String query = "SELECT CORRELAZIONE_APPLICATIVA FROM MESSAGGI WHERE ID_EGOV = ? AND TIPO=?";
                pstmtRead = connectionDB.prepareStatement(query);
                pstmtRead.setString(1, this.idEGov);
                pstmtRead.setString(2, this.tipo);
                rs = pstmtRead.executeQuery();
                if (rs.next()) {
                    id = rs.getString("CORRELAZIONE_APPLICATIVA");
                }
                rs.close();
                pstmtRead.close();
                if (id == null) {
                    throw new Exception("ID di CorrelazioneApplicativa non registrata");
                }
                return id;
            }
            catch (Exception e) {
                String errorMsg = "GESTORE_MESSAGGI, Errore getIDCorrelazioneApplicativa " + this.tipo + "/" + this.idEGov + ": " + e.getMessage();
                try {
                    if (rs != null) {
                        rs.close();
                    }
                }
                catch (Exception er) {
                    // empty catch block
                }
                try {
                    if (pstmtRead != null) {
                        pstmtRead.close();
                    }
                }
                catch (Exception er) {
                    // empty catch block
                }
                if (!e.getMessage().equals("ID di CorrelazioneApplicativa non registrata")) {
                    this.log.error((Object)errorMsg, (Throwable)e);
                } else {
                    this.log.debug((Object)errorMsg, (Throwable)e);
                }
                throw new GestoreMessaggiException(errorMsg, e);
            }
        }
        if (this.openspcoopstate instanceof OpenSPCoopStateless) {
            return ((OpenSPCoopStateless)this.openspcoopstate).getIDCorrelazioneApplicativa();
        }
        throw new GestoreMessaggiException("Metodo invocato con OpenSPCoopState non valido");
    }

    public PdDContext getPdDContext() throws GestoreMessaggiException {
        if (this.openspcoopstate instanceof OpenSPCoopStateful) {
            StatefulMessage stateful = this.isRichiesta ? (StatefulMessage)this.openspcoopstate.getStatoRichiesta() : (StatefulMessage)this.openspcoopstate.getStatoRisposta();
            Connection connectionDB = stateful.getConnectionDB();
            Statement pstmtRead = null;
            ResultSet rs = null;
            try {
                Hashtable<String, String> contextSerializerParameters;
                StringBuffer fieldNamesPdDContext_db = new StringBuffer();
                Hashtable<String, String> mapping = new Hashtable<String, String>();
                if (this.pddContextSerializer != null && (contextSerializerParameters = this.pddContextSerializer.getGestoreMessaggiKeywords()) != null && contextSerializerParameters.size() > 0) {
                    Enumeration<String> keywordContext = contextSerializerParameters.keys();
                    while (keywordContext.hasMoreElements()) {
                        String keyword = keywordContext.nextElement();
                        if (fieldNamesPdDContext_db.length() > 0) {
                            fieldNamesPdDContext_db.append(" , ");
                        }
                        String nomeDB = contextSerializerParameters.get(keyword);
                        fieldNamesPdDContext_db.append(nomeDB);
                        mapping.put(nomeDB, keyword);
                    }
                }
                PdDContext pddContext = new PdDContext();
                if (mapping.size() <= 0) {
                    return pddContext;
                }
                String query = "SELECT " + fieldNamesPdDContext_db.toString() + " FROM " + MESSAGGI + " WHERE ID_EGOV = ? AND TIPO=?";
                pstmtRead = connectionDB.prepareStatement(query);
                pstmtRead.setString(1, this.idEGov);
                pstmtRead.setString(2, this.tipo);
                rs = pstmtRead.executeQuery();
                if (rs.next()) {
                    Enumeration keysDB = mapping.keys();
                    while (keysDB.hasMoreElements()) {
                        String keyDB = (String)keysDB.nextElement();
                        Object object = rs.getObject(keyDB);
                        pddContext.addObject((String)mapping.get(keyDB), object);
                    }
                } else {
                    throw new Exception("Messaggio non trovato");
                }
                rs.close();
                pstmtRead.close();
                return pddContext;
            }
            catch (Exception e) {
                String errorMsg = "GESTORE_MESSAGGI, Errore getPdDContext " + this.tipo + "/" + this.idEGov + ": " + e.getMessage();
                try {
                    if (rs != null) {
                        rs.close();
                    }
                }
                catch (Exception er) {
                    // empty catch block
                }
                try {
                    if (pstmtRead != null) {
                        pstmtRead.close();
                    }
                }
                catch (Exception er) {
                    // empty catch block
                }
                if (!e.getMessage().equals("Messaggio non trovato")) {
                    this.log.error((Object)errorMsg, (Throwable)e);
                } else {
                    this.log.debug((Object)errorMsg, (Throwable)e);
                }
                throw new GestoreMessaggiException(errorMsg, e);
            }
        }
        if (this.openspcoopstate instanceof OpenSPCoopStateless) {
            return ((OpenSPCoopStateless)this.openspcoopstate).getPddContext();
        }
        throw new GestoreMessaggiException("Metodo invocato con OpenSPCoopState non valido");
    }

    public boolean existsMessageForSIL(String servizioApplicativo) throws GestoreMessaggiException {
        return this.existsMessageForSIL(servizioApplicativo, false);
    }

    public boolean existsMessageForSIL(String servizioApplicativo, boolean searchForRiferimentoMsg) throws GestoreMessaggiException {
        if (this.openspcoopstate instanceof OpenSPCoopStateful) {
            StatefulMessage stateful = this.isRichiesta ? (StatefulMessage)this.openspcoopstate.getStatoRichiesta() : (StatefulMessage)this.openspcoopstate.getStatoRisposta();
            Connection connectionDB = stateful.getConnectionDB();
            PreparedStatement pstmt = null;
            ResultSet rs = null;
            try {
                String idEGovSearch = this.idEGov;
                if (searchForRiferimentoMsg) {
                    idEGovSearch = this.mapRiferimentoIntoIDEgov();
                }
                String query = "SELECT * FROM MSG_SERVIZI_APPLICATIVI,MESSAGGI WHERE MSG_SERVIZI_APPLICATIVI.ID_EGOV=? AND MSG_SERVIZI_APPLICATIVI.SERVIZIO_APPLICATIVO=? AND MSG_SERVIZI_APPLICATIVI.ID_EGOV=MESSAGGI.ID_EGOV AND MESSAGGI.PROPRIETARIO=?";
                pstmt = connectionDB.prepareStatement(query);
                pstmt.setString(1, idEGovSearch);
                pstmt.setString(2, servizioApplicativo);
                pstmt.setString(3, "ConsegnaContenutiApplicativi");
                rs = pstmt.executeQuery();
                if (rs.next()) {
                    rs.close();
                    pstmt.close();
                    return true;
                }
                rs.close();
                pstmt.close();
                return false;
            }
            catch (Exception e) {
                String errorMsg = "GESTORE_MESSAGGI, error existsMessage " + this.tipo + "/" + this.idEGov + ": " + e.getMessage();
                try {
                    if (rs != null) {
                        rs.close();
                    }
                }
                catch (Exception er) {
                    // empty catch block
                }
                try {
                    if (pstmt != null) {
                        pstmt.close();
                    }
                }
                catch (Exception er) {
                    // empty catch block
                }
                this.log.error((Object)errorMsg, (Throwable)e);
                throw new GestoreMessaggiException(errorMsg, e);
            }
        }
        throw new GestoreMessaggiException("Metodo invocato con OpenSPCoopState non valido");
    }

    public boolean checkAutorizzazione(String servizioApplicativo) throws GestoreMessaggiException {
        return this.checkAutorizzazione(servizioApplicativo, false);
    }

    public boolean checkAutorizzazione(String servizioApplicativo, boolean searchForRiferimentoMsg) throws GestoreMessaggiException {
        if (this.openspcoopstate instanceof OpenSPCoopStateful) {
            StatefulMessage stateful = this.isRichiesta ? (StatefulMessage)this.openspcoopstate.getStatoRichiesta() : (StatefulMessage)this.openspcoopstate.getStatoRisposta();
            Connection connectionDB = stateful.getConnectionDB();
            PreparedStatement pstmt = null;
            ResultSet rs = null;
            try {
                String idEGovSearch = this.idEGov;
                if (searchForRiferimentoMsg) {
                    idEGovSearch = this.mapRiferimentoIntoIDEgov();
                }
                String query = "SELECT INTEGRATION_MANAGER FROM MSG_SERVIZI_APPLICATIVI WHERE ID_EGOV=? AND SERVIZIO_APPLICATIVO=?";
                pstmt = connectionDB.prepareStatement(query);
                pstmt.setString(1, idEGovSearch);
                pstmt.setString(2, servizioApplicativo);
                rs = pstmt.executeQuery();
                boolean auth = false;
                if (rs.next() && rs.getInt("INTEGRATION_MANAGER") == 1) {
                    auth = true;
                }
                rs.close();
                pstmt.close();
                return auth;
            }
            catch (Exception e) {
                String errorMsg = "GESTORE_MESSAGGI, error existsMessage " + this.tipo + "/" + this.idEGov + ": " + e.getMessage();
                try {
                    if (rs != null) {
                        rs.close();
                    }
                }
                catch (Exception er) {
                    // empty catch block
                }
                try {
                    if (pstmt != null) {
                        pstmt.close();
                    }
                }
                catch (Exception er) {
                    // empty catch block
                }
                this.log.error((Object)errorMsg, (Throwable)e);
                throw new GestoreMessaggiException(errorMsg, e);
            }
        }
        throw new GestoreMessaggiException("Metodo invocato con OpenSPCoopState non valido");
    }

    public boolean sbustamentoSoap(String servizioApplicativo) throws GestoreMessaggiException {
        return this.sbustamentoSoap(servizioApplicativo, false);
    }

    public boolean sbustamentoSoap(String servizioApplicativo, boolean searchForRiferimentoMsg) throws GestoreMessaggiException {
        if (this.openspcoopstate instanceof OpenSPCoopStateful) {
            StatefulMessage stateful = this.isRichiesta ? (StatefulMessage)this.openspcoopstate.getStatoRichiesta() : (StatefulMessage)this.openspcoopstate.getStatoRisposta();
            Connection connectionDB = stateful.getConnectionDB();
            PreparedStatement pstmt = null;
            ResultSet rs = null;
            try {
                String idEGovSearch = this.idEGov;
                if (searchForRiferimentoMsg) {
                    idEGovSearch = this.mapRiferimentoIntoIDEgov();
                }
                String query = "SELECT SBUSTAMENTO_SOAP FROM MSG_SERVIZI_APPLICATIVI WHERE ID_EGOV=? AND SERVIZIO_APPLICATIVO=?";
                pstmt = connectionDB.prepareStatement(query);
                pstmt.setString(1, idEGovSearch);
                pstmt.setString(2, servizioApplicativo);
                rs = pstmt.executeQuery();
                boolean sbustamento = false;
                if (rs.next() && rs.getInt("SBUSTAMENTO_SOAP") == 1) {
                    sbustamento = true;
                }
                rs.close();
                pstmt.close();
                return sbustamento;
            }
            catch (Exception e) {
                String errorMsg = "GESTORE_MESSAGGI, error getSbustamentoSoap " + this.tipo + "/" + this.idEGov + ": " + e.getMessage();
                try {
                    if (rs != null) {
                        rs.close();
                    }
                }
                catch (Exception er) {
                    // empty catch block
                }
                try {
                    if (pstmt != null) {
                        pstmt.close();
                    }
                }
                catch (Exception er) {
                    // empty catch block
                }
                this.log.error((Object)errorMsg, (Throwable)e);
                throw new GestoreMessaggiException(errorMsg, e);
            }
        }
        throw new GestoreMessaggiException("Metodo invocato con OpenSPCoopState non valido");
    }

    public boolean existsMessageInProcessamento() throws GestoreMessaggiException {
        return this.existsMessageInProcessamento(false);
    }

    public boolean existsMessageInProcessamentoByReference() throws GestoreMessaggiException {
        return this.existsMessageInProcessamento(true);
    }

    private boolean existsMessageInProcessamento(boolean rifMsg) throws GestoreMessaggiException {
        if (this.openspcoopstate instanceof OpenSPCoopStateful) {
            StatefulMessage stateful = this.isRichiesta ? (StatefulMessage)this.openspcoopstate.getStatoRichiesta() : (StatefulMessage)this.openspcoopstate.getStatoRisposta();
            Connection connectionDB = stateful.getConnectionDB();
            Statement pstmt = null;
            ResultSet rs = null;
            try {
                StringBuffer bf = new StringBuffer();
                bf.append("SELECT ID_EGOV FROM ");
                bf.append(MESSAGGI);
                bf.append(" WHERE ");
                if (!rifMsg) {
                    bf.append("ID_EGOV=?");
                } else {
                    bf.append("RIFERIMENTO_MSG=?");
                }
                bf.append(" AND TIPO=? AND PROPRIETARIO<>?");
                pstmt = connectionDB.prepareStatement(bf.toString());
                pstmt.setString(1, this.idEGov);
                pstmt.setString(2, this.tipo);
                pstmt.setString(3, "GestoreMessaggi");
                rs = pstmt.executeQuery();
                if (rs.next()) {
                    rs.close();
                    pstmt.close();
                    return true;
                }
                rs.close();
                pstmt.close();
                return false;
            }
            catch (Exception e) {
                String errorMsg = "GESTORE_MESSAGGI, Errore existsMessageInProcessamento " + this.tipo + "/" + this.idEGov + ": " + e.getMessage();
                try {
                    if (rs != null) {
                        rs.close();
                    }
                }
                catch (Exception er) {
                    // empty catch block
                }
                try {
                    if (pstmt != null) {
                        pstmt.close();
                    }
                }
                catch (Exception er) {
                    // empty catch block
                }
                this.log.error((Object)errorMsg, (Throwable)e);
                return false;
            }
        }
        throw new GestoreMessaggiException("Metodo invocato con OpenSPCoopState non valido");
    }

    public Vector<String> getIDMessaggi_ServizioApplicativo(String servizioApplicativo) throws GestoreMessaggiException {
        return this.getIDMessaggi_ServizioApplicativo_engine(servizioApplicativo, -1, -1, null, null, null);
    }

    public Vector<String> getIDMessaggi_ServizioApplicativo(String servizioApplicativo, int counter) throws GestoreMessaggiException {
        return this.getIDMessaggi_ServizioApplicativo_engine(servizioApplicativo, counter, -1, null, null, null);
    }

    public Vector<String> getIDMessaggi_ServizioApplicativo(String servizioApplicativo, int counter, int offset) throws GestoreMessaggiException {
        return this.getIDMessaggi_ServizioApplicativo_engine(servizioApplicativo, counter, offset, null, null, null);
    }

    public Vector<String> getIDMessaggi_ServizioApplicativo(String servizioApplicativo, String tipoServizio, String servizio) throws GestoreMessaggiException {
        return this.getIDMessaggi_ServizioApplicativo_engine(servizioApplicativo, -1, -1, tipoServizio, servizio, null);
    }

    public Vector<String> getIDMessaggi_ServizioApplicativo(String servizioApplicativo, String tipoServizio, String servizio, int counter) throws GestoreMessaggiException {
        return this.getIDMessaggi_ServizioApplicativo_engine(servizioApplicativo, counter, -1, tipoServizio, servizio, null);
    }

    public Vector<String> getIDMessaggi_ServizioApplicativo(String servizioApplicativo, String tipoServizio, String servizio, int counter, int offset) throws GestoreMessaggiException {
        return this.getIDMessaggi_ServizioApplicativo_engine(servizioApplicativo, counter, offset, tipoServizio, servizio, null);
    }

    public Vector<String> getIDMessaggi_ServizioApplicativo(String servizioApplicativo, String tipoServizio, String servizio, String azione) throws GestoreMessaggiException {
        return this.getIDMessaggi_ServizioApplicativo_engine(servizioApplicativo, -1, -1, tipoServizio, servizio, azione);
    }

    public Vector<String> getIDMessaggi_ServizioApplicativo(String servizioApplicativo, String tipoServizio, String servizio, String azione, int counter) throws GestoreMessaggiException {
        return this.getIDMessaggi_ServizioApplicativo_engine(servizioApplicativo, counter, -1, tipoServizio, servizio, azione);
    }

    public Vector<String> getIDMessaggi_ServizioApplicativo(String servizioApplicativo, String tipoServizio, String servizio, String azione, int counter, int offset) throws GestoreMessaggiException {
        return this.getIDMessaggi_ServizioApplicativo_engine(servizioApplicativo, counter, offset, tipoServizio, servizio, azione);
    }

    private Vector<String> getIDMessaggi_ServizioApplicativo_engine(String servizioApplicativo, int counter, int offset, String tipoServizio, String servizio, String azione) throws GestoreMessaggiException {
        if (this.openspcoopstate instanceof OpenSPCoopStateful) {
            StatefulMessage stateful = this.isRichiesta ? (StatefulMessage)this.openspcoopstate.getStatoRichiesta() : (StatefulMessage)this.openspcoopstate.getStatoRisposta();
            Connection connectionDB = stateful.getConnectionDB();
            Statement pstmt = null;
            ResultSet rs = null;
            Vector<String> ids = new Vector<String>();
            String queryString = null;
            try {
                if (Configurazione.getSqlQueryObjectType() == null) {
                    if (offset >= 0) {
                        throw new GestoreMessaggiException("La funzione di ricerca tramite offset e limit non e' utilizzabile se nella configurazione della PdD non viene specificato il tipo di database");
                    }
                    StringBuffer query = new StringBuffer();
                    query.append("SELECT ");
                    query.append(MSG_SERVIZI_APPLICATIVI);
                    query.append(".ID_EGOV as IdMsgServizioApplicativo FROM ");
                    query.append(MSG_SERVIZI_APPLICATIVI);
                    query.append(",");
                    query.append(MESSAGGI);
                    if (tipoServizio != null || servizio != null || azione != null) {
                        query.append(",");
                        query.append("REPOSITORY_EGOV");
                    }
                    query.append(" WHERE ");
                    query.append(MSG_SERVIZI_APPLICATIVI);
                    query.append(".ID_EGOV=");
                    query.append(MESSAGGI);
                    query.append(".ID_EGOV AND ");
                    if (tipoServizio != null || servizio != null || azione != null) {
                        query.append("REPOSITORY_EGOV");
                        query.append(".ID_EGOV=");
                        query.append(MESSAGGI);
                        query.append(".ID_EGOV AND ");
                        query.append("REPOSITORY_EGOV");
                        query.append(".TIPO=");
                        query.append(MESSAGGI);
                        query.append(".TIPO AND ");
                    }
                    query.append(MSG_SERVIZI_APPLICATIVI);
                    query.append(".SERVIZIO_APPLICATIVO=? AND ");
                    query.append(MSG_SERVIZI_APPLICATIVI);
                    query.append(".INTEGRATION_MANAGER=1 AND ");
                    query.append(MESSAGGI);
                    query.append(".TIPO=? AND ");
                    query.append(MESSAGGI);
                    query.append(".PROPRIETARIO=? ");
                    if (tipoServizio != null) {
                        query.append("AND ");
                        query.append("REPOSITORY_EGOV");
                        query.append(".TIPO_SERVIZIO=? ");
                    }
                    if (servizio != null) {
                        query.append("AND ");
                        query.append("REPOSITORY_EGOV");
                        query.append(".SERVIZIO=? ");
                    }
                    if (azione != null) {
                        query.append("AND ");
                        query.append("REPOSITORY_EGOV");
                        query.append(".AZIONE=? ");
                    }
                    query.append("ORDER BY ");
                    query.append(MESSAGGI);
                    query.append(".ORA_REGISTRAZIONE,");
                    query.append(MESSAGGI);
                    query.append(".ID_EGOV");
                    queryString = query.toString();
                } else {
                    ISQLQueryObject sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)Configurazione.getSqlQueryObjectType());
                    sqlQueryObject.addFromTable(MSG_SERVIZI_APPLICATIVI);
                    sqlQueryObject.addFromTable(MESSAGGI);
                    if (tipoServizio != null || servizio != null || azione != null) {
                        sqlQueryObject.addFromTable("REPOSITORY_EGOV");
                    }
                    sqlQueryObject.addSelectAliasField(MSG_SERVIZI_APPLICATIVI, "ID_EGOV", "IdMsgServizioApplicativo");
                    sqlQueryObject.addSelectAliasField(MESSAGGI, "ID_EGOV", "IdEgovMessaggio");
                    sqlQueryObject.addSelectAliasField(MESSAGGI, "TIPO", "TipoMessaggio");
                    sqlQueryObject.addSelectAliasField(MESSAGGI, "ORA_REGISTRAZIONE", "OraMessaggio");
                    sqlQueryObject.addSelectField(MESSAGGI, "PROPRIETARIO");
                    sqlQueryObject.addSelectField(MSG_SERVIZI_APPLICATIVI, "SERVIZIO_APPLICATIVO");
                    sqlQueryObject.addSelectField(MSG_SERVIZI_APPLICATIVI, "INTEGRATION_MANAGER");
                    sqlQueryObject.addWhereCondition("MSG_SERVIZI_APPLICATIVI.ID_EGOV=MESSAGGI.ID_EGOV");
                    if (tipoServizio != null || servizio != null || azione != null) {
                        sqlQueryObject.addSelectAliasField("REPOSITORY_EGOV", "ID_EGOV", "IdEgovRepositoryEGov");
                        sqlQueryObject.addSelectAliasField("REPOSITORY_EGOV", "TIPO", "TipoEgovRepositoryEGov");
                        sqlQueryObject.addSelectAliasField("REPOSITORY_EGOV", "ORA_REGISTRAZIONE", "OraRepositoryEGov");
                        sqlQueryObject.addWhereCondition("REPOSITORY_EGOV.ID_EGOV=MESSAGGI.ID_EGOV");
                        sqlQueryObject.addWhereCondition("REPOSITORY_EGOV.TIPO=MESSAGGI.TIPO");
                    }
                    sqlQueryObject.addWhereCondition("MSG_SERVIZI_APPLICATIVI.SERVIZIO_APPLICATIVO=?");
                    sqlQueryObject.addWhereCondition("MSG_SERVIZI_APPLICATIVI.INTEGRATION_MANAGER=1");
                    sqlQueryObject.addWhereCondition("MESSAGGI.TIPO=?");
                    sqlQueryObject.addWhereCondition("MESSAGGI.PROPRIETARIO=?");
                    if (tipoServizio != null) {
                        sqlQueryObject.addSelectField("REPOSITORY_EGOV", "TIPO_SERVIZIO");
                        sqlQueryObject.addWhereCondition("REPOSITORY_EGOV.TIPO_SERVIZIO=?");
                    }
                    if (servizio != null) {
                        sqlQueryObject.addSelectField("REPOSITORY_EGOV", "SERVIZIO");
                        sqlQueryObject.addWhereCondition("REPOSITORY_EGOV.SERVIZIO=?");
                    }
                    if (azione != null) {
                        sqlQueryObject.addSelectField("REPOSITORY_EGOV", "AZIONE");
                        sqlQueryObject.addWhereCondition("REPOSITORY_EGOV.AZIONE=?");
                    }
                    sqlQueryObject.setANDLogicOperator(true);
                    sqlQueryObject.addOrderBy("OraMessaggio");
                    sqlQueryObject.addOrderBy("IdEgovMessaggio");
                    sqlQueryObject.setSortType(true);
                    if (counter >= 0) {
                        sqlQueryObject.setLimit(counter);
                    }
                    if (offset >= 0) {
                        sqlQueryObject.setOffset(offset);
                    }
                    queryString = sqlQueryObject.createSQLQuery();
                }
                pstmt = connectionDB.prepareStatement(queryString);
                pstmt.setString(1, servizioApplicativo);
                pstmt.setString(2, "INBOX");
                pstmt.setString(3, "ConsegnaContenutiApplicativi");
                int indexPstmt = 4;
                if (tipoServizio != null) {
                    pstmt.setString(indexPstmt, tipoServizio);
                    ++indexPstmt;
                }
                if (servizio != null) {
                    pstmt.setString(indexPstmt, servizio);
                    ++indexPstmt;
                }
                if (azione != null) {
                    pstmt.setString(indexPstmt, azione);
                    ++indexPstmt;
                }
                rs = pstmt.executeQuery();
                int countLimit = 0;
                while (rs.next()) {
                    ids.add(rs.getString("IdMsgServizioApplicativo"));
                    if (counter < 0 || Configurazione.getSqlQueryObjectType() != null || ++countLimit != counter) continue;
                }
                rs.close();
                pstmt.close();
            }
            catch (Exception e) {
                String errorMsg = "[GestoreMessaggi.getIDMessaggi_ServizioApplicativo_engine] errore, queryString[" + queryString + "]: " + e.getMessage();
                try {
                    if (rs != null) {
                        rs.close();
                    }
                }
                catch (Exception er) {
                    // empty catch block
                }
                try {
                    if (pstmt != null) {
                        pstmt.close();
                    }
                }
                catch (Exception er) {
                    // empty catch block
                }
                this.log.error((Object)errorMsg, (Throwable)e);
                throw new GestoreMessaggiException(errorMsg, e);
            }
            return ids;
        }
        throw new GestoreMessaggiException("Metodo invocato con OpenSPCoopState non valido");
    }

    @Deprecated
    public void eliminaDestinatarioMessaggio_serializable(String servizioApplicativo, String riferimentoMessaggio) throws GestoreMessaggiException {
        this.eliminaDestinatarioMessaggio_serializable(servizioApplicativo, riferimentoMessaggio, 60000L, 100);
    }

    @Deprecated
    public void eliminaDestinatarioMessaggio_serializable(String servizioApplicativo, String riferimentoMessaggio, long attesaAttiva, int checkInterval) throws GestoreMessaggiException {
        if (this.openspcoopstate instanceof OpenSPCoopStateful) {
            StatefulMessage stateful = this.isRichiesta ? (StatefulMessage)this.openspcoopstate.getStatoRichiesta() : (StatefulMessage)this.openspcoopstate.getStatoRisposta();
            Connection connectionDB = stateful.getConnectionDB();
            int oldTransactionIsolation = -1;
            try {
                oldTransactionIsolation = connectionDB.getTransactionIsolation();
                connectionDB.setAutoCommit(false);
                connectionDB.setTransactionIsolation(8);
            }
            catch (Exception er) {
                String errorMsg = "GESTORE_MESSAGGI, error  eliminaDestinatarioMessaggio (setIsolation)" + this.idEGov + "/" + servizioApplicativo + ": " + er.getMessage();
                this.log.error((Object)errorMsg, (Throwable)er);
                throw new GestoreMessaggiException(errorMsg, er);
            }
            boolean deleteDestinatarioOK = false;
            long scadenzaWhile = DateManager.getTimeMillis() + attesaAttiva;
            while (!deleteDestinatarioOK && DateManager.getTimeMillis() < scadenzaWhile) {
                PreparedStatement pstmtDeleteSIL = null;
                try {
                    String query = "DELETE FROM MSG_SERVIZI_APPLICATIVI WHERE ID_EGOV=? AND SERVIZIO_APPLICATIVO=?";
                    pstmtDeleteSIL = connectionDB.prepareStatement(query);
                    pstmtDeleteSIL.setString(1, this.idEGov);
                    pstmtDeleteSIL.setString(2, servizioApplicativo);
                    pstmtDeleteSIL.executeUpdate();
                    pstmtDeleteSIL.close();
                    connectionDB.commit();
                    stateful.updateConnection(connectionDB);
                    if (this.isRichiesta) {
                        this.openspcoopstate.setStatoRichiesta((IState)stateful);
                    } else {
                        this.openspcoopstate.setStatoRisposta((IState)stateful);
                    }
                    deleteDestinatarioOK = true;
                }
                catch (Exception e) {
                    try {
                        if (pstmtDeleteSIL != null) {
                            pstmtDeleteSIL.close();
                        }
                    }
                    catch (Exception er) {
                        // empty catch block
                    }
                    try {
                        connectionDB.rollback();
                        stateful.updateConnection(connectionDB);
                        if (this.isRichiesta) {
                            this.openspcoopstate.setStatoRichiesta((IState)stateful);
                        } else {
                            this.openspcoopstate.setStatoRisposta((IState)stateful);
                        }
                    }
                    catch (Exception er) {
                        // empty catch block
                    }
                }
                if (deleteDestinatarioOK) continue;
                try {
                    Thread.sleep(new Random().nextInt(checkInterval));
                }
                catch (Exception eRandom) {}
            }
            boolean deleteRiferimentoMsgOK = false;
            boolean eliminazioneRifCompleta = false;
            scadenzaWhile = DateManager.getTimeMillis() + attesaAttiva;
            while (!deleteRiferimentoMsgOK && DateManager.getTimeMillis() < scadenzaWhile) {
                Statement pstmtUpdateMsg = null;
                PreparedStatement pstmt = null;
                ResultSet rs = null;
                try {
                    String query = "SELECT  * FROM MSG_SERVIZI_APPLICATIVI WHERE ID_EGOV=? FOR UPDATE";
                    pstmt = connectionDB.prepareStatement(query);
                    pstmt.setString(1, this.idEGov);
                    rs = pstmt.executeQuery();
                    eliminazioneRifCompleta = !rs.next();
                    rs.close();
                    pstmt.close();
                    if (eliminazioneRifCompleta) {
                        StringBuffer queryUpdate = new StringBuffer();
                        queryUpdate.append("UPDATE ");
                        queryUpdate.append(MESSAGGI);
                        queryUpdate.append(" SET PROPRIETARIO=? WHERE  ID_EGOV = ? AND TIPO=?");
                        pstmtUpdateMsg = connectionDB.prepareStatement(queryUpdate.toString());
                        pstmtUpdateMsg.setString(1, "GestoreMessaggi");
                        pstmtUpdateMsg.setString(2, this.idEGov);
                        pstmtUpdateMsg.setString(3, "INBOX");
                        pstmtUpdateMsg.execute();
                        pstmtUpdateMsg.close();
                        this.addProprietarioIntoTable("INBOX", this.idEGov, "GestoreMessaggi");
                    }
                    connectionDB.commit();
                    stateful.updateConnection(connectionDB);
                    if (this.isRichiesta) {
                        this.openspcoopstate.setStatoRichiesta((IState)stateful);
                    } else {
                        this.openspcoopstate.setStatoRisposta((IState)stateful);
                    }
                    deleteRiferimentoMsgOK = true;
                }
                catch (Exception e) {
                    try {
                        if (pstmtUpdateMsg != null) {
                            pstmtUpdateMsg.close();
                        }
                    }
                    catch (Exception er) {
                        // empty catch block
                    }
                    try {
                        if (rs != null) {
                            rs.close();
                        }
                    }
                    catch (Exception er) {
                        // empty catch block
                    }
                    try {
                        if (pstmt != null) {
                            pstmt.close();
                        }
                    }
                    catch (Exception er) {
                        // empty catch block
                    }
                    try {
                        connectionDB.rollback();
                        stateful.updateConnection(connectionDB);
                        if (this.isRichiesta) {
                            this.openspcoopstate.setStatoRichiesta((IState)stateful);
                        } else {
                            this.openspcoopstate.setStatoRisposta((IState)stateful);
                        }
                    }
                    catch (Exception er) {
                        // empty catch block
                    }
                }
                if (!deleteRiferimentoMsgOK) {
                    try {
                        Thread.sleep(new Random().nextInt(checkInterval));
                    }
                    catch (Exception eRandom) {
                        // empty catch block
                    }
                }
                if (!eliminazioneRifCompleta) continue;
                this.addProprietariIntoCache_readFromTable("GestoreMessaggi", "eliminaDestinatarioMessaggio_serializable", riferimentoMessaggio, false);
            }
            try {
                connectionDB.setTransactionIsolation(oldTransactionIsolation);
                connectionDB.setAutoCommit(true);
                stateful.updateConnection(connectionDB);
                if (this.isRichiesta) {
                    this.openspcoopstate.setStatoRichiesta((IState)stateful);
                }
                this.openspcoopstate.setStatoRisposta((IState)stateful);
            }
            catch (Exception er) {
                String errorMsg = "GESTORE_MESSAGGI, error  eliminaDestinatarioMessaggio (ripristinoIsolation)" + this.idEGov + "/" + servizioApplicativo + ": " + er.getMessage();
                this.log.error((Object)errorMsg, (Throwable)er);
                throw new GestoreMessaggiException(errorMsg, er);
            }
        } else if (!(this.openspcoopstate instanceof OpenSPCoopStateless)) {
            throw new GestoreMessaggiException("Metodo invocato con OpenSPCoopState non valido");
        }
    }

    public void eliminaDestinatarioMessaggio(String servizioApplicativo, String riferimentoMessaggio) throws GestoreMessaggiException {
        if (this.openspcoopstate instanceof OpenSPCoopStateful || this.oneWayVersione11) {
            StateMessage stateMSG = this.isRichiesta ? (StateMessage)this.openspcoopstate.getStatoRichiesta() : (StateMessage)this.openspcoopstate.getStatoRisposta();
            Connection connectionDB = stateMSG.getConnectionDB();
            Statement pstmtDeleteSIL = null;
            try {
                this.log.debug((Object)("DELETE MSG_SERVIZI_APPLICATIVI WHERE ID_EGOV='" + this.idEGov + "' AND SERVIZIO_APPLICATIVO='" + servizioApplicativo + "'"));
                String query = "DELETE FROM MSG_SERVIZI_APPLICATIVI WHERE ID_EGOV=? AND SERVIZIO_APPLICATIVO=?";
                pstmtDeleteSIL = connectionDB.prepareStatement(query);
                pstmtDeleteSIL.setString(1, this.idEGov);
                pstmtDeleteSIL.setString(2, servizioApplicativo);
                pstmtDeleteSIL.executeUpdate();
                pstmtDeleteSIL.close();
            }
            catch (Exception e) {
                try {
                    if (pstmtDeleteSIL != null) {
                        pstmtDeleteSIL.close();
                    }
                }
                catch (Exception er) {
                    // empty catch block
                }
                String msgError = "ERROR ELIMINAZIONE DESTINATARIO MESSAGGIO: " + e.getMessage();
                this.log.error((Object)msgError, (Throwable)e);
                throw new GestoreMessaggiException(msgError, e);
            }
            Statement pstmtUpdateMsg = null;
            PreparedStatement pstmt = null;
            ResultSet rs = null;
            try {
                String query = "SELECT  * FROM MSG_SERVIZI_APPLICATIVI WHERE ID_EGOV=?";
                pstmt = connectionDB.prepareStatement(query);
                pstmt.setString(1, this.idEGov);
                rs = pstmt.executeQuery();
                boolean eliminazioneRifCompleta = !rs.next();
                rs.close();
                pstmt.close();
                if (eliminazioneRifCompleta) {
                    RepositoryEGov repositoryEGov = new RepositoryEGov((IState)stateMSG, this.isRichiesta);
                    repositoryEGov.eliminaUtilizzoPdDFromInBox(this.idEGov);
                    if (this.oneWayVersione11) {
                        repositoryEGov.eliminaBustaStatelessFromInBox(this.idEGov);
                    }
                    StringBuffer queryUpdate = new StringBuffer();
                    queryUpdate.append("UPDATE ");
                    queryUpdate.append(MESSAGGI);
                    queryUpdate.append(" SET PROPRIETARIO=? WHERE  ID_EGOV = ? AND TIPO=?");
                    pstmtUpdateMsg = connectionDB.prepareStatement(queryUpdate.toString());
                    pstmtUpdateMsg.setString(1, "GestoreMessaggi");
                    pstmtUpdateMsg.setString(2, this.idEGov);
                    pstmtUpdateMsg.setString(3, "INBOX");
                    stateMSG.getPreparedStatement().put("UPDATE aggiornaProprietarioMessaggioOpenSPCoop " + this.tipo + "/" + this.idEGov, pstmtUpdateMsg);
                    this.addProprietarioIntoTable("INBOX", this.idEGov, "GestoreMessaggi");
                    boolean oldValue = false;
                    if (this.oneWayVersione11) {
                        oldValue = ((OpenSPCoopStateless)this.openspcoopstate).isUseConnection();
                        ((OpenSPCoopStateless)this.openspcoopstate).setUseConnection(true);
                    }
                    this.openspcoopstate.commit();
                    if (this.oneWayVersione11) {
                        ((OpenSPCoopStateless)this.openspcoopstate).setUseConnection(oldValue);
                    }
                }
                if (eliminazioneRifCompleta) {
                    this.addProprietariIntoCache_readFromTable("GestoreMessaggi", "eliminaDestinatarioMessaggio", riferimentoMessaggio, false);
                }
                if (this.isRichiesta) {
                    this.openspcoopstate.setStatoRichiesta((IState)stateMSG);
                }
                this.openspcoopstate.setStatoRisposta((IState)stateMSG);
            }
            catch (Exception e) {
                try {
                    if (pstmtUpdateMsg != null) {
                        pstmtUpdateMsg.close();
                    }
                }
                catch (Exception er) {
                    // empty catch block
                }
                try {
                    if (rs != null) {
                        rs.close();
                    }
                }
                catch (Exception er) {
                    // empty catch block
                }
                try {
                    if (pstmt != null) {
                        pstmt.close();
                    }
                }
                catch (Exception er) {
                    // empty catch block
                }
                String msgError = "ERROR ELIMINAZIONE DESTINATARIO MESSAGGIO, STEP 2: " + e.getMessage();
                this.log.error((Object)msgError, (Throwable)e);
                throw new GestoreMessaggiException(msgError, e);
            }
        } else if (!(this.openspcoopstate instanceof OpenSPCoopStateless) || this.oneWayVersione11) {
            throw new GestoreMessaggiException("Metodo invocato con OpenSPCoopState non valido");
        }
    }

    public Vector<String> readMessaggiInutiliIntoInbox(String idModuloCleaner, int limit, boolean logQuery) throws GestoreMessaggiException {
        return this.readMessaggiInutiliIntoBox(true, idModuloCleaner, limit, logQuery);
    }

    public Vector<String> readMessaggiInutiliIntoOutbox(String idModuloCleaner, int limit, boolean logQuery) throws GestoreMessaggiException {
        return this.readMessaggiInutiliIntoBox(false, idModuloCleaner, limit, logQuery);
    }

    private Vector<String> readMessaggiInutiliIntoBox(boolean searchIntoInbox, String idModuloCleaner, int limit, boolean logQuery) throws GestoreMessaggiException {
        if (this.openspcoopstate instanceof OpenSPCoopStateful) {
            StatefulMessage stateful = this.isRichiesta ? (StatefulMessage)this.openspcoopstate.getStatoRichiesta() : (StatefulMessage)this.openspcoopstate.getStatoRisposta();
            Connection connectionDB = stateful.getConnectionDB();
            Vector<String> idMsg = new Vector<String>();
            Statement pstmtMsgEliminati = null;
            ResultSet rs = null;
            String queryString = null;
            try {
                String tipo = null;
                tipo = searchIntoInbox ? "INBOX" : "OUTBOX";
                if (Configurazione.getSqlQueryObjectType() == null) {
                    StringBuffer query = new StringBuffer();
                    query.append("SELECT ID_EGOV FROM ");
                    query.append(MESSAGGI);
                    query.append(" WHERE TIPO=? AND PROPRIETARIO=? ");
                    queryString = query.toString();
                } else {
                    ISQLQueryObject sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)Configurazione.getSqlQueryObjectType());
                    sqlQueryObject.addSelectField("ID_EGOV");
                    sqlQueryObject.addSelectField("ORA_REGISTRAZIONE");
                    sqlQueryObject.addSelectField("PROPRIETARIO");
                    sqlQueryObject.addSelectField("TIPO");
                    sqlQueryObject.addFromTable(MESSAGGI);
                    sqlQueryObject.addWhereCondition("TIPO=?");
                    sqlQueryObject.addWhereCondition("PROPRIETARIO=?");
                    sqlQueryObject.setANDLogicOperator(true);
                    sqlQueryObject.addOrderBy("ORA_REGISTRAZIONE");
                    sqlQueryObject.setSortType(true);
                    sqlQueryObject.setLimit(limit);
                    queryString = sqlQueryObject.createSQLQuery();
                }
                pstmtMsgEliminati = connectionDB.prepareStatement(queryString);
                pstmtMsgEliminati.setString(1, tipo);
                pstmtMsgEliminati.setString(2, idModuloCleaner);
                long startDateSQLCommand = DateManager.getTimeMillis();
                if (logQuery) {
                    this.log.debug((Object)("[QUERY] (Messaggi.eliminatiLogicamente) [" + queryString + "] 1[" + idModuloCleaner + "]  2[" + tipo + "]..."));
                }
                rs = pstmtMsgEliminati.executeQuery();
                long endDateSQLCommand = DateManager.getTimeMillis();
                long secondSQLCommand = (endDateSQLCommand - startDateSQLCommand) / 1000L;
                if (logQuery) {
                    this.log.debug((Object)("[QUERY] (Messaggi.eliminatiLogicamente) [" + queryString + "] 1[" + idModuloCleaner + "]  2[" + tipo + "] effettuata in " + secondSQLCommand + " secondi"));
                }
                int countLimit = 0;
                while (rs.next()) {
                    idMsg.add(rs.getString("ID_EGOV"));
                    if (Configurazione.getSqlQueryObjectType() != null || ++countLimit != limit) continue;
                }
                rs.close();
                pstmtMsgEliminati.close();
                return idMsg;
            }
            catch (Exception e) {
                String errorMsg = "[GestoreMessaggi.readMessaggiInutiliIntoBox] errore, queryString[" + queryString + "]: " + e.getMessage();
                try {
                    if (rs != null) {
                        rs.close();
                    }
                }
                catch (Exception er) {
                    // empty catch block
                }
                try {
                    if (pstmtMsgEliminati != null) {
                        pstmtMsgEliminati.close();
                    }
                }
                catch (Exception er) {
                    // empty catch block
                }
                this.log.error((Object)errorMsg, (Throwable)e);
                throw new GestoreMessaggiException(errorMsg, e);
            }
        }
        throw new GestoreMessaggiException("Metodo invocato con OpenSPCoopState non valido");
    }

    public Vector<String> readMessaggiScadutiIntoInbox(long scadenzaMsg, int limit, boolean logQuery) throws GestoreMessaggiException {
        return this.readMessaggiScadutiIntoBox(true, scadenzaMsg, limit, logQuery);
    }

    public Vector<String> readMessaggiScadutiIntoOutbox(long scadenzaMsg, int limit, boolean logQuery) throws GestoreMessaggiException {
        return this.readMessaggiScadutiIntoBox(false, scadenzaMsg, limit, logQuery);
    }

    private Vector<String> readMessaggiScadutiIntoBox(boolean searchIntoInbox, long scadenzaMsg, int limit, boolean logQuery) throws GestoreMessaggiException {
        if (this.openspcoopstate instanceof OpenSPCoopStateful) {
            StatefulMessage stateful = this.isRichiesta ? (StatefulMessage)this.openspcoopstate.getStatoRichiesta() : (StatefulMessage)this.openspcoopstate.getStatoRisposta();
            Connection connectionDB = stateful.getConnectionDB();
            Vector<String> idMsg = new Vector<String>();
            Statement pstmtMsgScaduti = null;
            ResultSet rs = null;
            String queryString = null;
            try {
                String tipo = null;
                tipo = searchIntoInbox ? "INBOX" : "OUTBOX";
                long scadenza = DateManager.getTimeMillis() - scadenzaMsg * 60L * 1000L;
                Timestamp scandenzaT = new Timestamp(scadenza);
                if (Configurazione.getSqlQueryObjectType() == null) {
                    StringBuffer query = new StringBuffer();
                    query.append("SELECT ID_EGOV FROM ");
                    query.append(MESSAGGI);
                    query.append(" WHERE ? > ORA_REGISTRAZIONE AND TIPO=?");
                    queryString = query.toString();
                } else {
                    ISQLQueryObject sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)Configurazione.getSqlQueryObjectType());
                    sqlQueryObject.addSelectField("ID_EGOV");
                    sqlQueryObject.addSelectField("ORA_REGISTRAZIONE");
                    sqlQueryObject.addSelectField("TIPO");
                    sqlQueryObject.addFromTable(MESSAGGI);
                    sqlQueryObject.addWhereCondition("? > ORA_REGISTRAZIONE");
                    sqlQueryObject.addWhereCondition("TIPO=?");
                    sqlQueryObject.setANDLogicOperator(true);
                    sqlQueryObject.addOrderBy("ORA_REGISTRAZIONE");
                    sqlQueryObject.setSortType(true);
                    sqlQueryObject.setLimit(limit);
                    queryString = sqlQueryObject.createSQLQuery();
                }
                pstmtMsgScaduti = connectionDB.prepareStatement(queryString);
                pstmtMsgScaduti.setTimestamp(1, scandenzaT);
                pstmtMsgScaduti.setString(2, tipo);
                long startDateSQLCommand = DateManager.getTimeMillis();
                if (logQuery) {
                    this.log.debug((Object)("[QUERY] (Messaggi.scaduti) [" + queryString + "] 1[" + scandenzaT + "] 2[" + tipo + "]..."));
                }
                rs = pstmtMsgScaduti.executeQuery();
                long endDateSQLCommand = DateManager.getTimeMillis();
                long secondSQLCommand = (endDateSQLCommand - startDateSQLCommand) / 1000L;
                if (logQuery) {
                    this.log.debug((Object)("[QUERY] (Messaggi.scaduti) [" + queryString + "] 1[" + scandenzaT + "] 2[" + tipo + "] effettuata in " + secondSQLCommand + " secondi"));
                }
                int countLimit = 0;
                while (rs.next()) {
                    idMsg.add(rs.getString("ID_EGOV"));
                    if (Configurazione.getSqlQueryObjectType() != null || ++countLimit != limit) continue;
                }
                rs.close();
                pstmtMsgScaduti.close();
                return idMsg;
            }
            catch (Exception e) {
                String errorMsg = "[GestoreMessaggi.readMessaggiScadutiIntoBox] errore, queryString[" + queryString + "]: " + e.getMessage();
                try {
                    if (rs != null) {
                        rs.close();
                    }
                }
                catch (Exception er) {
                    // empty catch block
                }
                try {
                    if (pstmtMsgScaduti != null) {
                        pstmtMsgScaduti.close();
                    }
                }
                catch (Exception er) {
                    // empty catch block
                }
                this.log.error((Object)errorMsg, (Throwable)e);
                throw new GestoreMessaggiException(errorMsg, e);
            }
        }
        throw new GestoreMessaggiException("Metodo invocato con OpenSPCoopState non valido");
    }

    public boolean existsServiziApplicativiDestinatariMessaggio() throws GestoreMessaggiException {
        if (this.openspcoopstate instanceof OpenSPCoopStateful) {
            StatefulMessage stateful = this.isRichiesta ? (StatefulMessage)this.openspcoopstate.getStatoRichiesta() : (StatefulMessage)this.openspcoopstate.getStatoRisposta();
            Connection connectionDB = stateful.getConnectionDB();
            PreparedStatement pstmtExistsAnotherServiziApplicativi = null;
            ResultSet rs = null;
            String queryString = null;
            try {
                StringBuffer query = new StringBuffer();
                query.append("SELECT SERVIZIO_APPLICATIVO FROM ");
                query.append(MSG_SERVIZI_APPLICATIVI);
                query.append(" WHERE ID_EGOV=?");
                queryString = query.toString();
                pstmtExistsAnotherServiziApplicativi = connectionDB.prepareStatement(queryString);
                pstmtExistsAnotherServiziApplicativi.setString(1, this.idEGov);
                rs = pstmtExistsAnotherServiziApplicativi.executeQuery();
                boolean risultato = rs.next();
                rs.close();
                pstmtExistsAnotherServiziApplicativi.close();
                return risultato;
            }
            catch (Exception e) {
                String errorMsg = "[GestoreMessaggi.existsServiziApplicativiDestinatariMessaggio] errore, queryString[" + queryString + "]: " + e.getMessage();
                try {
                    if (rs != null) {
                        rs.close();
                    }
                }
                catch (Exception er) {
                    // empty catch block
                }
                try {
                    if (pstmtExistsAnotherServiziApplicativi != null) {
                        pstmtExistsAnotherServiziApplicativi.close();
                    }
                }
                catch (Exception er) {
                    // empty catch block
                }
                this.log.error((Object)errorMsg, (Throwable)e);
                throw new GestoreMessaggiException(errorMsg, e);
            }
        }
        throw new GestoreMessaggiException("Metodo invocato con OpenSPCoopState non valido");
    }

    public Vector<String> readMsgForRicezioneContenutiApplicativiNonGestiti(long timeout, int limit, boolean logQuery) throws GestoreMessaggiException {
        if (this.openspcoopstate instanceof OpenSPCoopStateful) {
            StatefulMessage stateful = this.isRichiesta ? (StatefulMessage)this.openspcoopstate.getStatoRichiesta() : (StatefulMessage)this.openspcoopstate.getStatoRisposta();
            Connection connectionDB = stateful.getConnectionDB();
            Vector<String> idMsg = new Vector<String>();
            Statement pstmtMsgScaduti = null;
            ResultSet rs = null;
            String queryString = null;
            try {
                long scadenza = DateManager.getTimeMillis() - timeout;
                Timestamp scandenzaT = new Timestamp(scadenza);
                if (Configurazione.getSqlQueryObjectType() == null) {
                    StringBuffer query = new StringBuffer();
                    query.append("SELECT MESSAGGI.ID_EGOV as identificativoEGov,MSG_SERVIZI_APPLICATIVI.SERVIZIO_APPLICATIVO FROM ");
                    query.append(MESSAGGI);
                    query.append(",");
                    query.append(MSG_SERVIZI_APPLICATIVI);
                    query.append(" WHERE ? > MESSAGGI.ORA_REGISTRAZIONE AND MESSAGGI.RIFERIMENTO_MSG IS NOT NULL AND MESSAGGI.TIPO=? AND MSG_SERVIZI_APPLICATIVI.TIPO_CONSEGNA=? AND MESSAGGI.PROPRIETARIO LIKE 'RicezioneContenutiApplicativi%' AND MSG_SERVIZI_APPLICATIVI.INTEGRATION_MANAGER=? AND MESSAGGI.ID_EGOV=MSG_SERVIZI_APPLICATIVI.ID_EGOV ");
                    queryString = query.toString();
                } else {
                    ISQLQueryObject sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)Configurazione.getSqlQueryObjectType());
                    sqlQueryObject.addFromTable(MESSAGGI);
                    sqlQueryObject.addFromTable(MSG_SERVIZI_APPLICATIVI);
                    sqlQueryObject.addSelectAliasField(MESSAGGI, "ID_EGOV", "identificativoEGov");
                    sqlQueryObject.addSelectField("SERVIZIO_APPLICATIVO");
                    sqlQueryObject.addSelectField("ORA_REGISTRAZIONE");
                    sqlQueryObject.addSelectField("RIFERIMENTO_MSG");
                    sqlQueryObject.addSelectField("TIPO");
                    sqlQueryObject.addSelectField("TIPO_CONSEGNA");
                    sqlQueryObject.addSelectField("PROPRIETARIO");
                    sqlQueryObject.addSelectField("INTEGRATION_MANAGER");
                    sqlQueryObject.addWhereCondition("? > MESSAGGI.ORA_REGISTRAZIONE");
                    sqlQueryObject.addWhereCondition("MESSAGGI.RIFERIMENTO_MSG IS NOT NULL");
                    sqlQueryObject.addWhereCondition("MESSAGGI.TIPO=?");
                    sqlQueryObject.addWhereCondition("MSG_SERVIZI_APPLICATIVI.TIPO_CONSEGNA=?");
                    sqlQueryObject.addWhereLikeCondition("MESSAGGI.PROPRIETARIO", "RicezioneContenutiApplicativi", true, true);
                    sqlQueryObject.addWhereCondition("MSG_SERVIZI_APPLICATIVI.INTEGRATION_MANAGER=?");
                    sqlQueryObject.addWhereCondition("MESSAGGI.ID_EGOV=MSG_SERVIZI_APPLICATIVI.ID_EGOV");
                    sqlQueryObject.setANDLogicOperator(true);
                    sqlQueryObject.addOrderBy("MESSAGGI.ORA_REGISTRAZIONE");
                    sqlQueryObject.setSortType(true);
                    sqlQueryObject.setLimit(limit);
                    queryString = sqlQueryObject.createSQLQuery();
                }
                pstmtMsgScaduti = connectionDB.prepareStatement(queryString);
                pstmtMsgScaduti.setTimestamp(1, scandenzaT);
                pstmtMsgScaduti.setString(2, "INBOX");
                pstmtMsgScaduti.setString(3, CONSEGNA_TRAMITE_CONNECTION_REPLY);
                pstmtMsgScaduti.setLong(4, 0L);
                long startDateSQLCommand = DateManager.getTimeMillis();
                if (logQuery) {
                    this.log.debug((Object)("[QUERY] (Messaggi.scadutiPerRicezioneContenutiApplicativi) [" + queryString + "] 1[" + scandenzaT + "] 2[" + "INBOX" + "] 3[" + CONSEGNA_TRAMITE_CONNECTION_REPLY + "] 4[" + 0 + "]..."));
                }
                rs = pstmtMsgScaduti.executeQuery();
                long endDateSQLCommand = DateManager.getTimeMillis();
                long secondSQLCommand = (endDateSQLCommand - startDateSQLCommand) / 1000L;
                if (logQuery) {
                    this.log.debug((Object)("[QUERY] Messaggi.scadutiPerRicezioneContenutiApplicativi) [" + queryString + "] 1[" + scandenzaT + "] 2[" + "INBOX" + "] 3[" + CONSEGNA_TRAMITE_CONNECTION_REPLY + "] 4[" + 0 + "] effettuata in " + secondSQLCommand + " secondi"));
                }
                int countLimit = 0;
                while (rs.next()) {
                    idMsg.add(rs.getString("identificativoEGov") + "@" + rs.getString("SERVIZIO_APPLICATIVO"));
                    if (Configurazione.getSqlQueryObjectType() != null || ++countLimit != limit) continue;
                }
                rs.close();
                pstmtMsgScaduti.close();
                return idMsg;
            }
            catch (Exception e) {
                String errorMsg = "[GestoreMessaggi.readMsgForRicezioneContenutiApplicativiNonGestiti] errore, queryString[" + queryString + "]: " + e.getMessage();
                try {
                    if (rs != null) {
                        rs.close();
                    }
                }
                catch (Exception er) {
                    // empty catch block
                }
                try {
                    if (pstmtMsgScaduti != null) {
                        pstmtMsgScaduti.close();
                    }
                }
                catch (Exception er) {
                    // empty catch block
                }
                this.log.error((Object)errorMsg, (Throwable)e);
                throw new GestoreMessaggiException(errorMsg, e);
            }
        }
        throw new GestoreMessaggiException("Metodo invocato con OpenSPCoopState non valido");
    }

    public Vector<String> readMsgForRicezioneBusteEGovNonGestiti(long timeout, int limit, boolean logQuery) throws GestoreMessaggiException {
        if (this.openspcoopstate instanceof OpenSPCoopStateful) {
            StatefulMessage stateful = this.isRichiesta ? (StatefulMessage)this.openspcoopstate.getStatoRichiesta() : (StatefulMessage)this.openspcoopstate.getStatoRisposta();
            Connection connectionDB = stateful.getConnectionDB();
            Vector<String> idMsg = new Vector<String>();
            Statement pstmtMsgScaduti = null;
            ResultSet rs = null;
            String queryString = null;
            try {
                long scadenza = DateManager.getTimeMillis() - timeout;
                Timestamp scandenzaT = new Timestamp(scadenza);
                if (Configurazione.getSqlQueryObjectType() == null) {
                    StringBuffer query = new StringBuffer();
                    query.append("SELECT ID_EGOV FROM ");
                    query.append(MESSAGGI);
                    query.append(" WHERE ? > ORA_REGISTRAZIONE AND RIFERIMENTO_MSG IS NOT NULL AND TIPO=? AND PROPRIETARIO LIKE 'RicezioneBusteEGov%'");
                    queryString = query.toString();
                } else {
                    ISQLQueryObject sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)Configurazione.getSqlQueryObjectType());
                    sqlQueryObject.addSelectField("ID_EGOV");
                    sqlQueryObject.addSelectField("RIFERIMENTO_MSG");
                    sqlQueryObject.addSelectField("TIPO");
                    sqlQueryObject.addSelectField("PROPRIETARIO");
                    sqlQueryObject.addSelectField("ORA_REGISTRAZIONE");
                    sqlQueryObject.addFromTable(MESSAGGI);
                    sqlQueryObject.addWhereCondition("? > ORA_REGISTRAZIONE");
                    sqlQueryObject.addWhereCondition("RIFERIMENTO_MSG IS NOT NULL");
                    sqlQueryObject.addWhereCondition("TIPO=?");
                    sqlQueryObject.addWhereLikeCondition("PROPRIETARIO", "RicezioneBusteEGov", true, true);
                    sqlQueryObject.setANDLogicOperator(true);
                    sqlQueryObject.addOrderBy("ORA_REGISTRAZIONE");
                    sqlQueryObject.setSortType(true);
                    sqlQueryObject.setLimit(limit);
                    queryString = sqlQueryObject.createSQLQuery();
                }
                pstmtMsgScaduti = connectionDB.prepareStatement(queryString);
                pstmtMsgScaduti.setTimestamp(1, scandenzaT);
                pstmtMsgScaduti.setString(2, "OUTBOX");
                long startDateSQLCommand = DateManager.getTimeMillis();
                if (logQuery) {
                    this.log.debug((Object)("[QUERY] (Messaggi.scadutiPerRicezioneBusteEGov) [" + queryString + "] 1[" + scandenzaT + "] 2[" + "OUTBOX" + "]..."));
                }
                rs = pstmtMsgScaduti.executeQuery();
                long endDateSQLCommand = DateManager.getTimeMillis();
                long secondSQLCommand = (endDateSQLCommand - startDateSQLCommand) / 1000L;
                if (logQuery) {
                    this.log.debug((Object)("[QUERY] Messaggi.scadutiPerRicezioneBusteEGov) [" + queryString + "] 1[" + scandenzaT + "] 2[" + "OUTBOX" + "] effettuata in " + secondSQLCommand + " secondi"));
                }
                int countLimit = 0;
                while (rs.next()) {
                    idMsg.add(rs.getString("ID_EGOV"));
                    if (Configurazione.getSqlQueryObjectType() != null || ++countLimit != limit) continue;
                }
                rs.close();
                pstmtMsgScaduti.close();
                return idMsg;
            }
            catch (Exception e) {
                String errorMsg = "[GestoreMessaggi.readMsgForRicezioneBusteEGovNonGestiti] errore, queryString[" + queryString + "]: " + e.getMessage();
                try {
                    if (rs != null) {
                        rs.close();
                    }
                }
                catch (Exception er) {
                    // empty catch block
                }
                try {
                    if (pstmtMsgScaduti != null) {
                        pstmtMsgScaduti.close();
                    }
                }
                catch (Exception er) {
                    // empty catch block
                }
                this.log.error((Object)errorMsg, (Throwable)e);
                throw new GestoreMessaggiException(errorMsg, e);
            }
        }
        throw new GestoreMessaggiException("Metodo invocato con OpenSPCoopState non valido");
    }

    public Vector<String> readBusteEGovNonRiferiteDaMessaggiFromInBox(int limit, boolean logQuery, boolean forceIndex) throws EGovException, GestoreMessaggiException {
        return this.readBusteEgovNonRiferiteDaMessaggi("INBOX", limit, logQuery, forceIndex);
    }

    public Vector<String> readBusteEGovNonRiferiteDaMessaggiFromOutBox(int limit, boolean logQuery, boolean forceIndex) throws EGovException, GestoreMessaggiException {
        return this.readBusteEgovNonRiferiteDaMessaggi("OUTBOX", limit, logQuery, forceIndex);
    }

    private Vector<String> readBusteEgovNonRiferiteDaMessaggi(String tipoBusta, int limit, boolean logQuery, boolean forceIndex) throws EGovException, GestoreMessaggiException {
        if (this.openspcoopstate instanceof OpenSPCoopStateful) {
            StatefulMessage stateful = this.isRichiesta ? (StatefulMessage)this.openspcoopstate.getStatoRichiesta() : (StatefulMessage)this.openspcoopstate.getStatoRisposta();
            Connection connectionDB = stateful.getConnectionDB();
            Statement pstmt = null;
            ResultSet rs = null;
            Vector<String> idBuste = new Vector<String>();
            String queryString = null;
            try {
                String tipoRovesciato = null;
                tipoRovesciato = "INBOX".equals(tipoBusta) ? "OUTBOX" : "INBOX";
                IGestoreRepositoryEGov gestoreRepositoryEGov = Configurazione.getGestoreRepositoryEGov();
                if (Configurazione.getSqlQueryObjectType() == null) {
                    StringBuffer query = new StringBuffer();
                    query.append("SELECT ");
                    if (forceIndex) {
                        query.append("/*+ index(REPOSITORY_EGOV REP_EGOV_SEARCH_TIPO) */");
                    }
                    query.append(" ID_EGOV FROM ");
                    query.append("REPOSITORY_EGOV");
                    query.append(" WHERE ");
                    query.append(" TIPO=? AND ");
                    query.append("( ");
                    query.append(gestoreRepositoryEGov.createSQLCondition_ProfiloCollaborazione(true));
                    query.append(" OR ");
                    query.append(gestoreRepositoryEGov.createSQLCondition_PdD(true));
                    query.append(" ) AND ");
                    query.append("(");
                    query.append("  NOT EXISTS (");
                    query.append("  SELECT * FROM ");
                    query.append("ASINCRONO");
                    query.append("  WHERE ");
                    query.append("    ( ");
                    query.append("ASINCRONO.ID_EGOV=REPOSITORY_EGOV.ID_EGOV AND ");
                    query.append("ASINCRONO.TIPO=REPOSITORY_EGOV.TIPO");
                    query.append("    ) ");
                    query.append("  )");
                    query.append(") AND ");
                    query.append("(");
                    query.append(" NOT EXISTS (");
                    query.append(" SELECT * FROM ");
                    query.append(MESSAGGI);
                    query.append(" WHERE ");
                    query.append("( ");
                    query.append("MESSAGGI.ID_EGOV=REPOSITORY_EGOV.ID_EGOV AND ");
                    query.append("MESSAGGI.TIPO=REPOSITORY_EGOV.TIPO");
                    query.append(" ) OR ( ");
                    query.append("MESSAGGI.RIFERIMENTO_MSG=REPOSITORY_EGOV.ID_EGOV AND ");
                    query.append("MESSAGGI.TIPO=?");
                    query.append(" ) ");
                    query.append(")");
                    query.append(")");
                    queryString = query.toString();
                } else {
                    ISQLQueryObject sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)Configurazione.getSqlQueryObjectType());
                    if (forceIndex) {
                        sqlQueryObject.addSelectForceIndex("REPOSITORY_EGOV", "REP_EGOV_SEARCH_TIPO");
                    }
                    sqlQueryObject.addSelectField("ID_EGOV");
                    sqlQueryObject.addSelectField("TIPO");
                    sqlQueryObject.addSelectField(gestoreRepositoryEGov.createSQLFields());
                    sqlQueryObject.addSelectField("ORA_REGISTRAZIONE");
                    sqlQueryObject.addFromTable("REPOSITORY_EGOV");
                    sqlQueryObject.addWhereCondition("TIPO=?");
                    sqlQueryObject.addWhereCondition(false, new String[]{gestoreRepositoryEGov.createSQLCondition_ProfiloCollaborazione(true), gestoreRepositoryEGov.createSQLCondition_PdD(true)});
                    ISQLQueryObject sqlQueryObjectAsincronoNotExists = SQLObjectFactory.createSQLQueryObject((String)Configurazione.getSqlQueryObjectType());
                    sqlQueryObjectAsincronoNotExists.addFromTable("ASINCRONO");
                    sqlQueryObjectAsincronoNotExists.addWhereCondition(true, new String[]{"ASINCRONO.ID_EGOV=REPOSITORY_EGOV.ID_EGOV", "ASINCRONO.TIPO=REPOSITORY_EGOV.TIPO"});
                    sqlQueryObject.addWhereExistsCondition(true, sqlQueryObjectAsincronoNotExists);
                    ISQLQueryObject sqlQueryObjectMessaggiNotExists = SQLObjectFactory.createSQLQueryObject((String)Configurazione.getSqlQueryObjectType());
                    sqlQueryObjectMessaggiNotExists.addFromTable(MESSAGGI);
                    sqlQueryObjectMessaggiNotExists.addWhereCondition(true, new String[]{"MESSAGGI.ID_EGOV=REPOSITORY_EGOV.ID_EGOV", "MESSAGGI.TIPO=REPOSITORY_EGOV.TIPO"});
                    sqlQueryObjectMessaggiNotExists.addWhereCondition(true, new String[]{"MESSAGGI.RIFERIMENTO_MSG=REPOSITORY_EGOV.ID_EGOV", "MESSAGGI.TIPO=?"});
                    sqlQueryObjectMessaggiNotExists.setANDLogicOperator(false);
                    sqlQueryObject.addWhereExistsCondition(true, sqlQueryObjectMessaggiNotExists);
                    sqlQueryObject.setANDLogicOperator(true);
                    sqlQueryObject.addOrderBy("ORA_REGISTRAZIONE");
                    sqlQueryObject.setSortType(true);
                    sqlQueryObject.setLimit(limit);
                    queryString = sqlQueryObject.createSQLQuery();
                }
                pstmt = connectionDB.prepareStatement(queryString);
                pstmt.setString(1, tipoBusta);
                pstmt.setString(2, tipoRovesciato);
                long startDateSQLCommand = DateManager.getTimeMillis();
                if (logQuery) {
                    this.log.debug((Object)("[QUERY] (Messaggi.busteEGovNonRiferite) [" + queryString + "] 1[" + tipoBusta + "] 2[" + tipoRovesciato + "]..."));
                }
                rs = pstmt.executeQuery();
                long endDateSQLCommand = DateManager.getTimeMillis();
                long secondSQLCommand = (endDateSQLCommand - startDateSQLCommand) / 1000L;
                if (logQuery) {
                    this.log.debug((Object)("[QUERY] (Messaggi.busteEGovNonRiferite) [" + queryString + "] 1[" + tipoBusta + "] 2[" + tipoRovesciato + "] effettuata in " + secondSQLCommand + " secondi"));
                }
                int countLimit = 0;
                while (rs.next()) {
                    idBuste.add(rs.getString("ID_EGOV"));
                    if (Configurazione.getSqlQueryObjectType() != null || ++countLimit != limit) continue;
                }
                rs.close();
                pstmt.close();
                if (Configurazione.getSqlQueryObjectType() == null) {
                    StringBuffer query = new StringBuffer();
                    query.append("SELECT ");
                    if (forceIndex) {
                        query.append("/*+ index(REPOSITORY_EGOV REP_EGOV_SEARCH_TIPO) */");
                    }
                    query.append(" ID_EGOV FROM ");
                    query.append("REPOSITORY_EGOV");
                    query.append(" WHERE ");
                    query.append(" TIPO=? AND ");
                    query.append("( ");
                    query.append(gestoreRepositoryEGov.createSQLCondition_ProfiloCollaborazione(true));
                    query.append(" OR ");
                    query.append(gestoreRepositoryEGov.createSQLCondition_PdD(true));
                    query.append(" ) AND ");
                    query.append("(");
                    query.append("  EXISTS (");
                    query.append("  SELECT * FROM ");
                    query.append("ASINCRONO");
                    query.append("  WHERE ");
                    query.append("    ( ");
                    query.append("ASINCRONO.ID_EGOV=REPOSITORY_EGOV.ID_EGOV AND ");
                    query.append("ASINCRONO.TIPO=REPOSITORY_EGOV.TIPO AND ");
                    query.append("REPOSITORY_EGOV.SCADENZA_BUSTA < ?");
                    query.append("    ) ");
                    query.append("  )");
                    query.append(") AND ");
                    query.append("(");
                    query.append(" NOT EXISTS (");
                    query.append(" SELECT * FROM ");
                    query.append(MESSAGGI);
                    query.append(" WHERE ");
                    query.append("( ");
                    query.append("MESSAGGI.ID_EGOV=REPOSITORY_EGOV.ID_EGOV AND ");
                    query.append("MESSAGGI.TIPO=REPOSITORY_EGOV.TIPO");
                    query.append(" ) OR ( ");
                    query.append("MESSAGGI.RIFERIMENTO_MSG=REPOSITORY_EGOV.ID_EGOV AND ");
                    query.append("MESSAGGI.TIPO=?");
                    query.append(" ) ");
                    query.append(")");
                    query.append(")");
                    queryString = query.toString();
                } else {
                    ISQLQueryObject sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)Configurazione.getSqlQueryObjectType());
                    if (forceIndex) {
                        sqlQueryObject.addSelectForceIndex("REPOSITORY_EGOV", "REP_EGOV_SEARCH_TIPO");
                    }
                    sqlQueryObject.addSelectField("ID_EGOV");
                    sqlQueryObject.addSelectField("TIPO");
                    sqlQueryObject.addSelectField(gestoreRepositoryEGov.createSQLFields());
                    sqlQueryObject.addSelectField("ORA_REGISTRAZIONE");
                    sqlQueryObject.addFromTable("REPOSITORY_EGOV");
                    sqlQueryObject.addWhereCondition("TIPO=?");
                    sqlQueryObject.addWhereCondition(false, new String[]{gestoreRepositoryEGov.createSQLCondition_ProfiloCollaborazione(true), gestoreRepositoryEGov.createSQLCondition_PdD(true)});
                    ISQLQueryObject sqlQueryObjectAsincronoExists = SQLObjectFactory.createSQLQueryObject((String)Configurazione.getSqlQueryObjectType());
                    sqlQueryObjectAsincronoExists.addFromTable("ASINCRONO");
                    sqlQueryObjectAsincronoExists.addWhereCondition("ASINCRONO.ID_EGOV=REPOSITORY_EGOV.ID_EGOV");
                    sqlQueryObjectAsincronoExists.addWhereCondition("ASINCRONO.TIPO=REPOSITORY_EGOV.TIPO");
                    sqlQueryObjectAsincronoExists.addWhereCondition("REPOSITORY_EGOV.SCADENZA_BUSTA < ?");
                    sqlQueryObjectAsincronoExists.setANDLogicOperator(true);
                    sqlQueryObject.addWhereExistsCondition(false, sqlQueryObjectAsincronoExists);
                    ISQLQueryObject sqlQueryObjectMessaggiNotExists = SQLObjectFactory.createSQLQueryObject((String)Configurazione.getSqlQueryObjectType());
                    sqlQueryObjectMessaggiNotExists.addFromTable(MESSAGGI);
                    sqlQueryObjectMessaggiNotExists.addWhereCondition(true, new String[]{"MESSAGGI.ID_EGOV=REPOSITORY_EGOV.ID_EGOV", "MESSAGGI.TIPO=REPOSITORY_EGOV.TIPO"});
                    sqlQueryObjectMessaggiNotExists.addWhereCondition(true, new String[]{"MESSAGGI.RIFERIMENTO_MSG=REPOSITORY_EGOV.ID_EGOV", "MESSAGGI.TIPO=?"});
                    sqlQueryObjectMessaggiNotExists.setANDLogicOperator(false);
                    sqlQueryObject.addWhereExistsCondition(true, sqlQueryObjectMessaggiNotExists);
                    sqlQueryObject.setANDLogicOperator(true);
                    sqlQueryObject.addOrderBy("ORA_REGISTRAZIONE");
                    sqlQueryObject.setSortType(true);
                    sqlQueryObject.setLimit(limit);
                    queryString = sqlQueryObject.createSQLQuery();
                }
                Timestamp now = DateManager.getTimestamp();
                pstmt = connectionDB.prepareStatement(queryString);
                pstmt.setString(1, tipoBusta);
                pstmt.setTimestamp(2, now);
                pstmt.setString(3, tipoRovesciato);
                startDateSQLCommand = DateManager.getTimeMillis();
                if (logQuery) {
                    this.log.debug((Object)("[QUERY] (Messaggi.busteEGovNonRiferite_asincrono) [" + queryString + "] 1[" + tipoBusta + "] 2[" + now + "] 3[" + tipoRovesciato + "]..."));
                }
                rs = pstmt.executeQuery();
                endDateSQLCommand = DateManager.getTimeMillis();
                secondSQLCommand = (endDateSQLCommand - startDateSQLCommand) / 1000L;
                if (logQuery) {
                    this.log.debug((Object)("[QUERY] (Messaggi.busteEGovNonRiferite_asincrono) [" + queryString + "] 1[" + tipoBusta + "] 2[" + now + "] 3[" + tipoRovesciato + "] effettuata in " + secondSQLCommand + " secondi"));
                }
                countLimit = 0;
                while (rs.next()) {
                    idBuste.add(rs.getString("ID_EGOV"));
                    if (Configurazione.getSqlQueryObjectType() != null || ++countLimit != limit) continue;
                }
                rs.close();
                pstmt.close();
                return idBuste;
            }
            catch (Exception e) {
                String errorMsg = "[RepositoryEGov.getBusteDaEliminare] errore, queryString[" + queryString + "]: " + e.getMessage();
                this.log.error((Object)errorMsg, (Throwable)e);
                try {
                    if (rs != null) {
                        rs.close();
                    }
                }
                catch (Exception er) {
                    // empty catch block
                }
                try {
                    if (pstmt != null) {
                        pstmt.close();
                    }
                }
                catch (Exception er) {
                    // empty catch block
                }
                throw new EGovException(errorMsg, (Throwable)e);
            }
        }
        throw new GestoreMessaggiException("Metodo invocato con OpenSPCoopState non valido");
    }

    public void deleteMessage() throws GestoreMessaggiException {
        if (this.openspcoopstate instanceof OpenSPCoopStateful || this.oneWayVersione11) {
            StateMessage stateMSG = this.isRichiesta ? (StateMessage)this.openspcoopstate.getStatoRichiesta() : (StateMessage)this.openspcoopstate.getStatoRisposta();
            Connection connectionDB = stateMSG.getConnectionDB();
            PreparedStatement pstmtDeleteSIL = null;
            Statement pstmtDeleteMSG = null;
            try {
                if ("INBOX".equals(this.tipo)) {
                    String query = "DELETE FROM MSG_SERVIZI_APPLICATIVI WHERE ID_EGOV=?";
                    pstmtDeleteSIL = connectionDB.prepareStatement(query);
                    pstmtDeleteSIL.setString(1, this.idEGov);
                    pstmtDeleteSIL.execute();
                    pstmtDeleteSIL.close();
                }
                SoapMessage msgDelete = new SoapMessage(this.idEGov, this.openspcoopstate, this.tipo, this.workDir, this.adapter, this.log);
                msgDelete.delete(this.isRichiesta, this.oneWayVersione11);
                String query = "DELETE FROM MESSAGGI WHERE ID_EGOV=? AND TIPO=?";
                pstmtDeleteMSG = connectionDB.prepareStatement(query);
                pstmtDeleteMSG.setString(1, this.idEGov);
                pstmtDeleteMSG.setString(2, this.tipo);
                pstmtDeleteMSG.execute();
                pstmtDeleteMSG.close();
                GestoreMessaggi.deleteFromCache_Proprietario("GestoreMessaggi", this.tipo, this.idEGov);
            }
            catch (Exception e) {
                String errorMsg = "GESTORE_MESSAGGI, error deleteMessage " + this.tipo + "/" + this.idEGov + ": " + e.getMessage();
                try {
                    if (pstmtDeleteMSG != null) {
                        pstmtDeleteMSG.close();
                    }
                }
                catch (Exception er) {
                    // empty catch block
                }
                try {
                    if (pstmtDeleteSIL != null) {
                        pstmtDeleteSIL.close();
                    }
                }
                catch (Exception er) {
                    // empty catch block
                }
                this.log.error((Object)errorMsg, (Throwable)e);
                throw new GestoreMessaggiException(errorMsg, e);
            }
        }
        if (!(this.openspcoopstate instanceof OpenSPCoopStateless)) {
            throw new GestoreMessaggiException("Metodo invocato con OpenSPCoopState non valido");
        }
    }

    public void deleteMessageFromFileSystem() {
        SoapMessage msgDelete = null;
        try {
            msgDelete = new SoapMessage(this.idEGov, this.openspcoopstate, this.tipo, this.workDir, this.adapter, this.log);
            msgDelete.deleteMessageFromFileSystem();
        }
        catch (Exception e) {
            String errorMsg = "GESTORE_MESSAGGI, error deleteMessage " + this.tipo + "/" + this.idEGov + ": " + e.getMessage();
            this.log.error((Object)errorMsg, (Throwable)e);
        }
    }

    public void validateAndDeleteMsgOneWayRiscontrato() throws GestoreMessaggiException, EGovException {
        StateMessage stateMSG = this.isRichiesta ? (StateMessage)this.openspcoopstate.getStatoRichiesta() : (StateMessage)this.openspcoopstate.getStatoRisposta();
        Riscontri gestoreRiscontri = null;
        try {
            gestoreRiscontri = new Riscontri((IState)stateMSG);
            gestoreRiscontri.validazioneRiscontroRicevuto(this.idEGov);
            this.aggiornaProprietarioMessaggio("GestoreMessaggi");
            this.openspcoopstate.commit();
        }
        catch (Exception e) {
            String errorMsg = "GESTORE_MESSAGGI, error validateAndDeleteMsgRiscontrato " + this.tipo + "/" + this.idEGov + ": " + e.getMessage();
            this.log.error((Object)errorMsg, (Throwable)e);
            throw new GestoreMessaggiException(errorMsg, e);
        }
        this.addProprietariIntoCache_readFromTable("GestoreMessaggi", "validateAndDeleteMsgOneWayRiscontrato", null, false);
    }

    public void validateAndDeleteMsgAsincronoRiscontrato(Busta bustaRicevuta) throws GestoreMessaggiException, EGovException {
        StateMessage state = this.isRichiesta ? (StateMessage)this.openspcoopstate.getStatoRichiesta() : (StateMessage)this.openspcoopstate.getStatoRisposta();
        ProfiloDiCollaborazione profiloCollaborazione = null;
        try {
            profiloCollaborazione = new ProfiloDiCollaborazione((IState)state);
            profiloCollaborazione.asincrono_valdazioneRicevuta(bustaRicevuta);
            this.aggiornaProprietarioMessaggio("GestoreMessaggi");
            this.openspcoopstate.commit();
        }
        catch (Exception e) {
            String errorMsg = "GESTORE_MESSAGGI, error validateAndDeleteMsgRiscontrato " + this.tipo + "/" + this.idEGov + ": " + e.getMessage();
            this.log.error((Object)errorMsg, (Throwable)e);
            throw new GestoreMessaggiException(errorMsg, e);
        }
        this.addProprietariIntoCache_readFromTable("GestoreMessaggi", "validateAndDeleteMsgAsincronoRiscontrato", null, false);
    }

    public boolean forcedDeleteMessage() throws GestoreMessaggiException {
        if (this.openspcoopstate instanceof OpenSPCoopStateful) {
            StatefulMessage stateful = this.isRichiesta ? (StatefulMessage)this.openspcoopstate.getStatoRichiesta() : (StatefulMessage)this.openspcoopstate.getStatoRisposta();
            RollbackRepositoryEGov rollbackEGovMessaggio = null;
            RollbackRepositoryEGov rollbackEGovRepository = null;
            try {
                if (!this.existsMessage_noCache()) {
                    return false;
                }
                String rifMsg = this.getRiferimentoMessaggio();
                JMSReceiver receiverJMS = null;
                if ("jms".equals(this.propertiesReader.getNodeReceiver())) {
                    receiverJMS = new JMSReceiver(this.propertiesReader.getIdentificativoPortaDefault(), "ForcedDeleteMessage", this.propertiesReader.singleConnection_NodeReceiver(), this.log);
                }
                if ("INBOX".equals(this.tipo)) {
                    rollbackEGovMessaggio = new RollbackRepositoryEGov(this.idEGov, (IState)stateful, this.oneWayVersione11);
                    rollbackEGovMessaggio.rollbackBustaIntoInBox();
                    if (rifMsg == null) {
                        String strMessageSelector;
                        if (receiverJMS != null && receiverJMS.clean("RicezioneBusteEGov", strMessageSelector = "ID = '" + this.idEGov + "'")) {
                            this.log.info((Object)("Trovato messaggio nella coda RicezioneBusteEGov con id [" + this.idEGov + "] non consumato"));
                        }
                    } else {
                        String strMessageSelector;
                        rollbackEGovRepository = new RollbackRepositoryEGov(rifMsg, (IState)stateful, this.oneWayVersione11);
                        rollbackEGovRepository.rollbackBustaIntoOutBox(false);
                        if (receiverJMS != null && receiverJMS.clean("RicezioneContenutiApplicativi", strMessageSelector = "ID = '" + rifMsg + "'")) {
                            this.log.info((Object)("Trovato messaggio (tramite riferimento) nella coda RicezioneContenutiApplicativi con id [" + rifMsg + "] non consumato"));
                        }
                    }
                } else {
                    rollbackEGovMessaggio = new RollbackRepositoryEGov(this.idEGov, (IState)stateful, this.oneWayVersione11);
                    rollbackEGovMessaggio.rollbackBustaIntoOutBox();
                    if (rifMsg == null) {
                        String strMessageSelector;
                        if (receiverJMS != null && receiverJMS.clean("RicezioneContenutiApplicativi", strMessageSelector = "ID = '" + this.idEGov + "'")) {
                            this.log.info((Object)("Trovato messaggio nella coda RicezioneContenutiApplicativi con id [" + this.idEGov + "] non consumato"));
                        }
                    } else {
                        String strMessageSelector;
                        rollbackEGovRepository = new RollbackRepositoryEGov(rifMsg, (IState)stateful, this.oneWayVersione11);
                        rollbackEGovRepository.rollbackBustaIntoInBox(false);
                        if (receiverJMS != null && receiverJMS.clean("RicezioneBusteEGov", strMessageSelector = "ID = '" + rifMsg + "'")) {
                            this.log.info((Object)("Trovato messaggio (tramite riferimento) nella coda RicezioneBusteEGov con id [" + rifMsg + "] non consumato"));
                        }
                    }
                }
                this.aggiornaProprietarioMessaggio("GestoreMessaggi");
                this.openspcoopstate.commit();
                this.addProprietariIntoCache_readFromTable("GestoreMessaggi", "forcedDeleteMessage", this.getRiferimentoMessaggio(), false);
                return true;
            }
            catch (Exception e) {
                String errorMsg = "GESTORE_MESSAGGI, Errore forcedDeleteMessage " + this.tipo + "/" + this.idEGov + ": " + e.getMessage();
                this.log.error((Object)errorMsg, (Throwable)e);
                throw new GestoreMessaggiException(errorMsg, e);
            }
        }
        throw new GestoreMessaggiException("Metodo invocato con OpenSPCoopState non valido");
    }

    public Message buildRichiestaPubblicazioneMessaggio_RepositoryMessaggi(IDSoggetto soggettoMittente, String tipoServizio, String servizio, String azione) throws GestoreMessaggiException {
        try {
            String msg = "<soapenv:Envelope xmlns:soapenv=\"http://schemas.xmlsoap.org/soap/envelope/\" xmlns:xsd=\"http://www.w3.org/2001/XMLSchema\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\">\n<soapenv:Body>\n<pubblicazioneMessaggio xmlns=\"http://gestoreeventi.openspcoop.org\"><in0><ns1:idMessaggio xmlns:ns1=\"http://types.gestoreeventi.openspcoop.org\">" + this.idEGov + "</ns1:idMessaggio>" + "<ns2:soggetto xmlns:ns2=\"http://types.gestoreeventi.openspcoop.org\"><ns2:nome>" + soggettoMittente.getNome() + "</ns2:nome><ns2:tipo>" + soggettoMittente.getTipo() + "</ns2:tipo></ns2:soggetto>" + "<ns3:servizio xmlns:ns3=\"http://types.gestoreeventi.openspcoop.org\"><ns3:nome>" + servizio + "</ns3:nome><ns3:tipo>" + tipoServizio + "</ns3:tipo></ns3:servizio>" + "<ns4:tipoEvento xmlns:ns4=\"http://types.gestoreeventi.openspcoop.org\">" + azione + "</ns4:tipoEvento>" + "</in0></pubblicazioneMessaggio>\n" + "</soapenv:Body>\n" + "</soapenv:Envelope>";
            return new Message((Object)msg);
        }
        catch (Exception e) {
            String errorMsg = "GESTORE_MESSAGGI, error buildRichiestaPubblicazioneMessaggio_RepositoryMessaggi: " + e.getMessage();
            this.log.error((Object)errorMsg, (Throwable)e);
            throw new GestoreMessaggiException(errorMsg, e);
        }
    }

    public Message buildRispostaPrelevamentoMessaggio_RepositoryMessaggi(byte[] messaggio) throws GestoreMessaggiException {
        try {
            String msgUpper = "<soapenv:Envelope xmlns:soapenv=\"http://schemas.xmlsoap.org/soap/envelope/\" xmlns:xsd=\"http://www.w3.org/2001/XMLSchema\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\">\n<soapenv:Body>\n<prelevaMessaggioResponse xmlns=\"http://gestoreeventi.openspcoop.org\"><prelevaMessaggioReturn>";
            String msgDown = "</prelevaMessaggioReturn></prelevaMessaggioResponse>\n</soapenv:Body>\n</soapenv:Envelope>";
            ByteArrayOutputStream bout = new ByteArrayOutputStream();
            bout.write(msgUpper.getBytes());
            bout.write(Base64.encode((byte[])messaggio).getBytes());
            bout.write(msgDown.getBytes());
            return new Message((Object)bout.toByteArray());
        }
        catch (Exception e) {
            String errorMsg = "GESTORE_MESSAGGI, error buildRispostaPrelevamentoMessaggio_RepositoryMessaggi: " + e.getMessage();
            this.log.error((Object)errorMsg, (Throwable)e);
            throw new GestoreMessaggiException(errorMsg, e);
        }
    }

    public void setReadyForDrop(boolean readyForDrop) {
        this.readyForDrop = readyForDrop;
    }

    public void setOneWayVersione11(boolean oneWay11) {
        this.oneWayVersione11 = oneWay11;
    }

    public void setPortaDiTipoStateless(boolean portaDiTipoStateless) {
        this.portaDiTipoStateless = portaDiTipoStateless;
    }

    public void setRoutingStateless(boolean routingStateless) {
        this.routingStateless = routingStateless;
    }

    public boolean isRichiesta() {
        return this.isRichiesta;
    }

    public void setRichiesta(boolean isRichiesta) {
        this.isRichiesta = isRichiesta;
    }
}

