/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop.pdd.core;

import java.io.Serializable;
import javax.xml.soap.SOAPBody;
import javax.xml.soap.SOAPFault;
import org.openspcoop.egov.ProprietaErroreApplicativo;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public enum Esito implements Serializable
{
    OK("0"),
    ERRORE_SPCOOP("1"),
    ERRORE_APPLICATIVO("2"),
    ERRORE_GENERICO("3"),
    ERRORE_PROCESSAMENTO_PDD_4XX("4"),
    ERRORE_PROCESSAMENTO_PDD_5XX("5");

    private final String valore;

    private Esito(String valore) {
        this.valore = valore;
    }

    public String getValore() {
        return this.valore;
    }

    public int getValoreAsInt() {
        return Integer.parseInt(this.valore);
    }

    public static String[] toStringArray() {
        String[] res = new String[Esito.values().length];
        int i = 0;
        for (Esito tmp : Esito.values()) {
            res[i] = tmp.getValore();
            ++i;
        }
        return res;
    }

    public static int[] toIntArray() {
        int[] res = new int[Esito.values().length];
        int i = 0;
        for (Esito tmp : Esito.values()) {
            res[i] = tmp.getValoreAsInt();
            ++i;
        }
        return res;
    }

    public static String[] toEnumNameArray() {
        String[] res = new String[Esito.values().length];
        int i = 0;
        for (Esito tmp : Esito.values()) {
            res[i] = tmp.name();
            ++i;
        }
        return res;
    }

    public static Esito toEnumConstant(int val) {
        return Esito.toEnumConstant("" + val);
    }

    public static Esito toEnumConstant(String val) {
        Esito res = null;
        if (OK.toString().equals(val)) {
            res = OK;
        } else if (ERRORE_SPCOOP.toString().equals(val)) {
            res = ERRORE_SPCOOP;
        } else if (ERRORE_APPLICATIVO.toString().equals(val)) {
            res = ERRORE_APPLICATIVO;
        } else if (ERRORE_GENERICO.toString().equals(val)) {
            res = ERRORE_GENERICO;
        } else if (ERRORE_PROCESSAMENTO_PDD_4XX.toString().equals(val)) {
            res = ERRORE_PROCESSAMENTO_PDD_4XX;
        } else if (ERRORE_PROCESSAMENTO_PDD_5XX.toString().equals(val)) {
            res = ERRORE_PROCESSAMENTO_PDD_5XX;
        }
        return res;
    }

    public String toString() {
        return this.valore;
    }

    public boolean equals(Esito esito) {
        return this.toString().equals(esito.toString());
    }

    public static Esito getEsito(SOAPBody body) throws Exception {
        return Esito.getEsito(body, null);
    }

    public static Esito getEsito(SOAPBody body, ProprietaErroreApplicativo erroreApplicativo) throws Exception {
        try {
            NodeList elements;
            Node child;
            NodeList childNodes;
            if (body == null) {
                return OK;
            }
            if (body.hasFault()) {
                SOAPFault fault = body.getFault();
                String actor = fault.getFaultActor();
                String reason = fault.getFaultString();
                String codice = fault.getFaultCode();
                if (erroreApplicativo != null && erroreApplicativo.getFaultActor() != null && erroreApplicativo.getFaultActor().equals(actor)) {
                    if (codice == null) {
                        return ERRORE_GENERICO;
                    }
                    String prefixFaultCode = erroreApplicativo.getFaultPrefixCode();
                    if (prefixFaultCode == null) {
                        prefixFaultCode = "OPENSPCOOP_ORG_";
                    }
                    if (codice.startsWith(prefixFaultCode)) {
                        String value = codice.substring(prefixFaultCode.length());
                        int valueInt = Integer.parseInt(value);
                        if (valueInt >= 400 && valueInt <= 499) {
                            return ERRORE_PROCESSAMENTO_PDD_4XX;
                        }
                        if (valueInt >= 500 && valueInt <= 599) {
                            return ERRORE_PROCESSAMENTO_PDD_5XX;
                        }
                        return ERRORE_GENERICO;
                    }
                    return ERRORE_SPCOOP;
                }
                if ("Client".equals(codice) && "EGOV_IT_001 - Formato Busta non corretto".equals(reason)) {
                    return ERRORE_SPCOOP;
                }
                if ("Server".equals(codice) && "EGOV_IT_300 - Errore nel processamento del messaggio SPCoop".equals(reason)) {
                    return ERRORE_SPCOOP;
                }
                return ERRORE_APPLICATIVO;
            }
            if (erroreApplicativo != null && (childNodes = body.getChildNodes()) != null && childNodes.getLength() == 1 && "MessaggioDiErroreApplicativo".equals((child = childNodes.item(0)).getLocalName()) && "http://www.cnipa.it/schemas/2003/eGovIT/Exception1_0/".equals(child.getNamespaceURI()) && (elements = child.getChildNodes()) != null) {
                for (int i = 0; i < elements.getLength(); ++i) {
                    NodeList elementsEccezione;
                    Node elem = elements.item(i);
                    if (!"Eccezione".equals(elem.getLocalName()) || (elementsEccezione = elem.getChildNodes()) == null) continue;
                    for (int j = 0; j < elementsEccezione.getLength(); ++j) {
                        Node tipoEccezione = elementsEccezione.item(j);
                        if ("EccezioneProcessamento".equals(tipoEccezione.getLocalName())) {
                            Node at;
                            NamedNodeMap attr = tipoEccezione.getAttributes();
                            if (attr == null || (at = attr.getNamedItem("codiceEccezione")) == null) continue;
                            String value = at.getNodeValue();
                            String prefixFaultCode = erroreApplicativo.getFaultPrefixCode();
                            if (prefixFaultCode == null) {
                                prefixFaultCode = "OPENSPCOOP_ORG_";
                            }
                            if (value.startsWith(prefixFaultCode)) {
                                int valueInt = Integer.parseInt(value = value.substring(prefixFaultCode.length()));
                                if (valueInt >= 400 && valueInt <= 499) {
                                    return ERRORE_PROCESSAMENTO_PDD_4XX;
                                }
                                if (valueInt >= 500 && valueInt <= 599) {
                                    return ERRORE_PROCESSAMENTO_PDD_5XX;
                                }
                                return ERRORE_GENERICO;
                            }
                            return ERRORE_GENERICO;
                        }
                        if (!"EccezioneBusta".equals(tipoEccezione.getLocalName())) continue;
                        return ERRORE_SPCOOP;
                    }
                }
            }
            return OK;
        }
        catch (Exception e) {
            throw new Exception("Comprensione stato non riuscita: " + e.getMessage(), e);
        }
    }
}

