/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop.pdd.core;

import java.io.Serializable;
import java.sql.Timestamp;
import java.util.Properties;
import java.util.Vector;
import org.apache.axis.Message;
import org.apache.log4j.Logger;
import org.openspcoop.dao.commons.IDSoggetto;
import org.openspcoop.dao.config.PortaApplicativa;
import org.openspcoop.dao.config.PortaDelegata;
import org.openspcoop.dao.config.ServizioApplicativo;
import org.openspcoop.dao.config.driver.DriverConfigurazioneNotFound;
import org.openspcoop.dao.eccezione.DettaglioEccezione;
import org.openspcoop.dao.state.IState;
import org.openspcoop.dao.state.StateMessage;
import org.openspcoop.dao.state.StatelessMessage;
import org.openspcoop.egov.Busta;
import org.openspcoop.egov.Configurazione;
import org.openspcoop.egov.EGovException;
import org.openspcoop.egov.Eccezione;
import org.openspcoop.egov.Imbustamento;
import org.openspcoop.egov.Integrazione;
import org.openspcoop.egov.RepositoryEGov;
import org.openspcoop.egov.RollbackRepositoryEGov;
import org.openspcoop.pdd.config.ClassNameProperties;
import org.openspcoop.pdd.config.ConfigurazionePdDReader;
import org.openspcoop.pdd.config.OpenSPCoopProperties;
import org.openspcoop.pdd.config.RichiestaApplicativa;
import org.openspcoop.pdd.config.RichiestaDelegata;
import org.openspcoop.pdd.config.SoggettoVirtuale;
import org.openspcoop.pdd.core.EJBUtilsConsegnaException;
import org.openspcoop.pdd.core.EJBUtilsException;
import org.openspcoop.pdd.core.GestoreMessaggi;
import org.openspcoop.pdd.core.JMSSender;
import org.openspcoop.pdd.core.PdDContext;
import org.openspcoop.pdd.core.node.INodeSender;
import org.openspcoop.pdd.core.state.IOpenSPCoopState;
import org.openspcoop.pdd.core.state.OpenSPCoopStateful;
import org.openspcoop.pdd.core.state.OpenSPCoopStateless;
import org.openspcoop.pdd.logger.MsgDiagnostico;
import org.openspcoop.pdd.logger.OpenSPCoopLogger;
import org.openspcoop.pdd.mdb.ConsegnaContenutiApplicativiMessage;
import org.openspcoop.pdd.mdb.InoltroRisposteEGovMessage;
import org.openspcoop.pdd.services.RicezioneBusteEGovMessage;
import org.openspcoop.pdd.services.RicezioneContenutiApplicativiMessage;
import org.openspcoop.utils.Loader;
import org.openspcoop.utils.SoapUtils;
import org.openspcoop.utils.date.DateManager;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EJBUtils {
    private Logger log = null;
    private IOpenSPCoopState openSPCoopState;
    private String idModulo = null;
    private IDSoggetto identitaPdD = null;
    private String idEGovSessione;
    private String idEGovMessage;
    private String tipo;
    private String scenarioCooperazione;
    private MsgDiagnostico msgDiag;
    private boolean oneWayVersione11 = false;
    private boolean portaDiTipoStateless_esclusoOneWay11;
    private boolean rollbackRichiestaInCasoErrore = true;
    private boolean rollbackRichiestaInCasoErrore_rollbackHistory = true;
    private boolean routing;
    private OpenSPCoopProperties propertiesReader;
    private ConfigurazionePdDReader configurazionePdDReader;
    private boolean functionAsRouter = false;
    private Timestamp spedizioneMsgIngresso;
    private Timestamp ricezioneMsgRisposta;
    private Long dimensioneRichiestaInviataBytes;
    private Long dimensioneRispostaRicevutaBytes;
    private boolean replyOnNewConnection;
    private boolean utilizzoIndirizzoTelematico;
    private String implementazionePdDSoggettoMittente;
    private String implementazionePdDSoggettoDestinatario;
    private String servizioApplicativoErogatore;
    private PdDContext pddContext;
    private String oldFunctionName;
    private static INodeSender nodeSender = null;
    private boolean gestioneStatelessConIntegrationManager = false;

    public void setPddContext(PdDContext pddContext) {
        this.pddContext = pddContext;
    }

    public static synchronized void initializeNodeSender(OpenSPCoopProperties propertiesReader, Logger logCore) throws EJBUtilsException {
        if (nodeSender != null) {
            return;
        }
        String classTypeNodeSender = ClassNameProperties.getInstance().getNodeSender(propertiesReader.getNodeSender());
        try {
            nodeSender = (INodeSender)Loader.getInstance().newInstance(classTypeNodeSender);
            logCore.info((Object)("Inizializzazione gestore NodeSender di tipo " + classTypeNodeSender + " effettuata."));
        }
        catch (Exception e) {
            throw new EJBUtilsException("Riscontrato errore durante il caricamento della classe [" + classTypeNodeSender + "] da utilizzare per la spedizione nell'infrastruttura: " + e.getMessage());
        }
    }

    public static INodeSender getNodeSender(OpenSPCoopProperties propertiesReader, Logger log) throws EJBUtilsException {
        if (nodeSender == null) {
            EJBUtils.initializeNodeSender(propertiesReader, log);
        }
        return nodeSender;
    }

    public EJBUtils(IDSoggetto identitaPdD, String aIDModulo, String idEGovSessione, String idEGovMessage, String tipo, IOpenSPCoopState openspcoop_state, MsgDiagnostico msgDiag, boolean functionAsRouter, String implementazionePdDSoggettoMittente, String implementazionePdDSoggettoDestinatario, PdDContext pddContext) throws EJBUtilsException {
        this.identitaPdD = identitaPdD;
        this.idModulo = aIDModulo;
        this.idEGovSessione = idEGovSessione;
        this.idEGovMessage = idEGovMessage;
        this.tipo = tipo;
        this.openSPCoopState = openspcoop_state;
        this.functionAsRouter = functionAsRouter;
        this.log = OpenSPCoopLogger.getLoggerOpenSPCoopCore();
        if (this.log == null) {
            this.log = Logger.getLogger((String)"EJBUtils");
        }
        this.msgDiag = msgDiag;
        this.propertiesReader = OpenSPCoopProperties.getInstance();
        this.configurazionePdDReader = ConfigurazionePdDReader.getInstance();
        this.implementazionePdDSoggettoMittente = implementazionePdDSoggettoMittente;
        this.implementazionePdDSoggettoDestinatario = implementazionePdDSoggettoDestinatario;
        this.pddContext = pddContext;
        if (nodeSender == null) {
            EJBUtils.initializeNodeSender(this.propertiesReader, this.log);
        }
    }

    private void setEJBSuffixFunctionName() {
        if (this.msgDiag != null) {
            this.oldFunctionName = this.msgDiag.getFunzione();
            this.msgDiag.setFunzione(this.msgDiag.getFunzione() + ".EJBUtils");
        }
    }

    private void unsetEJBSuffixFunctionName() {
        if (this.msgDiag != null && this.oldFunctionName != null) {
            this.msgDiag.setFunzione(this.oldFunctionName);
        }
    }

    public void updateOpenSPCoopState(IOpenSPCoopState openSPCoopState) {
        this.openSPCoopState = openSPCoopState;
    }

    public void updateIdEGovSessione(String id) {
        this.idEGovSessione = id;
    }

    public void setReplyOnNewConnection(boolean replyOnNewConnection) {
        this.replyOnNewConnection = replyOnNewConnection;
    }

    public void setUtilizzoIndirizzoTelematico(boolean utilizzoIndirizzoTelematico) {
        this.utilizzoIndirizzoTelematico = utilizzoIndirizzoTelematico;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void rollbackMessage(String motivoRollbackEJB) {
        this.setEJBSuffixFunctionName();
        try {
            GestoreMessaggi msg = new GestoreMessaggi(this.openSPCoopState, true, this.idEGovMessage, this.tipo, this.msgDiag);
            msg.setOneWayVersione11(this.oneWayVersione11);
            msg.aggiornaErroreProcessamentoMessaggio(motivoRollbackEJB, null);
        }
        catch (Exception e) {
            this.msgDiag.logErroreGenerico(e, "EJBUtils.rollbackMessage(motivoRollbackEJB)");
        }
        finally {
            this.unsetEJBSuffixFunctionName();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void rollbackMessage(String motivoRollbackEJB, String servizioApplicativo) {
        this.setEJBSuffixFunctionName();
        try {
            GestoreMessaggi msg = new GestoreMessaggi(this.openSPCoopState, true, this.idEGovMessage, this.tipo, this.msgDiag);
            msg.setOneWayVersione11(this.oneWayVersione11);
            msg.aggiornaErroreProcessamentoMessaggio(motivoRollbackEJB, servizioApplicativo);
        }
        catch (Exception e) {
            this.msgDiag.logErroreGenerico(e, "EJBUtils.rollbackMessage(motivoRollbackEJB,servizioApplicativo)");
        }
        finally {
            this.unsetEJBSuffixFunctionName();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void rollbackMessage(String motivoRollbackEJB, Timestamp dataRiconsegna, String servizioApplicativo) {
        this.setEJBSuffixFunctionName();
        try {
            GestoreMessaggi msg = new GestoreMessaggi(this.openSPCoopState, true, this.idEGovMessage, this.tipo, this.msgDiag);
            msg.setOneWayVersione11(this.oneWayVersione11);
            msg.aggiornaErroreProcessamentoMessaggio(motivoRollbackEJB, servizioApplicativo);
            if (dataRiconsegna != null) {
                msg.aggiornaDataRispedizione(dataRiconsegna, servizioApplicativo);
            }
        }
        catch (Exception e) {
            this.msgDiag.logErroreGenerico(e, "EJBUtils.rollbackMessage(motivoRollbackEJB,dataRiconsegna,servizioApplicativo)");
        }
        finally {
            this.unsetEJBSuffixFunctionName();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void rollbackMessage(String motivoRollbackEJB, Timestamp dataRiconsegna) {
        this.setEJBSuffixFunctionName();
        try {
            GestoreMessaggi msg = new GestoreMessaggi(this.openSPCoopState, true, this.idEGovMessage, this.tipo, this.msgDiag);
            msg.setOneWayVersione11(this.oneWayVersione11);
            msg.aggiornaErroreProcessamentoMessaggio(motivoRollbackEJB, null);
            if (dataRiconsegna != null) {
                msg.aggiornaDataRispedizione(dataRiconsegna, null);
            }
        }
        catch (Exception e) {
            this.msgDiag.logErroreGenerico(e, "EJBUtils.rollbackMessage(motivoRollbackEJB,dataRiconsegna)");
        }
        finally {
            this.unsetEJBSuffixFunctionName();
        }
    }

    public void updateErroreProcessamentoMessage(String motivoRollbackEJB) {
        this.updateErroreProcessamentoMessage(motivoRollbackEJB, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateErroreProcessamentoMessage(String motivoRollbackEJB, Timestamp dataRispedizione) {
        this.setEJBSuffixFunctionName();
        try {
            GestoreMessaggi msg = new GestoreMessaggi(this.openSPCoopState, true, this.idEGovMessage, this.tipo, this.msgDiag);
            msg.setOneWayVersione11(this.oneWayVersione11);
            msg.aggiornaErroreProcessamentoMessaggio(motivoRollbackEJB, null);
            if (dataRispedizione != null) {
                msg.aggiornaDataRispedizione(dataRispedizione, null);
            }
        }
        catch (Exception e) {
            this.msgDiag.logErroreGenerico(e, "EJBUtils.updateErroreProcessamentoMessage");
        }
        finally {
            this.unsetEJBSuffixFunctionName();
        }
    }

    public void releaseOutboxMessage(boolean isMessaggioRichiesta) throws EJBUtilsException {
        this.releaseMessage(true, false, null, null, true, isMessaggioRichiesta);
    }

    public void releaseOutboxMessage(boolean cleanHistory, boolean isMessaggioRichiesta) throws EJBUtilsException {
        this.releaseMessage(true, false, null, null, cleanHistory, isMessaggioRichiesta);
    }

    public void releaseOutboxMessage(String tipo, String id, boolean isMessaggioRichiesta) throws EJBUtilsException {
        if (!"INBOX".equals(tipo) && !"OUTBOX".equals(tipo)) {
            throw new EJBUtilsException("EJBUtils.releaseOutboxMessage error: Tipo di Messaggio non definito");
        }
        if (id == null) {
            throw new EJBUtilsException("EJBUtils.releaseOutboxMessage error: ID Messaggio non definito");
        }
        this.releaseMessage(true, false, tipo, id, true, isMessaggioRichiesta);
    }

    public void releaseInboxMessage(boolean isMessaggioRichiesta) throws EJBUtilsException {
        this.releaseMessage(false, true, null, null, true, isMessaggioRichiesta);
    }

    public void releaseInboxMessage(boolean cleanHistory, boolean isMessaggioRichiesta) throws EJBUtilsException {
        this.releaseMessage(false, true, null, null, cleanHistory, isMessaggioRichiesta);
    }

    public void releaseInboxMessage(String tipo, String id, boolean isMessaggioRichiesta) throws EJBUtilsException {
        if (!"INBOX".equals(tipo) && !"OUTBOX".equals(tipo)) {
            throw new EJBUtilsException("EJBUtils.releaseOutboxMessage error: Tipo di Messaggio non definito");
        }
        if (id == null) {
            throw new EJBUtilsException("EJBUtils.releaseOutboxMessage error: ID Messaggio non definito");
        }
        this.releaseMessage(false, true, tipo, id, true, isMessaggioRichiesta);
    }

    private void releaseMessage(boolean rollbackOutbox, boolean rollbackInbox, String tipo, String id, boolean cleanHistory, boolean isMessaggioRichiesta) throws EJBUtilsException {
        StateMessage stateMSG;
        StateMessage stateMessage = stateMSG = isMessaggioRichiesta ? (StateMessage)this.openSPCoopState.getStatoRichiesta() : (StateMessage)this.openSPCoopState.getStatoRisposta();
        if (stateMSG instanceof StatelessMessage && !this.oneWayVersione11) {
            return;
        }
        RollbackRepositoryEGov rollbackEGov = null;
        RollbackRepositoryEGov rollbackEGovRifMessaggio = null;
        GestoreMessaggi msg = null;
        try {
            if (rollbackOutbox) {
                rollbackEGov = new RollbackRepositoryEGov(this.idEGovMessage, (IState)stateMSG, this.oneWayVersione11);
                rollbackEGov.rollbackBustaIntoOutBox(cleanHistory);
            } else if (rollbackInbox) {
                rollbackEGov = new RollbackRepositoryEGov(this.idEGovMessage, (IState)stateMSG, this.oneWayVersione11);
                rollbackEGov.rollbackBustaIntoInBox(cleanHistory);
            }
            if (tipo != null && id != null) {
                rollbackEGovRifMessaggio = new RollbackRepositoryEGov(id, (IState)stateMSG, this.oneWayVersione11);
                if ("OUTBOX".equals(tipo)) {
                    rollbackEGovRifMessaggio.rollbackBustaIntoOutBox();
                } else {
                    rollbackEGovRifMessaggio.rollbackBustaIntoInBox();
                }
            }
            msg = new GestoreMessaggi(this.openSPCoopState, true, this.idEGovMessage, this.tipo, this.msgDiag);
            msg.setOneWayVersione11(this.oneWayVersione11);
            msg.aggiornaProprietarioMessaggio("GestoreMessaggi");
            this.openSPCoopState.commit();
            String idEgovRichiestaCorrelata = null;
            if (!this.idEGovMessage.equals(this.idEGovSessione)) {
                idEgovRichiestaCorrelata = this.idEGovSessione;
            }
            msg.addProprietariIntoCache_readFromTable("EJBUtils." + this.idModulo, "releaseMessage", idEgovRichiestaCorrelata, this.functionAsRouter);
        }
        catch (Exception e) {
            stateMSG.closePreparedStatement();
            throw new EJBUtilsException("EJBUtils.releaseMessage error: " + e.getMessage(), e);
        }
    }

    public void sendRispostaApplicativaErrore(Message responseAxisMessageError, RichiestaDelegata richiestaDelegata, PortaDelegata pd, ServizioApplicativo sa) throws EJBUtilsException {
        this.sendRispostaApplicativaErrore(responseAxisMessageError, richiestaDelegata, true, pd, sa);
    }

    public void sendRispostaApplicativaErrore(Message responseAxisMessageError, RichiestaDelegata richiestaDelegata, boolean rollbackRichiesta, PortaDelegata pd, ServizioApplicativo sa) throws EJBUtilsException {
        if (this.openSPCoopState instanceof OpenSPCoopStateless) {
            ((OpenSPCoopStateless)this.openSPCoopState).setRispostaMsg(responseAxisMessageError);
        }
        StateMessage statoRichiesta = (StateMessage)this.openSPCoopState.getStatoRichiesta();
        StateMessage statoRisposta = (StateMessage)this.openSPCoopState.getStatoRisposta();
        String correlazioneApplicativa = null;
        if (richiestaDelegata != null) {
            correlazioneApplicativa = richiestaDelegata.getIdCorrelazioneApplicativa();
        }
        RollbackRepositoryEGov rollbackEGov = null;
        RollbackRepositoryEGov rollbackEGovRifMessaggio = null;
        GestoreMessaggi msgRequest = null;
        GestoreMessaggi msgResponse = null;
        GestoreMessaggi msgSbloccoRicezioneContenutiApplicativi = null;
        this.msgDiag.addKeyword("@SERVIZIO_APPLICATIVO_EROGATORE@", richiestaDelegata.getServizioApplicativo());
        this.setEJBSuffixFunctionName();
        try {
            String idModuloInAttesa = richiestaDelegata.getIdModuloInAttesa();
            boolean consegnaRispostaAsincrona = false;
            if (rollbackRichiesta) {
                rollbackEGovRifMessaggio = new RollbackRepositoryEGov(this.idEGovSessione, (IState)statoRichiesta, this.oneWayVersione11);
                rollbackEGovRifMessaggio.rollbackBustaIntoOutBox(this.rollbackRichiestaInCasoErrore_rollbackHistory);
            } else {
                rollbackEGovRifMessaggio = new RollbackRepositoryEGov(this.idEGovSessione, (IState)statoRichiesta, this.oneWayVersione11);
                rollbackEGovRifMessaggio.clearAccessiIntoOutBox(false, false, true);
            }
            if (!this.idEGovSessione.equals(this.idEGovMessage)) {
                rollbackEGov = new RollbackRepositoryEGov(this.idEGovMessage, (IState)statoRichiesta, this.oneWayVersione11);
                rollbackEGov.rollbackBustaIntoInBox();
            }
            msgRequest = new GestoreMessaggi(this.openSPCoopState, true, this.idEGovMessage, this.tipo, this.msgDiag);
            msgRequest.setOneWayVersione11(this.oneWayVersione11);
            msgRequest.aggiornaProprietarioMessaggio("GestoreMessaggi");
            String idRisposta = null;
            if (consegnaRispostaAsincrona || idModuloInAttesa != null) {
                Imbustamento imbustatore = new Imbustamento();
                idRisposta = imbustatore.buildID_eGov(this.identitaPdD.getCodicePorta(), this.identitaPdD.getNome());
                if (idRisposta == null) {
                    throw new Exception("Identificativo eGov non costruito.");
                }
                Timestamp oraRegistrazioneMessaggio = DateManager.getTimestamp();
                msgResponse = new GestoreMessaggi(this.openSPCoopState, false, idRisposta, "INBOX", this.msgDiag);
                msgResponse.registraMessaggio(responseAxisMessageError, oraRegistrazioneMessaggio, this.saveMessageStateless(pd), correlazioneApplicativa, this.pddContext);
                msgResponse.aggiornaRiferimentoMessaggio(this.idEGovSessione);
                if (consegnaRispostaAsincrona) {
                    msgResponse.aggiornaProprietarioMessaggio("ConsegnaContenutiApplicativi");
                } else if (idModuloInAttesa != null) {
                    msgResponse.aggiornaProprietarioMessaggio(idModuloInAttesa);
                }
                boolean servizioApplicativoConConnettore = false;
                boolean getMessageAbilitato = false;
                boolean sbustamentoSoap = false;
                try {
                    servizioApplicativoConConnettore = this.configurazionePdDReader.consegnaRispostaAsincronaConConnettore(sa);
                    getMessageAbilitato = this.configurazionePdDReader.consegnaRispostaAsincronaConGetMessage(sa);
                    sbustamentoSoap = this.configurazionePdDReader.consegnaRispostaAsincronaConSbustamento(sa);
                }
                catch (DriverConfigurazioneNotFound de) {
                    // empty catch block
                }
                if (!getMessageAbilitato && !servizioApplicativoConConnettore && idModuloInAttesa == null) {
                    this.msgDiag.logPersonalizzato("consegnaContenutiApplicativi.", "consegnaNonDefinita");
                    return;
                }
                String tipoConsegna = "IntegrationManager";
                if (consegnaRispostaAsincrona) {
                    if (servizioApplicativoConConnettore) {
                        richiestaDelegata.setScenario("ConsegnaContenutiApplicativi");
                        this.sendToConsegnaContenutiApplicativi_rispostaConsegnataModalitaAsincrona(richiestaDelegata, idRisposta, msgResponse);
                        tipoConsegna = "Connettore";
                    } else {
                        this.msgDiag.logPersonalizzato("consegnaContenutiApplicativi.", "integrationManager.messaggioDisponibile");
                    }
                } else if (idModuloInAttesa != null) {
                    this.sendToRicezioneContenutiApplicativi(idModuloInAttesa, idRisposta, richiestaDelegata.getIdCollaborazione(), richiestaDelegata.getProfiloCollaborazione());
                    tipoConsegna = "ConnectionReply";
                }
                msgResponse.registraDestinatarioMessaggio(richiestaDelegata.getServizioApplicativo(), sbustamentoSoap, getMessageAbilitato, tipoConsegna, oraRegistrazioneMessaggio);
            }
            String idSbloccoRicezioneContenutiApplicativi = null;
            if (consegnaRispostaAsincrona && idModuloInAttesa != null) {
                Imbustamento imbustatore = new Imbustamento();
                idSbloccoRicezioneContenutiApplicativi = imbustatore.buildID_eGov(this.identitaPdD.getCodicePorta(), this.identitaPdD.getNome());
                if (idSbloccoRicezioneContenutiApplicativi == null) {
                    throw new Exception("Identificativo eGov non costruito.");
                }
                msgSbloccoRicezioneContenutiApplicativi = new GestoreMessaggi(this.openSPCoopState, false, idSbloccoRicezioneContenutiApplicativi, "INBOX", this.msgDiag);
                if (this.propertiesReader.isHttpEmptyResponseOneWay()) {
                    msgSbloccoRicezioneContenutiApplicativi.registraMessaggio(SoapUtils.build_Soap_Empty(), correlazioneApplicativa, this.pddContext);
                } else {
                    msgSbloccoRicezioneContenutiApplicativi.registraMessaggio(SoapUtils.buildOpenSPCoopOK_axisMsg((String)this.idEGovSessione), correlazioneApplicativa, this.pddContext);
                }
                msgSbloccoRicezioneContenutiApplicativi.aggiornaRiferimentoMessaggio(this.idEGovSessione);
                msgSbloccoRicezioneContenutiApplicativi.aggiornaProprietarioMessaggio(idModuloInAttesa);
                this.sendToRicezioneContenutiApplicativi(idModuloInAttesa, idSbloccoRicezioneContenutiApplicativi, richiestaDelegata.getIdCollaborazione(), richiestaDelegata.getProfiloCollaborazione());
            }
            this.openSPCoopState.commit();
            if (msgSbloccoRicezioneContenutiApplicativi != null) {
                msgSbloccoRicezioneContenutiApplicativi.addMessaggiIntoCache_readFromTable(this.idModulo, "sendRispostaApplicativaErrore [sblocco]");
            }
            if (msgResponse != null) {
                msgResponse.addMessaggiIntoCache_readFromTable(this.idModulo, "sendRispostaApplicativaErrore [risposta]");
            }
            if (msgRequest != null) {
                String idEgovRichiestaCorrelata = null;
                if (!this.idEGovMessage.equals(this.idEGovSessione)) {
                    idEgovRichiestaCorrelata = this.idEGovSessione;
                }
                msgRequest.addProprietariIntoCache_readFromTable(this.idModulo, "sendRispostaApplicativaErrore [richiesta]", idEgovRichiestaCorrelata, this.functionAsRouter);
            }
            if (msgSbloccoRicezioneContenutiApplicativi != null) {
                msgSbloccoRicezioneContenutiApplicativi.addProprietariIntoCache_readFromTable(this.idModulo, "sendRispostaApplicativaErrore [sblocco]", this.idEGovSessione, this.functionAsRouter);
            }
            if (msgResponse != null) {
                msgResponse.addProprietariIntoCache_readFromTable(this.idModulo, "sendRispostaApplicativaErrore [risposta]", this.idEGovSessione, this.functionAsRouter);
            }
        }
        catch (Exception e) {
            this.msgDiag.logErroreGenerico(e, "EJBUtils.sendRispostaApplicativaErrore");
            statoRichiesta.closePreparedStatement();
            statoRisposta.closePreparedStatement();
            throw new EJBUtilsException("EJBUtils.sendRispostaApplicativaErrore error: " + e.getMessage(), e);
        }
        finally {
            this.unsetEJBSuffixFunctionName();
        }
    }

    public GestoreMessaggi sendRispostaApplicativa(RichiestaDelegata richiestaDelegata, PortaDelegata pd, ServizioApplicativo sa) throws EJBUtilsException {
        return this.sendRispostaApplicativa(null, richiestaDelegata, this.idEGovMessage, pd, sa);
    }

    public GestoreMessaggi sendRispostaApplicativaOK(Message axisMsg, RichiestaDelegata richiestaDelegata, PortaDelegata pd, ServizioApplicativo sa) throws EJBUtilsException {
        return this.sendRispostaApplicativa(axisMsg, richiestaDelegata, null, pd, sa);
    }

    private GestoreMessaggi sendRispostaApplicativa(Message axisMsg, RichiestaDelegata richiestaDelegata, String idEGovRisposta, PortaDelegata pd, ServizioApplicativo sa) throws EJBUtilsException {
        StateMessage statoRisposta = (StateMessage)this.openSPCoopState.getStatoRisposta();
        GestoreMessaggi msgResponse = null;
        GestoreMessaggi msgSbloccoRicezioneContenutiApplicativi = null;
        String correlazioneApplicativa = null;
        if (richiestaDelegata != null) {
            correlazioneApplicativa = richiestaDelegata.getIdCorrelazioneApplicativa();
        }
        this.msgDiag.addKeyword("@SERVIZIO_APPLICATIVO_EROGATORE@", richiestaDelegata.getServizioApplicativo());
        this.setEJBSuffixFunctionName();
        try {
            String idModuloInAttesa = richiestaDelegata.getIdModuloInAttesa();
            boolean existsConsegnaRispostaAsincrona = false;
            try {
                existsConsegnaRispostaAsincrona = this.configurazionePdDReader.existsConsegnaRispostaAsincrona(sa);
            }
            catch (DriverConfigurazioneNotFound de) {
                // empty catch block
            }
            boolean consegnaRispostaAsincrona = richiestaDelegata.getUtilizzoConsegnaAsincrona() && existsConsegnaRispostaAsincrona;
            String idRisposta = idEGovRisposta;
            if (consegnaRispostaAsincrona || idModuloInAttesa != null) {
                Timestamp oraRegistrazioneMessaggio = DateManager.getTimestamp();
                if (idRisposta == null) {
                    Imbustamento imbustatore = new Imbustamento();
                    idRisposta = imbustatore.buildID_eGov(this.identitaPdD.getCodicePorta(), this.identitaPdD.getNome());
                    if (idRisposta == null) {
                        throw new Exception("Identificativo eGov non costruito.");
                    }
                    msgResponse = new GestoreMessaggi(this.openSPCoopState, false, idRisposta, "INBOX", this.msgDiag);
                    msgResponse.registraMessaggio(axisMsg, oraRegistrazioneMessaggio, this.saveMessageStateless(pd), correlazioneApplicativa, this.pddContext);
                } else {
                    msgResponse = new GestoreMessaggi(this.openSPCoopState, false, idRisposta, "INBOX", this.msgDiag);
                    oraRegistrazioneMessaggio = msgResponse.getOraRegistrazioneMessaggio();
                }
                msgResponse.aggiornaRiferimentoMessaggio(this.idEGovSessione);
                if (consegnaRispostaAsincrona) {
                    msgResponse.aggiornaProprietarioMessaggio("ConsegnaContenutiApplicativi");
                } else if (idModuloInAttesa != null) {
                    msgResponse.aggiornaProprietarioMessaggio(idModuloInAttesa);
                }
                boolean servizioApplicativoConConnettore = false;
                boolean getMessageAbilitato = false;
                boolean sbustamentoSoap = false;
                try {
                    servizioApplicativoConConnettore = this.configurazionePdDReader.consegnaRispostaAsincronaConConnettore(sa);
                    getMessageAbilitato = this.configurazionePdDReader.consegnaRispostaAsincronaConGetMessage(sa);
                    sbustamentoSoap = this.configurazionePdDReader.consegnaRispostaAsincronaConSbustamento(sa);
                }
                catch (DriverConfigurazioneNotFound de) {
                    // empty catch block
                }
                if (!getMessageAbilitato && !servizioApplicativoConConnettore && idModuloInAttesa == null) {
                    this.msgDiag.logPersonalizzato("consegnaContenutiApplicativi.", "consegnaNonDefinita");
                    GestoreMessaggi de = msgResponse;
                    return de;
                }
                if (!servizioApplicativoConConnettore && idModuloInAttesa == null) {
                    this.msgDiag.logPersonalizzato("consegnaContenutiApplicativi.", "integrationManager.messaggioDisponibile");
                }
                String tipoConsegna = "IntegrationManager";
                if (consegnaRispostaAsincrona) {
                    if (servizioApplicativoConConnettore) {
                        richiestaDelegata.setScenario("ConsegnaContenutiApplicativi");
                        this.sendToConsegnaContenutiApplicativi_rispostaConsegnataModalitaAsincrona(richiestaDelegata, idRisposta, msgResponse);
                        tipoConsegna = "Connettore";
                    } else {
                        this.msgDiag.logPersonalizzato("consegnaContenutiApplicativi.", "integrationManager.messaggioDisponibile");
                    }
                } else if (idModuloInAttesa != null) {
                    this.sendToRicezioneContenutiApplicativi(idModuloInAttesa, idRisposta, richiestaDelegata.getIdCollaborazione(), richiestaDelegata.getProfiloCollaborazione());
                    tipoConsegna = "ConnectionReply";
                }
                msgResponse.registraDestinatarioMessaggio(richiestaDelegata.getServizioApplicativo(), sbustamentoSoap, getMessageAbilitato, tipoConsegna, oraRegistrazioneMessaggio);
            }
            if (consegnaRispostaAsincrona && idModuloInAttesa != null) {
                Imbustamento imbustatore = new Imbustamento();
                String idSbloccoRicezioneContenutiApplicativi = imbustatore.buildID_eGov(this.identitaPdD.getCodicePorta(), this.identitaPdD.getNome());
                if (idSbloccoRicezioneContenutiApplicativi == null) {
                    throw new Exception("Identificativo eGov non costruito.");
                }
                msgSbloccoRicezioneContenutiApplicativi = new GestoreMessaggi(this.openSPCoopState, false, idSbloccoRicezioneContenutiApplicativi, "INBOX", this.msgDiag);
                if (this.propertiesReader.isHttpEmptyResponseOneWay()) {
                    msgSbloccoRicezioneContenutiApplicativi.registraMessaggio(SoapUtils.build_Soap_Empty(), correlazioneApplicativa, this.pddContext);
                } else {
                    msgSbloccoRicezioneContenutiApplicativi.registraMessaggio(SoapUtils.buildOpenSPCoopOK_axisMsg((String)this.idEGovSessione), correlazioneApplicativa, this.pddContext);
                }
                msgSbloccoRicezioneContenutiApplicativi.aggiornaRiferimentoMessaggio(this.idEGovSessione);
                msgSbloccoRicezioneContenutiApplicativi.aggiornaProprietarioMessaggio(idModuloInAttesa);
                this.sendToRicezioneContenutiApplicativi(idModuloInAttesa, idSbloccoRicezioneContenutiApplicativi, richiestaDelegata.getIdCollaborazione(), richiestaDelegata.getProfiloCollaborazione());
            }
            GestoreMessaggi gestoreMessaggi = msgResponse;
            return gestoreMessaggi;
        }
        catch (Exception e) {
            this.msgDiag.logErroreGenerico(e, "EJBUtils.sendRispostaApplicativa");
            if (msgResponse != null) {
                statoRisposta.closePreparedStatement();
            }
            throw new EJBUtilsException("EJBUtils.sendRispostaApplicativa error: " + e.getMessage(), e);
        }
        finally {
            this.unsetEJBSuffixFunctionName();
        }
    }

    public void sendToRicezioneContenutiApplicativi(String idModuloInAttesa, String idRisposta, String idCollaborazione, String profiloCollaborazione) throws EJBUtilsException {
        if (this.openSPCoopState instanceof OpenSPCoopStateless) {
            RicezioneContenutiApplicativiMessage accettazioneMSG = new RicezioneContenutiApplicativiMessage();
            accettazioneMSG.setIdEGovRisposta(idRisposta);
            accettazioneMSG.setIdCollaborazione(idCollaborazione);
            accettazioneMSG.setProfiloCollaborazione(profiloCollaborazione);
            accettazioneMSG.setPddContext(this.pddContext);
            ((OpenSPCoopStateless)this.openSPCoopState).setMessageLib(accettazioneMSG);
            return;
        }
        if ("jms".equals(this.propertiesReader.getNodeReceiver())) {
            try {
                this.msgDiag.highDebug("[EJBUtils] Creazione ObjectMessage for send via JMS.");
                RicezioneContenutiApplicativiMessage accettazioneMSG = new RicezioneContenutiApplicativiMessage();
                accettazioneMSG.setIdEGovRisposta(idRisposta);
                accettazioneMSG.setIdCollaborazione(idCollaborazione);
                accettazioneMSG.setProfiloCollaborazione(profiloCollaborazione);
                accettazioneMSG.setPddContext(this.pddContext);
                if (this.openSPCoopState instanceof OpenSPCoopStateless) {
                    ((OpenSPCoopStateless)this.openSPCoopState).setMessageLib(accettazioneMSG);
                } else {
                    JMSSender senderJMS = new JMSSender(this.identitaPdD.getCodicePorta(), this.idModulo, this.log);
                    if (!senderJMS.send(idModuloInAttesa, (Serializable)accettazioneMSG, this.idEGovSessione)) {
                        this.msgDiag.logErroreGenerico(senderJMS.getErrore(), "EJBUtils.sendToRicezioneContenutiApplicativi.senderJMS");
                        throw new Exception("[EJBUtils]  SendJMSError: " + senderJMS.getErrore());
                    }
                    this.msgDiag.highDebug("[EJBUtils]  ObjectMessage send via JMS.");
                }
            }
            catch (Exception e) {
                this.msgDiag.logErroreGenerico(e, "EJBUtils.sendToRicezioneContenutiApplicativi");
                throw new EJBUtilsException("EJBUtils.sendToRicezioneContenutiApplicativi error: " + e.getMessage(), e);
            }
        }
    }

    public void sendToConsegnaContenutiApplicativi_rispostaConsegnataModalitaAsincrona(RichiestaDelegata richiestaDelegata, String idEGovConsegna, GestoreMessaggi gm) throws EJBUtilsException {
        try {
            this.msgDiag.highDebug("[EJBUtils]  Creazione ObjectMessage for send nell'infrastruttura.");
            ConsegnaContenutiApplicativiMessage consegnaMSG = new ConsegnaContenutiApplicativiMessage();
            consegnaMSG.setRichiestaDelegata(richiestaDelegata);
            consegnaMSG.setOneWayVersione11(this.oneWayVersione11);
            consegnaMSG.setStateless(this.portaDiTipoStateless_esclusoOneWay11);
            consegnaMSG.setImplementazionePdDSoggettoMittente(this.implementazionePdDSoggettoMittente);
            consegnaMSG.setImplementazionePdDSoggettoDestinatario(this.implementazionePdDSoggettoDestinatario);
            consegnaMSG.setPddContext(this.pddContext);
            Busta busta = new Busta();
            busta.setTipoMittente(richiestaDelegata.getSoggettoFruitore().getTipo());
            busta.setMittente(richiestaDelegata.getSoggettoFruitore().getNome());
            busta.setTipoDestinatario(richiestaDelegata.getIdServizio().getSoggettoErogatore().getTipo());
            busta.setDestinatario(richiestaDelegata.getIdServizio().getSoggettoErogatore().getNome());
            busta.setTipoServizio(richiestaDelegata.getIdServizio().getTipoServizio());
            busta.setServizio(richiestaDelegata.getIdServizio().getServizio());
            busta.setAzione(richiestaDelegata.getIdServizio().getAzione());
            busta.setID(idEGovConsegna);
            busta.setRiferimentoMessaggio(this.idEGovSessione);
            if ((!"eGov1.1-lineeGuida1.1".equals(richiestaDelegata.getProfiloGestione()) || "EGOV_IT_ServizioAsincronoAsimmetrico".equals(busta.getProfiloDiCollaborazione()) || "EGOV_IT_ServizioAsincronoSimmetrico".equals(busta.getProfiloDiCollaborazione())) && this.propertiesReader.isGestioneElementoCollaborazione(this.implementazionePdDSoggettoDestinatario)) {
                busta.setCollaborazione(richiestaDelegata.getIdCollaborazione());
            }
            consegnaMSG.setBusta(busta);
            nodeSender.send(consegnaMSG, "ConsegnaContenutiApplicativi", this.msgDiag, this.identitaPdD.getCodicePorta(), this.idModulo, idEGovConsegna, gm);
        }
        catch (Exception e) {
            this.log.error((Object)"Spedizione->ConsegnaContenutiApplicativi(RichiestaDelegata) non riuscita", (Throwable)e);
            this.msgDiag.logErroreGenerico(e, "EJBUtils.sendToConsegnaContenutiApplicativi(RichiestaDelegata)");
            throw new EJBUtilsException("EJBUtils.sendToConsegnaContenutiApplicativi error: " + e.getMessage(), e);
        }
    }

    public void sendToConsegnaContenutiApplicativi_gestioneMessaggio(RichiestaDelegata richiestaDelegata, Busta busta, GestoreMessaggi gestoreMessaggi, ServizioApplicativo sa) throws EJBUtilsException {
        block11: {
            try {
                this.msgDiag.addKeyword("@SERVIZIO_APPLICATIVO_EROGATORE@", richiestaDelegata.getServizioApplicativo());
                this.msgDiag.setServizioApplicativo(richiestaDelegata.getServizioApplicativo());
                this.msgDiag.logCorrelazioneServizioApplicativo();
                gestoreMessaggi.aggiornaRiferimentoMessaggio(busta.getRiferimentoMessaggio());
                boolean servizioApplicativoRicezioneAsincronaConConnettore = this.configurazionePdDReader.consegnaRispostaAsincronaConConnettore(sa);
                boolean getMessageAbilitato = this.configurazionePdDReader.consegnaRispostaAsincronaConGetMessage(sa);
                if (!getMessageAbilitato && !servizioApplicativoRicezioneAsincronaConConnettore) {
                    throw new EJBUtilsConsegnaException(this.msgDiag, "consegnaContenutiApplicativi.", "consegnaNonDefinita");
                }
                boolean sbustamentoSoap = this.configurazionePdDReader.consegnaRispostaAsincronaConSbustamento(sa);
                String tipoConsegna = "IntegrationManager";
                if (servizioApplicativoRicezioneAsincronaConConnettore) {
                    tipoConsegna = "Connettore";
                }
                Timestamp oraRegistrazioneMessaggio = gestoreMessaggi.getOraRegistrazioneMessaggio();
                gestoreMessaggi.registraDestinatarioMessaggio(richiestaDelegata.getServizioApplicativo(), sbustamentoSoap, getMessageAbilitato, tipoConsegna, oraRegistrazioneMessaggio);
                this.msgDiag.addKeyword("@SERVIZIO_APPLICATIVO_EROGATORE@", richiestaDelegata.getServizioApplicativo());
                if (servizioApplicativoRicezioneAsincronaConConnettore) {
                    this.msgDiag.highDebug("[EJBUtils] Creazione ObjectMessage for send nell'infrastruttura.");
                    ConsegnaContenutiApplicativiMessage consegnaMSG = new ConsegnaContenutiApplicativiMessage();
                    consegnaMSG.setRichiestaDelegata(richiestaDelegata);
                    consegnaMSG.setBusta(busta);
                    consegnaMSG.setOneWayVersione11(this.oneWayVersione11);
                    consegnaMSG.setStateless(this.portaDiTipoStateless_esclusoOneWay11);
                    consegnaMSG.setImplementazionePdDSoggettoMittente(this.implementazionePdDSoggettoMittente);
                    consegnaMSG.setImplementazionePdDSoggettoDestinatario(this.implementazionePdDSoggettoDestinatario);
                    consegnaMSG.setPddContext(this.pddContext);
                    if (this.openSPCoopState instanceof OpenSPCoopStateless) {
                        ((OpenSPCoopStateless)this.openSPCoopState).setMessageLib(consegnaMSG);
                    } else {
                        nodeSender.send(consegnaMSG, "ConsegnaContenutiApplicativi", this.msgDiag, this.identitaPdD.getCodicePorta(), this.idModulo, busta.getID(), gestoreMessaggi);
                    }
                    break block11;
                }
                if (richiestaDelegata.isRicevutaAsincrona() && ("EGOV_IT_ServizioAsincronoSimmetrico".equals(busta.getProfiloDiCollaborazione()) || "EGOV_IT_ServizioAsincronoAsimmetrico".equals(busta.getProfiloDiCollaborazione()))) {
                    throw new EJBUtilsConsegnaException(this.msgDiag, "consegnaContenutiApplicativi.", "gestioneProfiloAsincrono.servizioNonUtilizzabile");
                }
                this.msgDiag.logPersonalizzato("consegnaContenutiApplicativi.", "integrationManager.messaggioDisponibile");
            }
            catch (EJBUtilsConsegnaException e) {
                throw e;
            }
            catch (Exception e) {
                this.log.error((Object)"Spedizione->ConsegnaContenutiApplicativi_gestoreMessaggi(RichiestaDelegata) non riuscita", (Throwable)e);
                this.msgDiag.logErroreGenerico(e, "EJBUtils.sendToConsegnaContenutiApplicativi_gestoreMessaggi(RichiestaDelegata)");
                throw new EJBUtilsException("EJBUtils.sendToConsegnaContenutiApplicativi error: " + e.getMessage(), e);
            }
        }
    }

    public boolean isGestioneStatelessConIntegrationManager() {
        return this.gestioneStatelessConIntegrationManager;
    }

    public void sendToConsegnaContenutiApplicativi(RichiestaApplicativa richiestaApplicativa, Busta busta, GestoreMessaggi gestoreMessaggi, PortaApplicativa pa, RepositoryEGov repositoryEGov) throws EJBUtilsException {
        try {
            if (!("OneWay_InvocazioneServizio".equals(richiestaApplicativa.getScenario()) || "Sincrono_InvocazioneServizio".equals(richiestaApplicativa.getScenario()) || "AsincronoSimmetrico_InvocazioneServizio".equals(richiestaApplicativa.getScenario()) || "AsincronoAsimmetrico_InvocazioneServizio".equals(richiestaApplicativa.getScenario()) || "AsincronoAsimmetrico_Polling".equals(richiestaApplicativa.getScenario()))) {
                throw new Exception("Tipo di consegna non conosciuta");
            }
            String[] serviziApplicativi = null;
            IDSoggetto[] soggettiRealiMappatiInUnSoggettoVirtuale = null;
            IDSoggetto soggettoDestinatario = richiestaApplicativa.getIDServizio().getSoggettoErogatore();
            if ("AsincronoAsimmetrico_Polling".equals(richiestaApplicativa.getScenario())) {
                serviziApplicativi = this.configurazionePdDReader.getServiziApplicativi(pa);
                if (serviziApplicativi == null) {
                    throw new EJBUtilsConsegnaException(this.msgDiag, "consegnaContenutiApplicativi.", "servizioApplicativoNonDefinito");
                }
            } else if (this.configurazionePdDReader.isSoggettoVirtuale(soggettoDestinatario)) {
                SoggettoVirtuale soggettiVirtuali = this.configurazionePdDReader.getServiziApplicativi_SoggettiVirtuali(richiestaApplicativa);
                if (soggettiVirtuali == null) {
                    throw new EJBUtilsConsegnaException("(SoggettoVirtuale) " + this.msgDiag.getMessaggio_replaceKeywords("consegnaContenutiApplicativi.", "servizioApplicativoNonDefinito"), this.msgDiag.getLivello("consegnaContenutiApplicativi.", "servizioApplicativoNonDefinito"), this.msgDiag.getCodice("consegnaContenutiApplicativi.", "servizioApplicativoNonDefinito"));
                }
                serviziApplicativi = soggettiVirtuali.getServiziApplicativi();
                soggettiRealiMappatiInUnSoggettoVirtuale = soggettiVirtuali.getSoggettiReali();
            } else {
                serviziApplicativi = this.configurazionePdDReader.getServiziApplicativi(pa);
                if (serviziApplicativi == null) {
                    throw new EJBUtilsConsegnaException(this.msgDiag, "consegnaContenutiApplicativi.", "servizioApplicativoNonDefinito");
                }
            }
            if (serviziApplicativi.length < 1) {
                throw new EJBUtilsConsegnaException(this.msgDiag, "consegnaContenutiApplicativi.", "servizioApplicativoNonDefinito");
            }
            if (!"OneWay_InvocazioneServizio".equals(richiestaApplicativa.getScenario()) && serviziApplicativi.length > 1) {
                throw new EJBUtilsConsegnaException(this.msgDiag, "consegnaContenutiApplicativi.", "gestioneProfiloNonOneway.consegnaVersoNServiziApplicativi");
            }
            if ("OneWay_InvocazioneServizio".equals(richiestaApplicativa.getScenario()) && !this.oneWayVersione11 && this.openSPCoopState instanceof OpenSPCoopStateless && serviziApplicativi.length > 1) {
                for (int i = 0; i < serviziApplicativi.length; ++i) {
                    ServizioApplicativo sappl = this.configurazionePdDReader.getServizioApplicativo(richiestaApplicativa.getIdPortaApplicativa(), serviziApplicativi[i]);
                    boolean servizioApplicativoConConnettore = this.configurazionePdDReader.invocazioneServizioConConnettore(sappl);
                    boolean getMessageAbilitato = this.configurazionePdDReader.invocazioneServizioConGetMessage(sappl);
                    if (!servizioApplicativoConConnettore && getMessageAbilitato) continue;
                    throw new EJBUtilsConsegnaException(this.msgDiag, "consegnaContenutiApplicativi.", "gestioneStateless.consegnaVersoNServiziApplicativi");
                }
            }
            this.msgDiag.highDebug("[EJBUtils] Creazione ObjectMessage for send nell'infrastruttura.");
            ConsegnaContenutiApplicativiMessage consegnaMSG = new ConsegnaContenutiApplicativiMessage();
            consegnaMSG.setBusta(busta);
            consegnaMSG.setOneWayVersione11(this.oneWayVersione11);
            consegnaMSG.setStateless(this.portaDiTipoStateless_esclusoOneWay11);
            consegnaMSG.setImplementazionePdDSoggettoMittente(this.implementazionePdDSoggettoMittente);
            consegnaMSG.setImplementazionePdDSoggettoDestinatario(this.implementazionePdDSoggettoDestinatario);
            consegnaMSG.setPddContext(this.pddContext);
            boolean registrazioneMessaggioPerStatelessEffettuata = false;
            for (int i = 0; i < serviziApplicativi.length; ++i) {
                this.msgDiag.addKeyword("@SERVIZIO_APPLICATIVO_EROGATORE@", serviziApplicativi[i]);
                if (soggettiRealiMappatiInUnSoggettoVirtuale != null) {
                    String oldDominio = richiestaApplicativa.getIDServizio().getSoggettoErogatore().getCodicePorta();
                    richiestaApplicativa.getIDServizio().setSoggettoErogatore(soggettiRealiMappatiInUnSoggettoVirtuale[i]);
                    richiestaApplicativa.getIDServizio().getSoggettoErogatore().setCodicePorta(oldDominio);
                }
                richiestaApplicativa.setServizioApplicativo(serviziApplicativi[i]);
                ServizioApplicativo sappl = this.configurazionePdDReader.getServizioApplicativo(richiestaApplicativa.getIdPortaApplicativa(), serviziApplicativi[i]);
                this.msgDiag.setServizioApplicativo(serviziApplicativi[i]);
                this.msgDiag.logCorrelazioneServizioApplicativo();
                boolean servizioApplicativoConConnettore = true;
                boolean getMessageAbilitato = false;
                boolean sbustamento_soap = false;
                if ("AsincronoAsimmetrico_Polling".equals(richiestaApplicativa.getScenario())) {
                    sbustamento_soap = this.configurazionePdDReader.consegnaRispostaAsincronaConSbustamento(sappl);
                    servizioApplicativoConConnettore = this.configurazionePdDReader.consegnaRispostaAsincronaConConnettore(sappl);
                } else {
                    servizioApplicativoConConnettore = this.configurazionePdDReader.invocazioneServizioConConnettore(sappl);
                    sbustamento_soap = this.configurazionePdDReader.invocazioneServizioConSbustamento(sappl);
                    getMessageAbilitato = this.configurazionePdDReader.invocazioneServizioConGetMessage(sappl);
                }
                if (!getMessageAbilitato && !servizioApplicativoConConnettore) {
                    throw new EJBUtilsConsegnaException(this.msgDiag, "consegnaContenutiApplicativi.", "consegnaNonDefinita");
                }
                if (this.openSPCoopState instanceof OpenSPCoopStateless && !this.oneWayVersione11 && getMessageAbilitato && servizioApplicativoConConnettore) {
                    throw new EJBUtilsConsegnaException(this.msgDiag, "consegnaContenutiApplicativi.", "gestioneStateless.integrationManager");
                }
                String tipoConsegna = "IntegrationManager";
                if (servizioApplicativoConConnettore) {
                    tipoConsegna = "Connettore";
                }
                Timestamp oraRegistrazioneMessaggio = gestoreMessaggi.getOraRegistrazioneMessaggio();
                gestoreMessaggi.registraDestinatarioMessaggio(serviziApplicativi[i], sbustamento_soap, getMessageAbilitato, tipoConsegna, oraRegistrazioneMessaggio);
                if (servizioApplicativoConConnettore) {
                    consegnaMSG.setRichiestaApplicativa(richiestaApplicativa);
                    boolean stateless = this.configurazionePdDReader.isModalitaStateless(pa, busta.getProfiloDiCollaborazione());
                    if (!stateless) {
                        if (this.oneWayVersione11) {
                            OpenSPCoopStateless statelessSerializzabile = ((OpenSPCoopStateless)this.openSPCoopState).rendiSerializzabile();
                            consegnaMSG.setOpenspcoopstate(statelessSerializzabile);
                        }
                        try {
                            nodeSender.send(consegnaMSG, "ConsegnaContenutiApplicativi", this.msgDiag, this.identitaPdD.getCodicePorta(), this.idModulo, this.idEGovSessione, gestoreMessaggi);
                            continue;
                        }
                        catch (Exception e) {
                            this.msgDiag.logErroreGenerico(e, "EJBUtils.sendToConsegnaContenutiApplicativi(RichiestaApplicativa).senderJMS");
                            throw e;
                        }
                    }
                    ((OpenSPCoopStateless)this.openSPCoopState).setMessageLib(consegnaMSG);
                    continue;
                }
                if ("EGOV_IT_ServizioSincrono".equals(busta.getProfiloDiCollaborazione())) {
                    throw new EJBUtilsConsegnaException(this.msgDiag, "consegnaContenutiApplicativi.", "tramissioneSincrona.servizioNonUtilizzabile");
                }
                if (richiestaApplicativa.isRicevutaAsincrona() && ("EGOV_IT_ServizioAsincronoSimmetrico".equals(busta.getProfiloDiCollaborazione()) || "EGOV_IT_ServizioAsincronoAsimmetrico".equals(busta.getProfiloDiCollaborazione()))) {
                    throw new EJBUtilsConsegnaException(this.msgDiag, "consegnaContenutiApplicativi.", "gestioneProfiloAsincrono.servizioNonUtilizzabile");
                }
                if ("AsincronoAsimmetrico_Polling".equals(richiestaApplicativa.getScenario())) {
                    throw new EJBUtilsConsegnaException("(Polling AsincronoAsimmetrico) " + this.msgDiag.getMessaggio_replaceKeywords("consegnaContenutiApplicativi.", "tramissioneSincrona.servizioNonUtilizzabile"), this.msgDiag.getLivello("consegnaContenutiApplicativi.", "tramissioneSincrona.servizioNonUtilizzabile"), this.msgDiag.getCodice("consegnaContenutiApplicativi.", "tramissioneSincrona.servizioNonUtilizzabile"));
                }
                if (this.openSPCoopState instanceof OpenSPCoopStateless && !this.oneWayVersione11) {
                    this.gestioneStatelessConIntegrationManager = true;
                    if (!registrazioneMessaggioPerStatelessEffettuata) {
                        gestoreMessaggi.registraInformazioniMessaggio_statelessEngine(gestoreMessaggi.getOraRegistrazioneMessaggio(), "ConsegnaContenutiApplicativi", busta.getRiferimentoMessaggio(), richiestaApplicativa.getIdCorrelazioneApplicativa(), this.pddContext);
                        gestoreMessaggi.registraMessaggio_statelessEngine(((OpenSPCoopStateless)this.openSPCoopState).getRichiestaMsg());
                        String key = "INSERT RegistrazioneBustaForHistoryINBOX_" + busta.getID();
                        if (repositoryEGov.isRegistrataIntoInBox(busta.getID())) {
                            repositoryEGov.aggiornaBustaIntoInBox(busta, -1L);
                        } else if (((StateMessage)this.openSPCoopState.getStatoRichiesta()).getPreparedStatement().containsKey(key)) {
                            repositoryEGov.aggiornaBustaIntoInBox(busta, -1L);
                        } else {
                            repositoryEGov.registraBustaIntoInBox(busta, -1L);
                        }
                        registrazioneMessaggioPerStatelessEffettuata = true;
                    }
                    gestoreMessaggi.setOneWayVersione11(true);
                    gestoreMessaggi.registraDestinatarioMessaggio(serviziApplicativi[i], sbustamento_soap, getMessageAbilitato, tipoConsegna, oraRegistrazioneMessaggio);
                    gestoreMessaggi.setOneWayVersione11(false);
                }
                this.msgDiag.logPersonalizzato("consegnaContenutiApplicativi.", "integrationManager.messaggioDisponibile");
            }
        }
        catch (EJBUtilsConsegnaException e) {
            throw e;
        }
        catch (Exception e) {
            this.log.error((Object)"Spedizione->ConsegnaContenutiApplicativi(RichiestaApplicativa) non riuscita", (Throwable)e);
            this.log.error((Object)"EJBUtils.sendToConsegnaContenutiApplicativi(RichiestaApplicativa)", (Throwable)e);
            this.msgDiag.logErroreGenerico(e, "EJBUtils.sendToConsegnaContenutiApplicativi(RichiestaApplicativa)");
            throw new EJBUtilsException("EJBUtils.sendToConsegnaContenutiApplicativi error: " + e.getMessage(), e);
        }
    }

    public void sendRispostaSPCoopErroreProcessamento(String idModuloInAttesa, Busta busta, String codiceErrore, String motivoErrore, String idCorrelazioneApplicativa, String servizioApplicativoFruitore, Exception eProcessamento) throws EJBUtilsException, EGovException {
        Eccezione ecc = new Eccezione("EGOV_IT_300", motivoErrore, false, this.idModulo);
        Vector<Eccezione> errs = new Vector<Eccezione>();
        errs.add(ecc);
        this.sendRispostaSPCoopErroreProcessamento(idModuloInAttesa, busta, errs, idCorrelazioneApplicativa, servizioApplicativoFruitore, eProcessamento);
    }

    public void sendRispostaSPCoopErroreProcessamento(String idModuloInAttesa, Busta busta, Vector<Eccezione> errs, String idCorrelazioneApplicativa, String servizioApplicativoFruitore, Exception eProcessamento) throws EJBUtilsException, EGovException {
        Message axisMsg;
        Imbustamento imbustatore = new Imbustamento();
        String id_eGovErrore = imbustatore.buildID_eGov(this.identitaPdD.getCodicePorta(), this.identitaPdD.getNome());
        busta = imbustatore.buildSPCoopErrore_Processamento(errs, busta, id_eGovErrore, this.propertiesReader.getTipoTempoEGov(this.implementazionePdDSoggettoMittente));
        DettaglioEccezione dettaglioEccezione = null;
        if (Configurazione.getConfigurazioneGenerazioneBusta().isGenerazioneBustaSPCoopErroreProcessamentoWithDetails()) {
            dettaglioEccezione = imbustatore.buildDettaglioEccezioneFromBusta(this.identitaPdD, this.idModulo, this.servizioApplicativoErogatore, busta, eProcessamento);
        }
        imbustatore.gestioneListaEccezioniMessaggioSPCoopErroreProcessamento(busta);
        if (!this.identitaPdD.getNome().equals(busta.getMittente()) || !this.identitaPdD.getTipo().equals(busta.getTipoMittente())) {
            busta.setMittente(this.identitaPdD.getNome());
            busta.setTipoMittente(this.identitaPdD.getTipo());
            busta.setIndirizzoTelematicoMittente(null);
        }
        if ((axisMsg = imbustatore.buildAxisMsgSPCoopErrore_Processamento(dettaglioEccezione)) == null) {
            throw new EJBUtilsException("EJBUtils.sendRispostaSPCoopErroreProcessamento error: Costruzione AxisMsg SPCoopErrore fallita.");
        }
        this.sendRispostaSPCoopErrore(idModuloInAttesa, busta, axisMsg, false, idCorrelazioneApplicativa, servizioApplicativoFruitore);
    }

    public void sendRispostaSPCoopErroreValidazione(String idModuloInAttesa, Busta busta, Eccezione eccezione, String idCorrelazioneApplicativa, String servizioApplicativoFruitore) throws EJBUtilsException, EGovException {
        Vector<Eccezione> v = new Vector<Eccezione>();
        v.add(eccezione);
        this.sendRispostaSPCoopErroreValidazione(idModuloInAttesa, busta, v, idCorrelazioneApplicativa, servizioApplicativoFruitore);
    }

    public void sendRispostaSPCoopErroreValidazione(String idModuloInAttesa, Busta busta, Vector<Eccezione> eccezioni, String idCorrelazioneApplicativa, String servizioApplicativoFruitore) throws EJBUtilsException, EGovException {
        Message axisMsg;
        Imbustamento imbustatore = new Imbustamento();
        String id_eGovErrore = imbustatore.buildID_eGov(this.identitaPdD.getCodicePorta(), this.identitaPdD.getNome());
        busta = imbustatore.buildSPCoopErrore_Validazione(eccezioni, busta, id_eGovErrore, this.propertiesReader.getTipoTempoEGov(this.implementazionePdDSoggettoMittente));
        if (!this.identitaPdD.getNome().equals(busta.getMittente()) || !this.identitaPdD.getTipo().equals(busta.getTipoMittente())) {
            busta.setMittente(this.identitaPdD.getNome());
            busta.setTipoMittente(this.identitaPdD.getTipo());
            busta.setIndirizzoTelematicoMittente(null);
        }
        if ((axisMsg = imbustatore.buildAxisMsgSPCoopErrore_Validazione()) == null) {
            throw new EJBUtilsException("EJBUtils.sendRispostaSPCoopErroreValidazione error: Costruzione AxisMsg SPCoopErrore fallita.");
        }
        this.sendRispostaSPCoopErrore(idModuloInAttesa, busta, axisMsg, false, idCorrelazioneApplicativa, servizioApplicativoFruitore);
    }

    public void sendRispostaSPCoopErrore_inoltroSegnalazioneErrore(Busta busta, Vector<Eccezione> eccezioni) throws EJBUtilsException, EGovException {
        Imbustamento imbustatore = new Imbustamento();
        String id_eGovErrore = imbustatore.buildID_eGov(this.identitaPdD.getCodicePorta(), this.identitaPdD.getNome());
        busta = imbustatore.buildSPCoopErrore_Validazione(eccezioni, busta, id_eGovErrore, this.propertiesReader.getTipoTempoEGov(this.implementazionePdDSoggettoDestinatario));
        Message axisMsg = imbustatore.buildAxisMsgSPCoopErrore_Validazione();
        if (axisMsg == null) {
            throw new EJBUtilsException("EJBUtils.sendRispostaSPCoopErrore_BustaRispostaMalformata error: Costruzione AxisMsg SPCoopErrore fallita.");
        }
        this.sendRispostaSPCoopErrore(null, busta, axisMsg, true, null, null);
    }

    private void sendRispostaSPCoopErrore(String idModuloInAttesa, Busta busta, Message axisMsg, boolean segnalazioneBustaRispostaMalformata, String idCorrelazioneApplicativa, String servizioApplicativoFruitore) throws EJBUtilsException {
        StateMessage statoRichiesta = (StateMessage)this.openSPCoopState.getStatoRichiesta();
        StateMessage statoRisposta = (StateMessage)this.openSPCoopState.getStatoRisposta();
        RollbackRepositoryEGov rollbackEGov = null;
        RepositoryEGov repositoryEGov = null;
        GestoreMessaggi msgRequest = null;
        GestoreMessaggi msgResponse = null;
        this.setEJBSuffixFunctionName();
        try {
            boolean addIntoCache = false;
            if (this.rollbackRichiestaInCasoErrore) {
                rollbackEGov = new RollbackRepositoryEGov(this.idEGovSessione, (IState)statoRichiesta, this.oneWayVersione11);
                if (this.routing) {
                    rollbackEGov.rollbackBustaIntoOutBox(this.rollbackRichiestaInCasoErrore_rollbackHistory);
                } else {
                    rollbackEGov.rollbackBustaIntoInBox(this.rollbackRichiestaInCasoErrore_rollbackHistory);
                }
                if (!segnalazioneBustaRispostaMalformata && this.idEGovMessage != null) {
                    msgRequest = new GestoreMessaggi(this.openSPCoopState, true, this.idEGovMessage, this.tipo, this.msgDiag);
                    msgRequest.setOneWayVersione11(this.oneWayVersione11);
                    if (msgRequest.existsMessage_noCache()) {
                        msgRequest.aggiornaProprietarioMessaggio("GestoreMessaggi");
                        addIntoCache = true;
                    } else {
                        addIntoCache = false;
                    }
                }
            } else {
                msgRequest = new GestoreMessaggi(this.openSPCoopState, true, this.idEGovMessage, this.tipo, this.msgDiag);
                addIntoCache = false;
            }
            boolean httpReply = true;
            if (this.replyOnNewConnection) {
                httpReply = false;
            }
            if (busta.getIndirizzoTelematicoDestinatario() != null && this.utilizzoIndirizzoTelematico) {
                httpReply = false;
            }
            if (segnalazioneBustaRispostaMalformata) {
                httpReply = false;
            }
            if (!httpReply || idModuloInAttesa != null) {
                boolean salvaSuDatabasePerStateless = false;
                if (!httpReply) {
                    salvaSuDatabasePerStateless = true;
                }
                repositoryEGov = new RepositoryEGov((IState)statoRisposta, salvaSuDatabasePerStateless);
                repositoryEGov.registraBustaIntoOutBox(busta, this.propertiesReader.getRepositoryIntervalloScadenzaMessaggi());
                Integrazione infoIntegrazione = new Integrazione();
                infoIntegrazione.setIdModuloInAttesa(idModuloInAttesa);
                infoIntegrazione.setScenario(this.scenarioCooperazione);
                repositoryEGov.aggiornaInfoIntegrazioneIntoOutBox(busta.getID(), infoIntegrazione);
                msgResponse = new GestoreMessaggi(this.openSPCoopState, salvaSuDatabasePerStateless, busta.getID(), "OUTBOX", this.msgDiag);
                if (!httpReply) {
                    msgResponse.setOneWayVersione11(this.oneWayVersione11);
                }
                if (this.openSPCoopState instanceof OpenSPCoopStateless) {
                    msgResponse.registraMessaggio(axisMsg, ((OpenSPCoopStateless)this.openSPCoopState).getTempiAttraversamentoPDD().getRicezioneMsgIngresso(), idCorrelazioneApplicativa, this.pddContext);
                } else {
                    msgResponse.registraMessaggio(axisMsg, idCorrelazioneApplicativa, this.pddContext);
                }
                msgResponse.aggiornaRiferimentoMessaggio(this.idEGovSessione);
                if (!httpReply) {
                    msgResponse.aggiornaProprietarioMessaggio("InoltroRisposteEGov");
                } else if (idModuloInAttesa != null) {
                    msgResponse.aggiornaProprietarioMessaggio(idModuloInAttesa);
                }
                if (!httpReply) {
                    this.sendToInoltroRisposteEGov(busta, segnalazioneBustaRispostaMalformata, null, msgResponse, idCorrelazioneApplicativa, servizioApplicativoFruitore, true);
                } else if (idModuloInAttesa != null) {
                    this.sendBustaToRicezioneBusteEGov(idModuloInAttesa, busta, null);
                }
            }
            this.openSPCoopState.commit();
            if (msgResponse != null) {
                msgResponse.addMessaggiIntoCache_readFromTable(this.idModulo, "sendRispostaSPCoopErrore [risposta]");
            }
            if (addIntoCache) {
                String idEgovRichiestaCorrelata = null;
                if (!this.idEGovMessage.equals(this.idEGovSessione)) {
                    idEgovRichiestaCorrelata = this.idEGovSessione;
                }
                msgRequest.addProprietariIntoCache_readFromTable(this.idModulo, "sendRispostaSPCoopErrore [richiesta]", idEgovRichiestaCorrelata, this.functionAsRouter);
            }
            if (msgResponse != null) {
                msgResponse.addProprietariIntoCache_readFromTable(this.idModulo, "sendRispostaSPCoopErrore [risposta]", this.idEGovSessione, this.functionAsRouter);
            }
        }
        catch (Exception e) {
            this.msgDiag.logErroreGenerico(e, "EJBUtils.sendRispostaSPCoopErrore");
            statoRichiesta.closePreparedStatement();
            statoRisposta.closePreparedStatement();
            throw new EJBUtilsException("EJBUtils.sendRispostaSPCoopErrore error: " + e.getMessage(), e);
        }
        finally {
            this.unsetEJBSuffixFunctionName();
        }
    }

    public GestoreMessaggi sendSbloccoRicezioneBusteEGov(String idModuloInAttesa) throws EJBUtilsException, EGovException {
        Imbustamento imbustatore = new Imbustamento();
        String idSblocco = imbustatore.buildID_eGov(this.identitaPdD.getCodicePorta(), this.identitaPdD.getNome());
        return this.sendRispostaSPCoop(idModuloInAttesa, null, SoapUtils.build_Soap_Empty(), idSblocco, null, null, null);
    }

    public GestoreMessaggi sendSOAPFault(String idModuloInAttesa, Message axisMsg) throws EJBUtilsException, EGovException {
        Imbustamento imbustatore = new Imbustamento();
        String idSblocco = imbustatore.buildID_eGov(this.identitaPdD.getCodicePorta(), this.identitaPdD.getNome());
        return this.sendRispostaSPCoop(idModuloInAttesa, null, axisMsg, idSblocco, null, null, null);
    }

    public GestoreMessaggi buildAndSendRispostaSPCoop(String idModuloInAttesa, Busta busta, Message axisMsg, String profiloGestione, String idCorrelazioneApplicativa, String servizioApplicativoFruitore) throws EJBUtilsException, EGovException {
        Imbustamento imbustatore = new Imbustamento();
        String id_eGov = imbustatore.buildID_eGov(this.identitaPdD.getCodicePorta(), this.identitaPdD.getNome());
        busta.setID(id_eGov);
        return this.sendRispostaSPCoop(idModuloInAttesa, busta, axisMsg, null, profiloGestione, idCorrelazioneApplicativa, servizioApplicativoFruitore);
    }

    public GestoreMessaggi sendRispostaSPCoop(String idModuloInAttesa, Busta busta, String profiloGestione, String idCorrelazioneApplicativa, String servizioApplicativoFruitore) throws EJBUtilsException {
        return this.sendRispostaSPCoop(idModuloInAttesa, busta, null, null, profiloGestione, idCorrelazioneApplicativa, servizioApplicativoFruitore);
    }

    private GestoreMessaggi sendRispostaSPCoop(String idModuloInAttesa, Busta busta, Message axisMsg, String idSbloccoModulo, String profiloGestione, String idCorrelazioneApplicativa, String servizioApplicativoFruitore) throws EJBUtilsException {
        IState statoRisposta = this.openSPCoopState.getStatoRisposta();
        GestoreMessaggi msgResponse = null;
        this.setEJBSuffixFunctionName();
        try {
            boolean httpReply = true;
            if (idSbloccoModulo == null) {
                if (this.replyOnNewConnection) {
                    httpReply = false;
                }
                if (busta != null && busta.getIndirizzoTelematicoDestinatario() != null && this.utilizzoIndirizzoTelematico) {
                    httpReply = false;
                }
            }
            if (!httpReply || idModuloInAttesa != null) {
                boolean salvaSuDatabasePerStateless = false;
                if (!httpReply && !this.functionAsRouter && this.openSPCoopState instanceof OpenSPCoopStateless) {
                    salvaSuDatabasePerStateless = true;
                }
                if (busta != null) {
                    RepositoryEGov repositoryRisposta = new RepositoryEGov(statoRisposta, this.log, salvaSuDatabasePerStateless);
                    repositoryRisposta.registraBustaIntoOutBox(busta, this.propertiesReader.getRepositoryIntervalloScadenzaMessaggi());
                    Integrazione infoIntegrazione = new Integrazione();
                    infoIntegrazione.setIdModuloInAttesa(idModuloInAttesa);
                    infoIntegrazione.setScenario(this.scenarioCooperazione);
                    repositoryRisposta.aggiornaInfoIntegrazioneIntoOutBox(busta.getID(), infoIntegrazione);
                }
                String idRisposta = null;
                idRisposta = busta != null ? busta.getID() : idSbloccoModulo;
                msgResponse = new GestoreMessaggi(this.openSPCoopState, salvaSuDatabasePerStateless, idRisposta, "OUTBOX", this.msgDiag);
                if (!httpReply) {
                    msgResponse.setOneWayVersione11(this.oneWayVersione11);
                }
                if (axisMsg != null) {
                    if (this.openSPCoopState instanceof OpenSPCoopStateless) {
                        msgResponse.registraMessaggio(axisMsg, ((OpenSPCoopStateless)this.openSPCoopState).getTempiAttraversamentoPDD().getRicezioneMsgIngresso(), idCorrelazioneApplicativa, this.pddContext);
                    } else {
                        msgResponse.registraMessaggio(axisMsg, idCorrelazioneApplicativa, this.pddContext);
                    }
                }
                msgResponse.aggiornaRiferimentoMessaggio(this.idEGovSessione);
                if (!httpReply) {
                    msgResponse.aggiornaProprietarioMessaggio("InoltroRisposteEGov");
                } else if (idModuloInAttesa != null) {
                    msgResponse.aggiornaProprietarioMessaggio(idModuloInAttesa);
                }
                if (!httpReply) {
                    this.sendToInoltroRisposteEGov(busta, false, profiloGestione, msgResponse, idCorrelazioneApplicativa, servizioApplicativoFruitore, true);
                } else if (idModuloInAttesa != null) {
                    this.sendBustaToRicezioneBusteEGov(idModuloInAttesa, busta, idSbloccoModulo);
                }
            }
            GestoreMessaggi gestoreMessaggi = msgResponse;
            return gestoreMessaggi;
        }
        catch (Exception e) {
            this.msgDiag.logErroreGenerico(e, "EJBUtils.sendRispostaSPCoop");
            if (msgResponse != null) {
                ((StateMessage)statoRisposta).closePreparedStatement();
            }
            throw new EJBUtilsException("EJBUtils.sendRispostaSPCoop error: " + e.getMessage(), e);
        }
        finally {
            this.unsetEJBSuffixFunctionName();
        }
    }

    public void sendToInoltroRisposteEGov(Busta busta, boolean inoltroSegnalazioneErrore, String profiloGestione, GestoreMessaggi gm, String idCorrelazioneApplicativa, String servizioApplicativoFruitore, boolean imbustamentoEGov) throws EJBUtilsException {
        if (this.openSPCoopState instanceof OpenSPCoopStateful || this.oneWayVersione11) {
            try {
                this.msgDiag.highDebug("[EJBUtils] Creazione ObjectMessage for send nell'infrastruttura.");
                InoltroRisposteEGovMessage inoltroMSG = new InoltroRisposteEGovMessage();
                inoltroMSG.setDominio(this.identitaPdD);
                inoltroMSG.setInoltroSegnalazioneErrore(inoltroSegnalazioneErrore);
                inoltroMSG.setBustaRisposta(busta);
                inoltroMSG.setProfiloGestione(profiloGestione);
                inoltroMSG.setOneWayVersione11(this.oneWayVersione11);
                inoltroMSG.setIdCorrelazioneApplicativa(idCorrelazioneApplicativa);
                inoltroMSG.setServizioApplicativoFruitore(servizioApplicativoFruitore);
                inoltroMSG.setImbustamentoEGov(imbustamentoEGov);
                inoltroMSG.setImplementazionePdDSoggettoMittente(this.implementazionePdDSoggettoMittente);
                inoltroMSG.setImplementazionePdDSoggettoDestinatario(this.implementazionePdDSoggettoDestinatario);
                inoltroMSG.setPddContext(this.pddContext);
                if (this.oneWayVersione11) {
                    OpenSPCoopStateless statelessSerializzabile = ((OpenSPCoopStateless)this.openSPCoopState).rendiSerializzabile();
                    inoltroMSG.setOpenspcoopstate(statelessSerializzabile);
                }
                nodeSender.send(inoltroMSG, "InoltroRisposteEGov", this.msgDiag, this.identitaPdD.getCodicePorta(), this.idModulo, this.idEGovSessione, gm);
            }
            catch (Exception e) {
                this.log.error((Object)"Spedizione->InoltroRisposteEGov non riuscita", (Throwable)e);
                this.msgDiag.logErroreGenerico(e, "EJBUtils.sendToInoltroRisposteEGov");
                throw new EJBUtilsException("EJBUtils.sendToInoltroRisposteEGov error: " + e.getMessage(), e);
            }
        }
    }

    public void sendBustaToRicezioneBusteEGov(String idModuloInAttesa, Busta busta, String idSbloccoModulo) throws EJBUtilsException {
        RicezioneBusteEGovMessage ricezioneMSG;
        if (this.openSPCoopState instanceof OpenSPCoopStateless) {
            ricezioneMSG = new RicezioneBusteEGovMessage();
            ricezioneMSG.setBustaRisposta(busta);
            ricezioneMSG.setIdMessaggioSblocco(idSbloccoModulo);
            ricezioneMSG.setPddContext(this.pddContext);
            ((OpenSPCoopStateless)this.openSPCoopState).setMessageLib(ricezioneMSG);
        }
        if ("jms".equals(this.propertiesReader.getNodeReceiver())) {
            try {
                this.msgDiag.highDebug("Creazione ObjectMessage for send via JMS.");
                ricezioneMSG = new RicezioneBusteEGovMessage();
                ricezioneMSG.setBustaRisposta(busta);
                ricezioneMSG.setIdMessaggioSblocco(idSbloccoModulo);
                ricezioneMSG.setPddContext(this.pddContext);
                if (this.openSPCoopState instanceof OpenSPCoopStateless) {
                    ((OpenSPCoopStateless)this.openSPCoopState).setMessageLib(ricezioneMSG);
                } else {
                    JMSSender senderJMS = new JMSSender(this.identitaPdD.getCodicePorta(), this.idModulo, this.log);
                    Properties prop = new Properties();
                    prop.put("ID", this.idEGovSessione);
                    if (!senderJMS.send(idModuloInAttesa, (Serializable)ricezioneMSG, prop)) {
                        this.msgDiag.logErroreGenerico(senderJMS.getErrore(), "EJBUtils.sendBustaToRicezioneBusteEGov.senderJMS");
                        throw new Exception("SendJMSError: " + senderJMS.getErrore());
                    }
                    this.msgDiag.highDebug("ObjectMessage send via JMS.");
                }
            }
            catch (Exception e) {
                this.msgDiag.logErroreGenerico(e, "EJBUtils.sendBustaToRicezioneBusteEGov");
                throw new EJBUtilsException("EJBUtils.sendToRicezioneBusteEGov error: " + e.getMessage(), e);
            }
        }
    }

    public void setScenarioCooperazione(String scenarioCooperazione) {
        this.scenarioCooperazione = scenarioCooperazione;
    }

    public Timestamp getRicezioneMsgRisposta() {
        return this.ricezioneMsgRisposta;
    }

    public void setRicezioneMsgRisposta(Timestamp ricezioneMsgRisposta) {
        this.ricezioneMsgRisposta = ricezioneMsgRisposta;
    }

    public Timestamp getSpedizioneMsgIngresso() {
        return this.spedizioneMsgIngresso;
    }

    public void setSpedizioneMsgIngresso(Timestamp spedizioneMsgIngresso) {
        this.spedizioneMsgIngresso = spedizioneMsgIngresso;
    }

    public Long getDimensioneRichiestaInviataBytes() {
        return this.dimensioneRichiestaInviataBytes;
    }

    public void setDimensioneRichiestaInviataBytes(Long dimensioneRichiestaInviataBytes) {
        this.dimensioneRichiestaInviataBytes = dimensioneRichiestaInviataBytes;
    }

    public Long getDimensioneRispostaRicevutaBytes() {
        return this.dimensioneRispostaRicevutaBytes;
    }

    public void setDimensioneRispostaRicevutaBytes(Long dimensioneRispostaRicevutaBytes) {
        this.dimensioneRispostaRicevutaBytes = dimensioneRispostaRicevutaBytes;
    }

    public boolean saveMessageStateless(PortaDelegata pd) throws Exception {
        String profiloCollaborazione = EJBUtils.calcolaProfiloCollaborazione(this.scenarioCooperazione);
        return this.configurazionePdDReader.isModalitaStateless(pd, profiloCollaborazione);
    }

    public void setOneWayVersione11(boolean oneWay11) {
        this.oneWayVersione11 = oneWay11;
    }

    public void setPortaDiTipoStateless_esclusoOneWay11(boolean stateless) {
        this.portaDiTipoStateless_esclusoOneWay11 = stateless;
    }

    public void setRouting(boolean routing) {
        this.routing = routing;
    }

    public void setRollbackRichiestaInCasoErrore(boolean rollbackRichiestaInCasoErrore) {
        this.rollbackRichiestaInCasoErrore = rollbackRichiestaInCasoErrore;
    }

    public void setRollbackRichiestaInCasoErrore_rollbackHistory(boolean rollbackRichiestaInCasoErrore_rollbackHistory) {
        this.rollbackRichiestaInCasoErrore_rollbackHistory = rollbackRichiestaInCasoErrore_rollbackHistory;
    }

    public static String calcolaProfiloCollaborazione(String scenarioCooperazione) {
        String profiloCollaborazione = null;
        if ("OneWay_InvocazioneServizio".equals(scenarioCooperazione)) {
            profiloCollaborazione = "EGOV_IT_MessaggioSingoloOneWay";
        } else if ("Sincrono_InvocazioneServizio".equals(scenarioCooperazione)) {
            profiloCollaborazione = "EGOV_IT_ServizioSincrono";
        } else if ("AsincronoAsimmetrico_Polling".equals(scenarioCooperazione) || "AsincronoAsimmetrico_InvocazioneServizio".equals(scenarioCooperazione)) {
            profiloCollaborazione = "EGOV_IT_ServizioAsincronoAsimmetrico";
        } else if ("AsincronoSimmetrico_InvocazioneServizio".equals(scenarioCooperazione) || "AsincronoSimmetrico_ConsegnaRisposta".equals(scenarioCooperazione)) {
            profiloCollaborazione = "EGOV_IT_ServizioAsincronoSimmetrico";
        }
        return profiloCollaborazione;
    }

    public String getServizioApplicativoErogatore() {
        return this.servizioApplicativoErogatore;
    }

    public void setServizioApplicativoErogatore(String servizioApplicativoErogatore) {
        this.servizioApplicativoErogatore = servizioApplicativoErogatore;
    }
}

