/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop.pdd.config;

import java.io.Serializable;
import java.util.Hashtable;
import java.util.Properties;
import javax.jms.Connection;
import javax.jms.ConnectionFactory;
import javax.jms.Queue;
import javax.jms.Session;
import org.openspcoop.dao.commons.DriverException;
import org.openspcoop.dao.commons.IMonitoraggioRisorsa;
import org.openspcoop.pdd.config.JMSObject;
import org.openspcoop.pdd.config.OpenSPCoopConfigurationException;
import org.openspcoop.pdd.config.OpenSPCoopProperties;
import org.openspcoop.pdd.config.Resource;
import org.openspcoop.pdd.logger.MsgDiagnostico;
import org.openspcoop.utils.GestoreJNDI;
import org.openspcoop.utils.date.DateManager;

public class QueueManager
implements Serializable,
IMonitoraggioRisorsa {
    private static final long serialVersionUID = 2542909452367582138L;
    public static Queue QUEUE_RICEZIONE_CONTENUTI_APPLICATIVI;
    public static Queue QUEUE_RICEZIONE_BUSTE_EGOV;
    public static Queue QUEUE_IMBUSTAMENTO;
    public static Queue QUEUE_IMBUSTAMENTO_RISPOSTE;
    public static Queue QUEUE_SBUSTAMENTO;
    public static Queue QUEUE_SBUSTAMENTO_RISPOSTE;
    public static Queue QUEUE_INOLTRO_BUSTE_EGOV;
    public static Queue QUEUE_INOLTRO_RISPOSTE_EGOV;
    public static Queue QUEUE_CONSEGNA_CONTENUTI_APPLICATIVI;
    private static OpenSPCoopProperties openspcoopProperties;
    protected static Hashtable<String, Resource> risorseInGestione;
    private static QueueManager manager;
    private ConnectionFactory qcf = null;
    private MsgDiagnostico msgDiag = new MsgDiagnostico("WrapperQueueManager");

    public static String[] getStatoRisorse() throws Exception {
        Resource[] o = risorseInGestione.values().toArray(new Resource[0]);
        if (o == null) {
            return null;
        }
        Resource[] resources = o;
        if (resources == null || resources.length <= 0) {
            return null;
        }
        String[] r = new String[resources.length];
        for (int i = 0; i < resources.length; ++i) {
            Resource rr = resources[i];
            r[i] = rr.getIdentificativoPorta() + "." + rr.getModuloFunzionale() + " (" + rr.getDate().toString() + ")";
        }
        return r;
    }

    public static void initialize(String jndiName, Properties contextFactory) throws Exception {
        manager = new QueueManager(jndiName, contextFactory);
    }

    public static void initializeQueueNodeReceiver(Properties contextQueue) throws Exception {
        Hashtable<String, String> nomiJndi = OpenSPCoopProperties.getInstance().getJNDIQueueName(true, false);
        GestoreJNDI jndiQueue = new GestoreJNDI(contextQueue);
        QUEUE_RICEZIONE_CONTENUTI_APPLICATIVI = (Queue)jndiQueue.lookup(nomiJndi.get("RicezioneContenutiApplicativi"));
        QUEUE_RICEZIONE_BUSTE_EGOV = (Queue)jndiQueue.lookup(nomiJndi.get("RicezioneBusteEGov"));
    }

    public static void initializeQueueNodeSender(Properties contextQueue) throws Exception {
        Hashtable<String, String> nomiJndi = OpenSPCoopProperties.getInstance().getJNDIQueueName(false, true);
        GestoreJNDI jndiQueue = new GestoreJNDI(contextQueue);
        QUEUE_IMBUSTAMENTO = (Queue)jndiQueue.lookup(nomiJndi.get("Imbustamento"));
        QUEUE_IMBUSTAMENTO_RISPOSTE = (Queue)jndiQueue.lookup(nomiJndi.get("ImbustamentoRisposte"));
        QUEUE_SBUSTAMENTO = (Queue)jndiQueue.lookup(nomiJndi.get("Sbustamento"));
        QUEUE_SBUSTAMENTO_RISPOSTE = (Queue)jndiQueue.lookup(nomiJndi.get("SbustamentoRisposte"));
        QUEUE_INOLTRO_BUSTE_EGOV = (Queue)jndiQueue.lookup(nomiJndi.get("InoltroBusteEGov"));
        QUEUE_INOLTRO_RISPOSTE_EGOV = (Queue)jndiQueue.lookup(nomiJndi.get("InoltroRisposteEGov"));
        QUEUE_CONSEGNA_CONTENUTI_APPLICATIVI = (Queue)jndiQueue.lookup(nomiJndi.get("ConsegnaContenutiApplicativi"));
    }

    public static QueueManager getInstance() {
        return manager;
    }

    public Queue getQueue(String idNodo) throws Exception {
        if (idNodo.startsWith("RicezioneContenutiApplicativi")) {
            return QUEUE_RICEZIONE_CONTENUTI_APPLICATIVI;
        }
        if (idNodo.startsWith("RicezioneBusteEGov")) {
            return QUEUE_RICEZIONE_BUSTE_EGOV;
        }
        if ("Imbustamento".equals(idNodo)) {
            return QUEUE_IMBUSTAMENTO;
        }
        if ("ImbustamentoRisposte".equals(idNodo)) {
            return QUEUE_IMBUSTAMENTO_RISPOSTE;
        }
        if ("Sbustamento".equals(idNodo)) {
            return QUEUE_SBUSTAMENTO;
        }
        if ("SbustamentoRisposte".equals(idNodo)) {
            return QUEUE_SBUSTAMENTO_RISPOSTE;
        }
        if ("InoltroBusteEGov".equals(idNodo)) {
            return QUEUE_INOLTRO_BUSTE_EGOV;
        }
        if ("InoltroRisposteEGov".equals(idNodo)) {
            return QUEUE_INOLTRO_RISPOSTE_EGOV;
        }
        if ("ConsegnaContenutiApplicativi".equals(idNodo)) {
            return QUEUE_CONSEGNA_CONTENUTI_APPLICATIVI;
        }
        return null;
    }

    public QueueManager(String jndiName, Properties context) throws OpenSPCoopConfigurationException {
        try {
            GestoreJNDI jndi = new GestoreJNDI(context);
            this.qcf = (ConnectionFactory)jndi.lookup(jndiName);
        }
        catch (Exception e) {
            throw new OpenSPCoopConfigurationException("WrapperQueueManager: " + e.getMessage(), e);
        }
    }

    public Resource getResource(String idPDD, String modulo) throws OpenSPCoopConfigurationException {
        Resource risorsa = new Resource();
        try {
            Connection con = this.qcf.createConnection();
            if (con == null) {
                throw new OpenSPCoopConfigurationException("ConnessioneNonDisponibile");
            }
            Session s = con.createSession(false, openspcoopProperties.getAcknowledgeModeSessioneConnectionFactory());
            if (s == null) {
                con.close();
                throw new OpenSPCoopConfigurationException("SessioneNonDisponibile");
            }
            JMSObject jms = new JMSObject();
            jms.setConnection(con);
            jms.setSession(s);
            String idUnivoco = Resource.generaIdentificatoreUnivoco(idPDD, modulo);
            risorsa.setId(idUnivoco);
            risorsa.setDate(DateManager.getDate());
            risorsa.setIdentificativoPorta(idPDD);
            risorsa.setModuloFunzionale(modulo);
            risorsa.setResource(jms);
            risorsa.setResourceType(JMSObject.class.getName());
            risorseInGestione.put(idUnivoco, risorsa);
            return risorsa;
        }
        catch (Exception e) {
            this.msgDiag.aggiornaFiltri();
            this.msgDiag.setDominioSPCoop(idPDD);
            this.msgDiag.setFunzione("QueueManager." + modulo);
            this.msgDiag.logFatalError(e, "Richiesta connessione al QueueManager");
            throw new OpenSPCoopConfigurationException("getJMSObject: " + e.getMessage());
        }
    }

    public void releaseResource(String idPDD, String modulo, Resource resource) throws OpenSPCoopConfigurationException {
        block9: {
            try {
                if (resource == null) break block9;
                if (resource.getResource() != null) {
                    JMSObject jms = (JMSObject)resource.getResource();
                    if (jms == null) {
                        throw new OpenSPCoopConfigurationException("PassivateObject[JMSObjectNull]");
                    }
                    if (jms.getConnection() == null) {
                        throw new OpenSPCoopConfigurationException("PassivateObject[ConnectionNull]");
                    }
                    if (jms.getSession() == null) {
                        throw new OpenSPCoopConfigurationException("PassivateObject[SessionNull]");
                    }
                    try {
                        jms.getSession().close();
                    }
                    catch (Exception e) {
                        jms.getConnection().close();
                        throw e;
                    }
                    jms.getConnection().close();
                }
                if (risorseInGestione.containsKey(resource.getId())) {
                    risorseInGestione.remove(resource.getId());
                }
            }
            catch (Exception e) {
                this.msgDiag.aggiornaFiltri();
                this.msgDiag.setDominioSPCoop(idPDD);
                this.msgDiag.setFunzione("QueueManager." + modulo);
                this.msgDiag.logFatalError(e, "Rilasciata connessione al QueueManager");
                throw new OpenSPCoopConfigurationException("releaseJMSObject: " + e.getMessage());
            }
        }
    }

    public void isAlive() throws DriverException {
        Resource resource = null;
        try {
            resource = this.getResource("QueueManager", "CheckIsAlive");
            if (resource == null) {
                throw new Exception("Resource is null");
            }
            if (resource.getResource() == null) {
                throw new Exception("JMSObject is null");
            }
            JMSObject jmsObject = (JMSObject)resource.getResource();
            if (jmsObject.getConnection() == null) {
                throw new Exception("Connessione is null");
            }
            if (jmsObject.getSession() == null) {
                throw new Exception("Sessione is null");
            }
            Connection connectionJMS = jmsObject.getConnection();
            connectionJMS.getClientID();
        }
        catch (Exception e) {
            throw new DriverException("Connessione al broker JMS non disponibile: " + e.getMessage(), (Throwable)e);
        }
        finally {
            try {
                this.releaseResource("QueueManager", "CheckIsAlive", resource);
            }
            catch (Exception e) {}
        }
    }

    static {
        openspcoopProperties = OpenSPCoopProperties.getInstance();
        risorseInGestione = new Hashtable();
        manager = null;
    }
}

