/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop.pdd.config;

import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;
import org.apache.log4j.Logger;
import org.openspcoop.pdd.config.OpenSPCoopConfigurationException;
import org.openspcoop.pdd.config.PddInstanceProperties;
import org.openspcoop.pdd.logger.OpenSPCoopLogger;
import org.openspcoop.pdd.services.OpenSPCoopStartup;

public class PddProperties {
    private Logger log = OpenSPCoopStartup.initialize ? OpenSPCoopLogger.getLoggerOpenSPCoopCore() : Logger.getLogger((String)"PddProperties");
    private PddInstanceProperties reader;
    private static PddProperties pddProperties = null;

    public PddProperties(String location, String confDir) throws Exception {
        Properties propertiesReader = new Properties();
        InputStream properties = null;
        try {
            properties = location != null ? new FileInputStream(location) : PddProperties.class.getResourceAsStream("/pdd.properties");
            propertiesReader.load(properties);
            properties.close();
        }
        catch (IOException e) {
            this.log.error((Object)("Riscontrato errore durante la lettura del file 'pdd.properties': \n\n" + e.getMessage()));
            try {
                if (properties != null) {
                    properties.close();
                }
            }
            catch (Exception er) {
                // empty catch block
            }
            throw new Exception("PddProperties initialize error: " + e.getMessage());
        }
        this.reader = new PddInstanceProperties(propertiesReader, this.log, confDir);
    }

    public static boolean initialize(String location, String confDir) {
        try {
            pddProperties = new PddProperties(location, confDir);
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    public static PddProperties getInstance() throws OpenSPCoopConfigurationException {
        if (pddProperties == null) {
            throw new OpenSPCoopConfigurationException("PddProperties non inizializzato");
        }
        return pddProperties;
    }

    public static void updateLocalImplementation(Properties prop) {
        PddProperties.pddProperties.reader.setLocalObjectImplementation(prop);
    }

    public String getValidazioneEGov_Stato(String nomePdd) {
        return this.get(nomePdd, ".validazioneEGov.stato");
    }

    public String getValidazioneEGov_Controllo(String nomePdd) {
        return this.get(nomePdd, ".validazioneEGov.controllo");
    }

    public String getValidazioneEGov_ProfiloCollaborazione(String nomePdd) {
        return this.get(nomePdd, ".validazioneEGov.profiloCollaborazione");
    }

    public String getValidazioneEGov_ManifestAttachments(String nomePdd) {
        return this.get(nomePdd, ".validazioneEGov.manifestAttachments");
    }

    public String getValidazioneEGov_FiltroDuplicatiLetturaRegistro(String nomePdd) {
        return this.get(nomePdd, ".validazioneEGov.filtroDuplicati.letturaRegistro");
    }

    public String getValidazioneEGov_ConfermaRicezioneLetturaRegistro(String nomePdd) {
        return this.get(nomePdd, ".validazioneEGov.confermaRicezione.letturaRegistro");
    }

    public String getValidazioneEGov_ConsegnaInOrdineLetturaRegistro(String nomePdd) {
        return this.get(nomePdd, ".validazioneEGov.consegnaInOrdine.letturaRegistro");
    }

    public String getValidazioneEGov_readQualifiedAttribute(String nomePdd) {
        return this.get(nomePdd, ".validazioneEGov.readQualifiedAttribute");
    }

    public String getValidazioneEGov_ValidazioneIDEgovCompleta(String nomePdd) {
        return this.get(nomePdd, ".validazioneEGov.validazioneIDEgovCompleta");
    }

    public String getBustaEGov_TempoTipo(String nomePdd) {
        return this.get(nomePdd, ".bustaEGov.tempo.tipo");
    }

    public String getBustaEGov_AsincroniAttributiCorrelatiEnable(String nomePdd) {
        return this.get(nomePdd, ".bustaEGov.asincroni.attributiCorrelati.enable");
    }

    public String getBustaEGov_CollaborazioneEnable(String nomePdd) {
        return this.get(nomePdd, ".bustaEGov.collaborazione.enable");
    }

    public String getBustaEGov_ConsegnaInOrdineEnable(String nomePdd) {
        return this.get(nomePdd, ".bustaEGov.consegnaInOrdine.enable");
    }

    public String getBustaEGov_TrasmissioneEnable(String nomePdd) {
        return this.get(nomePdd, ".bustaEGov.trasmissione.enable");
    }

    public String getBustaEGov_RiscontriEnable(String nomePdd) {
        return this.get(nomePdd, ".bustaEGov.riscontri.enable");
    }

    public String getBustaEGov_FiltroduplicatiGenerazioneSPCoopErrore(String nomePdd) {
        return this.get(nomePdd, ".bustaEGov.filtroduplicati.generazioneSPCoopErrore");
    }

    public String getBustaEGov_ManifestAttachments_roleRichiesta(String nomePdd) {
        return this.get(nomePdd, ".bustaEGov.manifestAttachments.role.richiesta");
    }

    public String getBustaEGov_ManifestAttachments_roleRisposta(String nomePdd) {
        return this.get(nomePdd, ".bustaEGov.manifestAttachments.role.risposta");
    }

    public String getBustaEGov_ManifestAttachments_roleAllegato(String nomePdd) {
        return this.get(nomePdd, ".bustaEGov.manifestAttachments.role.allegato");
    }

    public String getValidazioneContenutiApplicativi_Stato(String nomePdd) {
        return this.get(nomePdd, ".validazioneContenutiApplicativi.stato");
    }

    public String getValidazioneContenutiApplicativi_Tipo(String nomePdd) {
        return this.get(nomePdd, ".validazioneContenutiApplicativi.tipo");
    }

    public String getWSSecurity_ActorDefaultEnable(String nomePdd) {
        return this.get(nomePdd, ".wssecurity.actorDefault.enable");
    }

    public String getWSSecurity_ActorDefaultValue(String nomePdd) {
        return this.get(nomePdd, ".wssecurity.actorDefault.valore");
    }

    private String get(String nomePdd, String proprieta) {
        try {
            return this.reader.getValue(nomePdd + proprieta);
        }
        catch (Exception e) {
            this.log.error((Object)("Errore durante la lettura della proprieta' '" + nomePdd + proprieta + "': " + e.getMessage()), (Throwable)e);
            return null;
        }
    }
}

