/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop.pdd.config;

import java.io.FileInputStream;
import java.io.IOException;
import java.net.URL;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import java.util.Vector;
import javax.sql.DataSource;
import org.apache.log4j.Logger;
import org.apache.log4j.PropertyConfigurator;
import org.openspcoop.dao.commons.IDSoggetto;
import org.openspcoop.dao.config.PortaApplicativa;
import org.openspcoop.dao.config.PortaDelegata;
import org.openspcoop.dao.config.ServizioApplicativo;
import org.openspcoop.dao.config.SoggettoSpcoop;
import org.openspcoop.dao.config.driver.DriverConfigurazioneDB;
import org.openspcoop.dao.config.driver.IDServizioApplicativo;
import org.openspcoop.dao.registry.AccordoServizio;
import org.openspcoop.dao.registry.AccordoServizioSoggettoReferente;
import org.openspcoop.dao.registry.Fruitore;
import org.openspcoop.dao.registry.ServizioSpcoop;
import org.openspcoop.dao.registry.driver.DriverRegistroServiziDB;
import org.openspcoop.dao.registry.driver.DriverRegistroServiziNotFound;
import org.openspcoop.dao.registry.driver.FiltroServiziSPCoop;
import org.openspcoop.dao.registry.driver.IDAccordo;
import org.openspcoop.dao.registry.driver.IDServizio;
import org.openspcoop.utils.GestoreJNDI;
import org.openspcoop.utils.Loader;
import org.openspcoop.utils.Utilities;
import org.openspcoop.utils.sql.ISQLQueryObject;
import org.openspcoop.utils.sql.SQLObjectFactory;

public class OpenSPCoopDBConfigurationUtility {
    private static final String TIPOLOGIA_ELIMINAZIONE_FRUIZIONE = "fruizione";
    private static final String TIPOLOGIA_ELIMINAZIONE_EROGAZIONE = "erogazione";

    public static void main(String[] args) throws Exception {
        String errorMsg;
        DataSource ds;
        GestoreJNDI gestoreJNDI;
        Properties context;
        String dataSource;
        if (args.length < 4) {
            String errorMsg2 = "ERROR, Usage:  java TestXMLDataConverter proprietaAccessoDatabase tipologiaEliminazione(fruzione/erogazione) servizio(tipo/nome) soggettoErogatoreServizio(tipo/nome o *) fruitore(SOLO se tipologia=fruizione) [Logger]";
            System.err.println(errorMsg2);
            throw new Exception(errorMsg2);
        }
        if (args[0] == null) {
            throw new Exception("Proprieta' per la configurazione dell'accesso al database non fornite");
        }
        String proprietaAccessoDatabase = args[0].trim();
        if (args[1] == null) {
            throw new Exception("Tipo di eliminazione non indicata");
        }
        String tipologiaEliminazione = args[1].trim();
        if (!TIPOLOGIA_ELIMINAZIONE_EROGAZIONE.equals(tipologiaEliminazione) && !TIPOLOGIA_ELIMINAZIONE_FRUIZIONE.equals(tipologiaEliminazione)) {
            throw new Exception("Tipo di eliminazione non gestito");
        }
        if (args[2] == null) {
            throw new Exception("Servizio da eliminare non indicato");
        }
        String tipoNomeServizio = args[2].trim();
        if (!tipoNomeServizio.contains("/")) {
            throw new Exception("Servizio da eliminare non indicato correttamente, atteso: tipo/nome");
        }
        String tipoServizio = null;
        String nomeServizio = null;
        try {
            tipoServizio = tipoNomeServizio.split("/")[0].trim();
            nomeServizio = tipoNomeServizio.split("/")[1].trim();
        }
        catch (Exception e) {
            throw new Exception("Servizio da eliminare non indicato correttamente, atteso: tipo/nome , errore: " + e.getMessage(), e);
        }
        if (args[3] == null) {
            throw new Exception("Soggetto da eliminare non indicato");
        }
        String tipoNomeSoggetto = args[3].trim();
        String tipoSoggettoErogatore = null;
        String nomeSoggettoErogatore = null;
        if (!"*".equals(tipoNomeSoggetto)) {
            if (!tipoNomeSoggetto.contains("/")) {
                throw new Exception("Soggetto erogatore del servizio da eliminare non indicato correttamente, atteso: tipo/nome");
            }
            try {
                tipoSoggettoErogatore = tipoNomeSoggetto.split("/")[0].trim();
                nomeSoggettoErogatore = tipoNomeSoggetto.split("/")[1].trim();
            }
            catch (Exception e) {
                throw new Exception("Soggetto erogatore del servizio da eliminare non indicato correttamente, atteso: tipo/nome , errore: " + e.getMessage(), e);
            }
        }
        int logIndex = 4;
        String tipoSoggettoFruitore = null;
        String nomeSoggettoFruitore = null;
        if (TIPOLOGIA_ELIMINAZIONE_FRUIZIONE.equals(tipologiaEliminazione)) {
            ++logIndex;
            String tipoNomeSoggettoFruitore = args[4].trim();
            if (tipoNomeSoggettoFruitore == null) {
                throw new Exception("Soggetto fruitore da eliminare non indicato");
            }
            if (!tipoNomeSoggettoFruitore.contains("/")) {
                throw new Exception("Soggetto fruitore da eliminare non indicato correttamente, atteso: tipo/nome");
            }
            try {
                tipoSoggettoFruitore = tipoNomeSoggettoFruitore.split("/")[0].trim();
                nomeSoggettoFruitore = tipoNomeSoggettoFruitore.split("/")[1].trim();
            }
            catch (Exception e) {
                throw new Exception("Soggetto fruitore da eliminare non indicato correttamente, atteso: tipo/nome , errore: " + e.getMessage(), e);
            }
        }
        try {
            if (args.length == logIndex + 1) {
                PropertyConfigurator.configure((String)args[logIndex]);
            } else {
                PropertyConfigurator.configure((URL)OpenSPCoopDBConfigurationUtility.class.getResource("/tracer.log4j.properties"));
            }
        }
        catch (Exception e) {
            String errorMsg3 = "Errore durante il caricamento del file di log args" + logIndex + "[" + args[logIndex] + "] : " + e.getMessage();
            System.err.println(errorMsg3);
            throw new Exception(errorMsg3);
        }
        Logger log = Logger.getLogger((String)"gestoreEliminazioneServizio");
        Properties reader = new Properties();
        try {
            reader.load(new FileInputStream(proprietaAccessoDatabase));
        }
        catch (IOException e) {
            String errorMsg4 = "Errore durante il caricamento del file di properties [" + proprietaAccessoDatabase + "] : " + e.getMessage();
            log.error((Object)errorMsg4, (Throwable)e);
            throw new Exception(errorMsg4, e);
        }
        String pddConsole = reader.getProperty("openspcoop.pddConsole");
        String tipoDatabase = null;
        boolean pddConsoleMode = false;
        if (pddConsole != null) {
            pddConsoleMode = Boolean.parseBoolean(pddConsole.trim());
        }
        Connection connectionConfigurazione = null;
        DriverConfigurazioneDB driverConfigurazione = null;
        try {
            String connection = null;
            String username = null;
            String password = null;
            String driver = null;
            boolean condivisioneDBRegservPddValue = false;
            tipoDatabase = reader.getProperty("openspcoop.configurazione.db.tipo");
            if (tipoDatabase == null) {
                throw new Exception("Non e' stato definito il tipo di database per la configurazione");
            }
            tipoDatabase = tipoDatabase.trim();
            String condivisioneDBRegservPdd = reader.getProperty("openspcoop.configurazione.db.condivisioneDBRegserv");
            try {
                condivisioneDBRegservPddValue = Boolean.parseBoolean(condivisioneDBRegservPdd.trim());
            }
            catch (Exception e) {
                throw new Exception("Non e' stato definita o e' definita non correttamente la proprieta' [openspcoop.configurazione.db.condivisioneDBRegserv]: " + e.getMessage());
            }
            dataSource = reader.getProperty("openspcoop.configurazione.db.dataSource");
            if (dataSource != null) {
                dataSource = dataSource.trim();
                context = Utilities.readProperties((String)"openspcoop.configurazione.db.context.", (Properties)reader);
                gestoreJNDI = new GestoreJNDI(context);
                ds = (DataSource)gestoreJNDI.lookup(dataSource);
                connectionConfigurazione = ds.getConnection();
            } else {
                connection = reader.getProperty("openspcoop.configurazione.db.url");
                if (connection == null) {
                    throw new Exception("Non e' stata definita una destinazione ne attraverso un datasource, ne attraverso una connessione diretta");
                }
                connection = connection.trim();
                driver = reader.getProperty("openspcoop.configurazione.db.driver");
                if (driver == null) {
                    throw new Exception("Connessione diretta: non e' stato definito il Driver");
                }
                driver = driver.trim();
                username = reader.getProperty("openspcoop.configurazione.db.user");
                password = reader.getProperty("openspcoop.configurazione.db.password");
                if (username != null) {
                    username = username.trim();
                }
                if (password != null) {
                    password = password.trim();
                }
                Loader.getInstance().newInstance(driver);
                connectionConfigurazione = username != null && password != null ? DriverManager.getConnection(connection, username, password) : DriverManager.getConnection(connection);
            }
            driverConfigurazione = new DriverConfigurazioneDB(connectionConfigurazione, null, tipoDatabase, condivisioneDBRegservPddValue);
        }
        catch (Exception e) {
            String errorMsg5 = "Errore durante la lettura del file di properties [" + args[1] + "] : " + e.getMessage();
            log.error((Object)errorMsg5, (Throwable)e);
            throw new Exception(errorMsg5, e);
        }
        Connection connectionRegistroServizi = null;
        DriverRegistroServiziDB driverRegistroServizi = null;
        try {
            String connection = null;
            String username = null;
            String password = null;
            String driver = null;
            tipoDatabase = reader.getProperty("openspcoop.registroServizi.db.tipo");
            if (tipoDatabase == null) {
                throw new Exception("Non e' stato definito il tipo di database per la configurazione");
            }
            tipoDatabase = tipoDatabase.trim();
            dataSource = reader.getProperty("openspcoop.registroServizi.db.dataSource");
            if (dataSource != null) {
                dataSource = dataSource.trim();
                context = Utilities.readProperties((String)"openspcoop.registroServizi.db.context.", (Properties)reader);
                if (!pddConsoleMode) {
                    gestoreJNDI = new GestoreJNDI(context);
                    ds = (DataSource)gestoreJNDI.lookup(dataSource);
                    connectionRegistroServizi = ds.getConnection();
                }
            } else {
                connection = reader.getProperty("openspcoop.registroServizi.db.url");
                if (connection == null) {
                    throw new Exception("Non e' stata definita una destinazione ne attraverso un datasource, ne attraverso una connessione diretta");
                }
                connection = connection.trim();
                driver = reader.getProperty("openspcoop.registroServizi.db.driver");
                if (driver == null) {
                    throw new Exception("Connessione diretta: non e' stato definito il Driver");
                }
                driver = driver.trim();
                username = reader.getProperty("openspcoop.registroServizi.db.user");
                password = reader.getProperty("openspcoop.registroServizi.db.password");
                if (username != null) {
                    username = username.trim();
                }
                if (password != null) {
                    password = password.trim();
                }
                if (!pddConsoleMode) {
                    Loader.getInstance().newInstance(driver);
                    connectionRegistroServizi = username != null && password != null ? DriverManager.getConnection(connection, username, password) : DriverManager.getConnection(connection);
                }
            }
            driverRegistroServizi = pddConsoleMode ? new DriverRegistroServiziDB(connectionConfigurazione, null, tipoDatabase) : new DriverRegistroServiziDB(connectionRegistroServizi, null, tipoDatabase);
        }
        catch (Exception e) {
            errorMsg = "Errore durante la lettura del file di properties [" + args[1] + "] : " + e.getMessage();
            log.error((Object)errorMsg, (Throwable)e);
            throw new Exception(errorMsg, e);
        }
        try {
            IDServizio idServizio;
            log.debug((Object)"Imposto auto-commit a false");
            connectionConfigurazione.setAutoCommit(false);
            if (!pddConsoleMode) {
                connectionRegistroServizi.setAutoCommit(false);
            } else {
                connectionRegistroServizi = connectionConfigurazione;
            }
            FiltroServiziSPCoop filtroRicercaServizio = new FiltroServiziSPCoop();
            filtroRicercaServizio.setTipo(tipoServizio);
            filtroRicercaServizio.setNome(nomeServizio);
            if (tipoSoggettoErogatore != null && nomeSoggettoErogatore != null) {
                filtroRicercaServizio.setTipoSoggettoErogatore(tipoSoggettoErogatore);
                filtroRicercaServizio.setNomeSoggettoErogatore(nomeSoggettoErogatore);
            }
            Vector<IDServizio> idServizi = new Vector<IDServizio>();
            try {
                idServizio = driverRegistroServizi.getAllIdServizi(filtroRicercaServizio);
                if (idServizio != null) {
                    for (int i = 0; i < ((IDServizio[])idServizio).length; ++i) {
                        idServizi.add(idServizio[i]);
                    }
                }
            }
            catch (DriverRegistroServiziNotFound notFound) {
                log.debug((Object)("Ricerca di servizi SPCoop con filtro [" + filtroRicercaServizio.toString() + "] non ha prodotto risultati: " + notFound.getMessage()));
            }
            try {
                IDServizio[] idServizioCorrelato = driverRegistroServizi.getAllIdServiziCorrelati(filtroRicercaServizio);
                if (idServizioCorrelato != null) {
                    for (int i = 0; i < idServizioCorrelato.length; ++i) {
                        idServizi.add(idServizioCorrelato[i]);
                    }
                }
            }
            catch (DriverRegistroServiziNotFound notFound) {
                log.debug((Object)("Ricerca di servizi SPCoop correlati con filtro [" + filtroRicercaServizio.toString() + "] non ha prodotto risultati: " + notFound.getMessage()));
            }
            log.debug((Object)("Totale servizi da eliminare con tipologia [" + tipologiaEliminazione + "] : " + idServizi.size()));
            while (idServizi.size() != 0) {
                idServizio = (IDServizio)idServizi.remove(0);
                log.debug((Object)("Gestione eliminazione servizio [" + idServizio.toString() + "] ..."));
                ServizioSpcoop servizioSPCoop = driverRegistroServizi.getServizio(idServizio);
                IDSoggetto soggettoErogatore = new IDSoggetto(servizioSPCoop.getTipoSoggettoErogatore(), servizioSPCoop.getNomeSoggettoErogatore());
                log.debug((Object)("\t dati servizio SoggettoErogatore[" + servizioSPCoop.getTipoSoggettoErogatore() + "/" + servizioSPCoop.getNomeSoggettoErogatore() + "] Correlato[" + servizioSPCoop.getServizioCorrelato() + "] ..."));
                if (TIPOLOGIA_ELIMINAZIONE_FRUIZIONE.equals(tipologiaEliminazione)) {
                    String sa;
                    PortaDelegata pd;
                    log.debug((Object)("\t dati Fruitore da eliminare [" + tipoSoggettoFruitore + "/" + nomeSoggettoFruitore + "]"));
                    IDSoggetto soggettoFruitore = new IDSoggetto(tipoSoggettoFruitore, nomeSoggettoFruitore);
                    SoggettoSpcoop soggettoConfig = driverConfigurazione.getSoggetto(soggettoFruitore);
                    if (pddConsoleMode) {
                        log.debug((Object)"\t- eliminazione politiche di sicurezza ...");
                        OpenSPCoopDBConfigurationUtility.deletePoliticheSicurezza(connectionConfigurazione, tipoDatabase, servizioSPCoop.getId(), soggettoConfig.getId());
                        log.debug((Object)"\t- eliminazione politiche di sicurezza effettuata");
                    }
                    log.debug((Object)"\t- eliminazione fruizione dal servizio spcoop ...");
                    for (int i = 0; i < servizioSPCoop.sizeFruitoreList(); ++i) {
                        Fruitore fr = servizioSPCoop.getFruitore(i);
                        if (!fr.getTipo().equals(tipoSoggettoFruitore) || !fr.getNome().equals(nomeSoggettoFruitore)) continue;
                        servizioSPCoop.removeFruitore(i);
                        break;
                    }
                    driverRegistroServizi.updateServizioSpcoop(servizioSPCoop);
                    log.debug((Object)"\t- eliminazione fruizione dal servizio spcoop effettuata");
                    Vector<String> nomiServiziApplicativi = new Vector<String>();
                    List listaPorteDelegate = driverConfigurazione.getPorteDelegateWithServizio(servizioSPCoop.getId(), servizioSPCoop.getTipo(), servizioSPCoop.getNome(), servizioSPCoop.getIdSoggetto(), servizioSPCoop.getTipoSoggettoErogatore(), servizioSPCoop.getNomeSoggettoErogatore());
                    ArrayList<PortaDelegata> listaPorteDelegateFruitoreDaEliminare = new ArrayList<PortaDelegata>();
                    while (listaPorteDelegate.size() > 0) {
                        pd = (PortaDelegata)listaPorteDelegate.remove(0);
                        if (!pd.getTipoSoggettoProprietario().equals(tipoSoggettoFruitore) || !pd.getNomeSoggettoProprietario().equals(nomeSoggettoFruitore)) continue;
                        listaPorteDelegateFruitoreDaEliminare.add(pd);
                    }
                    log.debug((Object)("\t- eliminazione porte delegate (" + listaPorteDelegateFruitoreDaEliminare.size() + ") ..."));
                    while (listaPorteDelegateFruitoreDaEliminare.size() > 0) {
                        pd = (PortaDelegata)listaPorteDelegateFruitoreDaEliminare.remove(0);
                        log.debug((Object)("\t\t. porta delegata (" + pd.getNome() + ") ..."));
                        for (int i = 0; i < pd.sizeServizioApplicativoList(); ++i) {
                            sa = pd.getServizioApplicativo(i).getNome();
                            if (nomiServiziApplicativi.contains(sa)) continue;
                            nomiServiziApplicativi.add(sa);
                        }
                        driverConfigurazione.deletePortaDelegata(pd);
                        log.debug((Object)("\t\t. porta delegata (" + pd.getNome() + ") eliminata"));
                    }
                    log.debug((Object)"\t- eliminazione porte delegate effettuata");
                    log.debug((Object)("\t- eliminazione servizi applicativi (" + nomiServiziApplicativi.size() + ") ..."));
                    while (nomiServiziApplicativi.size() > 0) {
                        String nomeSA = (String)nomiServiziApplicativi.remove(0);
                        log.debug((Object)("\t\t. servizio applicativo (" + nomeSA + ") ..."));
                        IDServizioApplicativo idSA = new IDServizioApplicativo();
                        idSA.setIdSoggettoProprietario(soggettoFruitore);
                        idSA.setNome(nomeSA);
                        sa = driverConfigurazione.getServizioApplicativo(idSA);
                        driverConfigurazione.deleteServizioApplicativo((ServizioApplicativo)sa);
                        log.debug((Object)("\t\t. servizio applicativo (" + nomeSA + ") eliminato"));
                    }
                    log.debug((Object)"\t- eliminazione servizi applicativi effettuata");
                } else {
                    int i;
                    IDServizio[] others;
                    if (pddConsoleMode) {
                        log.debug((Object)("\t- eliminazione politiche di sicurezza (" + servizioSPCoop.sizeFruitoreList() + ") ..."));
                        OpenSPCoopDBConfigurationUtility.deletePoliticheSicurezza(connectionConfigurazione, tipoDatabase, servizioSPCoop.getId(), null);
                        log.debug((Object)"\t- eliminazione politiche di sicurezza effettuata");
                    }
                    Vector<String> nomiServiziApplicativi = new Vector<String>();
                    List listaPorteDelegate = driverConfigurazione.getPorteDelegateWithServizio(servizioSPCoop.getId(), servizioSPCoop.getTipo(), servizioSPCoop.getNome(), servizioSPCoop.getIdSoggetto(), servizioSPCoop.getTipoSoggettoErogatore(), servizioSPCoop.getNomeSoggettoErogatore());
                    log.debug((Object)("\t- eliminazione porte delegate (" + listaPorteDelegate.size() + ") ..."));
                    while (listaPorteDelegate.size() > 0) {
                        PortaDelegata pd = (PortaDelegata)listaPorteDelegate.remove(0);
                        log.debug((Object)("\t\t. porta delegata (" + pd.getNome() + ") ..."));
                        for (int i2 = 0; i2 < pd.sizeServizioApplicativoList(); ++i2) {
                            String sa = pd.getServizioApplicativo(i2).getNome();
                            if (nomiServiziApplicativi.contains(sa)) continue;
                            nomiServiziApplicativi.add(sa);
                        }
                        driverConfigurazione.deletePortaDelegata(pd);
                        log.debug((Object)("\t\t. porta delegata (" + pd.getNome() + ") eliminata"));
                    }
                    log.debug((Object)"\t- eliminazione porte delegate effettuata");
                    List listaPorteApplicative = driverConfigurazione.getPorteApplicativeWithServizio(servizioSPCoop.getId(), servizioSPCoop.getTipo(), servizioSPCoop.getNome(), servizioSPCoop.getIdSoggetto(), servizioSPCoop.getTipoSoggettoErogatore(), servizioSPCoop.getNomeSoggettoErogatore());
                    log.debug((Object)("\t- eliminazione porte applicative (" + listaPorteApplicative.size() + ") ..."));
                    while (listaPorteApplicative.size() > 0) {
                        PortaApplicativa pa = (PortaApplicativa)listaPorteApplicative.remove(0);
                        pa = driverConfigurazione.getPortaApplicativa(pa.getNome(), soggettoErogatore);
                        log.debug((Object)("\t\t. porta applicativa (" + pa.getNome() + ") ..."));
                        for (int i3 = 0; i3 < pa.sizeServizioApplicativoList(); ++i3) {
                            String sa = pa.getServizioApplicativo(i3).getNome();
                            if (nomiServiziApplicativi.contains(sa)) continue;
                            nomiServiziApplicativi.add(sa);
                        }
                        driverConfigurazione.deletePortaApplicativa(pa);
                        log.debug((Object)("\t\t. porta applicativa (" + pa.getNome() + ") eliminata"));
                    }
                    log.debug((Object)"\t- eliminazione porte applicative effettuata");
                    log.debug((Object)("\t- eliminazione servizi applicativi (" + nomiServiziApplicativi.size() + ") ..."));
                    while (nomiServiziApplicativi.size() > 0) {
                        String nomeSA = (String)nomiServiziApplicativi.remove(0);
                        log.debug((Object)("\t\t. servizio applicativo (" + nomeSA + ") ..."));
                        IDServizioApplicativo idSA = new IDServizioApplicativo();
                        idSA.setIdSoggettoProprietario(soggettoErogatore);
                        idSA.setNome(nomeSA);
                        ServizioApplicativo sa = driverConfigurazione.getServizioApplicativo(idSA);
                        driverConfigurazione.deleteServizioApplicativo(sa);
                        log.debug((Object)("\t\t. servizio applicativo (" + nomeSA + ") eliminato"));
                    }
                    log.debug((Object)"\t- eliminazione servizi applicativi effettuata");
                    log.debug((Object)"\t- eliminazione servizio spcoop ...");
                    if (servizioSPCoop.getServizioCorrelato()) {
                        driverRegistroServizi.deleteServizioSpcoopCorrelato(servizioSPCoop);
                    } else {
                        driverRegistroServizi.deleteServizioSpcoop(servizioSPCoop);
                    }
                    log.debug((Object)"\t- eliminazione servizio spcoop effettuata");
                    log.debug((Object)"\t- eliminazione accordo parte comune ...");
                    FiltroServiziSPCoop filtroAltriServizi = new FiltroServiziSPCoop();
                    IDAccordo idAccordoParteComune = IDAccordo.getIDAccordoFromUri((String)servizioSPCoop.getAccordoServizio());
                    filtroAltriServizi.setIdAccordo(idAccordoParteComune);
                    boolean existsAltriServizi = false;
                    StringBuffer bfAltriServizi = new StringBuffer();
                    try {
                        others = driverRegistroServizi.getAllIdServizi(filtroAltriServizi);
                        if (others != null && others.length > 0) {
                            existsAltriServizi = true;
                        }
                        for (i = 0; i < others.length; ++i) {
                            if (bfAltriServizi.length() > 0) {
                                bfAltriServizi.append(",");
                            }
                            bfAltriServizi.append(others[i].toString());
                        }
                    }
                    catch (DriverRegistroServiziNotFound notFound) {
                        // empty catch block
                    }
                    try {
                        others = driverRegistroServizi.getAllIdServiziCorrelati(filtroAltriServizi);
                        if (others != null && others.length > 0) {
                            existsAltriServizi = true;
                        }
                        for (i = 0; i < others.length; ++i) {
                            if (bfAltriServizi.length() > 0) {
                                bfAltriServizi.append(",");
                            }
                            bfAltriServizi.append(others[i].toString());
                        }
                    }
                    catch (DriverRegistroServiziNotFound notFound) {
                        // empty catch block
                    }
                    if (!existsAltriServizi) {
                        AccordoServizio as = new AccordoServizio();
                        as.setNome(idAccordoParteComune.getNome());
                        as.setVersione(idAccordoParteComune.getVersione());
                        if (idAccordoParteComune.getSoggettoReferente() != null) {
                            AccordoServizioSoggettoReferente asr = new AccordoServizioSoggettoReferente();
                            asr.setTipo(idAccordoParteComune.getSoggettoReferente().getTipo());
                            asr.setNome(idAccordoParteComune.getSoggettoReferente().getNome());
                            as.setSoggettoReferente(asr);
                        }
                        driverRegistroServizi.deleteAccordoServizio(as);
                        log.debug((Object)"\t- eliminazione accordo parte comune effettuata");
                    } else {
                        log.debug((Object)("\t- eliminazione accordo parte comune non effettuata poiche' implementato da altri servizi spcoop: " + bfAltriServizi.toString()));
                    }
                }
                log.debug((Object)("Gestione eliminazione servizio [" + idServizio.toString() + "] completata"));
            }
            log.debug((Object)"Commit...");
            connectionConfigurazione.commit();
            if (!pddConsoleMode) {
                connectionRegistroServizi.commit();
            }
            log.debug((Object)"Commit effettuato");
        }
        catch (Exception e) {
            try {
                connectionConfigurazione.rollback();
            }
            catch (Exception eRollback) {
                // empty catch block
            }
            try {
                if (!pddConsoleMode) {
                    connectionRegistroServizi.rollback();
                }
            }
            catch (Exception eRollback) {
                // empty catch block
            }
            errorMsg = "Errore avvenuto durante l'eliminazione: " + e.getMessage();
            log.error((Object)errorMsg, (Throwable)e);
            throw new Exception(errorMsg, e);
        }
        finally {
            try {
                connectionConfigurazione.setAutoCommit(true);
            }
            catch (Exception e) {}
            try {
                if (!pddConsoleMode) {
                    connectionRegistroServizi.setAutoCommit(true);
                }
            }
            catch (Exception e) {}
            try {
                connectionConfigurazione.close();
            }
            catch (Exception e) {}
            try {
                if (!pddConsoleMode) {
                    connectionRegistroServizi.close();
                }
            }
            catch (Exception e) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void deletePoliticheSicurezza(Connection con, String tipoDatabase, Long idServizio, Long idFruitore) throws Exception {
        Statement pstmt = null;
        try {
            ISQLQueryObject sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)tipoDatabase);
            sqlQueryObject.addDeleteTable("politiche_sicurezza");
            sqlQueryObject.addWhereCondition("id_servizio=?");
            if (idFruitore != null) {
                sqlQueryObject.addWhereCondition("id_fruitore=?");
            }
            pstmt = con.prepareStatement(sqlQueryObject.createSQLDelete());
            pstmt.setLong(1, idServizio);
            if (idFruitore != null) {
                pstmt.setLong(2, idFruitore);
            }
            pstmt.executeUpdate();
        }
        finally {
            try {
                pstmt.close();
            }
            catch (Exception e) {}
        }
    }
}

