/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop.pdd.config;

import java.io.InputStream;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;
import org.apache.log4j.Logger;
import org.openspcoop.pdd.config.OpenSPCoopConfigurationException;

public class MailcapActivationReader {
    private static Hashtable<String, String> mimeTypes = new Hashtable();

    public static void initDataContentHandler(Logger log) throws OpenSPCoopConfigurationException {
        try {
            InputStream is = MailcapActivationReader.class.getResourceAsStream("/META-INF/mailcap");
            Properties prop = new Properties();
            prop.load(is);
            Enumeration<Object> en = prop.keys();
            while (en.hasMoreElements()) {
                String key = (String)en.nextElement();
                int index = key.indexOf(";;");
                if (index == -1) {
                    throw new Exception("Entry " + key + (String)prop.get(key) + " definita con un formato scorretto [;;] (vedi javax/activation/MailcapCommandMap api)");
                }
                String keyMime = key.substring(0, index);
                keyMime = keyMime.trim();
                String value = (String)prop.get(key);
                index = value.indexOf("=");
                if (index == -1) {
                    throw new Exception("Entry " + key + (String)prop.get(key) + " definita con un formato scorretto [=] (vedi javax/activation/MailcapCommandMap api)");
                }
                value = value.substring(index + 1, value.length());
                value = value.trim();
                mimeTypes.put(keyMime, value);
                log.info((Object)("Caricato DataContentHandler per mime-type " + keyMime + " gestito tramite la classe " + value));
            }
        }
        catch (Exception e) {
            throw new OpenSPCoopConfigurationException(e.getMessage(), e);
        }
    }

    public static boolean existsDataContentHandler(String mimeType) {
        return mimeTypes.containsKey(mimeType);
    }
}

