/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop.pdd.config;

import java.util.Enumeration;
import java.util.Properties;
import java.util.Vector;
import org.apache.log4j.Logger;
import org.openspcoop.pdd.config.PropertiesUtilities;
import org.openspcoop.pdd.logger.OpenSPCoopLogger;
import org.openspcoop.utils.PropertiesReader;
import org.openspcoop.utils.UtilsException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
abstract class InstanceProperties {
    private PropertiesReader propertiesOriginale;
    private PropertiesReader propertiesRidefinitoFile;
    private PropertiesReader propertiesRidefinitoObject;
    protected Logger log;

    InstanceProperties(Properties propertiesOriginale, Logger log) throws Exception {
        this.propertiesOriginale = new PropertiesReader(propertiesOriginale);
        this.log = log;
    }

    public void setLocalFileImplementation(String variable, String path, String confDirectory) {
        Properties prop = PropertiesUtilities.searchLocalImplementation(this.log, variable, path, confDirectory);
        if (prop != null) {
            this.propertiesRidefinitoFile = new PropertiesReader(prop);
        }
    }

    public void setLocalFileImplementation(Properties prop) {
        this.propertiesRidefinitoFile = new PropertiesReader(prop);
    }

    public void setLocalObjectImplementation(Properties prop) {
        this.propertiesRidefinitoObject = new PropertiesReader(prop);
    }

    public String getValue(String key) throws UtilsException {
        return this.getValueEngine(key, false);
    }

    public String getValue_convertEnvProperties(String key) throws UtilsException {
        return this.getValueEngine(key, true);
    }

    public Properties readProperties(String prefix) throws UtilsException {
        return this.readPropertiesEngine(prefix, false);
    }

    public Properties readProperties_convertEnvProperties(String prefix) throws UtilsException {
        return this.readPropertiesEngine(prefix, true);
    }

    public String convertEnvProperties(String value) throws UtilsException {
        return this.propertiesOriginale.convertEnvProperties(value);
    }

    public Enumeration<?> propertyNames() {
        String ridefinito;
        Enumeration enumPropRidefinito;
        Enumeration enumProp = this.propertiesOriginale.propertyNames();
        Vector<String> object = new Vector<String>();
        while (enumProp.hasMoreElements()) {
            object.add((String)enumProp.nextElement());
        }
        if (this.propertiesRidefinitoFile != null) {
            enumPropRidefinito = this.propertiesRidefinitoFile.propertyNames();
            while (enumPropRidefinito.hasMoreElements()) {
                ridefinito = (String)enumPropRidefinito.nextElement();
                if (object.contains(ridefinito)) continue;
                object.add(ridefinito);
            }
        }
        if (this.propertiesRidefinitoObject != null) {
            enumPropRidefinito = this.propertiesRidefinitoObject.propertyNames();
            while (enumPropRidefinito.hasMoreElements()) {
                ridefinito = (String)enumPropRidefinito.nextElement();
                if (object.contains(ridefinito)) continue;
                object.add(ridefinito);
            }
        }
        return object.elements();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private String getValueEngine(String key, boolean convertEnvProperties) throws UtilsException {
        try {
            int i;
            String tmp;
            String[] addObject = null;
            String tmpObject = null;
            if (this.propertiesRidefinitoObject != null) {
                tmpObject = convertEnvProperties ? this.propertiesRidefinitoObject.getValue_convertEnvProperties(key) : this.propertiesRidefinitoObject.getValue(key);
            }
            if (tmpObject != null) {
                tmpObject = tmpObject.trim();
                String add = null;
                if (tmpObject.startsWith("+")) {
                    add = tmpObject.substring(1);
                    add = add.trim();
                }
                if (add == null) return tmpObject;
                if (add.startsWith(",") && add.length() > 1) {
                    addObject = add.substring(1).split(",");
                    if (addObject == null || addObject.length <= 0) return tmpObject;
                    for (int i2 = 0; i2 < addObject.length; ++i2) {
                        addObject[i2] = addObject[i2].trim();
                    }
                }
            }
            String[] addFile = null;
            String tmpFile = null;
            if (this.propertiesRidefinitoFile != null) {
                tmpFile = convertEnvProperties ? this.propertiesRidefinitoFile.getValue_convertEnvProperties(key) : this.propertiesRidefinitoFile.getValue(key);
            }
            if (tmpFile != null) {
                tmpFile = tmpFile.trim();
                String add = null;
                if (tmpFile.startsWith("+")) {
                    add = tmpFile.substring(1);
                    add = add.trim();
                }
                if (add == null) return tmpFile;
                if (add.startsWith(",") && add.length() > 1) {
                    addFile = add.substring(1).split(",");
                    if (addFile == null || addFile.length <= 0) return tmpFile;
                    for (int i3 = 0; i3 < addFile.length; ++i3) {
                        addFile[i3] = addFile[i3].trim();
                    }
                }
            }
            if ((tmp = null) == null) {
                tmp = convertEnvProperties ? this.propertiesOriginale.getValue_convertEnvProperties(key) : this.propertiesOriginale.getValue(key);
            }
            if (addObject == null && addFile == null) {
                return tmp;
            }
            StringBuffer bf = new StringBuffer();
            if (tmp != null) {
                bf.append(tmp);
            }
            if (addObject != null) {
                for (i = 0; i < addObject.length; ++i) {
                    if (bf.length() > 0) {
                        bf.append(",");
                    }
                    bf.append(addObject[i]);
                }
            }
            if (addFile == null) return bf.toString();
            for (i = 0; i < addFile.length; ++i) {
                if (bf.length() > 0) {
                    bf.append(",");
                }
                bf.append(addFile[i]);
            }
            return bf.toString();
        }
        catch (Exception e) {
            if (OpenSPCoopLogger.getLoggerOpenSPCoopCore() != null) {
                OpenSPCoopLogger.getLoggerOpenSPCoopCore().error((Object)("Errore durante la lettura della proprieta' [" + key + "](" + convertEnvProperties + ")"), (Throwable)e);
                throw new UtilsException(e.getMessage(), (Throwable)e);
            } else {
                OpenSPCoopLogger.getLoggerOpenSPCoopConsole().error((Object)("Errore durante la lettura della proprieta' [" + key + "](" + convertEnvProperties + ")"), (Throwable)e);
            }
            throw new UtilsException(e.getMessage(), (Throwable)e);
        }
    }

    private Properties readPropertiesEngine(String prefix, boolean convertEnvProperties) throws UtilsException {
        Properties tmp = null;
        try {
            String key;
            Enumeration<Object> keys;
            tmp = convertEnvProperties ? this.propertiesOriginale.readProperties_convertEnvProperties(prefix) : this.propertiesOriginale.readProperties(prefix);
            if (this.propertiesRidefinitoFile != null) {
                Properties tmp2 = null;
                tmp2 = convertEnvProperties ? this.propertiesRidefinitoFile.readProperties_convertEnvProperties(prefix) : this.propertiesRidefinitoFile.readProperties(prefix);
                if (tmp2 != null) {
                    keys = tmp2.keys();
                    while (keys.hasMoreElements()) {
                        key = (String)keys.nextElement();
                        if (tmp.containsKey(key)) {
                            tmp.remove(key);
                        }
                        tmp.put(key, tmp2.get(key));
                    }
                }
            }
            if (this.propertiesRidefinitoObject != null) {
                Properties tmp3 = null;
                tmp3 = convertEnvProperties ? this.propertiesRidefinitoObject.readProperties_convertEnvProperties(prefix) : this.propertiesRidefinitoObject.readProperties(prefix);
                if (tmp3 != null) {
                    keys = tmp3.keys();
                    while (keys.hasMoreElements()) {
                        key = (String)keys.nextElement();
                        if (tmp.containsKey(key)) {
                            tmp.remove(key);
                        }
                        tmp.put(key, tmp3.get(key));
                    }
                }
            }
        }
        catch (Exception e) {
            if (OpenSPCoopLogger.getLoggerOpenSPCoopCore() != null) {
                OpenSPCoopLogger.getLoggerOpenSPCoopCore().error((Object)("Errore durante la lettura delle proprieta' con prefix [" + prefix + "](" + convertEnvProperties + ")"), (Throwable)e);
            } else {
                OpenSPCoopLogger.getLoggerOpenSPCoopConsole().error((Object)("Errore durante la lettura delle proprieta' con prefix [" + prefix + "](" + convertEnvProperties + ")"), (Throwable)e);
            }
            throw new UtilsException(e.getMessage(), (Throwable)e);
        }
        return tmp;
    }
}

