/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop.pdd.config;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.InputStream;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.net.URI;
import java.net.URL;
import java.util.Enumeration;
import java.util.Properties;
import java.util.Vector;
import java.util.jar.Attributes;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import org.apache.log4j.Logger;
import org.openspcoop.pdd.config.ResourceFinder;
import org.openspcoop.utils.FileSystemUtilities;
import org.openspcoop.utils.io.JarUtilities;
import org.openspcoop.utils.io.ZipUtilities;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GeneralInstanceProperties {
    private File archiveFile = null;
    private int RESULT_LENGTH = 7;

    public Object[] reads(Logger log) {
        Object[] oR = this.readLoadProperties(log);
        if (oR != null) {
            return oR;
        }
        boolean lookup = false;
        String properties = System.getenv("OPENSPCOOP_LOOKUP");
        if (properties != null && "true".equalsIgnoreCase(properties)) {
            lookup = true;
        }
        if (properties == null && (properties = System.getProperty("OPENSPCOOP_LOOKUP")) != null && "true".equalsIgnoreCase(properties)) {
            lookup = true;
        }
        if (!lookup) {
            return null;
        }
        File fClasspath = null;
        try {
            URL urlClasspath = GeneralInstanceProperties.class.getResource("/logger.log4j.properties");
            if (urlClasspath != null) {
                String[] tmp;
                URI uri = urlClasspath.toURI();
                String uriS = uri.toString();
                if (uriS.startsWith("vfsfile:")) {
                    uriS = uriS.substring("vfsfile:".length());
                } else if (uriS.startsWith("vfszip:")) {
                    uriS = uriS.substring("vfszip:".length());
                } else if (uriS.contains(":") && (tmp = uriS.split(":")).length > 1) {
                    uriS = tmp[1].trim();
                }
                File f = new File(uriS).getParentFile();
                if (f != null) {
                    if ("properties".equals(f.getName())) {
                        fClasspath = f.getParentFile().getParentFile();
                    } else if ("classes".equals(f.getName())) {
                        fClasspath = f.getParentFile().getParentFile().getParentFile();
                    }
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (fClasspath != null) {
            Vector<File> files = new Vector<File>();
            this.findArchives(log, fClasspath, files);
            if (files.size() <= 0) {
                String dir = fClasspath.getName();
                if ((fClasspath = fClasspath.getParentFile()) != null) {
                    if ("tmp".equalsIgnoreCase(fClasspath.getName())) {
                        if ((fClasspath = fClasspath.getParentFile()) != null) {
                            fClasspath = new File(fClasspath, dir);
                            this.findArchives(log, fClasspath, files);
                        }
                    } else if ("deploy".equalsIgnoreCase(dir) && fClasspath != null && (fClasspath = new File(fClasspath, "tmp")).exists() && fClasspath.canRead() && (fClasspath = new File(fClasspath, "deploy")).exists() && fClasspath.canRead()) {
                        this.findArchives(log, fClasspath, files);
                    }
                }
            }
            for (int i = 0; i < files.size(); ++i) {
                Object[] o = null;
                this.archiveFile = files.get(i);
                if (this.archiveFile.isFile()) {
                    log.debug((Object)("Archive [" + this.archiveFile.getAbsolutePath() + "] find in classpath"));
                    o = this.readFile(this.archiveFile, log);
                } else {
                    log.debug((Object)("Directory [" + this.archiveFile.getAbsolutePath() + "] find in classpath"));
                    o = this.readDir(this.archiveFile, log);
                }
                if (o == null) continue;
                return o;
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object[] readLoadProperties(Logger log) {
        try {
            Object[] o;
            Object result;
            InputStream is;
            String loaderP = System.getenv("OPENSPCOOP_LOADER");
            if (loaderP == null) {
                loaderP = System.getProperty("OPENSPCOOP_LOADER");
            }
            if (loaderP == null && (is = GeneralInstanceProperties.class.getResourceAsStream("/loader.properties")) != null) {
                try {
                    Properties p = new Properties();
                    p.load(is);
                    loaderP = p.getProperty("loader");
                    if (loaderP != null) {
                        loaderP = loaderP.trim();
                    }
                }
                finally {
                    try {
                        is.close();
                    }
                    catch (Exception eClose) {}
                }
            }
            if (loaderP == null) {
                return null;
            }
            Method method = this.getClass().getClassLoader().getClass().getMethod("loadClass", String.class);
            Object c = method.invoke((Object)this.getClass().getClassLoader(), loaderP);
            Object loader = null;
            if (c != null) {
                Constructor constructor = ((Class)c).getConstructor(ClassLoader.class);
                loader = (ClassLoader)constructor.newInstance(this.getClass().getClassLoader());
            }
            if (loader == null) {
                throw new Exception("Loader [" + loaderP + "] non caricato");
            }
            Method methodProperties = null;
            try {
                methodProperties = loader.getClass().getMethod("getClassProperties", new Class[0]);
            }
            catch (Exception e) {
            }
            catch (Throwable e) {
                // empty catch block
            }
            if (methodProperties != null && (result = methodProperties.invoke(loader, new Object[0])) != null && result instanceof String && (o = this.readProperties(log, (String)result, (ClassLoader)loader, "getClassProperties")) != null) {
                return o;
            }
            String tipo = "systemProperties";
            String properties = System.getenv("OPENSPCOOP_LOADER_PROPERTIES");
            if (properties == null) {
                tipo = "javaProperties";
                properties = System.getProperty("OPENSPCOOP_LOADER_PROPERTIES");
            }
            if (properties == null) {
                throw new Exception("Trovata proprieta' per loader ma non sono state fornite le properties");
            }
            Object[] o2 = this.readProperties(log, properties, (ClassLoader)loader, tipo);
            if (o2 != null) {
                return o2;
            }
            throw new Exception("Trovata proprieta' per loader ma non sono state fornite correttamente le properties");
        }
        catch (Exception e) {
            log.debug((Object)"LoadProperties ERROR", (Throwable)e);
        }
        catch (Throwable e) {
            log.debug((Object)"LoadProperties ERROR", e);
        }
        return null;
    }

    private Object[] readProperties(Logger log, String properties, ClassLoader loader, String tipoRicerca) throws Exception {
        String[] split = null;
        if (properties.contains(",")) {
            split = properties.split(",");
        } else if (properties.contains(":")) {
            split = properties.split(":");
        } else if (properties.contains(";")) {
            split = properties.split(";");
        } else if (properties.contains(" ")) {
            split = properties.split(" ");
        } else {
            throw new Exception("Trovata proprieta' per loader ma non sono state fornite correttamente le properties");
        }
        if (split == null || split.length != this.RESULT_LENGTH - 1) {
            throw new Exception("Trovata proprieta' per loader ma non sono state fornite correttamente le properties");
        }
        Properties opP = null;
        Properties clP = null;
        Properties pddP = null;
        Properties configP = null;
        Properties logP = null;
        Properties msgDiagP = null;
        for (int i = 0; i < split.length; ++i) {
            String v = split[i].trim();
            try {
                Method method = this.getClass().getClassLoader().getClass().getMethod("loadClass", String.class);
                Object find = method.invoke((Object)this.getClass().getClassLoader(), ClassLoader.class.getName());
                find = method.invoke((Object)loader, Properties.class.getName());
                Object c = method.invoke((Object)loader, v);
                if (c == null) {
                    throw new Exception("Proprieta' [" + v + "] non trovata");
                }
                if (((Class)find).isAssignableFrom((Class)c)) {
                    Constructor constructor = ((Class)c).getConstructor(new Class[0]);
                    Properties p = (Properties)constructor.newInstance(new Object[0]);
                    Object type = p.get("type");
                    if (type == null) {
                        throw new Exception("Proprieta' [" + v + "] con type non definito");
                    }
                    if ("openspcoop".equals(type)) {
                        opP = p;
                        continue;
                    }
                    if ("className".equals(type)) {
                        clP = p;
                        continue;
                    }
                    if ("pdd".equals(type)) {
                        pddP = p;
                        continue;
                    }
                    if ("logger".equals(type)) {
                        logP = p;
                        continue;
                    }
                    if ("config".equals(type)) {
                        configP = p;
                        continue;
                    }
                    if ("msgDiagnostici".equals(type)) {
                        msgDiagP = p;
                        continue;
                    }
                    throw new Exception("Proprieta' [" + v + "] con type non corretto");
                }
                throw new Exception("Proprieta' [" + v + "] di tipo non corretto");
            }
            catch (Exception e) {
                throw new Exception("Trovata proprieta' per loader ma non sono state fornite correttamente le properties. Errore durante la lookup della properties [" + v + "]: " + e.getMessage(), e);
            }
            catch (Throwable e) {
                throw new Exception("Trovata proprieta' per loader ma non sono state fornite correttamente le properties. Errore durante la lookup della properties [" + v + "]: " + e.getMessage(), e);
            }
        }
        if (opP != null && clP != null && pddP != null && logP != null && configP != null && msgDiagP != null) {
            Object[] o = new Object[this.RESULT_LENGTH];
            o[0] = loader;
            o[1] = opP;
            o[2] = clP;
            o[3] = pddP;
            o[4] = logP;
            o[5] = configP;
            o[6] = msgDiagP;
            for (int i = 0; i < o.length; ++i) {
                log.debug((Object)("Class (" + tipoRicerca + ") [" + i + "]=[" + o[i].getClass().getName() + "]"));
            }
            log.debug((Object)("Loader find (" + tipoRicerca + ")"));
            return o;
        }
        return null;
    }

    private void findArchives(Logger log, File fClasspath, Vector<File> files) {
        log.debug((Object)("Search libraries in classpath [" + fClasspath.getAbsolutePath() + "] ..."));
        if (fClasspath.isFile()) {
            log.debug((Object)"Classpath is file");
            return;
        }
        if (!fClasspath.canRead()) {
            log.debug((Object)"Classpath is not readable");
            return;
        }
        File[] f = fClasspath.listFiles();
        if (f != null) {
            for (int i = 0; i < f.length; ++i) {
                if (!f[i].canRead()) continue;
                if (f[i].isFile()) {
                    if (!this.checkFile(f[i])) continue;
                    log.debug((Object)("Find archive [" + f[i].getAbsolutePath() + "]"));
                    files.add(f[i]);
                    continue;
                }
                if (!f[i].isDirectory() || !this.checkDir(f[i])) continue;
                log.debug((Object)("Find dir [" + f[i].getAbsolutePath() + "]"));
                files.add(f[i]);
            }
        }
        log.debug((Object)("Search libraries in classpath [" + fClasspath.getAbsolutePath() + "]: find " + files.size()));
    }

    private boolean checkFile(File file) {
        if (!file.exists()) {
            return false;
        }
        if (!file.canRead()) {
            return false;
        }
        if (file.isDirectory()) {
            return false;
        }
        try {
            JarFile archive = JarUtilities.getJar((File)file, (boolean)false);
            if (archive == null) {
                return false;
            }
            Manifest manifest = archive.getManifest();
            return this.checkManifest(manifest);
        }
        catch (Exception e) {
            return false;
        }
    }

    private boolean checkDir(File dir) {
        try {
            if (!dir.canRead()) {
                return false;
            }
            File[] childs = dir.listFiles();
            if (childs == null || childs.length <= 0) {
                return false;
            }
            for (int i = 0; i < childs.length; ++i) {
                if (!childs[i].canRead() || !childs[i].isDirectory() || !"META-INF".equals(childs[i].getName())) continue;
                File[] childsInterni = childs[i].listFiles();
                if (childsInterni == null || childsInterni.length <= 0) {
                    return false;
                }
                for (int j = 0; j < childsInterni.length; ++j) {
                    if (!childsInterni[j].canRead() || !childsInterni[j].isFile() || !"MANIFEST.MF".equals(childsInterni[j].getName())) continue;
                    byte[] m = FileSystemUtilities.readBytesFromFile((File)childsInterni[j]);
                    if (m == null) {
                        return false;
                    }
                    Manifest manifest = new Manifest(new ByteArrayInputStream(m));
                    return this.checkManifest(manifest);
                }
            }
            return false;
        }
        catch (Exception e) {
            return false;
        }
    }

    private boolean checkManifest(Manifest manifest) {
        if (manifest == null) {
            return false;
        }
        if (manifest.getMainAttributes() == null) {
            return false;
        }
        Attributes attributes = manifest.getMainAttributes();
        if (attributes.size() < 2) {
            return false;
        }
        String attrProduct = attributes.getValue("product-name");
        if (!"OpenSPCoop".equals(attrProduct)) {
            return false;
        }
        String attrCopyright = attributes.getValue("copyright");
        if (attrCopyright == null) {
            return false;
        }
        return attrCopyright.contains("Link.it srl (http://link.it). All rights reserved.");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Object[] readFile(File file, Logger log) {
        if (!file.exists()) {
            log.debug((Object)("File [" + file.getAbsolutePath() + "] not exist"));
            return null;
        }
        if (!file.canRead()) {
            log.debug((Object)("File [" + file.getAbsolutePath() + "] not readable"));
            return null;
        }
        if (file.isDirectory()) {
            log.debug((Object)("File [" + file.getAbsolutePath() + "] is directory"));
            return null;
        }
        try {
            Object[] method;
            byte[] entryBytes;
            Object c;
            Object nome;
            String extension;
            JarEntry entry;
            JarFile archive = JarUtilities.getJar((File)file, (boolean)false);
            if (archive == null) {
                log.debug((Object)("File [" + file.getAbsolutePath() + "] is not jar archive"));
                return null;
            }
            Enumeration<JarEntry> entries = null;
            Object loader = null;
            String parentDirLoader = null;
            entries = archive.entries();
            while (entries.hasMoreElements()) {
                entry = entries.nextElement();
                extension = "";
                if (entry.getName().contains(".")) {
                    extension = entry.getName().substring(entry.getName().lastIndexOf(46) + 1, entry.getName().length());
                }
                nome = entry.getName().replaceAll("/", ".");
                if (extension != null) {
                    extension = "." + extension;
                    nome = ((String)nome).substring(0, ((String)nome).length() - extension.length());
                }
                if (((String)nome).endsWith(".")) continue;
                try {
                    Method method2 = this.getClass().getClassLoader().getClass().getMethod("loadClass", String.class);
                    Object find = method2.invoke((Object)this.getClass().getClassLoader(), ClassLoader.class.getName());
                    c = null;
                    try {
                        c = method2.invoke((Object)this.getClass().getClassLoader(), nome);
                    }
                    catch (Exception e) {
                    }
                    catch (Throwable e) {
                        // empty catch block
                    }
                    if (c == null || !((Class)find).isAssignableFrom((Class<?>)c)) continue;
                    Constructor<?> constructor = ((Class)c).getConstructor(ClassLoader.class);
                    loader = (ClassLoader)constructor.newInstance(this.getClass().getClassLoader());
                    parentDirLoader = ((String)nome).split("\\.")[0].trim() + ".";
                    break;
                }
                catch (Exception e) {
                }
            }
            if (loader != null) {
                log.debug((Object)"Loader find (loadClass)");
            }
            if (loader == null) {
                entries = archive.entries();
                while (entries.hasMoreElements()) {
                    entry = entries.nextElement();
                    extension = "";
                    if (entry.getName().contains(".")) {
                        extension = entry.getName().substring(entry.getName().lastIndexOf(46) + 1, entry.getName().length());
                    }
                    nome = entry.getName().replaceAll("/", ".");
                    if (extension != null) {
                        extension = "." + extension;
                        nome = ((String)nome).substring(0, ((String)nome).length() - extension.length());
                    }
                    if (((String)nome).endsWith(".")) continue;
                    entryBytes = null;
                    try {
                        entryBytes = JarUtilities.getEntry((File)file, (String)entry.getName());
                    }
                    catch (Exception e) {
                    }
                    catch (Throwable e) {
                        // empty catch block
                    }
                    try {
                        Object find;
                        ResourceFinder finder = new ResourceFinder(this.getClass().getClassLoader());
                        c = null;
                        try {
                            c = finder.loadResource((String)nome, entryBytes);
                        }
                        catch (Exception e) {
                        }
                        catch (Throwable e) {
                            // empty catch block
                        }
                        if (c == null || !((Class)(find = (method = this.getClass().getClassLoader().getClass().getMethod("loadClass", String.class)).invoke((Object)this.getClass().getClassLoader(), ClassLoader.class.getName()))).isAssignableFrom((Class)c)) continue;
                        Constructor constructor = ((Class)c).getConstructor(ClassLoader.class, JarFile.class, String.class, File.class);
                        parentDirLoader = ((String)nome).split("\\.")[0].trim() + ".";
                        loader = (ClassLoader)constructor.newInstance(this.getClass().getClassLoader(), archive, parentDirLoader, this.archiveFile);
                        break;
                    }
                    catch (Exception e) {
                    }
                }
                if (loader != null) {
                    log.debug((Object)"Loader find (ResourceFinder)");
                }
            }
            if (loader == null) {
                entries = archive.entries();
                while (entries.hasMoreElements()) {
                    entry = entries.nextElement();
                    extension = "";
                    if (entry.getName().contains(".")) {
                        extension = entry.getName().substring(entry.getName().lastIndexOf(46) + 1, entry.getName().length());
                    }
                    nome = entry.getName().replaceAll("/", ".");
                    if (extension != null) {
                        extension = "." + extension;
                        nome = ((String)nome).substring(0, ((String)nome).length() - extension.length());
                    }
                    if (((String)nome).endsWith(".")) continue;
                    entryBytes = null;
                    try {
                        entryBytes = JarUtilities.getEntry((File)file, (String)entry.getName());
                    }
                    catch (Exception e) {
                    }
                    catch (Throwable e) {
                        // empty catch block
                    }
                    if (entryBytes == null) continue;
                    File tmp = null;
                    try {
                        Object[] o;
                        tmp = File.createTempFile("PddInterceptor", "PddInterceptor");
                        FileSystemUtilities.writeFile((File)tmp, (byte[])entryBytes);
                        if (!JarUtilities.isJar((File)tmp, (boolean)false) || !this.checkFile(tmp) || (o = this.readFile(tmp, log)) == null) continue;
                        method = o;
                        return method;
                    }
                    catch (Exception e) {
                    }
                    catch (Throwable e) {
                    }
                    finally {
                        try {
                            FileSystemUtilities.deleteDir((File)tmp);
                            tmp.deleteOnExit();
                        }
                        catch (Exception e) {}
                    }
                }
            }
            if (loader == null) {
                File tmp = null;
                try {
                    tmp = File.createTempFile("PddInterceptor", "PddInterceptor");
                    tmp.delete();
                    ZipUtilities.unzipFile((String)file.getAbsolutePath(), (String)tmp.getAbsolutePath());
                    Object[] o = this.readDir(tmp, log);
                    if (o != null) {
                        nome = o;
                        return nome;
                    }
                }
                catch (Exception e) {
                }
                catch (Throwable e) {
                }
                finally {
                    try {
                        FileSystemUtilities.deleteDir((File)tmp);
                        tmp.deleteOnExit();
                    }
                    catch (Exception e) {}
                }
            }
            if (loader == null) return null;
            entries = archive.entries();
            Properties opP = null;
            Properties clP = null;
            Properties pddP = null;
            Properties configP = null;
            Properties logP = null;
            Properties msgDiagP = null;
            while (entries.hasMoreElements()) {
                JarEntry entry2 = entries.nextElement();
                String extension2 = "";
                if (entry2.getName().contains(".")) {
                    extension2 = entry2.getName().substring(entry2.getName().lastIndexOf(46) + 1, entry2.getName().length());
                }
                String nome2 = entry2.getName().replaceAll("/", ".");
                if (extension2 != null) {
                    extension2 = "." + extension2;
                    nome2 = nome2.substring(0, nome2.length() - extension2.length());
                }
                if (nome2.equals(loader.getClass().getName()) || ".".equals(extension2) || !nome2.startsWith(parentDirLoader)) continue;
                Object find = null;
                Object c2 = null;
                try {
                    log.debug((Object)("Load [" + nome2 + "]..."));
                    Method method3 = loader.getClass().getMethod("loadClass", String.class);
                    find = method3.invoke(loader, Properties.class.getName());
                    c2 = method3.invoke(loader, nome2);
                    log.debug((Object)("Load [" + nome2 + "] OK"));
                    if (find == null) {
                        throw new Exception("find null");
                    }
                    if (c2 == null) {
                        throw new Exception("c null");
                    }
                }
                catch (Exception e) {
                    log.debug((Object)("Load [" + nome2 + "] ERROR"), (Throwable)e);
                }
                catch (Throwable e) {
                    log.debug((Object)("Load [" + nome2 + "] ERROR"), e);
                }
                if (find == null || c2 == null) continue;
                try {
                    Constructor constructor;
                    Properties properties;
                    Object type;
                    if (!((Class)find).isAssignableFrom((Class)c2) || (type = (properties = (Properties)(constructor = ((Class)c2).getConstructor(new Class[0])).newInstance(new Object[0])).get("type")) == null) continue;
                    if ("openspcoop".equals(type)) {
                        opP = properties;
                        continue;
                    }
                    if ("className".equals(type)) {
                        clP = properties;
                        continue;
                    }
                    if ("pdd".equals(type)) {
                        pddP = properties;
                        continue;
                    }
                    if ("logger".equals(type)) {
                        logP = properties;
                        continue;
                    }
                    if ("config".equals(type)) {
                        configP = properties;
                        continue;
                    }
                    if (!"msgDiagnostici".equals(type)) continue;
                    msgDiagP = properties;
                }
                catch (Exception e) {
                    log.debug((Object)("Loader instance [" + nome2 + "] error: " + e.getMessage()), (Throwable)e);
                }
                catch (Throwable e) {
                    log.debug((Object)("Loader instance [" + nome2 + "] error: " + e.getMessage()), e);
                }
            }
            if (opP == null) return null;
            if (clP == null) return null;
            if (pddP == null) return null;
            if (logP == null) return null;
            if (configP == null) return null;
            if (msgDiagP == null) return null;
            Object[] o = new Object[this.RESULT_LENGTH];
            o[0] = loader;
            o[1] = opP;
            o[2] = clP;
            o[3] = pddP;
            o[4] = logP;
            o[5] = configP;
            o[6] = msgDiagP;
            int i = 0;
            while (i < o.length) {
                log.debug((Object)("Class [" + i + "]=[" + o[i].getClass().getName() + "]"));
                ++i;
            }
            return o;
        }
        catch (Exception e) {
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object[] readDir(File file, Logger log) {
        if (!file.exists()) {
            log.debug((Object)("File (DIR) [" + file.getAbsolutePath() + "] not exist"));
            return null;
        }
        if (!file.canRead()) {
            log.debug((Object)("File (DIR) [" + file.getAbsolutePath() + "] not readable"));
            return null;
        }
        if (file.isFile()) {
            log.debug((Object)("File (DIR) [" + file.getAbsolutePath() + "] is directory"));
            return null;
        }
        File[] childs = file.listFiles();
        if (childs != null && childs.length > 0) {
            Constructor constructor;
            Class<?> c;
            Object find;
            Method method;
            String extension;
            int k;
            Object loader = null;
            String parentDirLoader = null;
            for (int i = 0; i < childs.length; ++i) {
                if (!childs[i].isDirectory() || childs[i].listFiles() == null || childs[i].listFiles().length <= 0) continue;
                File[] childsInterni = childs[i].listFiles();
                File WEB_LIB = null;
                File WEB_CLASSES = null;
                File EAR = null;
                if ("WEB-INF".equals(childs[i].getName())) {
                    for (int k2 = 0; k2 < childsInterni.length; ++k2) {
                        if ("lib".equals(childsInterni[k2].getName())) {
                            WEB_LIB = childsInterni[k2];
                        }
                        if (!"classes".equals(childsInterni[k2].getName())) continue;
                        WEB_CLASSES = childsInterni[k2];
                    }
                } else if ("META-INF".equals(childs[i].getName())) {
                    for (int k3 = 0; k3 < childsInterni.length; ++k3) {
                        if (!"application.xml".equals(childsInterni[k3].getName())) continue;
                        EAR = childs[i];
                    }
                }
                if (WEB_LIB != null || WEB_CLASSES != null || EAR != null) {
                    if (WEB_LIB != null) {
                        Object[] o = null;
                        try {
                            o = this.readDir(WEB_LIB, log);
                        }
                        catch (Exception e) {
                        }
                        catch (Throwable e) {
                            // empty catch block
                        }
                        if (o != null) {
                            return o;
                        }
                    }
                    if (WEB_CLASSES != null) {
                        Object[] o = null;
                        try {
                            o = this.readDir(WEB_CLASSES, log);
                        }
                        catch (Exception e) {
                        }
                        catch (Throwable e) {
                            // empty catch block
                        }
                        if (o != null) {
                            return o;
                        }
                    }
                    if (WEB_LIB != null || WEB_CLASSES != null) {
                        Object[] o = null;
                        try {
                            o = this.readDir(childs[i], log);
                        }
                        catch (Exception e) {
                        }
                        catch (Throwable e) {
                            // empty catch block
                        }
                        if (o != null) {
                            return o;
                        }
                    }
                    if (EAR != null) {
                        Object[] o = null;
                        try {
                            o = this.readDir(EAR, log);
                        }
                        catch (Exception e) {
                        }
                        catch (Throwable e) {
                            // empty catch block
                        }
                        if (o != null) {
                            return o;
                        }
                    }
                }
                Object[] o = null;
                try {
                    o = this.readDir(childs[i], log);
                }
                catch (Exception e) {
                }
                catch (Throwable e) {
                    // empty catch block
                }
                if (o == null) continue;
                return o;
            }
            Vector<String> entries = new Vector<String>();
            Vector<byte[]> entriesBytes = new Vector<byte[]>();
            for (int i = 0; i < childs.length; ++i) {
                if (childs[i].isDirectory()) {
                    if (childs[i].listFiles() == null || childs[i].listFiles().length <= 0) continue;
                    File[] childsEntries = file.listFiles();
                    try {
                        if (childsEntries == null) continue;
                        for (int j = 0; j < childsEntries.length; ++j) {
                            this.buildEntryNames(childsEntries[j], null, entries, entriesBytes);
                        }
                        continue;
                    }
                    catch (Exception e) {
                        continue;
                    }
                }
                try {
                    entries.add(childs[i].getName());
                    entriesBytes.add(FileSystemUtilities.readBytesFromFile((File)childs[i]));
                    continue;
                }
                catch (Exception e) {
                    // empty catch block
                }
            }
            for (k = 0; k < entries.size(); ++k) {
                extension = "";
                if (((String)entries.get(k)).contains(".")) {
                    extension = ((String)entries.get(k)).substring(((String)entries.get(k)).lastIndexOf(46) + 1, ((String)entries.get(k)).length());
                }
                String nome = ((String)entries.get(k)).replaceAll("/", ".");
                if (extension != null) {
                    extension = "." + extension;
                    nome = nome.substring(0, nome.length() - extension.length());
                }
                try {
                    method = this.getClass().getClassLoader().getClass().getMethod("loadClass", String.class);
                    find = method.invoke((Object)this.getClass().getClassLoader(), ClassLoader.class.getName());
                    c = null;
                    try {
                        c = method.invoke((Object)this.getClass().getClassLoader(), nome);
                    }
                    catch (Exception e) {
                    }
                    catch (Throwable e) {
                        // empty catch block
                    }
                    if (!((Class)find).isAssignableFrom(c)) continue;
                    constructor = ((Class)c).getConstructor(ClassLoader.class);
                    loader = (ClassLoader)constructor.newInstance(this.getClass().getClassLoader());
                    parentDirLoader = nome.split("\\.")[0].trim() + ".";
                    break;
                }
                catch (Exception e) {
                    continue;
                }
                catch (Throwable e) {
                    // empty catch block
                }
            }
            if (loader != null) {
                log.debug((Object)"Loader DIR find (loadClass)");
            }
            if (loader == null) {
                for (k = 0; k < entries.size(); ++k) {
                    extension = "";
                    if (((String)entries.get(k)).contains(".")) {
                        extension = ((String)entries.get(k)).substring(((String)entries.get(k)).lastIndexOf(46) + 1, entries.get(k).length());
                    }
                    String nome = ((String)entries.get(k)).replaceAll("/", ".");
                    if (extension != null) {
                        extension = "." + extension;
                        nome = nome.substring(0, nome.length() - extension.length());
                    }
                    try {
                        method = this.getClass().getClassLoader().getClass().getMethod("loadClass", String.class);
                        find = method.invoke((Object)this.getClass().getClassLoader(), ClassLoader.class.getName());
                        c = null;
                        try {
                            ResourceFinder finder = new ResourceFinder(this.getClass().getClassLoader());
                            c = finder.loadResource(nome, entriesBytes.get(k));
                        }
                        catch (Exception e) {
                        }
                        catch (Throwable e) {
                            // empty catch block
                        }
                        if (c == null || !((Class)find).isAssignableFrom(c)) continue;
                        constructor = ((Class)c).getConstructor(ClassLoader.class, Vector.class, Vector.class, String.class, File.class);
                        parentDirLoader = nome.split("\\.")[0].trim() + ".";
                        loader = (ClassLoader)constructor.newInstance(this.getClass().getClassLoader(), entries, entriesBytes, parentDirLoader, this.archiveFile);
                        break;
                    }
                    catch (Exception e) {
                        continue;
                    }
                    catch (Throwable e) {
                        // empty catch block
                    }
                }
                if (loader != null) {
                    log.debug((Object)"Loader DIR find (ResourceFinder)");
                }
            }
            if (loader == null) {
                for (k = 0; k < entries.size(); ++k) {
                    if (entriesBytes.get(k) == null) continue;
                    File tmp = null;
                    try {
                        Object[] o;
                        tmp = File.createTempFile("PddInterceptor", "PddInterceptor");
                        FileSystemUtilities.writeFile((File)tmp, (byte[])((byte[])entriesBytes.get(k)));
                        if (!JarUtilities.isJar((File)tmp, (boolean)false) || !this.checkFile(tmp) || (o = this.readFile(tmp, log)) == null) continue;
                        Object[] e = o;
                        return e;
                    }
                    catch (Exception e) {
                        continue;
                    }
                    catch (Throwable e) {
                        continue;
                    }
                    finally {
                        try {
                            FileSystemUtilities.deleteDir((File)tmp);
                            tmp.deleteOnExit();
                        }
                        catch (Exception e) {}
                    }
                }
            }
            if (loader != null) {
                Properties opP = null;
                Properties clP = null;
                Properties pddP = null;
                Properties configP = null;
                Properties logP = null;
                Properties msgDiagP = null;
                for (int k4 = 0; k4 < entries.size(); ++k4) {
                    String entryName = (String)entries.get(k4);
                    String extension2 = "";
                    if (entryName.contains(".")) {
                        extension2 = entryName.substring(entryName.lastIndexOf(46) + 1, entryName.length());
                    }
                    String nome = entryName.replaceAll("/", ".");
                    if (extension2 != null) {
                        extension2 = "." + extension2;
                        nome = nome.substring(0, nome.length() - extension2.length());
                    }
                    if (nome.equals(loader.getClass().getName()) || ".".equals(extension2) || !nome.startsWith(parentDirLoader)) continue;
                    Object find2 = null;
                    Object c2 = null;
                    try {
                        log.debug((Object)("Load (DIR) [" + nome + "]..."));
                        Method method2 = loader.getClass().getMethod("loadClass", String.class);
                        find2 = method2.invoke(loader, Properties.class.getName());
                        c2 = method2.invoke(loader, nome);
                        log.debug((Object)("Load (DIR) [" + nome + "] OK"));
                        if (find2 == null) {
                            throw new Exception("find null");
                        }
                        if (c2 == null) {
                            throw new Exception("c null");
                        }
                    }
                    catch (Exception e) {
                        log.debug((Object)("Loader (DIR) instance [" + nome + "] error: " + e.getMessage()), (Throwable)e);
                    }
                    catch (Throwable e) {
                        log.debug((Object)("Loader (DIR) instance [" + nome + "] error: " + e.getMessage()), e);
                    }
                    if (find2 == null || c2 == null) continue;
                    try {
                        Constructor constructor2;
                        Properties properties;
                        Object type;
                        if (!((Class)find2).isAssignableFrom((Class)c2) || (type = (properties = (Properties)(constructor2 = ((Class)c2).getConstructor(new Class[0])).newInstance(new Object[0])).get("type")) == null) continue;
                        if ("openspcoop".equals(type)) {
                            opP = properties;
                            continue;
                        }
                        if ("className".equals(type)) {
                            clP = properties;
                            continue;
                        }
                        if ("pdd".equals(type)) {
                            pddP = properties;
                            continue;
                        }
                        if ("logger".equals(type)) {
                            logP = properties;
                            continue;
                        }
                        if ("config".equals(type)) {
                            configP = properties;
                            continue;
                        }
                        if (!"msgDiagnostici".equals(type)) continue;
                        msgDiagP = properties;
                        continue;
                    }
                    catch (Exception e) {
                        log.debug((Object)("Loader (DIR) instance [" + nome + "] error: " + e.getMessage()), (Throwable)e);
                        continue;
                    }
                    catch (Throwable e) {
                        log.debug((Object)("Loader (DIR) instance [" + nome + "] error: " + e.getMessage()), e);
                    }
                }
                if (opP != null && clP != null && pddP != null && logP != null && configP != null && msgDiagP != null) {
                    Object[] o = new Object[this.RESULT_LENGTH];
                    o[0] = loader;
                    o[1] = opP;
                    o[2] = clP;
                    o[3] = pddP;
                    o[4] = logP;
                    o[5] = configP;
                    o[6] = msgDiagP;
                    for (int i = 0; i < o.length; ++i) {
                        log.debug((Object)("Class (DIR) [" + i + "]=[" + o[i].getClass().getName() + "]"));
                    }
                    return o;
                }
            }
        }
        return null;
    }

    private void buildEntryNames(File file, String prefix, Vector<String> files, Vector<byte[]> entriesBytes) throws Exception {
        String name = null;
        name = prefix != null ? prefix + "." + file.getName() : file.getName();
        if (file.isFile()) {
            files.add(name);
            entriesBytes.add(FileSystemUtilities.readBytesFromFile((File)file));
            return;
        }
        if (file.isDirectory()) {
            File[] childs = file.listFiles();
            if (childs != null) {
                for (int i = 0; i < childs.length; ++i) {
                    this.buildEntryNames(childs[i], name, files, entriesBytes);
                }
            }
        } else {
            return;
        }
    }
}

