/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop.pdd.config;

import java.io.Serializable;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Properties;
import org.apache.jcs.JCS;
import org.apache.jcs.access.exception.CacheException;
import org.apache.jcs.engine.behavior.ICompositeCacheAttributes;
import org.apache.jcs.engine.behavior.IElementAttributes;
import org.apache.log4j.Logger;
import org.openspcoop.dao.commons.IDSoggetto;
import org.openspcoop.dao.config.AccessoConfigurazionePdD;
import org.openspcoop.dao.config.AccessoRegistro;
import org.openspcoop.dao.config.Configurazione;
import org.openspcoop.dao.config.GestioneErrore;
import org.openspcoop.dao.config.PortaApplicativa;
import org.openspcoop.dao.config.PortaDelegata;
import org.openspcoop.dao.config.RoutingTable;
import org.openspcoop.dao.config.ServizioApplicativo;
import org.openspcoop.dao.config.SoggettoSpcoop;
import org.openspcoop.dao.config.driver.DriverConfigurazioneDB;
import org.openspcoop.dao.config.driver.DriverConfigurazioneException;
import org.openspcoop.dao.config.driver.DriverConfigurazioneNotFound;
import org.openspcoop.dao.config.driver.DriverConfigurazioneXML;
import org.openspcoop.dao.config.driver.IDPortaApplicativa;
import org.openspcoop.dao.config.driver.IDPortaDelegata;
import org.openspcoop.dao.config.driver.IDriverConfigurazioneGet;
import org.openspcoop.dao.registry.driver.IDServizio;
import org.openspcoop.pdd.config.ConfigLocalProperties;
import org.openspcoop.pdd.config.OpenSPCoopProperties;
import org.openspcoop.utils.CacheResponse;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConfigurazionePdD {
    private JCS cache = null;
    private IDriverConfigurazioneGet driverConfigurazionePdD;
    private Logger log = null;
    private static Configurazione configurazioneGeneralePdD = null;
    private static GestioneErrore gestioneErroreComponenteCooperazione = null;
    private static GestioneErrore gestioneErroreComponenteIntegrazione = null;
    private static RoutingTable routingTable = null;
    private static AccessoRegistro accessoRegistro = null;
    private boolean configurazioneDinamica = false;
    private OpenSPCoopProperties openspcoopProperties = null;
    private ConfigLocalProperties configLocalProperties = null;

    public void resetCache() throws DriverConfigurazioneException {
        if (this.cache != null) {
            try {
                this.cache.clear();
            }
            catch (Exception e) {
                throw new DriverConfigurazioneException(e.getMessage(), (Throwable)e);
            }
        }
    }

    public void abilitaCache() throws DriverConfigurazioneException {
        if (this.cache != null) {
            throw new DriverConfigurazioneException("Cache gia' abilitata");
        }
        try {
            this.cache = JCS.getInstance((String)"configurazionePdD");
        }
        catch (Exception e) {
            throw new DriverConfigurazioneException(e.getMessage(), (Throwable)e);
        }
    }

    public void abilitaCache(long dimensioneCache, boolean algoritmoCacheLRU, long itemIdleTime, long itemLifeSecond) throws DriverConfigurazioneException {
        if (this.cache != null) {
            throw new DriverConfigurazioneException("Cache gia' abilitata");
        }
        try {
            AccessoConfigurazionePdD accessoConfigurazione = new AccessoConfigurazionePdD();
            accessoConfigurazione.setDimensioneCache(Integer.valueOf((int)dimensioneCache));
            if (algoritmoCacheLRU) {
                accessoConfigurazione.setAlgoritmoCache("lru");
            } else {
                accessoConfigurazione.setAlgoritmoCache("mru");
            }
            accessoConfigurazione.setItemIdleTimeCache(Integer.valueOf((int)itemIdleTime));
            accessoConfigurazione.setItemLifeTimeCache(Integer.valueOf((int)itemLifeSecond));
            this.initCacheConfigurazione(accessoConfigurazione, null);
        }
        catch (Exception e) {
            throw new DriverConfigurazioneException(e.getMessage(), (Throwable)e);
        }
    }

    public void disabilitaCache() throws DriverConfigurazioneException {
        if (this.cache == null) {
            throw new DriverConfigurazioneException("Cache gia' disabilitata");
        }
        try {
            this.cache.clear();
            this.cache = null;
        }
        catch (Exception e) {
            throw new DriverConfigurazioneException(e.getMessage(), (Throwable)e);
        }
    }

    public ConfigurazionePdD(AccessoConfigurazionePdD accessoConfigurazione, Logger alog, Logger alogConsole, Properties localProperties) throws DriverConfigurazioneException {
        try {
            this.openspcoopProperties = OpenSPCoopProperties.getInstance();
            this.configurazioneDinamica = this.openspcoopProperties.isConfigurazioneDinamica();
            this.log = alog != null ? alog : Logger.getLogger((String)"Configurazione della PdD OpenSPCoop");
            String msg = "Leggo configurazione di tipo[" + accessoConfigurazione.getTipo() + "]   location[" + accessoConfigurazione.getLocation() + "]";
            this.log.info((Object)msg);
            if (alogConsole != null) {
                alogConsole.info((Object)msg);
            }
            if ("xml".equalsIgnoreCase(accessoConfigurazione.getTipo())) {
                this.driverConfigurazionePdD = new DriverConfigurazioneXML(accessoConfigurazione.getLocation(), this.log);
                if (this.driverConfigurazionePdD == null || !((DriverConfigurazioneXML)this.driverConfigurazionePdD).create) {
                    throw new DriverConfigurazioneException("Riscontrato errore durante l'inizializzazione della configurazione di tipo " + accessoConfigurazione.getTipo() + " con location: " + accessoConfigurazione.getLocation());
                }
            } else if ("db".equalsIgnoreCase(accessoConfigurazione.getTipo())) {
                this.driverConfigurazionePdD = new DriverConfigurazioneDB(accessoConfigurazione.getLocation(), accessoConfigurazione.getContext(), this.log, accessoConfigurazione.getTipoDatabase(), accessoConfigurazione.isCondivisioneDatabasePddRegistro());
                if (this.driverConfigurazionePdD == null || !((DriverConfigurazioneDB)this.driverConfigurazionePdD).create) {
                    throw new DriverConfigurazioneException("Riscontrato errore durante l'inizializzazione della configurazione di tipo " + accessoConfigurazione.getTipo() + " con location: " + accessoConfigurazione.getLocation());
                }
            } else {
                throw new DriverConfigurazioneException("Riscontrato errore durante l'inizializzazione della configurazione di tipo sconosciuto " + accessoConfigurazione.getTipo() + " con location: " + accessoConfigurazione.getLocation());
            }
            if (accessoConfigurazione.getUtilizzoCache()) {
                this.initCacheConfigurazione(accessoConfigurazione, alogConsole);
            }
            this.configLocalProperties = new ConfigLocalProperties(this.log, this.openspcoopProperties.getRootDirectory(), localProperties);
        }
        catch (Exception e) {
            String msg = "Riscontrato errore durante l'inizializzazione della configurazione di OpenSPCoop: " + e.getMessage();
            this.log.error((Object)msg);
            if (alogConsole != null) {
                alogConsole.info((Object)msg);
            }
            throw new DriverConfigurazioneException("Riscontrato errore durante l'inizializzazione della configurazione di OpenSPCoop: " + e.getMessage());
        }
    }

    private void initCacheConfigurazione(AccessoConfigurazionePdD accessoConfigurazione, Logger alogConsole) throws Exception {
        this.cache = JCS.getInstance((String)"configurazionePdD");
        String msg = null;
        if (accessoConfigurazione.getDimensioneCache() != null || accessoConfigurazione.getAlgoritmoCache() != null) {
            ICompositeCacheAttributes cacheAttr = this.cache.getCacheAttributes();
            if (accessoConfigurazione.getDimensioneCache() != null) {
                try {
                    msg = "Dimensione della cache (ConfigurazionePdD) impostata al valore: " + accessoConfigurazione.getDimensioneCache();
                    this.log.info((Object)msg);
                    if (alogConsole != null) {
                        alogConsole.info((Object)msg);
                    }
                    cacheAttr.setMaxObjects(accessoConfigurazione.getDimensioneCache().intValue());
                }
                catch (Exception error) {
                    throw new DriverConfigurazioneException("Parametro errato per la dimensione della cache (ConfigurazionePdD): " + error.getMessage());
                }
            }
            if (accessoConfigurazione.getAlgoritmoCache() != null) {
                msg = "Algoritmo di cache (ConfigurazionePdD) impostato al valore: " + accessoConfigurazione.getAlgoritmoCache();
                this.log.info((Object)msg);
                if (alogConsole != null) {
                    alogConsole.info((Object)msg);
                }
                if ("mru".equalsIgnoreCase(accessoConfigurazione.getAlgoritmoCache())) {
                    cacheAttr.setCacheName("org.apache.jcs.engine.memory.mru.MRUMemoryCache");
                } else {
                    cacheAttr.setCacheName("org.apache.jcs.engine.memory.lru.LRUMemoryCache");
                }
            }
            this.cache.setCacheAttributes(cacheAttr);
        }
        if (accessoConfigurazione.getItemIdleTimeCache() != null || accessoConfigurazione.getItemLifeTimeCache() != null) {
            IElementAttributes elemAttr = this.cache.getDefaultElementAttributes();
            if (accessoConfigurazione.getItemIdleTimeCache() != null) {
                try {
                    msg = "Attributo 'IdleTime' (ConfigurazionePdD) impostato al valore: " + accessoConfigurazione.getItemIdleTimeCache();
                    this.log.info((Object)msg);
                    if (alogConsole != null) {
                        alogConsole.info((Object)msg);
                    }
                    elemAttr.setIdleTime((long)accessoConfigurazione.getItemIdleTimeCache().intValue());
                }
                catch (Exception error) {
                    throw new DriverConfigurazioneException("Parametro errato per l'attributo 'IdleTime' (ConfigurazionePdD): " + error.getMessage());
                }
            }
            if (accessoConfigurazione.getItemLifeTimeCache() != null) {
                try {
                    msg = "Attributo 'MaxLifeSecond' (ConfigurazionePdD) impostato al valore: " + accessoConfigurazione.getItemLifeTimeCache();
                    this.log.info((Object)msg);
                    if (alogConsole != null) {
                        alogConsole.info((Object)msg);
                    }
                    elemAttr.setMaxLifeSeconds((long)accessoConfigurazione.getItemLifeTimeCache().intValue());
                }
                catch (Exception error) {
                    throw new DriverConfigurazioneException("Parametro errato per l'attributo 'MaxLifeSecond' (ConfigurazionePdD): " + error.getMessage());
                }
            }
            this.cache.setDefaultElementAttributes(elemAttr);
        }
    }

    protected IDriverConfigurazioneGet getDriverConfigurazionePdD() {
        return this.driverConfigurazionePdD;
    }

    public synchronized Object getObjectCache(String keyCache, String methodName, Object ... arguments) throws DriverConfigurazioneException, DriverConfigurazioneNotFound {
        DriverConfigurazioneNotFound dNotFound = null;
        Object obj = null;
        try {
            CacheResponse response;
            if (keyCache == null) {
                throw new DriverConfigurazioneException("[" + methodName + "]: KeyCache non definita");
            }
            if (this.cache != null && (response = (CacheResponse)this.cache.get((Object)keyCache)) != null) {
                if (response.getObject() != null) {
                    this.log.debug((Object)("Oggetto (tipo:" + response.getObject().getClass().getName() + ") con chiave [" + keyCache + "] (methodo:" + methodName + ") in cache."));
                    return response.getObject();
                }
                if (response.getException() != null) {
                    this.log.debug((Object)("Eccezione (tipo:" + response.getException().getClass().getName() + ") con chiave [" + keyCache + "] (methodo:" + methodName + ") in cache."));
                    throw (Exception)response.getException();
                }
                this.log.error((Object)"In cache non e' presente ne un oggetto ne un'eccezione.");
            }
            this.log.debug((Object)("oggetto con chiave [" + keyCache + "] (methodo:" + methodName + ") ricerco nella configurazione..."));
            try {
                obj = this.getObject(methodName, arguments);
            }
            catch (DriverConfigurazioneNotFound e) {
                dNotFound = e;
            }
            if (this.cache != null) {
                if (dNotFound != null) {
                    this.log.info((Object)("Aggiungo eccezione not found [" + keyCache + "] in cache"));
                } else if (obj != null) {
                    this.log.info((Object)("Aggiungo oggetto [" + keyCache + "] in cache"));
                } else {
                    throw new Exception("Metodo (" + methodName + ") ha ritornato un valore null");
                }
                try {
                    CacheResponse responseCache = new CacheResponse();
                    if (dNotFound != null) {
                        responseCache.setException((Serializable)((Object)dNotFound));
                    } else {
                        responseCache.setObject((Serializable)obj);
                    }
                    this.cache.put((Object)keyCache, (Object)responseCache);
                }
                catch (CacheException e) {
                    this.log.error((Object)("Errore durante l'inserimento in cache [" + keyCache + "]: " + e.getMessage()));
                }
            }
        }
        catch (DriverConfigurazioneException e) {
            throw e;
        }
        catch (DriverConfigurazioneNotFound e) {
            throw e;
        }
        catch (Exception e) {
            if (DriverConfigurazioneNotFound.class.getName().equals(e.getClass().getName())) {
                throw (DriverConfigurazioneNotFound)((Object)e);
            }
            throw new DriverConfigurazioneException("Configurazione, Algoritmo di Cache fallito: " + e.getMessage(), (Throwable)e);
        }
        if (dNotFound != null) {
            throw dNotFound;
        }
        return obj;
    }

    public Object getObject(String methodName, Object ... arguments) throws DriverConfigurazioneException, DriverConfigurazioneNotFound {
        DriverConfigurazioneNotFound notFound;
        Object obj;
        block30: {
            obj = null;
            notFound = null;
            this.log.debug((Object)"Cerco nella configurazione");
            try {
                IDriverConfigurazioneGet driver = this.driverConfigurazionePdD;
                this.log.debug((Object)("invocazione metodo [" + methodName + "]..."));
                if (arguments.length == 0) {
                    Method method = driver.getClass().getMethod(methodName, new Class[0]);
                    obj = method.invoke((Object)driver, new Object[0]);
                    break block30;
                }
                if (arguments.length == 1) {
                    Method method = driver.getClass().getMethod(methodName, arguments[0].getClass());
                    obj = method.invoke((Object)driver, arguments[0]);
                    break block30;
                }
                if (arguments.length == 2) {
                    Method method = driver.getClass().getMethod(methodName, arguments[0].getClass(), arguments[1].getClass());
                    obj = method.invoke((Object)driver, arguments[0], arguments[1]);
                    break block30;
                }
                if (arguments.length == 3) {
                    Method method = driver.getClass().getMethod(methodName, arguments[0].getClass(), arguments[1].getClass(), arguments[2].getClass());
                    obj = method.invoke((Object)driver, arguments[0], arguments[1], arguments[2]);
                    break block30;
                }
                throw new Exception("Troppi argomenti per gestire la chiamata del metodo");
            }
            catch (DriverConfigurazioneNotFound e) {
                this.log.debug((Object)("Ricerca nella configurazione non riuscita (metodo [" + methodName + "]): " + e.getMessage()));
                notFound = e;
            }
            catch (InvocationTargetException e) {
                if (e.getTargetException() != null) {
                    if (DriverConfigurazioneNotFound.class.getName().equals(e.getTargetException().getClass().getName())) {
                        this.log.debug((Object)("Ricerca nella configurazione non riuscita [NotFound] (metodo [" + methodName + "]): " + e.getTargetException().getMessage()));
                        notFound = new DriverConfigurazioneNotFound(e.getTargetException().getMessage(), e.getTargetException());
                    }
                    if (DriverConfigurazioneException.class.getName().equals(e.getTargetException().getClass().getName())) {
                        this.log.debug((Object)("Ricerca nella configurazione non riuscita [DriverException] (metodo [" + methodName + "]): " + e.getTargetException().getMessage()), e.getTargetException());
                        throw new DriverConfigurazioneException(e.getTargetException().getMessage(), e.getTargetException());
                    }
                    this.log.debug((Object)("Ricerca nella configurazione non riuscita [InvTargetExcp.getTarget] (metodo [" + methodName + "]), " + e.getTargetException().getMessage()), e.getTargetException());
                    throw new DriverConfigurazioneException(e.getTargetException().getMessage(), e.getTargetException());
                }
                this.log.debug((Object)("Ricerca nella configurazione non riuscita [InvTargetExcp] (metodo [" + methodName + "]), " + e.getMessage()), (Throwable)e);
                throw new DriverConfigurazioneException(e.getMessage(), (Throwable)e);
            }
            catch (Exception e) {
                this.log.debug((Object)("ricerca nella configurazione non riuscita (metodo [" + methodName + "]), " + e.getMessage()), (Throwable)e);
                throw new DriverConfigurazioneException(e.getMessage(), (Throwable)e);
            }
        }
        if (notFound != null) {
            try {
                if ("getGestioneErroreComponenteCooperazione".equals(methodName)) {
                    obj = this.configLocalProperties.updateGestioneErroreCooperazione(null);
                } else if ("getGestioneErroreComponenteIntegrazione".equals(methodName)) {
                    obj = this.configLocalProperties.updateGestioneErroreIntegrazione(null);
                }
            }
            catch (Exception e) {
                this.log.debug((Object)("Refresh nella configurazione locale non riuscita (metodo [" + methodName + "]): " + e.getMessage()));
                throw new DriverConfigurazioneException(e.getMessage(), (Throwable)e);
            }
            if (obj == null) {
                throw notFound;
            }
        } else {
            try {
                if ("getRoutingTable".equals(methodName)) {
                    obj = this.configLocalProperties.updateRouting((RoutingTable)obj);
                } else if ("getAccessoRegistro".equals(methodName)) {
                    obj = this.configLocalProperties.updateAccessoRegistro((AccessoRegistro)obj);
                } else if ("getGestioneErroreComponenteCooperazione".equals(methodName)) {
                    obj = this.configLocalProperties.updateGestioneErroreCooperazione((GestioneErrore)obj);
                } else if ("getGestioneErroreComponenteIntegrazione".equals(methodName)) {
                    obj = this.configLocalProperties.updateGestioneErroreIntegrazione((GestioneErrore)obj);
                } else if ("getConfigurazioneGenerale".equals(methodName)) {
                    obj = this.configLocalProperties.updateConfigurazione((Configurazione)obj);
                }
            }
            catch (Exception e) {
                this.log.debug((Object)("Refresh nella configurazione locale non riuscita (metodo [" + methodName + "]): " + e.getMessage()));
                throw new DriverConfigurazioneException(e.getMessage(), (Throwable)e);
            }
        }
        this.log.debug((Object)("invocazione metodo [" + methodName + "] completata."));
        return obj;
    }

    public SoggettoSpcoop getSoggetto(IDSoggetto aSoggetto) throws DriverConfigurazioneException, DriverConfigurazioneNotFound {
        CacheResponse response;
        if (aSoggetto == null || aSoggetto.getNome() == null || aSoggetto.getTipo() == null) {
            throw new DriverConfigurazioneException("[getSoggetto]: Parametro non definito");
        }
        String key = null;
        if (this.cache != null && (response = (CacheResponse)this.cache.get((Object)(key = "getSoggetto_" + aSoggetto.getTipo() + aSoggetto.getNome()))) != null) {
            if (response.getException() != null) {
                if (DriverConfigurazioneNotFound.class.getName().equals(response.getException().getClass().getName())) {
                    throw (DriverConfigurazioneNotFound)((Object)response.getException());
                }
                throw (DriverConfigurazioneException)((Object)response.getException());
            }
            return (SoggettoSpcoop)response.getObject();
        }
        SoggettoSpcoop sogg = null;
        sogg = this.cache != null ? (SoggettoSpcoop)this.getObjectCache(key, "getSoggetto", aSoggetto) : (SoggettoSpcoop)this.getObject("getSoggetto", aSoggetto);
        if (sogg != null) {
            return sogg;
        }
        throw new DriverConfigurazioneNotFound("[getSoggetto] Soggetto non Trovato");
    }

    public SoggettoSpcoop getSoggetto(String location) throws DriverConfigurazioneException, DriverConfigurazioneNotFound {
        CacheResponse response;
        if (location == null) {
            throw new DriverConfigurazioneException("[getSoggetto(Location)]: Parametro non definito");
        }
        String key = null;
        if (this.cache != null && (response = (CacheResponse)this.cache.get((Object)(key = "getSoggetto(location)_" + location))) != null) {
            if (response.getException() != null) {
                if (DriverConfigurazioneNotFound.class.getName().equals(response.getException().getClass().getName())) {
                    throw (DriverConfigurazioneNotFound)((Object)response.getException());
                }
                throw (DriverConfigurazioneException)((Object)response.getException());
            }
            return (SoggettoSpcoop)response.getObject();
        }
        SoggettoSpcoop sogg = null;
        sogg = this.cache != null ? (SoggettoSpcoop)this.getObjectCache(key, "getSoggetto", location) : (SoggettoSpcoop)this.getObject("getSoggetto", location);
        if (sogg != null) {
            return sogg;
        }
        throw new DriverConfigurazioneNotFound("[getSoggetto(location)] Soggetto non Trovato");
    }

    public SoggettoSpcoop getRouter() throws DriverConfigurazioneException, DriverConfigurazioneNotFound {
        CacheResponse response;
        String key = null;
        if (this.cache != null && (response = (CacheResponse)this.cache.get((Object)(key = "getRouter"))) != null) {
            if (response.getException() != null) {
                if (DriverConfigurazioneNotFound.class.getName().equals(response.getException().getClass().getName())) {
                    throw (DriverConfigurazioneNotFound)((Object)response.getException());
                }
                throw (DriverConfigurazioneException)((Object)response.getException());
            }
            return (SoggettoSpcoop)response.getObject();
        }
        SoggettoSpcoop sogg = null;
        sogg = this.cache != null ? (SoggettoSpcoop)this.getObjectCache(key, "getRouter", new Object[0]) : (SoggettoSpcoop)this.getObject("getRouter", new Object[0]);
        if (sogg != null) {
            return sogg;
        }
        throw new DriverConfigurazioneNotFound("[getRouter] Soggetto non Trovato");
    }

    public HashSet<String> getSoggettiVirtuali() throws DriverConfigurazioneException, DriverConfigurazioneNotFound {
        CacheResponse response;
        String key = null;
        if (this.cache != null && (response = (CacheResponse)this.cache.get((Object)(key = "getSoggettiVirtuali"))) != null) {
            if (response.getException() != null) {
                if (DriverConfigurazioneNotFound.class.getName().equals(response.getException().getClass().getName())) {
                    throw (DriverConfigurazioneNotFound)((Object)response.getException());
                }
                throw (DriverConfigurazioneException)((Object)response.getException());
            }
            return (HashSet)response.getObject();
        }
        HashSet lista = null;
        lista = this.cache != null ? (HashSet)this.getObjectCache(key, "getSoggettiVirtuali", new Object[0]) : (HashSet)this.getObject("getSoggettiVirtuali", new Object[0]);
        if (lista != null) {
            return lista;
        }
        throw new DriverConfigurazioneNotFound("[getSoggettiVirtuali] Lista Soggetti Virtuali non costruita");
    }

    public HashSet<IDServizio> getServizi_SoggettiVirtuali() throws DriverConfigurazioneException, DriverConfigurazioneNotFound {
        CacheResponse response;
        String key = null;
        if (this.cache != null && (response = (CacheResponse)this.cache.get((Object)(key = "getServizi_SoggettiVirtuali"))) != null) {
            if (response.getException() != null) {
                if (DriverConfigurazioneNotFound.class.getName().equals(response.getException().getClass().getName())) {
                    throw (DriverConfigurazioneNotFound)((Object)response.getException());
                }
                throw (DriverConfigurazioneException)((Object)response.getException());
            }
            return (HashSet)response.getObject();
        }
        HashSet lista = null;
        lista = this.cache != null ? (HashSet)this.getObjectCache(key, "getServizi_SoggettiVirtuali", new Object[0]) : (HashSet)this.getObject("getServizi_SoggettiVirtuali", new Object[0]);
        if (lista != null) {
            return lista;
        }
        throw new DriverConfigurazioneNotFound("[getServizi_SoggettiVirtuali] Lista Servizi erogati da Soggetti Virtuali non costruita");
    }

    public PortaDelegata getPortaDelegata(IDPortaDelegata idPD) throws DriverConfigurazioneException, DriverConfigurazioneNotFound {
        CacheResponse response;
        if (idPD == null) {
            throw new DriverConfigurazioneException("[getPortaDelegata]: Parametro non definito (idPD)");
        }
        if (idPD.getLocationPD() == null) {
            throw new DriverConfigurazioneException("[getPortaDelegata]: Parametro non definito (location)");
        }
        if (idPD.getSoggettoFruitore() == null) {
            throw new DriverConfigurazioneException("[getPortaDelegata]: Parametro non definito (soggettoFruitore is null)");
        }
        if (idPD.getSoggettoFruitore().getTipo() == null || idPD.getSoggettoFruitore().getNome() == null) {
            throw new DriverConfigurazioneException("[getPortaDelegata]: Parametro non definito (soggettoFruitore is null tipo[" + idPD.getSoggettoFruitore().getTipo() + "] nome[" + idPD.getSoggettoFruitore().getNome() + "])");
        }
        String key = null;
        if (this.cache != null && (response = (CacheResponse)this.cache.get((Object)(key = "getPortaDelegata_" + idPD.getLocationPD() + "_" + idPD.getSoggettoFruitore().getTipo() + idPD.getSoggettoFruitore().getNome()))) != null) {
            if (response.getException() != null) {
                if (DriverConfigurazioneNotFound.class.getName().equals(response.getException().getClass().getName())) {
                    throw (DriverConfigurazioneNotFound)((Object)response.getException());
                }
                throw (DriverConfigurazioneException)((Object)response.getException());
            }
            return (PortaDelegata)response.getObject();
        }
        PortaDelegata pd = null;
        pd = this.cache != null ? (PortaDelegata)this.getObjectCache(key, "getPortaDelegata", idPD) : (PortaDelegata)this.getObject("getPortaDelegata", idPD);
        if (pd != null) {
            return pd;
        }
        throw new DriverConfigurazioneNotFound("[getPortaDelegata] PD non trovata");
    }

    private String toStringFiltriProprieta(Hashtable<String, String> filtroProprietaPorteApplicative) {
        StringBuffer bf = new StringBuffer();
        if (filtroProprietaPorteApplicative == null || filtroProprietaPorteApplicative.size() <= 0) {
            bf.append("Non presenti");
        } else {
            Enumeration<String> keys = filtroProprietaPorteApplicative.keys();
            while (keys.hasMoreElements()) {
                bf.append("\n");
                String key = keys.nextElement();
                bf.append(key + " = " + filtroProprietaPorteApplicative.get(key));
            }
        }
        return bf.toString();
    }

    private boolean checkProprietaFiltroPortaApplicativa(PortaApplicativa pa, Hashtable<String, String> proprietaPresentiBustaRicevuta) {
        boolean filtriPAPresenti = false;
        if (proprietaPresentiBustaRicevuta != null && proprietaPresentiBustaRicevuta.size() > 0) {
            for (int i = 0; i < pa.sizeSetSpcoopPropertyList(); ++i) {
                String nome = pa.getSetSpcoopProperty(i).getNome();
                String value = pa.getSetSpcoopProperty(i).getValore();
                this.log.debug((Object)("SPCoopProperty della PA[" + pa.getNome() + "] nome[" + nome + "] valore[" + value + "]"));
                if (value.indexOf("!#!") == -1) continue;
                filtriPAPresenti = true;
                String[] split = value.split("!#!");
                if (split == null || split.length != 2) continue;
                String operatoreP = split[1].trim();
                String valoreP = split[0].trim();
                String proprietaArrivata = proprietaPresentiBustaRicevuta.get(nome);
                this.log.debug((Object)("SPCoopProperty della PA[" + pa.getNome() + "] nome[" + nome + "] valore[" + value + "] interpretata come [" + nome + "][" + operatoreP + "][" + valoreP + "]. Viene utilizzata per la proprieta' della busta con valore [" + proprietaArrivata + "]"));
                if (proprietaArrivata == null) continue;
                proprietaArrivata = proprietaArrivata.trim();
                if ("=".equals(operatoreP)) {
                    if (!proprietaArrivata.equals(valoreP)) continue;
                    return true;
                }
                if (">".equals(operatoreP)) {
                    if (proprietaArrivata.compareTo(valoreP) <= 0) continue;
                    return true;
                }
                if (">=".equals(operatoreP)) {
                    if (proprietaArrivata.compareTo(valoreP) < 0) continue;
                    return true;
                }
                if ("<".equals(operatoreP)) {
                    if (proprietaArrivata.compareTo(valoreP) >= 0) continue;
                    return true;
                }
                if ("<=".equals(operatoreP)) {
                    if (proprietaArrivata.compareTo(valoreP) > 0) continue;
                    return true;
                }
                if ("<>".equals(operatoreP)) {
                    if (proprietaArrivata.equals(valoreP)) continue;
                    return true;
                }
                if ("like".equalsIgnoreCase(operatoreP)) {
                    String valoreMatch = valoreP.replaceAll("%", "");
                    int indexExpr = proprietaArrivata.indexOf(valoreMatch);
                    if (indexExpr < 0) continue;
                    return true;
                }
                this.log.error((Object)("[checkProprietaFiltroPortaApplicativa] Operator [" + operatoreP + "] non supportato per le spcoop properties..."));
            }
        } else {
            for (int i = 0; i < pa.sizeSetSpcoopPropertyList(); ++i) {
                String nome = pa.getSetSpcoopProperty(i).getNome();
                String value = pa.getSetSpcoopProperty(i).getValore();
                this.log.debug((Object)("SPCoopProperty della PA[" + pa.getNome() + "] nome[" + nome + "] valore[" + value + "]"));
                if (value.indexOf("!#!") == -1) continue;
                this.log.debug((Object)("SPCoopProperty della PA[" + pa.getNome() + "] nome[" + nome + "] valore[" + value + "] contiene una richiesta di filtro, siccome la busta arrivata non contiene proprieta', la PA non ha diritto a riceverla."));
                filtriPAPresenti = true;
                break;
            }
        }
        return !filtriPAPresenti;
    }

    public PortaApplicativa getPortaApplicativa(IDPortaApplicativa idPA, Hashtable<String, String> proprietaPresentiBustaRicevuta) throws DriverConfigurazioneException, DriverConfigurazioneNotFound {
        if (idPA == null) {
            throw new DriverConfigurazioneException("[getPortaApplicativa]: Parametro non definito (idPA is null)");
        }
        if (idPA.getIDServizio() == null) {
            throw new DriverConfigurazioneException("[getPortaApplicativa]: Parametro non definito (idPA.getIDServizio() is null)");
        }
        if (idPA.getIDServizio().getServizio() == null || idPA.getIDServizio().getTipoServizio() == null) {
            throw new DriverConfigurazioneException("[getPortaApplicativa]: Parametro non definito (tipoServizio=[" + idPA.getIDServizio().getTipoServizio() + "] servizio=[" + idPA.getIDServizio().getServizio() + "])");
        }
        if (idPA.getIDServizio().getSoggettoErogatore() == null) {
            throw new DriverConfigurazioneException("[getPortaApplicativa]: Parametro non definito (idPA.getIDServizio().getSoggettoErogatore() is null)");
        }
        if (idPA.getIDServizio().getSoggettoErogatore().getTipo() == null || idPA.getIDServizio().getSoggettoErogatore().getNome() == null) {
            throw new DriverConfigurazioneException("[getPortaApplicativa]: Parametro non definito (tipoSoggetto=[" + idPA.getIDServizio().getSoggettoErogatore().getTipo() + "] servizio=[" + idPA.getIDServizio().getSoggettoErogatore().getNome() + "])");
        }
        String key = null;
        if (this.cache != null) {
            CacheResponse response;
            key = "getPortaApplicativa_" + idPA.getIDServizio().getSoggettoErogatore().getTipo() + idPA.getIDServizio().getSoggettoErogatore().getNome() + "_" + idPA.getIDServizio().getTipoServizio() + idPA.getIDServizio().getServizio();
            if (idPA.getIDServizio().getAzione() != null) {
                key = key + "_" + idPA.getIDServizio().getAzione();
            }
            if ((response = (CacheResponse)this.cache.get((Object)key)) != null) {
                if (response.getException() != null) {
                    if (DriverConfigurazioneNotFound.class.getName().equals(response.getException().getClass().getName())) {
                        throw (DriverConfigurazioneNotFound)((Object)response.getException());
                    }
                    throw (DriverConfigurazioneException)((Object)response.getException());
                }
                PortaApplicativa pa = (PortaApplicativa)response.getObject();
                if (pa != null) {
                    return pa;
                }
            }
        }
        PortaApplicativa pa = null;
        pa = this.cache != null ? (PortaApplicativa)this.getObjectCache(key, "getPortaApplicativa", idPA) : (PortaApplicativa)this.getObject("getPortaApplicativa", idPA);
        if (pa != null) {
            return pa;
        }
        throw new DriverConfigurazioneNotFound("[getPortaApplicativa] PA non trovata");
    }

    public Hashtable<IDSoggetto, PortaApplicativa> getPorteApplicative_SoggettiVirtuali(IDPortaApplicativa idPA, Hashtable<String, String> proprietaPresentiBustaRicevuta, boolean useFiltroProprieta) throws DriverConfigurazioneException, DriverConfigurazioneNotFound {
        if (idPA == null || idPA.getIDServizio() == null || idPA.getIDServizio().getServizio() == null || idPA.getIDServizio().getTipoServizio() == null || idPA.getIDServizio().getSoggettoErogatore() == null || idPA.getIDServizio().getSoggettoErogatore().getTipo() == null || idPA.getIDServizio().getSoggettoErogatore().getNome() == null) {
            throw new DriverConfigurazioneException("[getPorteApplicative_SoggettiVirtuali]: Parametro non definito");
        }
        String key = null;
        if (this.cache != null) {
            CacheResponse response;
            this.log.debug((Object)"Search porte applicative soggetti virtuali in cache...");
            key = "getPorteApplicative_SoggettiVirtuali_" + idPA.getIDServizio().getSoggettoErogatore().getTipo() + idPA.getIDServizio().getSoggettoErogatore().getNome() + "_" + idPA.getIDServizio().getTipoServizio() + idPA.getIDServizio().getServizio();
            if (idPA.getIDServizio().getAzione() != null) {
                key = key + "_" + idPA.getIDServizio().getAzione();
            }
            if ((response = (CacheResponse)this.cache.get((Object)key)) != null) {
                if (response.getException() != null) {
                    if (DriverConfigurazioneNotFound.class.getName().equals(response.getException().getClass().getName())) {
                        throw (DriverConfigurazioneNotFound)((Object)response.getException());
                    }
                    throw (DriverConfigurazioneException)((Object)response.getException());
                }
                if (response.getObject() != null) {
                    this.log.debug((Object)("Oggetto in cache trovato. Analizzo porte virtuali trovate rispetto alle proprieta' presenti nella busta arrivata: " + this.toStringFiltriProprieta(proprietaPresentiBustaRicevuta)));
                    Hashtable pa = (Hashtable)response.getObject();
                    Hashtable<IDSoggetto, PortaApplicativa> paChecked = new Hashtable<IDSoggetto, PortaApplicativa>();
                    Enumeration enumer = pa.keys();
                    while (enumer.hasMoreElements()) {
                        IDSoggetto idS = (IDSoggetto)enumer.nextElement();
                        PortaApplicativa paC = (PortaApplicativa)pa.get(idS);
                        this.log.debug((Object)("Analizzo pa [" + paC.getNome() + "] del soggetto [" + idS.toString() + "]..."));
                        if (useFiltroProprieta) {
                            boolean ricezioneAutorizzata = this.checkProprietaFiltroPortaApplicativa(paC, proprietaPresentiBustaRicevuta);
                            if (ricezioneAutorizzata) {
                                this.log.debug((Object)("Filtri matchano le spcoop properties della pa [" + paC.getNome() + "] del soggetto [" + idS.toString() + "]"));
                                paChecked.put(idS, paC);
                                continue;
                            }
                            this.log.debug((Object)("Filtri non matchano le spcoop properties della pa [" + paC.getNome() + "] del soggetto [" + idS.toString() + "]"));
                            continue;
                        }
                        this.log.debug((Object)("Invocazione metodo senza la richiesta di filtro per proprieta, aggiunta pa [" + paC.getNome() + "] del soggetto [" + idS.toString() + "]"));
                        paChecked.put(idS, paC);
                    }
                    if (paChecked.size() > 0) {
                        return paChecked;
                    }
                }
            }
        }
        Hashtable pa = null;
        pa = this.cache != null ? (Hashtable)this.getObjectCache(key, "getPorteApplicative_SoggettiVirtuali", idPA) : (Hashtable)this.getObject("getPorteApplicative_SoggettiVirtuali", idPA);
        if (pa != null) {
            this.log.debug((Object)("Oggetto trovato. Analizzo porte virtuali trovate rispetto alle proprieta' presenti nella busta arrivata: " + this.toStringFiltriProprieta(proprietaPresentiBustaRicevuta)));
            Hashtable<IDSoggetto, PortaApplicativa> paChecked = new Hashtable<IDSoggetto, PortaApplicativa>();
            Enumeration enumer = pa.keys();
            while (enumer.hasMoreElements()) {
                IDSoggetto idS = (IDSoggetto)enumer.nextElement();
                PortaApplicativa paC = (PortaApplicativa)pa.get(idS);
                this.log.debug((Object)("Analizzo pa [" + paC.getNome() + "] del soggetto [" + idS.toString() + "]..."));
                if (useFiltroProprieta) {
                    boolean ricezioneAutorizzata = this.checkProprietaFiltroPortaApplicativa(paC, proprietaPresentiBustaRicevuta);
                    if (ricezioneAutorizzata) {
                        this.log.debug((Object)("Filtri matchano le spcoop properties della pa [" + paC.getNome() + "] del soggetto [" + idS.toString() + "]"));
                        paChecked.put(idS, paC);
                        continue;
                    }
                    this.log.debug((Object)("Filtri non matchano le spcoop properties della pa [" + paC.getNome() + "] del soggetto [" + idS.toString() + "]"));
                    continue;
                }
                this.log.debug((Object)("Invocazione metodo senza la richiesta di filtro per proprieta, aggiunta pa [" + paC.getNome() + "] del soggetto [" + idS.toString() + "]"));
                paChecked.put(idS, paC);
            }
            if (paChecked.size() > 0) {
                return paChecked;
            }
        }
        throw new DriverConfigurazioneNotFound("[getPorteApplicative_SoggettiVirtuali] PA_SoggettiVirtuali non trovati");
    }

    public ServizioApplicativo getServizioApplicativo(IDPortaDelegata idPD, String servizioApplicativo) throws DriverConfigurazioneException, DriverConfigurazioneNotFound {
        CacheResponse response;
        if (idPD == null) {
            throw new DriverConfigurazioneException("[getServizioApplicativo]: Parametro non definito (idPD)");
        }
        if (idPD.getLocationPD() == null) {
            throw new DriverConfigurazioneException("[getServizioApplicativo]: Parametro non definito (location)");
        }
        if (idPD.getSoggettoFruitore() == null || idPD.getSoggettoFruitore().getTipo() == null || idPD.getSoggettoFruitore().getNome() == null) {
            throw new DriverConfigurazioneException("[getServizioApplicativo]: Parametro non definito (soggetto fruitore)");
        }
        if (servizioApplicativo == null) {
            throw new DriverConfigurazioneException("[getServizioApplicativo]: Parametro non definito (servizioApplicativo)");
        }
        String key = null;
        if (this.cache != null && (response = (CacheResponse)this.cache.get((Object)(key = "getServizioApplicativo_" + idPD.getLocationPD() + "_" + idPD.getSoggettoFruitore().getTipo() + idPD.getSoggettoFruitore().getNome() + "_" + servizioApplicativo))) != null) {
            if (response.getException() != null) {
                if (DriverConfigurazioneNotFound.class.getName().equals(response.getException().getClass().getName())) {
                    throw (DriverConfigurazioneNotFound)((Object)response.getException());
                }
                throw (DriverConfigurazioneException)((Object)response.getException());
            }
            return (ServizioApplicativo)response.getObject();
        }
        ServizioApplicativo s = null;
        s = this.cache != null ? (ServizioApplicativo)this.getObjectCache(key, "getServizioApplicativo", idPD, servizioApplicativo) : (ServizioApplicativo)this.getObject("getServizioApplicativo", idPD, servizioApplicativo);
        if (s != null) {
            return s;
        }
        throw new DriverConfigurazioneNotFound("[getServizioApplicativo] Servizio Applicativo non trovato");
    }

    public ServizioApplicativo getServizioApplicativo(IDPortaApplicativa idPA, String servizioApplicativo) throws DriverConfigurazioneException, DriverConfigurazioneNotFound {
        if (idPA == null || idPA.getIDServizio() == null || idPA.getIDServizio().getServizio() == null || idPA.getIDServizio().getTipoServizio() == null || idPA.getIDServizio().getSoggettoErogatore() == null || idPA.getIDServizio().getSoggettoErogatore().getTipo() == null || idPA.getIDServizio().getSoggettoErogatore().getNome() == null || servizioApplicativo == null) {
            throw new DriverConfigurazioneException("[getServizioApplicativo]: Parametro non definito");
        }
        String key = null;
        if (this.cache != null) {
            CacheResponse response;
            key = "getServizioApplicativo_" + idPA.getIDServizio().getSoggettoErogatore().getTipo() + idPA.getIDServizio().getSoggettoErogatore().getNome() + "_" + idPA.getIDServizio().getTipoServizio() + idPA.getIDServizio().getServizio();
            if (idPA.getIDServizio().getAzione() != null) {
                key = key + "_" + idPA.getIDServizio().getAzione();
            }
            if ((response = (CacheResponse)this.cache.get((Object)(key = key + "_SA:" + servizioApplicativo))) != null) {
                if (response.getException() != null) {
                    if (DriverConfigurazioneNotFound.class.getName().equals(response.getException().getClass().getName())) {
                        throw (DriverConfigurazioneNotFound)((Object)response.getException());
                    }
                    throw (DriverConfigurazioneException)((Object)response.getException());
                }
                return (ServizioApplicativo)response.getObject();
            }
        }
        ServizioApplicativo s = null;
        s = this.cache != null ? (ServizioApplicativo)this.getObjectCache(key, "getServizioApplicativo", idPA, servizioApplicativo) : (ServizioApplicativo)this.getObject("getServizioApplicativo", idPA, servizioApplicativo);
        if (s != null) {
            return s;
        }
        throw new DriverConfigurazioneNotFound("[getServizioApplicativo] Servizio Applicativo non trovato");
    }

    public ServizioApplicativo getServizioApplicativoAutenticato(IDPortaDelegata idPD, String aUser, String aPassword) throws DriverConfigurazioneException, DriverConfigurazioneNotFound {
        if (aUser == null || aPassword == null) {
            throw new DriverConfigurazioneException("[getServizioApplicativoAutenticato]: Parametro non definito");
        }
        String key = null;
        if (this.cache != null) {
            CacheResponse response;
            key = "getServizioApplicativoAutenticatoBASIC";
            if (idPD != null && idPD.getLocationPD() != null) {
                key = key + "_" + idPD.getLocationPD();
            }
            if (idPD != null && idPD.getSoggettoFruitore() != null) {
                key = key + "_" + idPD.getSoggettoFruitore().getTipo() + idPD.getSoggettoFruitore().getNome();
            }
            if ((response = (CacheResponse)this.cache.get((Object)(key = key + "_" + aUser + "_" + aPassword))) != null) {
                if (response.getException() != null) {
                    if (DriverConfigurazioneNotFound.class.getName().equals(response.getException().getClass().getName())) {
                        throw (DriverConfigurazioneNotFound)((Object)response.getException());
                    }
                    throw (DriverConfigurazioneException)((Object)response.getException());
                }
                return (ServizioApplicativo)response.getObject();
            }
        }
        ServizioApplicativo s = null;
        s = this.cache != null ? (ServizioApplicativo)this.getObjectCache(key, "getServizioApplicativoAutenticato", idPD, aUser, aPassword) : (ServizioApplicativo)this.getObject("getServizioApplicativoAutenticato", idPD, aUser, aPassword);
        if (s != null) {
            return s;
        }
        throw new DriverConfigurazioneNotFound("[getServizioApplicativoAutenticato] Servizio Applicativo non trovato");
    }

    public ServizioApplicativo getServizioApplicativoAutenticato(String aUser, String aPassword) throws DriverConfigurazioneException, DriverConfigurazioneNotFound {
        if (aUser == null || aPassword == null) {
            throw new DriverConfigurazioneException("[getServizioApplicativoAutenticato]: Parametro non definito");
        }
        String key = null;
        if (this.cache != null) {
            key = "getServizioApplicativoAutenticatoBASIC";
            CacheResponse response = (CacheResponse)this.cache.get((Object)(key = key + "_" + aUser + "_" + aPassword));
            if (response != null) {
                if (response.getException() != null) {
                    if (DriverConfigurazioneNotFound.class.getName().equals(response.getException().getClass().getName())) {
                        throw (DriverConfigurazioneNotFound)((Object)response.getException());
                    }
                    throw (DriverConfigurazioneException)((Object)response.getException());
                }
                return (ServizioApplicativo)response.getObject();
            }
        }
        ServizioApplicativo s = null;
        s = this.cache != null ? (ServizioApplicativo)this.getObjectCache(key, "getServizioApplicativoAutenticato", aUser, aPassword) : (ServizioApplicativo)this.getObject("getServizioApplicativoAutenticato", aUser, aPassword);
        if (s != null) {
            return s;
        }
        throw new DriverConfigurazioneNotFound("[getServizioApplicativoAutenticato] Servizio Applicativo non trovato");
    }

    public ServizioApplicativo getServizioApplicativoAutenticato(IDPortaDelegata idPD, String aSubject) throws DriverConfigurazioneException, DriverConfigurazioneNotFound {
        if (aSubject == null) {
            throw new DriverConfigurazioneException("[getServizioApplicativoAutenticato]: Parametro non definito");
        }
        String key = null;
        if (this.cache != null) {
            CacheResponse response;
            key = "getServizioApplicativoAutenticatoSSL";
            if (idPD != null && idPD.getLocationPD() != null) {
                key = key + "_" + idPD.getLocationPD();
            }
            if (idPD != null && idPD.getSoggettoFruitore() != null) {
                key = key + "_" + idPD.getSoggettoFruitore().getTipo() + idPD.getSoggettoFruitore().getNome();
            }
            if ((response = (CacheResponse)this.cache.get((Object)(key = key + "_" + aSubject))) != null) {
                if (response.getException() != null) {
                    if (DriverConfigurazioneNotFound.class.getName().equals(response.getException().getClass().getName())) {
                        throw (DriverConfigurazioneNotFound)((Object)response.getException());
                    }
                    throw (DriverConfigurazioneException)((Object)response.getException());
                }
                return (ServizioApplicativo)response.getObject();
            }
        }
        ServizioApplicativo s = null;
        s = this.cache != null ? (ServizioApplicativo)this.getObjectCache(key, "getServizioApplicativoAutenticato", idPD, aSubject) : (ServizioApplicativo)this.getObject("getServizioApplicativoAutenticato", idPD, aSubject);
        if (s != null) {
            return s;
        }
        throw new DriverConfigurazioneNotFound("[getServizioApplicativoAutenticato] Servizio Applicativo non trovato");
    }

    public ServizioApplicativo getServizioApplicativoAutenticato(String aSubject) throws DriverConfigurazioneException, DriverConfigurazioneNotFound {
        if (aSubject == null) {
            throw new DriverConfigurazioneException("[getServizioApplicativoAutenticato]: Parametro non definito");
        }
        String key = null;
        if (this.cache != null) {
            key = "getServizioApplicativoAutenticatoSSL";
            CacheResponse response = (CacheResponse)this.cache.get((Object)(key = key + "_" + aSubject));
            if (response != null) {
                if (response.getException() != null) {
                    if (DriverConfigurazioneNotFound.class.getName().equals(response.getException().getClass().getName())) {
                        throw (DriverConfigurazioneNotFound)((Object)response.getException());
                    }
                    throw (DriverConfigurazioneException)((Object)response.getException());
                }
                return (ServizioApplicativo)response.getObject();
            }
        }
        ServizioApplicativo s = null;
        s = this.cache != null ? (ServizioApplicativo)this.getObjectCache(key, "getServizioApplicativoAutenticato", aSubject) : (ServizioApplicativo)this.getObject("getServizioApplicativoAutenticato", aSubject);
        if (s != null) {
            return s;
        }
        throw new DriverConfigurazioneNotFound("[getServizioApplicativoAutenticato] Servizio Applicativo non trovato");
    }

    public RoutingTable getRoutingTable() throws DriverConfigurazioneException, DriverConfigurazioneNotFound {
        CacheResponse response;
        if (!this.configurazioneDinamica && routingTable != null) {
            return routingTable;
        }
        String key = null;
        if (this.cache != null && (response = (CacheResponse)this.cache.get((Object)(key = "getRoutingTable"))) != null) {
            if (response.getException() != null) {
                if (DriverConfigurazioneNotFound.class.getName().equals(response.getException().getClass().getName())) {
                    throw (DriverConfigurazioneNotFound)((Object)response.getException());
                }
                throw (DriverConfigurazioneException)((Object)response.getException());
            }
            return (RoutingTable)response.getObject();
        }
        RoutingTable r = null;
        r = this.cache != null ? (RoutingTable)this.getObjectCache(key, "getRoutingTable", new Object[0]) : (RoutingTable)this.getObject("getRoutingTable", new Object[0]);
        if (r != null) {
            if (!this.configurazioneDinamica) {
                routingTable = r;
            }
            return r;
        }
        throw new DriverConfigurazioneNotFound("[getRoutingTable] RoutingTable non trovata");
    }

    public AccessoRegistro getAccessoRegistro() throws DriverConfigurazioneException, DriverConfigurazioneNotFound {
        CacheResponse response;
        if (!this.configurazioneDinamica && accessoRegistro != null) {
            return accessoRegistro;
        }
        String key = null;
        if (this.cache != null && (response = (CacheResponse)this.cache.get((Object)(key = "getAccessoRegistro"))) != null) {
            if (response.getException() != null) {
                if (DriverConfigurazioneNotFound.class.getName().equals(response.getException().getClass().getName())) {
                    throw (DriverConfigurazioneNotFound)((Object)response.getException());
                }
                throw (DriverConfigurazioneException)((Object)response.getException());
            }
            return (AccessoRegistro)response.getObject();
        }
        AccessoRegistro ar = null;
        ar = this.cache != null ? (AccessoRegistro)this.getObjectCache(key, "getAccessoRegistro", new Object[0]) : (AccessoRegistro)this.getObject("getAccessoRegistro", new Object[0]);
        if (ar != null) {
            if (!this.configurazioneDinamica) {
                accessoRegistro = ar;
            }
            return ar;
        }
        throw new DriverConfigurazioneNotFound("[getAccessoRegistro] Configurazione di accesso ai registri non trovata");
    }

    public GestioneErrore getGestioneErroreComponenteCooperazione() throws DriverConfigurazioneException, DriverConfigurazioneNotFound {
        return this.getGestioneErrore(true);
    }

    public GestioneErrore getGestioneErroreComponenteIntegrazione() throws DriverConfigurazioneException, DriverConfigurazioneNotFound {
        return this.getGestioneErrore(false);
    }

    /*
     * Unable to fully structure code
     */
    private GestioneErrore getGestioneErrore(boolean cooperazione) throws DriverConfigurazioneException, DriverConfigurazioneNotFound {
        if (!this.configurazioneDinamica) {
            if (cooperazione) {
                if (ConfigurazionePdD.gestioneErroreComponenteCooperazione != null) {
                    return ConfigurazionePdD.gestioneErroreComponenteCooperazione;
                }
            } else if (ConfigurazionePdD.gestioneErroreComponenteIntegrazione != null) {
                return ConfigurazionePdD.gestioneErroreComponenteIntegrazione;
            }
        }
        key = null;
        if (this.cache != null) {
            key = "getGestioneErrore";
            key = cooperazione != false ? key + "ComponenteCooperazione" : key + "ComponenteIntegrazione";
            response = (CacheResponse)this.cache.get((Object)key);
            if (response != null) {
                if (response.getException() != null) {
                    if (DriverConfigurazioneNotFound.class.getName().equals(response.getException().getClass().getName())) {
                        throw (DriverConfigurazioneNotFound)response.getException();
                    }
                    throw (DriverConfigurazioneException)response.getException();
                }
                return (GestioneErrore)response.getObject();
            }
        }
        ge = null;
        nomeMetodo = "getGestioneErrore";
        nomeMetodo = cooperazione != false ? nomeMetodo + "ComponenteCooperazione" : nomeMetodo + "ComponenteIntegrazione";
        if (this.cache != null) {
            try {
                ge = (GestioneErrore)this.getObjectCache(key, nomeMetodo, new Object[0]);
            }
            catch (DriverConfigurazioneException e) {
                erroreCooperazione = "Configurazione, Algoritmo di Cache fallito: Metodo (getGestioneErroreComponenteCooperazione) ha ritornato un valore null";
                erroreIntegrazione = "Configurazione, Algoritmo di Cache fallito: Metodo (getGestioneErroreComponenteIntegrazione) ha ritornato un valore null";
                if (e.getMessage() == null || erroreCooperazione.equals(e.getMessage()) || erroreIntegrazione.equals(e.getMessage())) ** GOTO lbl32
                throw e;
            }
        } else {
            ge = (GestioneErrore)this.getObject(nomeMetodo, new Object[0]);
        }
lbl32:
        // 3 sources

        if (ge != null) {
            if (!this.configurazioneDinamica) {
                if (cooperazione) {
                    ConfigurazionePdD.gestioneErroreComponenteCooperazione = ge;
                } else {
                    ConfigurazionePdD.gestioneErroreComponenteIntegrazione = ge;
                }
            }
            return ge;
        }
        throw new DriverConfigurazioneNotFound("[getGestioneErrore] GestioneErrore non trovato");
    }

    public Configurazione getConfigurazioneGenerale() throws DriverConfigurazioneException, DriverConfigurazioneNotFound {
        CacheResponse response;
        if (!this.configurazioneDinamica && configurazioneGeneralePdD != null) {
            return configurazioneGeneralePdD;
        }
        String key = null;
        if (this.cache != null && (response = (CacheResponse)this.cache.get((Object)(key = "getConfigurazioneGenerale"))) != null) {
            if (response.getException() != null) {
                if (DriverConfigurazioneNotFound.class.getName().equals(response.getException().getClass().getName())) {
                    throw (DriverConfigurazioneNotFound)((Object)response.getException());
                }
                throw (DriverConfigurazioneException)((Object)response.getException());
            }
            return (Configurazione)response.getObject();
        }
        Configurazione c = null;
        c = this.cache != null ? (Configurazione)this.getObjectCache(key, "getConfigurazioneGenerale", new Object[0]) : (Configurazione)this.getObject("getConfigurazioneGenerale", new Object[0]);
        if (c != null) {
            if (!this.configurazioneDinamica) {
                configurazioneGeneralePdD = c;
            }
            return c;
        }
        throw new DriverConfigurazioneNotFound("[getConfigurazioneGenerale] Configurazione Generale non trovata");
    }
}

