/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop.pdd.config;

import java.math.BigInteger;
import java.util.Enumeration;
import java.util.Properties;
import org.apache.log4j.Logger;
import org.openspcoop.dao.config.AccessoRegistro;
import org.openspcoop.dao.config.AccessoRegistroCache;
import org.openspcoop.dao.config.AccessoRegistroRegistro;
import org.openspcoop.dao.config.Attachments;
import org.openspcoop.dao.config.Configurazione;
import org.openspcoop.dao.config.GestioneErrore;
import org.openspcoop.dao.config.GestioneErroreCodiceTrasporto;
import org.openspcoop.dao.config.GestioneErroreSoapFault;
import org.openspcoop.dao.config.IndirizzoTelematico;
import org.openspcoop.dao.config.InoltroBusteNonRiscontrate;
import org.openspcoop.dao.config.IntegrationManager;
import org.openspcoop.dao.config.OpenspcoopAppender;
import org.openspcoop.dao.config.OpenspcoopAppenderProperty;
import org.openspcoop.dao.config.RisposteSpcoop;
import org.openspcoop.dao.config.Route;
import org.openspcoop.dao.config.RouteGateway;
import org.openspcoop.dao.config.RouteRegistro;
import org.openspcoop.dao.config.RoutingTable;
import org.openspcoop.dao.config.RoutingTableDestinazione;
import org.openspcoop.dao.config.Tracciamento;
import org.openspcoop.dao.config.ValidazioneBusteEgov;
import org.openspcoop.dao.config.ValidazioneContenutiApplicativi;
import org.openspcoop.pdd.config.InstanceProperties;
import org.openspcoop.pdd.config.PropertiesUtilities;

public class ConfigLocalProperties
extends InstanceProperties {
    private boolean configLocal = false;

    public ConfigLocalProperties(Logger log, String confDir, Properties prop) throws Exception {
        super(new Properties(), log);
        Properties properties = PropertiesUtilities.searchLocalImplementation(log, "OPENSPCOOP_CONFIG_PROPERTIES", "config_local.properties", confDir);
        if (properties != null) {
            this.configLocal = true;
            this.setLocalFileImplementation(properties);
        }
        if (prop != null) {
            this.configLocal = true;
            this.setLocalObjectImplementation(prop);
        }
    }

    public RoutingTable updateRouting(RoutingTable routingTable) throws Exception {
        if (!this.configLocal) {
            return routingTable;
        }
        try {
            int i;
            String enabled = this.getValue("routingTable.enabled");
            if (enabled != null && "false".equals(enabled = enabled.trim())) {
                if (routingTable == null) {
                    routingTable = new RoutingTable();
                }
                routingTable.setAbilitata(Boolean.valueOf(false));
                return routingTable;
            }
            String defaultRoutesTmp = this.getValue("routingTable.default.routes");
            String[] defaultRoutes = null;
            if (defaultRoutesTmp != null && defaultRoutesTmp.length() > 0 && (defaultRoutes = defaultRoutesTmp.split(",")) != null) {
                if (defaultRoutes.length > 0) {
                    for (int i2 = 0; i2 < defaultRoutes.length; ++i2) {
                        defaultRoutes[i2] = defaultRoutes[i2].trim();
                    }
                } else {
                    defaultRoutes = null;
                }
            }
            String staticRoutesTmp = this.getValue("routingTable.routes");
            String[] staticRoutes = null;
            if (staticRoutesTmp != null && staticRoutesTmp.length() > 0 && (staticRoutes = staticRoutesTmp.split(",")) != null) {
                if (staticRoutes.length > 0) {
                    for (i = 0; i < staticRoutes.length; ++i) {
                        staticRoutes[i] = staticRoutes[i].trim();
                    }
                } else {
                    staticRoutes = null;
                }
            }
            if (defaultRoutes != null || staticRoutesTmp != null) {
                if (enabled == null) {
                    throw new Exception("Indicazione se la tabella di routing e' abilitata o meno non fornita");
                }
                if (!"true".equals(enabled) && !"false".equals(enabled)) {
                    throw new Exception("Indicazione se la tabella di routing e' abilitata o meno fornita non correttamente");
                }
                if (routingTable == null) {
                    if (defaultRoutes == null) {
                        throw new Exception("Rotte di default non definite");
                    }
                    routingTable = new RoutingTable();
                }
                routingTable.setAbilitata(Boolean.valueOf("true".equals(enabled)));
            }
            if (defaultRoutes != null) {
                while (routingTable.sizeDefaultList() > 0) {
                    routingTable.removeDefault(0);
                }
                for (i = 0; i < defaultRoutes.length; ++i) {
                    Route route = new Route();
                    String tipo = this.getValue("routingTable.default.route." + defaultRoutes[i] + ".tipo");
                    if (tipo == null) {
                        throw new Exception("Tipo della rotta " + defaultRoutes[i] + " non definito");
                    }
                    if (!"registro".equals(tipo = tipo.trim()) && !"gateway".equals(tipo)) {
                        throw new Exception("Tipo della rotta " + defaultRoutes[i] + " non corretto");
                    }
                    if ("registro".equals(tipo)) {
                        RouteRegistro rr = new RouteRegistro();
                        String nome = this.getValue("routingTable.default.route." + defaultRoutes[i] + ".registro.nome");
                        if (nome != null) {
                            nome = nome.trim();
                            rr.setNome(nome);
                        }
                        route.setRegistro(rr);
                    } else {
                        RouteGateway rg = new RouteGateway();
                        String tipoSPCoop = this.getValue("routingTable.default.route." + defaultRoutes[i] + ".gateway.tipo");
                        if (tipoSPCoop == null) {
                            throw new Exception("Tipo del soggetto della rotta gateway " + defaultRoutes[i] + " non definito");
                        }
                        tipoSPCoop = tipoSPCoop.trim();
                        rg.setTipo(tipoSPCoop);
                        String nomeSPCoop = this.getValue("routingTable.default.route." + defaultRoutes[i] + ".gateway.nome");
                        if (nomeSPCoop == null) {
                            throw new Exception("Tipo del soggetto della rotta gateway " + defaultRoutes[i] + " non definito");
                        }
                        nomeSPCoop = nomeSPCoop.trim();
                        rg.setNome(nomeSPCoop);
                        route.setGateway(rg);
                    }
                    routingTable.addDefault(route);
                }
            }
            if (staticRoutes != null) {
                block6: for (i = 0; i < staticRoutes.length; ++i) {
                    String tipoSoggettoDestinazione = this.getValue("routingTable.route." + staticRoutes[i] + ".soggetto.tipo");
                    if (tipoSoggettoDestinazione == null) {
                        throw new Exception("Tipo del soggetto della rotta statica " + staticRoutes[i] + " non definito");
                    }
                    tipoSoggettoDestinazione = tipoSoggettoDestinazione.trim();
                    String nomeSoggettoDestinazione = this.getValue("routingTable.route." + staticRoutes[i] + ".soggetto.nome");
                    if (nomeSoggettoDestinazione == null) {
                        throw new Exception("Nome del soggetto della rotta statica " + staticRoutes[i] + " non definito");
                    }
                    nomeSoggettoDestinazione = nomeSoggettoDestinazione.trim();
                    String valueEnable = this.getValue("routingTable.route." + staticRoutes[i] + ".enabled");
                    if (valueEnable != null && "false".equalsIgnoreCase(valueEnable.trim())) {
                        for (int j = 0; j < routingTable.sizeDestinazioneList(); ++j) {
                            if (!tipoSoggettoDestinazione.equals(routingTable.getDestinazione(j).getTipo()) || !nomeSoggettoDestinazione.equals(routingTable.getDestinazione(j).getNome())) continue;
                            routingTable.removeDestinazione(j);
                            continue block6;
                        }
                        continue;
                    }
                    RoutingTableDestinazione rtd = null;
                    for (int j = 0; j < routingTable.sizeDestinazioneList(); ++j) {
                        if (!tipoSoggettoDestinazione.equals(routingTable.getDestinazione(j).getTipo()) || !nomeSoggettoDestinazione.equals(routingTable.getDestinazione(j).getNome())) continue;
                        rtd = routingTable.removeDestinazione(j);
                        break;
                    }
                    if (rtd == null) {
                        rtd = new RoutingTableDestinazione();
                        rtd.setTipo(tipoSoggettoDestinazione);
                        rtd.setNome(nomeSoggettoDestinazione);
                    } else {
                        while (rtd.sizeRouteList() > 0) {
                            rtd.removeRoute(0);
                        }
                    }
                    Route route = new Route();
                    String tipo = this.getValue("routingTable.route." + staticRoutes[i] + ".tipo");
                    if (tipo == null) {
                        throw new Exception("Tipo della rotta statica " + staticRoutes[i] + " non definito");
                    }
                    if (!"registro".equals(tipo = tipo.trim()) && !"gateway".equals(tipo)) {
                        throw new Exception("Tipo della rotta statica " + staticRoutes[i] + " non corretto");
                    }
                    if ("registro".equals(tipo)) {
                        RouteRegistro rr = new RouteRegistro();
                        String nome = this.getValue("routingTable.route." + staticRoutes[i] + ".registro.nome");
                        if (nome != null) {
                            nome = nome.trim();
                            rr.setNome(nome);
                        }
                        route.setRegistro(rr);
                    } else {
                        RouteGateway rg = new RouteGateway();
                        String tipoSPCoop = this.getValue("routingTable.route." + staticRoutes[i] + ".gateway.tipo");
                        if (tipoSPCoop == null) {
                            throw new Exception("Tipo del soggetto della rotta statica di tipo gateway " + staticRoutes[i] + " non definito");
                        }
                        tipoSPCoop = tipoSPCoop.trim();
                        rg.setTipo(tipoSPCoop);
                        String nomeSPCoop = this.getValue("routingTable.route." + staticRoutes[i] + ".gateway.nome");
                        if (nomeSPCoop == null) {
                            throw new Exception("Tipo del soggetto della rotta statica di tipo gateway " + staticRoutes[i] + " non definito");
                        }
                        nomeSPCoop = nomeSPCoop.trim();
                        rg.setNome(nomeSPCoop);
                        route.setGateway(rg);
                    }
                    rtd.addRoute(route);
                    routingTable.addDestinazione(rtd);
                }
            }
            return routingTable;
        }
        catch (Exception e) {
            this.log.error((Object)("Errore durante la lettura del file config_local.properties (RoutingTable): " + e.getMessage()), (Throwable)e);
            throw new Exception("Errore durante la lettura del file config_local.properties (RoutingTable): " + e.getMessage(), e);
        }
    }

    public AccessoRegistro updateAccessoRegistro(AccessoRegistro accessoRegistro) throws Exception {
        if (!this.configLocal) {
            return accessoRegistro;
        }
        try {
            String cacheAbilitata = this.getValue("registro.cache.enabled");
            boolean cacheDisabilitata = false;
            if (cacheAbilitata != null && "false".equalsIgnoreCase(cacheAbilitata.trim())) {
                accessoRegistro.setCache(null);
                cacheDisabilitata = true;
            }
            if (!cacheDisabilitata) {
                String cacheItemLifeSecond;
                String cacheAlgoritmo;
                String cacheDimensione = this.getValue("registro.cache.dimensione");
                if (cacheDimensione != null) {
                    cacheDimensione = cacheDimensione.trim();
                    try {
                        Integer.parseInt(cacheDimensione);
                    }
                    catch (Exception e) {
                        throw new Exception("Valore impostato non corretto per registro.cache.dimensione");
                    }
                }
                if ((cacheAlgoritmo = this.getValue("registro.cache.algoritmo")) != null && !"lru".equals(cacheAlgoritmo = cacheAlgoritmo.trim()) && !"mru".equals(cacheAlgoritmo)) {
                    throw new Exception("Algoritmo impostato per la cache del registro non corretto");
                }
                String cacheItemIdleTime = this.getValue("registro.cache.item-idle-time");
                if (cacheItemIdleTime != null) {
                    cacheItemIdleTime = cacheItemIdleTime.trim();
                    try {
                        Integer.parseInt(cacheItemIdleTime);
                    }
                    catch (Exception e) {
                        throw new Exception("Valore impostato non corretto per registro.cache.item-idle-time");
                    }
                }
                if ((cacheItemLifeSecond = this.getValue("registro.cache.item-life-second")) != null) {
                    cacheItemLifeSecond = cacheItemLifeSecond.trim();
                    try {
                        Integer.parseInt(cacheItemLifeSecond);
                    }
                    catch (Exception e) {
                        throw new Exception("Valore impostato non corretto per registro.cache.item-life-second");
                    }
                }
                AccessoRegistroCache registroCache = accessoRegistro.getCache();
                if (cacheDimensione != null || cacheAlgoritmo != null || cacheItemIdleTime != null || cacheItemLifeSecond != null) {
                    if (registroCache == null) {
                        registroCache = new AccessoRegistroCache();
                    }
                    if (cacheDimensione != null) {
                        registroCache.setDimensione(cacheDimensione);
                    }
                    if (cacheAlgoritmo != null) {
                        registroCache.setAlgoritmo(cacheAlgoritmo);
                    }
                    if (cacheItemIdleTime != null) {
                        registroCache.setItemIdleTime(cacheItemIdleTime);
                    }
                    if (cacheItemLifeSecond != null) {
                        registroCache.setItemLifeSecond(cacheItemLifeSecond);
                    }
                    accessoRegistro.setCache(registroCache);
                }
            }
            String registriTmp = this.getValue("registri");
            String[] registri = null;
            if (registriTmp != null && (registri = (registriTmp = registriTmp.trim()).split(",")) != null) {
                if (registri.length > 0) {
                    for (int i = 0; i < registri.length; ++i) {
                        registri[i] = registri[i].trim();
                    }
                } else {
                    registri = null;
                }
            }
            if (registri != null) {
                block9: for (int i = 0; i < registri.length; ++i) {
                    String password;
                    String tipo;
                    String nomeRegistro = this.getValue("registro." + registri[i] + ".nome");
                    if (nomeRegistro == null) {
                        throw new Exception("Nome del registro " + registri[i] + " non definito");
                    }
                    nomeRegistro = nomeRegistro.trim();
                    String valueEnable = this.getValue("registro." + registri[i] + ".enabled");
                    if (valueEnable != null && "false".equalsIgnoreCase(valueEnable.trim())) {
                        for (int j = 0; j < accessoRegistro.sizeRegistroList(); ++j) {
                            if (!nomeRegistro.equals(accessoRegistro.getRegistro(j).getNome())) continue;
                            accessoRegistro.removeRegistro(j);
                            continue block9;
                        }
                        continue;
                    }
                    AccessoRegistroRegistro registro = null;
                    for (int j = 0; j < accessoRegistro.sizeRegistroList(); ++j) {
                        if (!nomeRegistro.equals(accessoRegistro.getRegistro(j).getNome())) continue;
                        registro = accessoRegistro.removeRegistro(j);
                        break;
                    }
                    if (registro == null) {
                        registro = new AccessoRegistroRegistro();
                        registro.setNome(nomeRegistro);
                    }
                    if ((tipo = this.getValue("registro." + registri[i] + ".tipo")) == null) {
                        throw new Exception("Tipo del registro " + registri[i] + " non definito");
                    }
                    if (!("db".equals(tipo = tipo.trim()) || "uddi".equals(tipo) || "web".equals(tipo) || "ws".equals(tipo) || "xml".equals(tipo))) {
                        throw new Exception("Tipo del registro " + registri[i] + " non corretto");
                    }
                    registro.setTipo(tipo);
                    String location = this.getValue("registro." + registri[i] + ".location");
                    if (location == null) {
                        throw new Exception("Location del registro " + registri[i] + " non definito");
                    }
                    location = location.trim();
                    registro.setLocation(location);
                    String username = this.getValue("registro." + registri[i] + ".user");
                    if (username != null) {
                        if ("".equals(username = username.trim())) {
                            registro.setUser(null);
                        } else {
                            registro.setUser(username);
                        }
                    }
                    if ((password = this.getValue("registro." + registri[i] + ".password")) != null) {
                        if ("".equals(password = password.trim())) {
                            registro.setPassword(null);
                        } else {
                            registro.setPassword(password);
                        }
                    }
                    accessoRegistro.addRegistro(registro);
                }
            }
            return accessoRegistro;
        }
        catch (Exception e) {
            this.log.error((Object)("Errore durante la lettura del file config_local.properties (AccessoRegistro): " + e.getMessage()), (Throwable)e);
            throw new Exception("Errore durante la lettura del file config_local.properties (AccessoRegistro): " + e.getMessage(), e);
        }
    }

    public GestioneErrore updateGestioneErroreCooperazione(GestioneErrore gestioneErrore) throws Exception {
        if (!this.configLocal) {
            return gestioneErrore;
        }
        try {
            return this.updateGestioneErrore(gestioneErrore, "cooperazione");
        }
        catch (Exception e) {
            this.log.error((Object)("Errore durante la lettura del file config_local.properties (GestioneErrore Cooperazione): " + e.getMessage()), (Throwable)e);
            throw new Exception("Errore durante la lettura del file config_local.properties (GestioneErrore Cooperazione): " + e.getMessage(), e);
        }
    }

    public GestioneErrore updateGestioneErroreIntegrazione(GestioneErrore gestioneErrore) throws Exception {
        if (!this.configLocal) {
            return gestioneErrore;
        }
        try {
            return this.updateGestioneErrore(gestioneErrore, "integrazione");
        }
        catch (Exception e) {
            this.log.error((Object)("Errore durante la lettura del file config_local.properties (GestioneErrore Integrazione): " + e.getMessage()), (Throwable)e);
            throw new Exception("Errore durante la lettura del file config_local.properties (GestioneErrore Integrazione): " + e.getMessage(), e);
        }
    }

    private GestioneErrore updateGestioneErrore(GestioneErrore gestioneErrore, String tipo) throws Exception {
        int i;
        String gestioneErroreDefaultComportamento = this.getValue("gestioneErrore." + tipo + ".comportamento");
        if (gestioneErroreDefaultComportamento != null && !"accetta".equals(gestioneErroreDefaultComportamento = gestioneErroreDefaultComportamento.trim()) && !"rispedisci".equals(gestioneErroreDefaultComportamento)) {
            throw new Exception("Comportamento di default per la gestione errore (" + tipo + ") non correttamento fornito");
        }
        String gestioneErroreDefaultCadenzaRispedizione = this.getValue("gestioneErrore." + tipo + ".cadenzaRispedizione");
        if (gestioneErroreDefaultCadenzaRispedizione != null) {
            gestioneErroreDefaultCadenzaRispedizione = gestioneErroreDefaultCadenzaRispedizione.trim();
            try {
                Integer.parseInt(gestioneErroreDefaultCadenzaRispedizione);
            }
            catch (Exception e) {
                throw new Exception("Cadenza di rispedizione di default per la gestione errore (" + tipo + ") non correttamento fornito");
            }
        }
        String gestioneErroreCodiciTrasportoTmp = this.getValue("gestioneErrore." + tipo + ".codiciTrasporto");
        String[] gestioneErroreCodiciTrasporto = null;
        if (gestioneErroreCodiciTrasportoTmp != null && (gestioneErroreCodiciTrasporto = (gestioneErroreCodiciTrasportoTmp = gestioneErroreCodiciTrasportoTmp.trim()).split(",")) != null) {
            if (gestioneErroreCodiciTrasporto.length > 0) {
                for (int i2 = 0; i2 < gestioneErroreCodiciTrasporto.length; ++i2) {
                    gestioneErroreCodiciTrasporto[i2] = gestioneErroreCodiciTrasporto[i2].trim();
                }
            } else {
                gestioneErroreCodiciTrasporto = null;
            }
        }
        String gestioneErroreFaultTmp = this.getValue("gestioneErrore." + tipo + ".soapFault");
        String[] gestioneErroreFault = null;
        if (gestioneErroreFaultTmp != null && (gestioneErroreFault = (gestioneErroreFaultTmp = gestioneErroreFaultTmp.trim()).split(",")) != null) {
            if (gestioneErroreFault.length > 0) {
                for (i = 0; i < gestioneErroreFault.length; ++i) {
                    gestioneErroreFault[i] = gestioneErroreFault[i].trim();
                }
            } else {
                gestioneErroreFault = null;
            }
        }
        if (gestioneErroreDefaultComportamento != null || gestioneErroreDefaultCadenzaRispedizione != null || gestioneErroreCodiciTrasporto != null || gestioneErroreFault != null) {
            if (gestioneErroreDefaultComportamento == null) {
                throw new Exception("Comportamento di default deve essere fornito");
            }
            gestioneErrore = new GestioneErrore();
            gestioneErrore.setComportamento(gestioneErroreDefaultComportamento);
            if (gestioneErroreDefaultCadenzaRispedizione != null) {
                gestioneErrore.setCadenzaRispedizione(gestioneErroreDefaultCadenzaRispedizione);
            }
            if (gestioneErroreCodiciTrasporto != null) {
                for (i = 0; i < gestioneErroreCodiciTrasporto.length; ++i) {
                    String codiceTrasportoCadenza;
                    String codiceTrasportoMassimo;
                    GestioneErroreCodiceTrasporto ct = new GestioneErroreCodiceTrasporto();
                    String codiceTrasportoMinimo = this.getValue("gestioneErrore." + tipo + ".codiceTrasporto." + gestioneErroreCodiciTrasporto[i] + ".valoreMinimo");
                    if (codiceTrasportoMinimo != null) {
                        codiceTrasportoMinimo = codiceTrasportoMinimo.trim();
                        try {
                            Integer.parseInt(codiceTrasportoMinimo);
                        }
                        catch (Exception e) {
                            throw new Exception("Codice di trasporto minimo non correttaemnte definito la gestione errore (" + tipo + "), trasporto " + gestioneErroreCodiciTrasporto[i]);
                        }
                        ct.setValoreMinimo(new BigInteger(codiceTrasportoMinimo));
                    }
                    if ((codiceTrasportoMassimo = this.getValue("gestioneErrore." + tipo + ".codiceTrasporto." + gestioneErroreCodiciTrasporto[i] + ".valoreMassimo")) != null) {
                        codiceTrasportoMassimo = codiceTrasportoMassimo.trim();
                        try {
                            Integer.parseInt(codiceTrasportoMassimo);
                        }
                        catch (Exception e) {
                            throw new Exception("Codice di trasporto massimo non correttaemnte definito la gestione errore (" + tipo + "), trasporto " + gestioneErroreCodiciTrasporto[i]);
                        }
                        ct.setValoreMassimo(new BigInteger(codiceTrasportoMassimo));
                    }
                    if (codiceTrasportoMinimo == null && codiceTrasportoMassimo == null) {
                        throw new Exception("Ne valore minimo, ne valore massimo fornito per la gestione errore (" + tipo + "), codice di trasporto " + gestioneErroreCodiciTrasporto[i]);
                    }
                    String codiceTrasportoComportamento = this.getValue("gestioneErrore." + tipo + ".codiceTrasporto." + gestioneErroreCodiciTrasporto[i] + ".comportamento");
                    if (codiceTrasportoComportamento != null) {
                        if (!"accetta".equals(codiceTrasportoComportamento = codiceTrasportoComportamento.trim()) && !"rispedisci".equals(codiceTrasportoComportamento)) {
                            throw new Exception("Comportamento  per la gestione errore (" + tipo + "), codice di trasporto " + gestioneErroreCodiciTrasporto[i] + " non correttamento fornito");
                        }
                        ct.setComportamento(codiceTrasportoComportamento);
                    }
                    if ((codiceTrasportoCadenza = this.getValue("gestioneErrore." + tipo + ".codiceTrasporto." + gestioneErroreCodiciTrasporto[i] + ".cadenzaRispedizione")) != null) {
                        codiceTrasportoCadenza = codiceTrasportoCadenza.trim();
                        try {
                            Integer.parseInt(gestioneErroreDefaultCadenzaRispedizione);
                        }
                        catch (Exception e) {
                            throw new Exception("Cadenza di rispedizione di default per la gestione errore (" + tipo + "), codice di trasporto " + gestioneErroreCodiciTrasporto[i] + " non correttamento fornito");
                        }
                        ct.setCadenzaRispedizione(codiceTrasportoCadenza);
                    }
                    gestioneErrore.addCodiceTrasporto(ct);
                }
            }
            if (gestioneErroreFault != null) {
                for (i = 0; i < gestioneErroreFault.length; ++i) {
                    String faultCadenza;
                    String faultComportamento;
                    String faultString;
                    String faultCode;
                    GestioneErroreSoapFault fault = new GestioneErroreSoapFault();
                    String faultActor = this.getValue("gestioneErrore." + tipo + ".soapFault." + gestioneErroreFault[i] + ".faultActor");
                    if (faultActor != null) {
                        faultActor = faultActor.trim();
                        fault.setFaultActor(faultActor);
                    }
                    if ((faultCode = this.getValue("gestioneErrore." + tipo + ".soapFault." + gestioneErroreFault[i] + ".faultCode")) != null) {
                        faultCode = faultCode.trim();
                        fault.setFaultCode(faultCode);
                    }
                    if ((faultString = this.getValue("gestioneErrore." + tipo + ".soapFault." + gestioneErroreFault[i] + ".faultString")) != null) {
                        faultString = faultString.trim();
                        fault.setFaultString(faultString);
                    }
                    if ((faultComportamento = this.getValue("gestioneErrore." + tipo + ".soapFault." + gestioneErroreFault[i] + ".comportamento")) != null) {
                        if (!"accetta".equals(faultComportamento = faultComportamento.trim()) && !"rispedisci".equals(faultComportamento)) {
                            throw new Exception("Comportamento  per la gestione errore (" + tipo + "), soapFault " + gestioneErroreFault[i] + " non correttamento fornito");
                        }
                        fault.setComportamento(faultComportamento);
                    }
                    if ((faultCadenza = this.getValue("gestioneErrore." + tipo + ".soapFault." + gestioneErroreFault[i] + ".cadenzaRispedizione")) != null) {
                        faultCadenza = faultCadenza.trim();
                        try {
                            Integer.parseInt(gestioneErroreDefaultCadenzaRispedizione);
                        }
                        catch (Exception e) {
                            throw new Exception("Cadenza di rispedizione di default per la gestione errore (" + tipo + "), soapFault " + gestioneErroreFault[i] + " non correttamento fornito");
                        }
                        fault.setCadenzaRispedizione(faultCadenza);
                    }
                    gestioneErrore.addSoapFault(fault);
                }
            }
        }
        return gestioneErrore;
    }

    public Configurazione updateConfigurazione(Configurazione configurazione) throws Exception {
        if (!this.configLocal) {
            return configurazione;
        }
        try {
            String integrationManager_autenticazione;
            String tracciamentoEGov;
            int i;
            String msgDiagnostici_livelloSeveritaSPCoop;
            String msgDiagnostici_livelloSeveritaOpenSPCoop;
            String inoltroBuste_cadenza;
            String risposteSPCoop_connection;
            String attachments_gestioneManifest;
            String indirizzoTelematico_utilizzo;
            String validazioneContenutiApplicativi_stato;
            String validazioneBusteEGov_stato = this.getValue("validazione.egov.stato");
            if (!(validazioneBusteEGov_stato == null || "abilitato".equals(validazioneBusteEGov_stato = validazioneBusteEGov_stato.trim()) || "disabilitato".equals(validazioneBusteEGov_stato) || "warningOnly".equals(validazioneBusteEGov_stato))) {
                throw new Exception("Stato della validazione egov non corretto");
            }
            String validazioneBusteEGov_controllo = this.getValue("validazione.egov.controllo");
            if (validazioneBusteEGov_controllo != null && !"normale".equals(validazioneBusteEGov_controllo = validazioneBusteEGov_controllo.trim()) && !"rigido".equals(validazioneBusteEGov_controllo)) {
                throw new Exception("Tipo di controllo della validazione egov non corretto");
            }
            String validazioneBusteEGov_profiloCollaborazione = this.getValue("validazione.egov.profiloCollaborazione");
            if (validazioneBusteEGov_profiloCollaborazione != null && !"abilitato".equals(validazioneBusteEGov_profiloCollaborazione = validazioneBusteEGov_profiloCollaborazione.trim()) && !"disabilitato".equals(validazioneBusteEGov_profiloCollaborazione)) {
                throw new Exception("Stato della validazione del profilo di collaborazione egov non corretto");
            }
            String validazioneBusteEGov_manifestAttachments = this.getValue("validazione.egov.manifestAttachments");
            if (validazioneBusteEGov_manifestAttachments != null && !"abilitato".equals(validazioneBusteEGov_manifestAttachments = validazioneBusteEGov_manifestAttachments.trim()) && !"disabilitato".equals(validazioneBusteEGov_manifestAttachments)) {
                throw new Exception("Stato della validazione del manifest egov degli attachments non corretto");
            }
            if (validazioneBusteEGov_stato != null || validazioneBusteEGov_controllo != null || validazioneBusteEGov_profiloCollaborazione != null || validazioneBusteEGov_manifestAttachments != null) {
                if (configurazione.getValidazioneBusteEgov() == null) {
                    configurazione.setValidazioneBusteEgov(new ValidazioneBusteEgov());
                }
                if (validazioneBusteEGov_stato != null) {
                    configurazione.getValidazioneBusteEgov().setStato(validazioneBusteEGov_stato);
                }
                if (validazioneBusteEGov_controllo != null) {
                    configurazione.getValidazioneBusteEgov().setControllo(validazioneBusteEGov_controllo);
                }
                if (validazioneBusteEGov_profiloCollaborazione != null) {
                    configurazione.getValidazioneBusteEgov().setProfiloCollaborazione(validazioneBusteEGov_profiloCollaborazione);
                }
                if (validazioneBusteEGov_manifestAttachments != null) {
                    configurazione.getValidazioneBusteEgov().setManifestAttachments(validazioneBusteEGov_manifestAttachments);
                }
            }
            if (!((validazioneContenutiApplicativi_stato = this.getValue("validazione.contenutiApplicativi.stato")) == null || "abilitato".equals(validazioneContenutiApplicativi_stato = validazioneContenutiApplicativi_stato.trim()) || "disabilitato".equals(validazioneContenutiApplicativi_stato) || "warningOnly".equals(validazioneContenutiApplicativi_stato))) {
                throw new Exception("Stato della validazione dei contenuti applicativi non corretto");
            }
            String validazioneContenutiApplicativi_tipo = this.getValue("validazione.contenutiApplicativi.tipo");
            if (!(validazioneContenutiApplicativi_tipo == null || "xsd".equals(validazioneContenutiApplicativi_tipo = validazioneContenutiApplicativi_tipo.trim()) || "wsdl".equals(validazioneContenutiApplicativi_tipo) || "openspcoop".equals(validazioneContenutiApplicativi_tipo))) {
                throw new Exception("Tipo di controllo della validazione dei contenuti applicativi non corretto");
            }
            if (validazioneContenutiApplicativi_stato != null || validazioneContenutiApplicativi_tipo != null) {
                if (configurazione.getValidazioneContenutiApplicativi() == null) {
                    configurazione.setValidazioneContenutiApplicativi(new ValidazioneContenutiApplicativi());
                }
                if (validazioneContenutiApplicativi_stato != null) {
                    configurazione.getValidazioneContenutiApplicativi().setStato(validazioneContenutiApplicativi_stato);
                }
                if (validazioneContenutiApplicativi_tipo != null) {
                    configurazione.getValidazioneContenutiApplicativi().setTipo(validazioneContenutiApplicativi_tipo);
                }
            }
            if ((indirizzoTelematico_utilizzo = this.getValue("indirizzoTelematico.utilizzo")) != null) {
                if (!"abilitato".equals(indirizzoTelematico_utilizzo = indirizzoTelematico_utilizzo.trim()) && !"disabilitato".equals(indirizzoTelematico_utilizzo)) {
                    throw new Exception("Impostazione sull'utilizzo dell'indirizzo telematico non corretta");
                }
                if (configurazione.getIndirizzoTelematico() == null) {
                    configurazione.setIndirizzoTelematico(new IndirizzoTelematico());
                }
                configurazione.getIndirizzoTelematico().setUtilizzo(indirizzoTelematico_utilizzo);
            }
            if ((attachments_gestioneManifest = this.getValue("attachments.gestioneManifest")) != null) {
                if (!"abilitato".equals(attachments_gestioneManifest = attachments_gestioneManifest.trim()) && !"disabilitato".equals(attachments_gestioneManifest)) {
                    throw new Exception("Impostazione sulla gestione del manifest egov non corretta");
                }
                if (configurazione.getAttachments() == null) {
                    configurazione.setAttachments(new Attachments());
                }
                configurazione.getAttachments().setGestioneManifest(attachments_gestioneManifest);
            }
            if ((risposteSPCoop_connection = this.getValue("risposteSPCoop.connessione")) != null) {
                if (!"reply".equals(risposteSPCoop_connection = risposteSPCoop_connection.trim()) && !"new".equals(risposteSPCoop_connection)) {
                    throw new Exception("Impostazione sulla gestione della connessione per le risposte SPCoop non corretta");
                }
                if (configurazione.getRisposteSpcoop() == null) {
                    configurazione.setRisposteSpcoop(new RisposteSpcoop());
                }
                configurazione.getRisposteSpcoop().setConnessione(risposteSPCoop_connection);
            }
            if ((inoltroBuste_cadenza = this.getValue("inoltroBusteNonRiscontrate.cadenza")) != null) {
                inoltroBuste_cadenza = inoltroBuste_cadenza.trim();
                try {
                    Integer.parseInt(inoltroBuste_cadenza);
                }
                catch (Exception e) {
                    throw new Exception("Impostazione sulla cadenza per l'inoltro di buste non riscontrate non corretta");
                }
                if (configurazione.getInoltroBusteNonRiscontrate() == null) {
                    configurazione.setInoltroBusteNonRiscontrate(new InoltroBusteNonRiscontrate());
                }
                configurazione.getInoltroBusteNonRiscontrate().setCadenza(inoltroBuste_cadenza);
            }
            if ((msgDiagnostici_livelloSeveritaOpenSPCoop = this.getValue("messaggiDiagnostici.livelloOpenSPCoop")) != null) {
                if (!("all".equals(msgDiagnostici_livelloSeveritaOpenSPCoop = msgDiagnostici_livelloSeveritaOpenSPCoop.trim()) || "debugHigh".equals(msgDiagnostici_livelloSeveritaOpenSPCoop) || "debugMedium".equals(msgDiagnostici_livelloSeveritaOpenSPCoop) || "debugLow".equals(msgDiagnostici_livelloSeveritaOpenSPCoop) || "errorOpenspcoop".equals(msgDiagnostici_livelloSeveritaOpenSPCoop) || "errorSpcoop".equals(msgDiagnostici_livelloSeveritaOpenSPCoop) || "fatalOpenspcoop".equals(msgDiagnostici_livelloSeveritaOpenSPCoop) || "infoOpenspcoop".equals(msgDiagnostici_livelloSeveritaOpenSPCoop) || "infoSpcoop".equals(msgDiagnostici_livelloSeveritaOpenSPCoop) || "off".equals(msgDiagnostici_livelloSeveritaOpenSPCoop))) {
                    throw new Exception("Impostazione sul livello openspcoop dei messsaggi diagnostici emessi non corretta");
                }
                configurazione.getMessaggiDiagnostici().setOpenspcoop(msgDiagnostici_livelloSeveritaOpenSPCoop);
            }
            if ((msgDiagnostici_livelloSeveritaSPCoop = this.getValue("messaggiDiagnostici.livelloSPCoop")) != null) {
                if (!("all".equals(msgDiagnostici_livelloSeveritaSPCoop = msgDiagnostici_livelloSeveritaSPCoop.trim()) || "debugHigh".equals(msgDiagnostici_livelloSeveritaSPCoop) || "debugMedium".equals(msgDiagnostici_livelloSeveritaSPCoop) || "debugLow".equals(msgDiagnostici_livelloSeveritaSPCoop) || "errorOpenspcoop".equals(msgDiagnostici_livelloSeveritaSPCoop) || "errorSpcoop".equals(msgDiagnostici_livelloSeveritaSPCoop) || "fatalOpenspcoop".equals(msgDiagnostici_livelloSeveritaSPCoop) || "infoOpenspcoop".equals(msgDiagnostici_livelloSeveritaSPCoop) || "infoSpcoop".equals(msgDiagnostici_livelloSeveritaSPCoop) || "off".equals(msgDiagnostici_livelloSeveritaSPCoop))) {
                    throw new Exception("Impostazione sul livello spcoop dei messsaggi diagnostici emessi non corretta");
                }
                configurazione.getMessaggiDiagnostici().setSpcoop(msgDiagnostici_livelloSeveritaSPCoop);
            }
            String msgDiagnosticiAppendersDisabledTmp = this.getValue("messaggiDiagnostici.appenders.disabled");
            boolean disabilitatiMsgDiagnosticiAppenderOriginali = false;
            if (msgDiagnosticiAppendersDisabledTmp != null && "true".equals(msgDiagnosticiAppendersDisabledTmp)) {
                disabilitatiMsgDiagnosticiAppenderOriginali = true;
                while (configurazione.getMessaggiDiagnostici().sizeOpenspcoopAppenderList() > 0) {
                    configurazione.getMessaggiDiagnostici().removeOpenspcoopAppender(0);
                }
            }
            String msgDiagnosticiAppendersTmp = this.getValue("messaggiDiagnostici.appenders");
            String[] msgDiagnosticiAppenders = null;
            if (msgDiagnosticiAppendersTmp != null && (msgDiagnosticiAppenders = (msgDiagnosticiAppendersTmp = msgDiagnosticiAppendersTmp.trim()).split(",")) != null) {
                if (msgDiagnosticiAppenders.length > 0) {
                    for (i = 0; i < msgDiagnosticiAppenders.length; ++i) {
                        msgDiagnosticiAppenders[i] = msgDiagnosticiAppenders[i].trim();
                    }
                } else {
                    msgDiagnosticiAppenders = null;
                }
            }
            if (msgDiagnosticiAppenders != null) {
                block6: for (i = 0; i < msgDiagnosticiAppenders.length; ++i) {
                    String tipo = this.getValue("messaggiDiagnostici.appender." + msgDiagnosticiAppenders[i] + ".tipo");
                    if (tipo == null) {
                        throw new Exception("Tipo dell'appender dei messaggi diagnostici " + msgDiagnosticiAppenders[i] + " non definito");
                    }
                    tipo = tipo.trim();
                    String valueEnable = this.getValue("messaggiDiagnostici.appender." + msgDiagnosticiAppenders[i] + ".enabled");
                    if (valueEnable != null && "false".equalsIgnoreCase(valueEnable.trim())) {
                        if (disabilitatiMsgDiagnosticiAppenderOriginali) continue;
                        for (int j = 0; j < configurazione.getMessaggiDiagnostici().sizeOpenspcoopAppenderList(); ++j) {
                            if (!tipo.equals(configurazione.getMessaggiDiagnostici().getOpenspcoopAppender(j).getTipo())) continue;
                            configurazione.getMessaggiDiagnostici().removeOpenspcoopAppender(j);
                            continue block6;
                        }
                        continue;
                    }
                    OpenspcoopAppender appender = null;
                    for (int j = 0; j < configurazione.getMessaggiDiagnostici().sizeOpenspcoopAppenderList(); ++j) {
                        if (!tipo.equals(configurazione.getMessaggiDiagnostici().getOpenspcoopAppender(j).getTipo())) continue;
                        appender = configurazione.getMessaggiDiagnostici().removeOpenspcoopAppender(j);
                        break;
                    }
                    if (appender == null) {
                        appender = new OpenspcoopAppender();
                        appender.setTipo(tipo);
                    }
                    while (appender.sizePropertyList() > 0) {
                        appender.removeProperty(0);
                    }
                    Properties properties = this.readProperties("messaggiDiagnostici.appender." + msgDiagnosticiAppenders[i] + ".property.");
                    Enumeration<Object> keys = properties.keys();
                    while (keys.hasMoreElements()) {
                        String key = (String)keys.nextElement();
                        OpenspcoopAppenderProperty ap = new OpenspcoopAppenderProperty();
                        ap.setNome(key);
                        ap.setValore(properties.getProperty(key));
                        appender.addProperty(ap);
                    }
                    configurazione.getMessaggiDiagnostici().addOpenspcoopAppender(appender);
                }
            }
            if ((tracciamentoEGov = this.getValue("tracciamento.busteEGov")) != null && !"abilitato".equals(tracciamentoEGov = tracciamentoEGov.trim()) && !"disabilitato".equals(tracciamentoEGov)) {
                throw new Exception("Impostazione sul tracciamento egov non corretta");
            }
            String tracciamentoDump = this.getValue("tracciamento.dump");
            if (tracciamentoDump != null && !"abilitato".equals(tracciamentoDump = tracciamentoDump.trim()) && !"disabilitato".equals(tracciamentoDump)) {
                throw new Exception("Impostazione sul dump applicativo non corretta");
            }
            String tracciamentoAppendersDisabledTmp = this.getValue("tracciamento.appenders.disabled");
            boolean disabilitatiTracciamentoAppenderOriginali = false;
            if (tracciamentoAppendersDisabledTmp != null && "true".equals(tracciamentoAppendersDisabledTmp)) {
                disabilitatiTracciamentoAppenderOriginali = true;
                if (configurazione.getTracciamento() != null) {
                    while (configurazione.getTracciamento().sizeOpenspcoopAppenderList() > 0) {
                        configurazione.getTracciamento().removeOpenspcoopAppender(0);
                    }
                }
            }
            String tracciamentoAppendersTmp = this.getValue("tracciamento.appenders");
            String[] tracciamentoAppenders = null;
            if (tracciamentoAppendersTmp != null && (tracciamentoAppenders = (tracciamentoAppendersTmp = tracciamentoAppendersTmp.trim()).split(",")) != null) {
                if (tracciamentoAppenders.length > 0) {
                    for (int i2 = 0; i2 < tracciamentoAppenders.length; ++i2) {
                        tracciamentoAppenders[i2] = tracciamentoAppenders[i2].trim();
                    }
                } else {
                    tracciamentoAppenders = null;
                }
            }
            if ((tracciamentoEGov != null || tracciamentoDump != null || tracciamentoAppenders != null) && configurazione.getTracciamento() == null) {
                configurazione.setTracciamento(new Tracciamento());
                if (tracciamentoEGov == null) {
                    configurazione.getTracciamento().setBusteEgov("abilitato");
                }
                if (tracciamentoDump == null) {
                    configurazione.getTracciamento().setDump("disabilitato");
                }
            }
            if (tracciamentoEGov != null) {
                configurazione.getTracciamento().setBusteEgov(tracciamentoEGov);
            }
            if (tracciamentoDump != null) {
                configurazione.getTracciamento().setDump(tracciamentoDump);
            }
            if (tracciamentoAppenders != null) {
                block13: for (int i3 = 0; i3 < tracciamentoAppenders.length; ++i3) {
                    String tipo = this.getValue("tracciamento.appender." + tracciamentoAppenders[i3] + ".tipo");
                    if (tipo == null) {
                        throw new Exception("Tipo dell'appender delle tracce " + tracciamentoAppenders[i3] + " non definito");
                    }
                    tipo = tipo.trim();
                    String valueEnable = this.getValue("tracciamento.appender." + tracciamentoAppenders[i3] + ".enabled");
                    if (valueEnable != null && "false".equalsIgnoreCase(valueEnable.trim())) {
                        if (disabilitatiTracciamentoAppenderOriginali) continue;
                        for (int j = 0; j < configurazione.getTracciamento().sizeOpenspcoopAppenderList(); ++j) {
                            if (!tipo.equals(configurazione.getTracciamento().getOpenspcoopAppender(j).getTipo())) continue;
                            configurazione.getTracciamento().removeOpenspcoopAppender(j);
                            continue block13;
                        }
                        continue;
                    }
                    OpenspcoopAppender appender = null;
                    for (int j = 0; j < configurazione.getTracciamento().sizeOpenspcoopAppenderList(); ++j) {
                        if (!tipo.equals(configurazione.getTracciamento().getOpenspcoopAppender(j).getTipo())) continue;
                        appender = configurazione.getTracciamento().removeOpenspcoopAppender(j);
                        break;
                    }
                    if (appender == null) {
                        appender = new OpenspcoopAppender();
                        appender.setTipo(tipo);
                    }
                    while (appender.sizePropertyList() > 0) {
                        appender.removeProperty(0);
                    }
                    Properties properties = this.readProperties("tracciamento.appender." + tracciamentoAppenders[i3] + ".property.");
                    Enumeration<Object> keys = properties.keys();
                    while (keys.hasMoreElements()) {
                        String key = (String)keys.nextElement();
                        OpenspcoopAppenderProperty ap = new OpenspcoopAppenderProperty();
                        ap.setNome(key);
                        ap.setValore(properties.getProperty(key));
                        appender.addProperty(ap);
                    }
                    configurazione.getTracciamento().addOpenspcoopAppender(appender);
                }
            }
            if ((integrationManager_autenticazione = this.getValue("integrationManager.autenticazione")) != null) {
                integrationManager_autenticazione = integrationManager_autenticazione.trim();
                if (configurazione.getIntegrationManager() == null) {
                    configurazione.setIntegrationManager(new IntegrationManager());
                }
                configurazione.getIntegrationManager().setAutenticazione(integrationManager_autenticazione);
            }
            return configurazione;
        }
        catch (Exception e) {
            this.log.error((Object)("Errore durante la lettura del file config_local.properties (Configurazione): " + e.getMessage()), (Throwable)e);
            throw new Exception("Errore durante la lettura del file config_local.properties (Configurazione): " + e.getMessage(), e);
        }
    }
}

