/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop.pdd.config;

import java.io.IOException;
import java.io.InputStream;
import java.util.Enumeration;
import java.util.Properties;
import java.util.Vector;
import org.apache.log4j.Logger;
import org.openspcoop.pdd.config.ClassNameInstanceProperties;
import org.openspcoop.pdd.logger.OpenSPCoopLogger;
import org.openspcoop.pdd.services.OpenSPCoopStartup;

public class ClassNameProperties {
    private Logger log = OpenSPCoopStartup.initialize ? OpenSPCoopLogger.getLoggerOpenSPCoopCore() : Logger.getLogger((String)"ClassNameProperties");
    private ClassNameInstanceProperties reader;
    private static ClassNameProperties classNameProperties = null;

    public ClassNameProperties() throws Exception {
        Properties propertiesReader = new Properties();
        InputStream properties = null;
        try {
            properties = ClassNameProperties.class.getResourceAsStream("/className.properties");
            propertiesReader.load(properties);
            properties.close();
        }
        catch (IOException e) {
            this.log.error((Object)("Riscontrato errore durante la lettura del file 'className.properties': \n\n" + e.getMessage()));
            try {
                if (properties != null) {
                    properties.close();
                }
            }
            catch (Exception er) {
                // empty catch block
            }
            throw new Exception("ClassName initialize error: " + e.getMessage());
        }
        this.reader = new ClassNameInstanceProperties(propertiesReader, this.log);
    }

    public void refreshLocalProperties(Properties localProp, String confDir) {
        this.reader.searchLocalFileImplementation(confDir);
        if (localProp != null) {
            this.reader.setLocalObjectImplementation(localProp);
        }
    }

    public static boolean initialize() {
        try {
            classNameProperties = new ClassNameProperties();
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    public static ClassNameProperties getInstance() {
        if (classNameProperties == null) {
            ClassNameProperties.initialize();
        }
        return classNameProperties;
    }

    public String getConnettore(String nome) {
        return this.getValue("org.openspcoop.connettore.", nome);
    }

    public String[] getConnettore() throws Exception {
        return this.getTipiGestiti("org.openspcoop.connettore.", "disabilitato");
    }

    public String getAutenticazione(String nome) {
        return this.getValue("org.openspcoop.autenticazione.", nome);
    }

    public String[] getAutenticazione() throws Exception {
        return this.getTipiGestiti("org.openspcoop.autenticazione.", "none");
    }

    public String getAutorizzazione(String nome) {
        return this.getValue("org.openspcoop.autorizzazione.", nome);
    }

    public String[] getAutorizzazione() throws Exception {
        return this.getTipiGestiti("org.openspcoop.autorizzazione.", "none");
    }

    public String getAutorizzazioneSPCoop(String nome) {
        return this.getValue("org.openspcoop.autorizzazioneSPCoop.", nome);
    }

    public String[] getAutorizzazioneSPCoop() throws Exception {
        return this.getTipiGestiti("org.openspcoop.autorizzazioneSPCoop.", "none");
    }

    public String getAutorizzazioneContenuto(String nome) {
        return this.getValue("org.openspcoop.autorizzazioneContenuto.", nome);
    }

    public String[] getAutorizzazioneContenuto() throws Exception {
        return this.getTipiGestiti("org.openspcoop.autorizzazioneContenuto.", "none");
    }

    public String getAutorizzazioneContenutoSPCoop(String nome) {
        return this.getValue("org.openspcoop.autorizzazioneContenutoSPCoop.", nome);
    }

    public String[] getAutorizzazioneContenutoSPCoop() throws Exception {
        return this.getTipiGestiti("org.openspcoop.autorizzazioneContenutoSPCoop.", "none");
    }

    public String getIntegrazionePortaDelegata(String nome) {
        return this.getValue("org.openspcoop.integrazione.pd.", nome);
    }

    public String[] getIntegrazionePortaDelegata() throws Exception {
        return this.getTipiGestiti("org.openspcoop.integrazione.pd.", new String[0]);
    }

    public String getIntegrazionePortaApplicativa(String nome) {
        return this.getValue("org.openspcoop.integrazione.pa.", nome);
    }

    public String[] getIntegrazionePortaApplicativa() throws Exception {
        return this.getTipiGestiti("org.openspcoop.integrazione.pa.", new String[0]);
    }

    public String getJDBCAdapter(String nome) {
        return this.getValue("org.openspcoop.jdbcAdapter.", nome);
    }

    public String[] getJDBCAdapter() throws Exception {
        return this.getTipiGestiti("org.openspcoop.jdbcAdapter.", new String[0]);
    }

    public String getThreshold(String nome) {
        return this.getValue("org.openspcoop.threshold.", nome);
    }

    public String[] getThreshold() throws Exception {
        return this.getTipiGestiti("org.openspcoop.threshold.", new String[0]);
    }

    public String getMsgDiagnosticoOpenSPCoopAppender(String nome) {
        return this.getValue("org.openspcoop.msgdiagnosticoAppender.", nome);
    }

    public String[] getMsgDiagnosticoOpenSPCoopAppender() throws Exception {
        return this.getTipiGestiti("org.openspcoop.msgdiagnosticoAppender.", new String[0]);
    }

    public String getTracciamentoOpenSPCoopAppender(String nome) {
        return this.getValue("org.openspcoop.tracciamentoAppender.", nome);
    }

    public String[] getTracciamentoOpenSPCoopAppender() throws Exception {
        return this.getTipiGestiti("org.openspcoop.tracciamentoAppender.", new String[0]);
    }

    public String getNodeReceiver(String nome) {
        return this.getValue("org.openspcoop.nodeReceiver.", nome);
    }

    public String[] getNodeReceiver() throws Exception {
        return this.getTipiGestiti("org.openspcoop.nodeReceiver.", new String[0]);
    }

    public String getNodeSender(String nome) {
        return this.getValue("org.openspcoop.nodeSender.", nome);
    }

    public String[] getNodeSender() throws Exception {
        return this.getTipiGestiti("org.openspcoop.nodeSender.", new String[0]);
    }

    public String getRepositoryEGov(String nome) {
        return this.getValue("org.openspcoop.repositoryEGov.", nome);
    }

    public String[] getRepositoryEGov() throws Exception {
        return this.getTipiGestiti("org.openspcoop.repositoryEGov.", new String[0]);
    }

    public String getSQLQueryObject(String nome) {
        return this.getValue("org.openspcoop.sqlQueryObject.", nome);
    }

    public String[] getSQLQueryObject() throws Exception {
        return this.getTipiGestiti("org.openspcoop.sqlQueryObject.", new String[0]);
    }

    public String getDateManager(String nome) {
        return this.getValue("org.openspcoop.date.", nome);
    }

    public String[] getDateManager() throws Exception {
        return this.getTipiGestiti("org.openspcoop.date.", new String[0]);
    }

    public String getUniqueIdentifier(String nome) {
        return this.getValue("org.openspcoop.id.", nome);
    }

    public String[] getUniqueIdentifier() throws Exception {
        return this.getTipiGestiti("org.openspcoop.id.", new String[0]);
    }

    public String getFiltroDuplicati(String nome) {
        return this.getValue("org.openspcoop.egov.filtroDuplicati.", nome);
    }

    public String[] getFiltroDuplicati() throws Exception {
        return this.getTipiGestiti("org.openspcoop.egov.filtroDuplicati.", new String[0]);
    }

    public String getInitHandler(String nome) {
        return this.getValue("org.openspcoop.pdd.handler.init.", nome);
    }

    public String[] getInitHandler() throws Exception {
        return this.getTipiGestiti("org.openspcoop.pdd.handler.init.", new String[0]);
    }

    public String getExitHandler(String nome) {
        return this.getValue("org.openspcoop.pdd.handler.exit.", nome);
    }

    public String[] getExitHandler() throws Exception {
        return this.getTipiGestiti("org.openspcoop.pdd.handler.exit.", new String[0]);
    }

    public String getPreInRequestHandler(String nome) {
        return this.getValue("org.openspcoop.pdd.handler.pre-in-request.", nome);
    }

    public String[] getPreInRequestHandler() throws Exception {
        return this.getTipiGestiti("org.openspcoop.pdd.handler.pre-in-request.", new String[0]);
    }

    public String getInRequestHandler(String nome) {
        return this.getValue("org.openspcoop.pdd.handler.in-request.", nome);
    }

    public String[] getInRequestHandler() throws Exception {
        return this.getTipiGestiti("org.openspcoop.pdd.handler.in-request.", new String[0]);
    }

    public String getInRequestEGovHandler(String nome) {
        return this.getValue("org.openspcoop.pdd.handler.in-egov-request.", nome);
    }

    public String[] getInRequestEGovHandler() throws Exception {
        return this.getTipiGestiti("org.openspcoop.pdd.handler.in-egov-request.", new String[0]);
    }

    public String getOutRequestHandler(String nome) {
        return this.getValue("org.openspcoop.pdd.handler.out-request.", nome);
    }

    public String[] getOutRequestHandler() throws Exception {
        return this.getTipiGestiti("org.openspcoop.pdd.handler.out-request.", new String[0]);
    }

    public String getInResponseHandler(String nome) {
        return this.getValue("org.openspcoop.pdd.handler.in-response.", nome);
    }

    public String[] getInResponseHandler() throws Exception {
        return this.getTipiGestiti("org.openspcoop.pdd.handler.in-response.", new String[0]);
    }

    public String getOutResponseHandler(String nome) {
        return this.getValue("org.openspcoop.pdd.handler.out-response.", nome);
    }

    public String[] getOutResponseHandler() throws Exception {
        return this.getTipiGestiti("org.openspcoop.pdd.handler.out-response.", new String[0]);
    }

    public String getPostOutResponseHandler(String nome) {
        return this.getValue("org.openspcoop.pdd.handler.post-out-response.", nome);
    }

    public String[] getPostOutResponseHandler() throws Exception {
        return this.getTipiGestiti("org.openspcoop.pdd.handler.post-out-response.", new String[0]);
    }

    public String getIntegrationManagerRequestHandler(String nome) {
        return this.getValue("org.openspcoop.pdd.integrationManager.handler.request.", nome);
    }

    public String[] getIntegrationManagerRequestHandler() throws Exception {
        return this.getTipiGestiti("org.openspcoop.pdd.integrationManager.handler.request.", new String[0]);
    }

    public String getIntegrationManagerResponseHandler(String nome) {
        return this.getValue("org.openspcoop.pdd.integrationManager.handler.response.", nome);
    }

    public String[] getIntegrationManagerResponseHandler() throws Exception {
        return this.getTipiGestiti("org.openspcoop.pdd.integrationManager.handler.response.", new String[0]);
    }

    public String getGestoreCredenziali(String nome) {
        return this.getValue("org.openspcoop.pdd.gestoreCredenziali.", nome);
    }

    public String[] getGestoreCredenziali() throws Exception {
        return this.getTipiGestiti("org.openspcoop.pdd.gestoreCredenziali.", new String[0]);
    }

    public String getGestoreCredenzialiIM(String nome) {
        return this.getValue("org.openspcoop.integrationManager.gestoreCredenziali.", nome);
    }

    public String[] getGestoreCredenzialiIM() throws Exception {
        return this.getTipiGestiti("org.openspcoop.integrationManager.gestoreCredenziali.", new String[0]);
    }

    private String getValue(String prop, String nome) {
        try {
            String value = this.reader.getValue(prop + nome);
            if (value != null) {
                value = value.trim();
            }
            return value;
        }
        catch (Exception e) {
            this.log.error((Object)("Errore durante la lettura della proprieta [" + prop + nome + "]: " + e.getMessage()), (Throwable)e);
            return null;
        }
    }

    private String[] getTipiGestiti(String prefix, String ... defaults) throws Exception {
        Properties prop = this.reader.readProperties(prefix);
        Enumeration<Object> en = prop.keys();
        Vector<String> tipi = new Vector<String>();
        if (defaults != null && defaults.length > 0) {
            for (int i = 0; i < defaults.length; ++i) {
                tipi.add(defaults[i]);
            }
        }
        while (en.hasMoreElements()) {
            Object o = en.nextElement();
            if (o == null) continue;
            String v = (String)o;
            tipi.add(v.trim());
        }
        if (tipi.size() > 0) {
            return tipi.toArray(new String[1]);
        }
        return null;
    }
}

