/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.monitor.engine.status;

import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.openspcoop2.monitor.engine.constants.SondaStatus;
import org.openspcoop2.monitor.engine.status.GatewayStatus;
import org.openspcoop2.monitor.engine.status.IStatus;
import org.openspcoop2.utils.transport.http.HttpRequest;
import org.openspcoop2.utils.transport.http.HttpRequestMethod;
import org.openspcoop2.utils.transport.http.HttpUtilities;
import org.openspcoop2.utils.transport.http.HttpUtilsException;
import org.slf4j.Logger;

public class StatusUtilities {
    public static List<IStatus> updateStato(List<IStatus> listaStatus, Logger log) throws Exception {
        for (IStatus status : listaStatus) {
            StatusUtilities.updateStato(status, log);
        }
        return listaStatus;
    }

    public static void updateStato(IStatus status, Logger log) throws Exception {
        try {
            StatusUtilities._check((GatewayStatus)status);
            status.setStato(SondaStatus.OK);
            status.setDescrizione(null);
        }
        catch (Exception e) {
            if (e instanceof HttpUtilsException) {
                HttpUtilsException http = (HttpUtilsException)e;
                if (http.getReturnCode() >= 200 && http.getReturnCode() <= 299) {
                    status.setStato(SondaStatus.WARNING);
                } else {
                    status.setStato(SondaStatus.ERROR);
                }
            } else {
                status.setStato(SondaStatus.ERROR);
            }
            status.setDescrizione(e.getMessage());
            log.error("Verifica '" + status.getNome() + "' fallita: " + e.getMessage(), (Throwable)e);
        }
    }

    private static void _check(GatewayStatus status) throws Exception {
        boolean https = status.isHttps();
        boolean https_verificaHostName = true;
        boolean https_autenticazioneServer = true;
        String https_truststorePath = null;
        String https_truststoreType = null;
        String https_truststorePassword = null;
        if (https) {
            https_verificaHostName = status.isHttps_verificaHostName();
            https_autenticazioneServer = status.isHttps_autenticazioneServer();
            if (https_autenticazioneServer) {
                https_truststorePath = status.getHttps_autenticazioneServer_truststorePath();
                if (StringUtils.isEmpty((String)https_truststorePath)) {
                    throw new Exception("[alias:" + status.getNome() + "] TLS Truststore path non fornito");
                }
                https_truststoreType = status.getHttps_autenticazioneServer_truststoreType();
                if (StringUtils.isEmpty((String)https_truststoreType)) {
                    throw new Exception("[alias:" + status.getNome() + "] TLS Truststore type non fornito");
                }
                https_truststorePassword = status.getHttps_autenticazioneServer_truststorePassword();
                if (StringUtils.isEmpty((String)https_truststorePassword)) {
                    throw new Exception("[alias:" + status.getNome() + "] TLS Truststore password non fornito");
                }
            }
        }
        if (https) {
            HttpRequest httpRequest = new HttpRequest();
            httpRequest.setUrl(status.getUrl());
            httpRequest.setReadTimeout(status.getReadConnectionTimeout());
            httpRequest.setConnectTimeout(status.getConnectionTimeout());
            httpRequest.setMethod(HttpRequestMethod.GET);
            httpRequest.setHostnameVerifier(https_verificaHostName);
            if (https_autenticazioneServer) {
                httpRequest.setTrustStorePath(https_truststorePath);
                httpRequest.setTrustStoreType(https_truststoreType);
                httpRequest.setTrustStorePassword(https_truststorePassword);
            } else {
                httpRequest.setTrustAllCerts(true);
            }
            HttpUtilities.check((HttpRequest)httpRequest);
        } else {
            HttpUtilities.check((String)status.getUrl(), (int)status.getReadConnectionTimeout(), (int)status.getConnectionTimeout());
        }
    }

    public static int getTotOk(List<IStatus> listaStatus) throws Exception {
        int totOk = 0;
        try {
            for (IStatus pddBean : listaStatus) {
                if (!pddBean.getStato().equals(SondaStatus.OK)) continue;
                ++totOk;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return totOk;
    }

    public static SondaStatus statesProcess(List<IStatus> listaStatus) throws Exception {
        int tot_ok = StatusUtilities.getTotOk(listaStatus);
        if (tot_ok == 0) {
            boolean findWarning = false;
            try {
                for (IStatus pddBean : listaStatus) {
                    if (!pddBean.getStato().equals(SondaStatus.WARNING)) continue;
                    findWarning = true;
                    break;
                }
                if (findWarning) {
                    return SondaStatus.WARNING;
                }
                return SondaStatus.ERROR;
            }
            catch (Exception e) {
                return SondaStatus.ERROR;
            }
        }
        if (tot_ok < listaStatus.size()) {
            return SondaStatus.WARNING;
        }
        return SondaStatus.OK;
    }

    public static String getDetailStatesProcess(List<IStatus> listaStatus) throws Exception {
        int tot_ok = StatusUtilities.getTotOk(listaStatus);
        if (tot_ok == 0) {
            if (listaStatus.size() == 1) {
                return "Il Gateway non \u00e8 funzionante";
            }
            return "Nessuno dei " + listaStatus.size() + " nodi del Gateway \u00e8 funzionante";
        }
        if (tot_ok < listaStatus.size()) {
            return listaStatus.size() - tot_ok + " su " + listaStatus.size() + " nodi del Gateway non sono funzionanti";
        }
        if (listaStatus.size() == 1) {
            return "Il Gateway \u00e8 funzionante";
        }
        return "Tutti i " + listaStatus.size() + " nodi del Gateway sono funzionanti";
    }
}

