/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.monitor.engine.statistic;

import java.util.Calendar;
import java.util.Date;
import org.openspcoop2.core.plugins.dao.IServiceManager;
import org.openspcoop2.core.statistiche.Statistica;
import org.openspcoop2.core.statistiche.StatisticaContenuti;
import org.openspcoop2.core.statistiche.StatisticaOraria;
import org.openspcoop2.core.statistiche.constants.TipoIntervalloStatistico;
import org.openspcoop2.core.statistiche.dao.IDBStatisticaOrariaService;
import org.openspcoop2.core.statistiche.dao.IStatisticaOrariaService;
import org.openspcoop2.generic_project.exception.NotImplementedException;
import org.openspcoop2.generic_project.exception.ServiceException;
import org.openspcoop2.monitor.engine.statistic.AbstractStatistiche;
import org.openspcoop2.monitor.engine.statistic.CustomStatisticsSdkGenerator;
import org.openspcoop2.monitor.engine.statistic.StatisticBean;
import org.openspcoop2.monitor.engine.statistic.StatisticsConfig;
import org.openspcoop2.monitor.sdk.constants.StatisticType;
import org.openspcoop2.monitor.sdk.exceptions.StatisticException;
import org.openspcoop2.monitor.sdk.plugins.IStatisticProcessing;
import org.openspcoop2.monitor.sdk.statistic.IStatistic;

public class StatisticheOrarie
extends AbstractStatistiche {
    public static StatisticheOrarie getInstanceForUtils() {
        return new StatisticheOrarie();
    }

    StatisticheOrarie() {
    }

    @Override
    public void init(StatisticsConfig config, org.openspcoop2.core.statistiche.dao.IServiceManager statisticheSM, org.openspcoop2.core.transazioni.dao.IServiceManager transazioniSM, org.openspcoop2.monitor.engine.config.statistiche.dao.IServiceManager pluginsStatisticheSM, IServiceManager pluginsBaseSM, org.openspcoop2.core.commons.search.dao.IServiceManager utilsSM, org.openspcoop2.monitor.engine.config.transazioni.dao.IServiceManager pluginsTransazioniSM) {
        super.init(config, statisticheSM, transazioniSM, pluginsStatisticheSM, pluginsBaseSM, utilsSM, pluginsTransazioniSM);
        try {
            if (statisticheSM == null) {
                throw new ServiceException("ServiceManager [" + org.openspcoop2.core.statistiche.dao.IServiceManager.class.getName() + "] non inizializzato");
            }
            this.model = StatisticaOraria.model().STATISTICA_BASE;
            this.statisticaServiceDAO = this.statisticheSM.getStatisticaOrariaService();
            this.statisticaServiceSearchDAO = this.statisticheSM.getStatisticaOrariaServiceSearch();
        }
        catch (ServiceException e) {
            this.logger.error(e.getMessage(), (Throwable)e);
        }
        catch (NotImplementedException e) {
            this.logger.error(e.getMessage(), (Throwable)e);
        }
    }

    private Calendar truncDate(Date date) {
        Calendar cTmp = Calendar.getInstance();
        cTmp.setTime(date);
        cTmp.set(12, 0);
        cTmp.set(13, 0);
        cTmp.set(14, 0);
        return cTmp;
    }

    @Override
    public Date truncDate(Date date, boolean print) {
        Calendar cTmp = this.truncDate(date);
        if (print) {
            this.printCalendar(cTmp);
        }
        return cTmp.getTime();
    }

    @Override
    public String getIntervalloStatistica(Date date, boolean print) {
        Calendar cTmp = this.truncDate(date);
        StringBuilder bf = new StringBuilder();
        bf.append(cTmp.get(5));
        bf.append("/");
        bf.append(cTmp.get(2) + 1);
        bf.append("/");
        bf.append(cTmp.get(1));
        bf.append(" ");
        bf.append(cTmp.get(11));
        bf.append(":00.000-");
        bf.append(cTmp.get(11));
        bf.append(":59.999-");
        return bf.toString();
    }

    @Override
    public Date incrementDate(Date date, boolean print) {
        return this.operation(date, print, 1);
    }

    @Override
    public Date decrementDate(Date date, boolean print) {
        return this.operation(date, print, -1);
    }

    private Date operation(Date date, boolean print, int value) {
        Calendar cTmp = Calendar.getInstance();
        cTmp.setTime(date);
        if (print) {
            this.logger.debug(">>> incrementDate >>>>");
            this.logger.debug("Before: ");
            this.printCalendar(cTmp);
        }
        cTmp.add(11, value);
        if (print) {
            this.logger.debug("After: ");
            this.printCalendar(cTmp);
            this.logger.debug(">>> incrementDate end >>>>");
        }
        return cTmp.getTime();
    }

    @Override
    public TipoIntervalloStatistico getTipoStatistiche() {
        return TipoIntervalloStatistico.STATISTICHE_ORARIE;
    }

    @Override
    public void callStatisticPluginMethod(IStatisticProcessing statProcessing, StatisticBean stat) throws StatisticException {
        CustomStatisticsSdkGenerator statContext = new CustomStatisticsSdkGenerator(stat, StatisticType.ORARIA, this);
        statProcessing.createHourlyStatisticData((IStatistic)statContext);
    }

    @Override
    public String getStatisticPluginMethodName() throws StatisticException {
        return "createHourlyStatisticData";
    }

    @Override
    protected Long insertStatistica(Statistica statistica) throws StatisticException {
        try {
            StatisticaOraria stat = new StatisticaOraria();
            stat.setStatisticaBase(statistica);
            ((IStatisticaOrariaService)this.statisticaServiceDAO).create((Object)stat);
            return stat.getId();
        }
        catch (Exception e) {
            throw new StatisticException(e.getMessage(), (Throwable)e);
        }
    }

    @Override
    protected void updateStatistica(long idStatistica, StatisticaContenuti ... statisticaContenuti) throws StatisticException {
        try {
            StatisticaOraria stat = (StatisticaOraria)((IDBStatisticaOrariaService)this.statisticaServiceDAO).get(idStatistica);
            for (int i = 0; i < statisticaContenuti.length; ++i) {
                statisticaContenuti[i].setData(stat.getStatisticaBase().getData());
                stat.addStatisticaOrariaContenuti(statisticaContenuti[i]);
            }
            ((IStatisticaOrariaService)this.statisticaServiceDAO).update((Object)stat);
        }
        catch (Exception e) {
            throw new StatisticException(e.getMessage(), (Throwable)e);
        }
    }

    @Override
    protected boolean isGestioneUltimoIntervallo(StatisticsConfig config) {
        return config.isStatisticheOrarieGestioneUltimoIntervallo();
    }

    @Override
    public boolean isEnabled(StatisticsConfig config) {
        return config.isStatisticheOrarie();
    }
}

