/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.monitor.engine.config.ricerche.dao.jdbc;

import java.sql.Connection;
import javax.sql.DataSource;
import org.openspcoop2.generic_project.exception.NotImplementedException;
import org.openspcoop2.generic_project.exception.ServiceException;
import org.openspcoop2.monitor.engine.config.ricerche.dao.IConfigurazioneRicercaService;
import org.openspcoop2.monitor.engine.config.ricerche.dao.IConfigurazioneRicercaServiceSearch;
import org.openspcoop2.monitor.engine.config.ricerche.dao.jdbc.JDBCConfigurazioneRicercaService;
import org.openspcoop2.monitor.engine.config.ricerche.dao.jdbc.JDBCConfigurazioneRicercaServiceSearch;
import org.openspcoop2.monitor.engine.config.ricerche.dao.jdbc.JDBCServiceManager;
import org.openspcoop2.utils.UtilsRuntimeException;

public class JDBCLimitedServiceManager
extends JDBCServiceManager {
    private JDBCServiceManager unlimitedJdbcServiceManager;
    private static final String CONNNECTION_MANAGED = "Connection managed from framework";

    public JDBCLimitedServiceManager(JDBCServiceManager jdbcServiceManager) {
        this.datasource = jdbcServiceManager.getDatasourceInternalResource();
        this.connection = jdbcServiceManager.getConnectionInternalResource();
        this.log = jdbcServiceManager.getLoggerInternalResource();
        this.jdbcProperties = jdbcServiceManager.getJdbcPropertiesInternalResource();
        this.unlimitedJdbcServiceManager = jdbcServiceManager;
    }

    @Override
    public Connection getConnection() throws ServiceException {
        throw new ServiceException(CONNNECTION_MANAGED);
    }

    @Override
    public void closeConnection(Connection connection) throws ServiceException {
        throw new ServiceException(CONNNECTION_MANAGED);
    }

    @Override
    protected Connection getConnectionInternalResource() {
        throw new UtilsRuntimeException(CONNNECTION_MANAGED);
    }

    @Override
    protected DataSource getDatasourceInternalResource() {
        throw new UtilsRuntimeException(CONNNECTION_MANAGED);
    }

    @Override
    public IConfigurazioneRicercaServiceSearch getConfigurazioneRicercaServiceSearch() throws ServiceException, NotImplementedException {
        return new JDBCConfigurazioneRicercaServiceSearch(this.unlimitedJdbcServiceManager);
    }

    @Override
    public IConfigurazioneRicercaService getConfigurazioneRicercaService() throws ServiceException, NotImplementedException {
        return new JDBCConfigurazioneRicercaService(this.unlimitedJdbcServiceManager);
    }
}

