/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.monitor.engine.config;

import java.sql.Connection;
import org.openspcoop2.core.commons.dao.DAOFactory;
import org.openspcoop2.core.commons.dao.DAOFactoryException;
import org.openspcoop2.core.id.IDAccordo;
import org.openspcoop2.core.plugins.ConfigurazioneServizioAzione;
import org.openspcoop2.generic_project.beans.IProjectInfo;
import org.openspcoop2.generic_project.exception.MultipleResultException;
import org.openspcoop2.generic_project.exception.NotFoundException;
import org.openspcoop2.generic_project.exception.NotImplementedException;
import org.openspcoop2.generic_project.exception.ServiceException;
import org.openspcoop2.generic_project.utils.ServiceManagerProperties;
import org.openspcoop2.monitor.engine.config.BasicServiceLibrary;
import org.openspcoop2.monitor.engine.config.TransactionServiceLibrary;
import org.openspcoop2.monitor.engine.config.transazioni.ConfigurazioneTransazione;
import org.openspcoop2.monitor.engine.config.transazioni.IdConfigurazioneServizio;
import org.openspcoop2.monitor.engine.config.transazioni.IdConfigurazioneServizioAzione;
import org.openspcoop2.monitor.engine.config.transazioni.IdConfigurazioneTransazione;
import org.openspcoop2.monitor.engine.config.transazioni.dao.IConfigurazioneTransazioneServiceSearch;
import org.openspcoop2.monitor.engine.config.transazioni.dao.IServiceManager;
import org.openspcoop2.monitor.engine.config.transazioni.dao.jdbc.JDBCServiceManager;
import org.openspcoop2.monitor.engine.config.transazioni.utils.ProjectInfo;
import org.slf4j.Logger;

public class TransactionServiceLibraryReader {
    private Connection connection;
    private DAOFactory daoFactory = null;
    private ServiceManagerProperties daoFactoryServiceManagerPropertiesPluginsTransazioni = null;
    private Logger daoFactoryLogger = null;
    private IServiceManager serviceManagerPluginsTransazioni;
    private boolean debug;

    public TransactionServiceLibraryReader(Connection connection, DAOFactory daoFactory, ServiceManagerProperties daoFactoryServiceManagerPropertiesPluginsTransazioni, Logger daoFactoryLogger, boolean debug) {
        this.connection = connection;
        this.daoFactory = daoFactory;
        this.daoFactoryServiceManagerPropertiesPluginsTransazioni = daoFactoryServiceManagerPropertiesPluginsTransazioni;
        this.daoFactoryLogger = daoFactoryLogger;
        this.debug = debug;
    }

    public TransactionServiceLibraryReader(IServiceManager serviceManagerPluginsTransazioni, boolean debug) {
        this.serviceManagerPluginsTransazioni = serviceManagerPluginsTransazioni;
        this.debug = debug;
    }

    public TransactionServiceLibrary readConfigurazioneTransazione(BasicServiceLibrary basicServiceLibrary, Logger log) throws Exception {
        ConfigurazioneTransazione transactionActionAllLibrary;
        IDAccordo idAccordo;
        String portType;
        TransactionServiceLibrary transactionServiceLibrary;
        block14: {
            ConfigurazioneTransazione transactionActionLibrary;
            String azione;
            block13: {
                transactionServiceLibrary = new TransactionServiceLibrary();
                transactionServiceLibrary.setBasicServiceLibrary(basicServiceLibrary);
                azione = basicServiceLibrary.getAzione();
                portType = basicServiceLibrary.getPortType();
                idAccordo = basicServiceLibrary.getIdAccordoServizioParteComune();
                transactionActionLibrary = null;
                if (basicServiceLibrary.getServiceActionLibrary() != null) {
                    try {
                        transactionActionLibrary = this.getServiceActionTransactionLibrary(basicServiceLibrary.getServiceActionLibrary());
                    }
                    catch (NotFoundException notFound) {
                        if (!this.debug) break block13;
                        log.debug("Non risulta configurata una transazione personalizzata per l'azione specifica [" + azione + "] per la libreria di servizio [" + portType + "] dell'accordo [" + idAccordo.toString() + "]", (Throwable)notFound);
                    }
                }
            }
            if (transactionActionLibrary != null) {
                if (transactionActionLibrary.isEnabled()) {
                    transactionServiceLibrary.setTransactionActionLibrary(transactionActionLibrary);
                } else if (this.debug) {
                    log.debug("Risulta configurata, ma non abilitata, una transazione personalizzata per l'azione specifica [" + azione + "] per la libreria di servizio [" + portType + "] dell'accordo [" + idAccordo.toString() + "]");
                }
            }
            transactionActionAllLibrary = null;
            try {
                transactionActionAllLibrary = this.getServiceActionTransactionLibrary(basicServiceLibrary.getServiceActionAllLibrary());
            }
            catch (NotFoundException notFound) {
                if (!this.debug) break block14;
                log.debug("Non risulta configurata una transazione personalizzata per l'azione specifica [*] per la libreria di servizio [" + portType + "] dell'accordo [" + idAccordo.toString() + "]", (Throwable)notFound);
            }
        }
        if (transactionActionAllLibrary != null) {
            if (transactionActionAllLibrary.isEnabled()) {
                transactionServiceLibrary.setTransactionActionAllLibrary(transactionActionAllLibrary);
            } else if (this.debug) {
                log.debug("Risulta configurata, ma non abilitata, una transazione personalizzata per l'azione specifica [*] per la libreria di servizio [" + portType + "] dell'accordo [" + idAccordo.toString() + "]");
            }
        }
        return transactionServiceLibrary;
    }

    private ConfigurazioneTransazione getServiceActionTransactionLibrary(ConfigurazioneServizioAzione serviceActionLibrary) throws DAOFactoryException, ServiceException, NotImplementedException, NotFoundException, MultipleResultException {
        boolean autoCommit = true;
        IServiceManager serviceManager = this.serviceManagerPluginsTransazioni;
        if (serviceManager == null && (serviceManager = (IServiceManager)this.daoFactory.getServiceManager((IProjectInfo)ProjectInfo.getInstance(), this.connection, autoCommit, this.daoFactoryServiceManagerPropertiesPluginsTransazioni, this.daoFactoryLogger)) instanceof JDBCServiceManager) {
            ((JDBCServiceManager)serviceManager).getJdbcProperties().setShowSql(this.debug);
        }
        IConfigurazioneTransazioneServiceSearch serviceSearch = serviceManager.getConfigurazioneTransazioneServiceSearch();
        IdConfigurazioneTransazione idConfigurazioneTransazione = new IdConfigurazioneTransazione();
        IdConfigurazioneServizioAzione idConfigurazioneServizioAzione = new IdConfigurazioneServizioAzione();
        IdConfigurazioneServizio idConfigurazioneServizio = new IdConfigurazioneServizio();
        idConfigurazioneServizio.setAccordo(serviceActionLibrary.getIdConfigurazioneServizio().getAccordo());
        idConfigurazioneServizio.setTipoSoggettoReferente(serviceActionLibrary.getIdConfigurazioneServizio().getTipoSoggettoReferente());
        idConfigurazioneServizio.setNomeSoggettoReferente(serviceActionLibrary.getIdConfigurazioneServizio().getNomeSoggettoReferente());
        idConfigurazioneServizio.setVersione(serviceActionLibrary.getIdConfigurazioneServizio().getVersione());
        idConfigurazioneServizio.setServizio(serviceActionLibrary.getIdConfigurazioneServizio().getServizio());
        idConfigurazioneServizioAzione.setIdConfigurazioneServizio(idConfigurazioneServizio);
        idConfigurazioneServizioAzione.setAzione(serviceActionLibrary.getAzione());
        idConfigurazioneTransazione.setIdConfigurazioneServizioAzione(idConfigurazioneServizioAzione);
        return (ConfigurazioneTransazione)serviceSearch.get(idConfigurazioneTransazione);
    }
}

