/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.monitor.engine.config;

import java.io.InputStream;
import java.util.Properties;
import org.openspcoop2.monitor.engine.config.MonitorInstanceProperties;
import org.openspcoop2.monitor.engine.exceptions.EngineException;
import org.openspcoop2.utils.UtilsException;
import org.slf4j.Logger;

public class MonitorProperties {
    private static MonitorProperties monitorPropertiesStaticInstance = null;
    private MonitorInstanceProperties reader;

    private static synchronized void initialize(Logger log) throws EngineException {
        if (monitorPropertiesStaticInstance == null) {
            monitorPropertiesStaticInstance = new MonitorProperties(log);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static MonitorProperties getInstance(Logger log) throws EngineException {
        if (monitorPropertiesStaticInstance != null) return monitorPropertiesStaticInstance;
        Class<MonitorProperties> clazz = MonitorProperties.class;
        synchronized (MonitorProperties.class) {
            MonitorProperties.initialize(log);
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return monitorPropertiesStaticInstance;
        }
    }

    public MonitorInstanceProperties getReader() {
        return this.reader;
    }

    private MonitorProperties(Logger log) throws EngineException {
        Properties propertiesReader = new Properties();
        InputStream properties = null;
        try {
            properties = MonitorProperties.class.getResourceAsStream("/openspcoop2.monitor.properties");
            if (properties == null) {
                throw new EngineException("Properties openspcoop2.monitor.properties not found");
            }
            propertiesReader.load(properties);
            properties.close();
        }
        catch (Exception e) {
            this.doError(log, properties, e);
        }
        try {
            this.reader = new MonitorInstanceProperties(propertiesReader, log);
        }
        catch (Exception e) {
            throw new EngineException(e.getMessage(), e);
        }
    }

    private void doError(Logger log, InputStream properties, Exception e) throws EngineException {
        log.error("Riscontrato errore durante la lettura del file 'openspcoop2.monitor.properties': " + e.getMessage(), (Throwable)e);
        try {
            if (properties != null) {
                properties.close();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        throw new EngineException(e.getMessage(), e);
    }

    public String getProperty(String name, String defaultValue, boolean convertEnvProperty) throws UtilsException {
        String tmp = null;
        tmp = convertEnvProperty ? this.reader.getValueConvertEnvProperties(name) : this.reader.getValue(name);
        if (tmp == null) {
            return defaultValue;
        }
        return tmp.trim();
    }

    public String getProperty(String name, boolean required, boolean convertEnvProperty) throws UtilsException {
        String tmp = null;
        tmp = convertEnvProperty ? this.reader.getValueConvertEnvProperties(name) : this.reader.getValue(name);
        if (tmp == null && required) {
            throw new UtilsException("Property [" + name + "] not found");
        }
        if (tmp != null) {
            return tmp.trim();
        }
        return null;
    }
}

