/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.monitor.engine.config;

import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.util.Properties;
import org.openspcoop2.utils.LoggerWrapperFactory;
import org.slf4j.Logger;

public class LoggerManager {
    private static Logger logger = LoggerWrapperFactory.getLogger(LoggerManager.class);
    private static boolean initialized = false;

    public static void initLogger() {
        if (!initialized) {
            InputStream is = null;
            Properties config = null;
            try {
                File f = new File("openspcoop2.monitor.log4j2.properties");
                if (f.exists()) {
                    is = new FileInputStream(f);
                } else {
                    f = new File("deploy" + File.separatorChar + "properties", "openspcoop2.monitor.log4j2.properties");
                    if (f.exists()) {
                        is = new FileInputStream(f);
                    } else {
                        is = LoggerManager.class.getResourceAsStream("/openspcoop2.monitor.log4j2.properties");
                        if (is == null) {
                            throw new Exception("Configurazione del framework [openspcoop2.monitor.log4j2.properties] non trovata");
                        }
                    }
                }
                config = new Properties();
                config.load(is);
                LoggerWrapperFactory.setLogConfiguration((Properties)config);
                logger.info("Sistema di logging correttamente inizializzato");
                initialized = true;
            }
            catch (Exception e) {
                logger.error("Errore durante l'inizializzazione del Sistema di Logging: " + e.getMessage(), (Throwable)e);
            }
            finally {
                try {
                    if (is != null) {
                        is.close();
                    }
                }
                catch (Exception exception) {}
            }
        }
    }

    static {
        LoggerManager.initLogger();
    }
}

