/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.monitor.engine.condition;

import java.util.ArrayList;
import java.util.List;
import org.openspcoop2.core.plugins.utils.FilterUtils;
import org.openspcoop2.core.transazioni.Transazione;
import org.openspcoop2.core.transazioni.dao.jdbc.converter.TransazioneFieldConverter;
import org.openspcoop2.generic_project.beans.AliasTableComplexField;
import org.openspcoop2.generic_project.beans.ComplexField;
import org.openspcoop2.generic_project.beans.IAliasTableField;
import org.openspcoop2.generic_project.beans.IField;
import org.openspcoop2.generic_project.dao.jdbc.JDBCExpression;
import org.openspcoop2.generic_project.expression.IExpression;
import org.openspcoop2.generic_project.expression.impl.sql.ISQLFieldConverter;
import org.openspcoop2.monitor.engine.condition.FilterImpl;
import org.openspcoop2.monitor.sdk.condition.IStatisticFilter;
import org.openspcoop2.monitor.sdk.exceptions.SearchException;
import org.openspcoop2.monitor.sdk.statistic.StatisticFilterName;
import org.openspcoop2.utils.TipiDatabase;

public class FilterTransactionRepositoryImpl
extends FilterImpl {
    public FilterTransactionRepositoryImpl(TipiDatabase databaseType) throws SearchException {
        super(FilterTransactionRepositoryImpl.newExpression(databaseType), databaseType, FilterTransactionRepositoryImpl.newFieldConverter(databaseType));
    }

    private static IExpression newExpression(TipiDatabase databaseType) throws SearchException {
        try {
            return new JDBCExpression(FilterTransactionRepositoryImpl.newFieldConverter(databaseType));
        }
        catch (Exception e) {
            throw new SearchException(e.getMessage(), (Throwable)e);
        }
    }

    private static ISQLFieldConverter newFieldConverter(TipiDatabase databaseType) {
        return new TransazioneFieldConverter(databaseType);
    }

    @Override
    protected IStatisticFilter newIFilter() throws SearchException {
        try {
            return new FilterTransactionRepositoryImpl(this.databaseType);
        }
        catch (Exception e) {
            throw new SearchException(e.getMessage(), (Throwable)e);
        }
    }

    @Override
    protected IExpression newIExpression() throws SearchException {
        try {
            return FilterTransactionRepositoryImpl.newExpression(this.databaseType);
        }
        catch (Exception e) {
            throw new SearchException(e.getMessage(), (Throwable)e);
        }
    }

    @Override
    protected IField getIFieldForMessageType() throws SearchException {
        return Transazione.model().DUMP_MESSAGGIO.TIPO_MESSAGGIO;
    }

    @Override
    protected List<IField> getIFieldForResourceName(StatisticFilterName statisticFilter) throws SearchException {
        try {
            ArrayList<IField> l = new ArrayList<IField>();
            l.add((IField)new AliasTableComplexField((ComplexField)Transazione.model().DUMP_MESSAGGIO.CONTENUTO.NOME, FilterUtils.getNextAliasTransactionTable()));
            return l;
        }
        catch (Exception e) {
            throw new SearchException(e.getMessage(), (Throwable)e);
        }
    }

    @Override
    protected IField getIFieldForResourceValue(IField fieldResourceName) throws SearchException {
        try {
            if (!(fieldResourceName instanceof IAliasTableField)) {
                throw new Exception("Unknown parameter type: " + fieldResourceName.getClass().getName());
            }
            IAliasTableField af = (IAliasTableField)fieldResourceName;
            String aliasTable = af.getAliasTable();
            return new AliasTableComplexField((ComplexField)Transazione.model().DUMP_MESSAGGIO.CONTENUTO.VALORE, aliasTable);
        }
        catch (Exception e) {
            throw new SearchException(e.getMessage(), (Throwable)e);
        }
    }
}

