/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.monitor.engine.alarm;

import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.openspcoop2.core.allarmi.Allarme;
import org.openspcoop2.core.allarmi.utils.ProjectInfo;
import org.openspcoop2.core.commons.dao.DAOFactory;
import org.openspcoop2.core.commons.dao.DAOFactoryProperties;
import org.openspcoop2.core.constants.TipoPdD;
import org.openspcoop2.generic_project.beans.IProjectInfo;
import org.openspcoop2.monitor.sdk.constants.CRUDType;
import org.openspcoop2.monitor.sdk.constants.SearchType;
import org.openspcoop2.monitor.sdk.parameters.Parameter;
import org.openspcoop2.protocol.sdk.builder.EsitoTransazione;
import org.openspcoop2.utils.TipiDatabase;
import org.slf4j.Logger;

public class AlarmContext
implements org.openspcoop2.monitor.sdk.condition.AlarmContext {
    private Allarme allarme;
    private Logger log;
    private DAOFactory daoFactory;
    private List<Parameter<?>> parameters;

    public AlarmContext(Allarme allarme, Logger log, DAOFactory daoFactory) {
        this(allarme, log, daoFactory, null);
    }

    public AlarmContext(Allarme allarme, Logger log, DAOFactory daoFactory, List<Parameter<?>> parameters) {
        this.allarme = allarme;
        this.log = log;
        this.daoFactory = daoFactory;
        this.parameters = parameters;
    }

    public void setParameters(List<Parameter<?>> parameters) {
        this.parameters = parameters;
    }

    public SearchType getTipoRicerca() {
        return SearchType.ALL;
    }

    public Date getIntervalloInferiore() {
        return null;
    }

    public Date getIntervalloSuperiore() {
        return null;
    }

    public String getTipoSoggettoMittente() {
        if (this.allarme != null && this.allarme.getFiltro() != null && StringUtils.isNotEmpty((String)this.allarme.getFiltro().getTipoFruitore()) && !"*".equals(this.allarme.getFiltro().getTipoFruitore())) {
            return this.allarme.getFiltro().getTipoFruitore();
        }
        return null;
    }

    public String getSoggettoMittente() {
        if (this.allarme != null && this.allarme.getFiltro() != null && StringUtils.isNotEmpty((String)this.allarme.getFiltro().getNomeFruitore()) && !"*".equals(this.allarme.getFiltro().getNomeFruitore())) {
            return this.allarme.getFiltro().getNomeFruitore();
        }
        return null;
    }

    public String getTipoSoggettoDestinatario() {
        if (this.allarme != null && this.allarme.getFiltro() != null && StringUtils.isNotEmpty((String)this.allarme.getFiltro().getTipoErogatore()) && !"*".equals(this.allarme.getFiltro().getTipoErogatore())) {
            return this.allarme.getFiltro().getTipoErogatore();
        }
        return null;
    }

    public String getSoggettoDestinatario() {
        if (this.allarme != null && this.allarme.getFiltro() != null && StringUtils.isNotEmpty((String)this.allarme.getFiltro().getNomeErogatore()) && !"*".equals(this.allarme.getFiltro().getNomeErogatore())) {
            return this.allarme.getFiltro().getNomeErogatore();
        }
        return null;
    }

    public String getTipoServizio() {
        if (this.allarme != null && this.allarme.getFiltro() != null && StringUtils.isNotEmpty((String)this.allarme.getFiltro().getTipoServizio()) && !"*".equals(this.allarme.getFiltro().getTipoServizio())) {
            return this.allarme.getFiltro().getTipoServizio();
        }
        return null;
    }

    public String getServizio() {
        if (this.allarme != null && this.allarme.getFiltro() != null && StringUtils.isNotEmpty((String)this.allarme.getFiltro().getNomeServizio()) && !"*".equals(this.allarme.getFiltro().getNomeServizio())) {
            return this.allarme.getFiltro().getNomeServizio();
        }
        return null;
    }

    public Integer getVersioneServizio() {
        if (this.allarme != null && this.allarme.getFiltro() != null && this.allarme.getFiltro().getVersioneServizio() != null && this.allarme.getFiltro().getVersioneServizio() > 0) {
            return this.allarme.getFiltro().getVersioneServizio();
        }
        return null;
    }

    public String getAzione() {
        if (this.allarme != null && this.allarme.getFiltro() != null && StringUtils.isNotEmpty((String)this.allarme.getFiltro().getAzione()) && !"*".equals(this.allarme.getFiltro().getAzione())) {
            return this.allarme.getFiltro().getAzione();
        }
        return null;
    }

    public String getInterfaccia() {
        if (this.allarme != null && this.allarme.getFiltro() != null && StringUtils.isNotEmpty((String)this.allarme.getFiltro().getNomePorta()) && !"*".equals(this.allarme.getFiltro().getNomePorta())) {
            return this.allarme.getFiltro().getNomePorta();
        }
        return null;
    }

    public TipoPdD getRuolo() {
        if (this.allarme != null && this.allarme.getFiltro() != null && this.allarme.getFiltro().getRuoloPorta() != null) {
            switch (this.allarme.getFiltro().getRuoloPorta()) {
                case DELEGATA: {
                    return TipoPdD.DELEGATA;
                }
                case APPLICATIVA: {
                    return TipoPdD.APPLICATIVA;
                }
            }
            return null;
        }
        return null;
    }

    public EsitoTransazione getEsitoTransazione() {
        return null;
    }

    public Parameter<?> getParameter(String paramID) {
        return this.getParameters().get(paramID);
    }

    public Map<String, Parameter<?>> getParameters() {
        HashMap map = new HashMap();
        if (this.parameters != null) {
            for (Parameter<?> param : this.parameters) {
                map.put(param.getId(), param);
            }
        }
        return map;
    }

    public TipiDatabase getDatabaseType() {
        return this._getTipoDatabase((IProjectInfo)ProjectInfo.getInstance());
    }

    public TipiDatabase _getTipoDatabase(IProjectInfo nomeDAO) {
        try {
            DAOFactoryProperties prop = DAOFactoryProperties.getInstance((Logger)this.getLogger());
            return prop.getTipoDatabaseEnum(nomeDAO);
        }
        catch (Exception e) {
            this.log.error(e.getMessage(), (Throwable)e);
            return null;
        }
    }

    public Logger getLogger() {
        return this.log;
    }

    public DAOFactory getDAOFactory() {
        return this.daoFactory;
    }

    public CRUDType getTipoOperazione() {
        if (this.allarme != null && this.allarme.getId() != null && this.allarme.getId() > 0L) {
            return CRUDType.UPDATE;
        }
        return CRUDType.CREATE;
    }

    public Allarme getConfigAllarme() {
        return this.allarme;
    }
}

